import { CommonModule } from '@angular/common';
import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, inject, Input, Output } from '@angular/core';
import { FormBuilder, FormControl, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { NgbActiveModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslocoModule, TranslocoService } from '@jsverse/transloco';
import _, { cloneDeep, forEach, isUndefined } from 'lodash-es';
import { isArray } from 'lodash-es';
import { ToastrService } from 'ngx-toastr';
import { catchError, finalize, switchMap, throwError } from 'rxjs';
import { XFFormFieldsModule } from '../../form-fields/form-fields.module';
import { PermissionService } from '../../core/services/permission.service';
import { UserService } from '../../core/services/user.service';
import { PendingDecisionService } from '../../core/services/pending-decision.service';
import { UtilityService } from '../../core/services/utility.service';
import { ModalService } from '../../core/services/modal.service';
import { Entity } from '../../core/models/entity';
import { RichtextHTMLField } from '../../form-fields/field-types/richtext-html';
import { FIXED_MODULE, PERMISSION } from '../../core/constants';
import { ModuleAttributeMap } from '../../core/models/attribute-map';
import { Field } from '../../core/models/field';
import { EmbedService } from '../../core/services/embed.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "../../form-fields/field-renderers/built-ins/form-field/form-field.component";
import * as i4 from "../../form-fields/field-renderers/built-ins/editable-field/editable-field.component";
import * as i5 from "@jsverse/transloco";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
const _c0 = a0 => ({ "margin-bottom-12px": a0 });
const _c1 = a0 => ({ "margin-top-10px": a0 });
function PendingDecisionComponent_form_1_h4_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "h4", 14);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.decisionInput.input.schema.title, "");
} }
function PendingDecisionComponent_form_1_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 15);
    i0.ɵɵlistener("click", function PendingDecisionComponent_form_1_button_3_Template_button_click_0_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.closePopup($event)); });
    i0.ɵɵelement(1, "i", 16);
    i0.ɵɵelementEnd();
} }
function PendingDecisionComponent_form_1_xf_editable_field_6_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-editable-field", 17);
    i0.ɵɵtwoWayListener("valueChange", function PendingDecisionComponent_form_1_xf_editable_field_6_Template_xf_editable_field_valueChange_0_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r0 = i0.ɵɵnextContext(2); i0.ɵɵtwoWayBindingSet(ctx_r0.decisionInput.input.schema.description, $event) || (ctx_r0.decisionInput.input.schema.description = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate("title", ctx_r0.decisionDescriptionField.title);
    i0.ɵɵproperty("field", ctx_r0.decisionDescriptionField)("ngClass", i0.ɵɵpureFunction1(6, _c0, (ctx_r0.decisionInput.input.schema.inputVariables == null ? null : ctx_r0.decisionInput.input.schema.inputVariables.length) === 0));
    i0.ɵɵtwoWayProperty("value", ctx_r0.decisionInput.input.schema.description);
    i0.ɵɵproperty("fieldClass", "form-control-sm")("readOnly", true);
} }
function PendingDecisionComponent_form_1_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 18);
    i0.ɵɵelement(2, "xf-form-field", 19);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r4 = ctx.$implicit;
    const first_r5 = ctx.first;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(3, _c1, !first_r5));
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", field_r4.value)("formControlName", field_r4.key);
} }
function PendingDecisionComponent_form_1_div_10_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 22);
    i0.ɵɵlistener("click", function PendingDecisionComponent_form_1_div_10_button_1_Template_button_click_0_listener() { const option_r7 = i0.ɵɵrestoreView(_r6).$implicit; const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.submitDecision(option_r7)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r7 = ctx.$implicit;
    const i_r8 = ctx.index;
    i0.ɵɵpropertyInterpolate1("id", "submit-pending-decision-btn-", i_r8, "");
    i0.ɵɵproperty("ngClass", option_r7.primary ? "btn-primary" : "btn-secondary");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r7.option);
} }
function PendingDecisionComponent_form_1_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 20);
    i0.ɵɵtemplate(1, PendingDecisionComponent_form_1_div_10_button_1_Template, 2, 4, "button", 21);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r0.decisionInput.response_mapping.options);
} }
function PendingDecisionComponent_form_1_Conditional_11_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r9 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 13)(1, "span", 24);
    i0.ɵɵlistener("click", function PendingDecisionComponent_form_1_Conditional_11_div_0_Template_span_click_1_listener() { i0.ɵɵrestoreView(_r9); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.deleteManualInput()); });
    i0.ɵɵelement(2, "i", 25);
    i0.ɵɵelementStart(3, "span", 26);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "span", 27);
    i0.ɵɵelement(6, "i", 28);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r10 = ctx.$implicit;
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(t_r10("NOTIFICATIONS.DISCARD_USER_INPUT"));
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate("ngbTooltip", t_r10("NOTIFICATIONS.DISCARD_USER_INPUT_TOOLTIP"));
} }
function PendingDecisionComponent_form_1_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, PendingDecisionComponent_form_1_Conditional_11_div_0_Template, 7, 2, "div", 23);
} }
function PendingDecisionComponent_form_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "form", 3)(1, "div", 4);
    i0.ɵɵtemplate(2, PendingDecisionComponent_form_1_h4_2_Template, 2, 1, "h4", 5)(3, PendingDecisionComponent_form_1_button_3_Template, 2, 0, "button", 6);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 7)(5, "div", 8);
    i0.ɵɵtemplate(6, PendingDecisionComponent_form_1_xf_editable_field_6_Template, 1, 8, "xf-editable-field", 9);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "div", 10);
    i0.ɵɵtemplate(8, PendingDecisionComponent_form_1_div_8_Template, 3, 5, "div", 11);
    i0.ɵɵpipe(9, "keyvalue");
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(10, PendingDecisionComponent_form_1_div_10_Template, 2, 1, "div", 12)(11, PendingDecisionComponent_form_1_Conditional_11_Template, 1, 0, "div", 13);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.formGroup);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.decisionInput.input.schema.title);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.type === "modal");
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r0.decisionDescriptionField);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", i0.ɵɵpipeBind2(9, 7, ctx_r0.fields, ctx_r0.originalOrder));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", (ctx_r0.decisionInput.response_mapping.options == null ? null : ctx_r0.decisionInput.response_mapping.options.length) > 0);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r0.type === "modal" && ctx_r0.playbookExecutePermission ? 11 : -1);
} }
function PendingDecisionComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 29)(1, "div", 30);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r0.decisionInput.response_mapping.customSuccessMessage ? ctx_r0.decisionInput.response_mapping.customSuccessMessage : "Playbook successfully resumed.");
} }
export class PendingDecisionComponent {
    constructor() {
        this.decisionInput = {};
        this.unauthenticated = false;
        this.type = 'inline';
        this.mode = 'edit';
        this.submitResponse = new EventEmitter();
        this.permissionsService = inject(PermissionService);
        this.usersService = inject(UserService);
        this.pendingDecisionService = inject(PendingDecisionService);
        this.utilityService = inject(UtilityService);
        this.toaster = inject(ToastrService);
        this.activeOffCanvas = inject(NgbActiveModal);
        this.translocoService = inject(TranslocoService);
        this.embedService = inject(EmbedService);
        this.modalService = inject(ModalService);
        this.formBuilder = inject(FormBuilder);
        this.playbookExecutePermission = false;
        this.playbookReadPermission = false;
        this.fields = {};
        this.processing = false;
        this.playbookResumed = false;
        this.isEmbed = false;
        // Preserve original property order
        this.originalOrder = (a, b) => {
            return 0;
        };
    }
    ngOnInit() {
        if (window.isEmbed) {
            this.isEmbed = true;
        }
        this.formGroup = this.formBuilder.group({});
        this.checkPermissions();
        this.currentUser = this.usersService.getCurrentUser();
        this.createDescriptionField();
        this.initializeInputParams();
    }
    checkPermissions() {
        if (this.unauthenticated) {
            this.playbookExecutePermission = true;
            this.playbookReadPermission = true;
        }
        else {
            const playbookPermissions = this.permissionsService.getPermission(FIXED_MODULE.PLAYBOOK);
            this.playbookExecutePermission = playbookPermissions.includes(PERMISSION.EXECUTE);
            this.playbookReadPermission = playbookPermissions.includes(PERMISSION.READ);
        }
    }
    initializeInputParams() {
        if (this.decisionInput.input.schema.inputVariables.length > 0) {
            this.processing = true;
            let stepDataVariables = this.decisionInput.input.schema.inputVariables;
            var moduleField = _.find(stepDataVariables, function (variable) {
                return variable.useRecordFieldDefault || variable.useModuleField;
            });
            if (!isUndefined(moduleField)) {
                if (isUndefined(this.entity)) {
                    //TODO: In case of record fields
                    //var recordEntity = FormEntityService.get();
                    //var recordModule = $filter('getModuleName')(this.decisionInput.record);
                    // if (recordEntity && recordEntity.module === recordModule && angular.equals({}, recordEntity.originalData) || !recordEntity) {
                    //   entity = new Entity(recordModule);
                    //   entity.get($filter('getEndPathName')(this.decisionInput.record)).then(function () {
                    //     _prepareVariableData(stepDataVariables);
                    //   });
                    // } else {
                    //   entity = recordEntity;
                    //   _prepareVariableData(stepDataVariables);
                    // }
                }
            }
            else {
                this.prepareVariableData(stepDataVariables);
            }
        }
    }
    prepareVariableData(stepDataVariables) {
        this.fields = {};
        //var firstField;
        let rows = !isUndefined(this.entity) ? [this.entity.originalData] : [];
        forEach(stepDataVariables, (inputVariable) => {
            let field;
            let fieldMetadata = cloneDeep(inputVariable);
            let formControl;
            fieldMetadata.title = fieldMetadata.label; // || $filter('camelCaseToHuman')(inputVariable.name);
            if (inputVariable.useRecordFieldDefault || inputVariable.useModuleField) {
                // field = angular.copy(entity.fields[inputVariable.moduleField]);
                // if(angular.isUndefined(field)){
                //   scope.processing = false;
                //   scope.error = '<span class="fa fa-exclamation-triangle warning-icon font-size-10"></span> <span class="font-bold font-italic">'+inputVariable.title + ' </span> field not found in ' + entity.descriptions.plural + ' module.';
                //   return;
                // }
                // var commonValue = CommonUtils.getCommonValue(rows, field.name);
                // field.value = field.type === 'datetime' ? new Date(commonValue * 1000) : commonValue;
                // if (angular.isObject(commonValue)) {
                //   field.value.display = field.getExportValue();
                // }
                // field.title = inputVariable.title ? inputVariable.title : field.title;
                // field.name = inputVariable.name ? inputVariable.name : field.name;
                // field.tooltip = inputVariable.tooltip ? inputVariable.tooltip : field.tooltip;
                // field.validation = {
                //   'required': angular.isDefined(inputVariable.required) ? inputVariable.required : true
                // };
                // field.required = angular.isDefined(inputVariable.required) ? inputVariable.required : true;
                // field.buttonClasses = 'btn btn-link';
            }
            else {
                fieldMetadata.writeable = true;
                const fieldAttributes = ModuleAttributeMap[fieldMetadata.formType];
                field = new fieldAttributes.field(fieldMetadata.name);
                //field = new Field(inputVariable);
                if (field.formType === Field.BuiltInType.SELECT) {
                    field.isMultiple = fieldMetadata.isMultiple;
                    if (isArray(fieldMetadata.options)) {
                        field.fieldOptions = { options: fieldMetadata.options.map((option) => {
                                return { label: option, value: option };
                            })
                        };
                    }
                }
                field.defaultValue = inputVariable.defaultValue;
                formControl = new FormControl(inputVariable.defaultValue || '');
                field.title = inputVariable.label;
                field.tooltip = fieldMetadata.tooltip;
                field.validation = {
                    required: !isUndefined(fieldMetadata.required) ? fieldMetadata.required : true
                };
                field.required = !isUndefined(fieldMetadata.required) ? fieldMetadata.required : true;
                if (field.formType === Field.BuiltInType.CHECKBOX) {
                    field.viewMode = 'checkbox';
                }
                if (field.formType === Field.BuiltInType.JSON) {
                    field.modes = ['code', 'view'];
                }
                if (this.unauthenticated && field.formType === Field.BuiltInType.RICHTEXTHTML) {
                    field.params = { theme: 'dark' };
                }
                if (field.formType.indexOf('datetime') === 0 && fieldMetadata.value) {
                    // if (angular.isObject(field.value) && field.value.hasOwnProperty('differenceType')) {
                    //   field.value = convertToRelativeDateService(field.value);
                    // }
                    // evaluateDateFieldValue(field);
                }
            }
            // TODO: Visibility conditions
            //field.visibility = inputVariable.visibilityQuery && inputVariable.visibilityQuery.filters && inputVariable.visibilityQuery.filters.length > 0 ? inputVariable.visibilityQuery : true;
            if (field.formType === Field.BuiltInType.PICKLIST || field.formType === Field.BuiltInType.MULTISELECT_PICKLIST) {
                //picklistsService.loadPicklists(field);
            }
            this.fields[field.name] = field;
            this.formGroup.addControl(fieldMetadata.name, formControl);
        });
        this.inputVariableEntity = new Entity('inputVariables');
        this.inputVariableEntity.fields = this.fields;
        this.inputVariableEntity.evaluateAllFields();
        this.processing = false;
    }
    createDescriptionField() {
        if (this.decisionInput.input.schema.description) {
            let field = new RichtextHTMLField('decisionDescription');
            this.decisionDescriptionField = field;
        }
    }
    submitDecision(option) {
        let payload = {
            input: {},
            step_uuid: option.step_uuid,
            step_id: this.decisionInput.step_id,
            manual_input_id: this.decisionInput.id
        };
        if (this.decisionInput.is_approval) {
            payload.approved = option.primary;
        }
        if (!this.unauthenticated) {
            payload.user = this.currentUser.uuid;
        }
        // Add form values to payload
        payload.input = this.formGroup.value;
        this.pendingDecisionService.resumeAwaitingPlaybook(payload, this.decisionInput.workflow).pipe(finalize(() => {
            if (this.type === 'modal') {
                //this.activeOffCanvas.close('resumed');
            }
            else {
                this.playbookResumed = true;
            }
        })).subscribe({
            next: (data) => {
                let successMsg = this.utilityService.isUndefined(this.decisionInput.response_mapping.customSuccessMessage) ? this.decisionInput.response_mapping.customSuccessMessage : 'Awaiting Playbook resumed successfully';
                this.toaster.success(successMsg || data.message, 'Success');
                if (this.isEmbed) {
                    this.embedService.sendEventData({
                        'type': 'XF_MANUAL_INPUT_RESPONSE',
                        'data': {
                            'status': 'success',
                            'data': data
                        }
                    });
                }
                this.submitResponse.emit();
            }, error: (error) => {
                this.toaster.error(error.error.message, 'Error');
            }
        });
    }
    ;
    closePopup(event) {
        event.stopPropagation();
        this.submitResponse.emit(true);
        this.activeOffCanvas.dismiss();
    }
    deleteManualInput() {
        this.modalService.confirm(this.translocoService.translate('NOTIFICATIONS.MANUAL_INPUT_DELETE_NOTIFICATION_CONFIRMATION_MESSAGE')).pipe(switchMap(() => {
            return this.pendingDecisionService.deleteManualInput(this.decisionInput.id);
        }), catchError(error => {
            return throwError(() => error);
        })).subscribe({
            next: () => {
                this.submitResponse.emit(true);
                this.activeOffCanvas.dismiss();
                this.toaster.success(this.translocoService.translate('NOTIFICATIONS.MANUAL_INPUT_DELETE_SUCCESS_MESSAGE'), 'Success');
            }, error: (e) => {
                if (e instanceof HttpErrorResponse) {
                    this.toaster.error(e.error.message, 'Error');
                }
            }
        });
    }
    static { this.ɵfac = function PendingDecisionComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PendingDecisionComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PendingDecisionComponent, selectors: [["xf-pending-decision"]], inputs: { decisionInput: "decisionInput", unauthenticated: "unauthenticated", type: "type", mode: "mode" }, outputs: { submitResponse: "submitResponse" }, standalone: true, features: [i0.ɵɵProvidersFeature([
                NgbActiveModal,
            ]), i0.ɵɵStandaloneFeature], decls: 3, vars: 2, consts: [[1, "position-relative"], [3, "formGroup", 4, "ngIf"], ["class", "padding-top-lg padding-bottom-lg", 4, "ngIf"], [3, "formGroup"], [1, "modal-header", "padding-bottom-8px", "padding-left-12px", "padding-right-16px", "padding-top-8px", "modal-close-left"], ["class", "page-title-font modal-title", 4, "ngIf"], ["ype", "button", "aria-label", "Close", "class", "btn btn-sm ms-auto", 3, "click", 4, "ngIf"], [1, "h-auto", "modal-body"], [1, "padding-left-12px"], ["class", "d-block", "use-placeholder", "true", 3, "field", "ngClass", "value", "fieldClass", "readOnly", "title", "valueChange", 4, "ngIf"], [1, "padding-left-12px", "padding-right-16px", "padding-top-8px", "padding-bottom-8px"], [4, "ngFor", "ngForOf"], ["class", "flex-row modal-footer padding-bottom-12px padding-left-12px padding-right-16px padding-top-16px position-relative", 4, "ngIf"], [1, "border-1", "border-dark", "border-top", "padding-bottom-6px", "padding-left-20px", "padding-right-20px", "padding-top-6px", "text-end"], [1, "page-title-font", "modal-title"], ["ype", "button", "aria-label", "Close", 1, "btn", "btn-sm", "ms-auto", 3, "click"], [1, "fa", "fa-close"], ["use-placeholder", "true", 1, "d-block", 3, "valueChange", "field", "ngClass", "value", "fieldClass", "readOnly", "title"], [3, "ngClass"], [3, "field", "formControlName"], [1, "flex-row", "modal-footer", "padding-bottom-12px", "padding-left-12px", "padding-right-16px", "padding-top-16px", "position-relative"], ["type", "button", "class", "btn btn-sm margin-right-4px", 3, "ngClass", "id", "click", 4, "ngFor", "ngForOf"], ["type", "button", 1, "btn", "btn-sm", "margin-right-4px", 3, "click", "ngClass", "id"], ["class", "border-1 border-dark border-top padding-bottom-6px padding-left-20px padding-right-20px padding-top-6px text-end", 4, "transloco"], [1, "font-size-12px", "text-danger", "cursor-pointer", 3, "click"], [1, "fa", "fa-light", "fa-trash-alt"], [1, "margin-left-6px"], ["container", "body", 3, "ngbTooltip"], [1, "content-font", "fa-circle-info", "fa-duotone", "fa-light", "margin-left-4px"], [1, "padding-top-lg", "padding-bottom-lg"], [1, "text-center", "content-font"]], template: function PendingDecisionComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, PendingDecisionComponent_form_1_Template, 12, 10, "form", 1)(2, PendingDecisionComponent_div_2_Template, 3, 1, "div", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.playbookResumed);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.playbookResumed);
        } }, dependencies: [CommonModule, i1.NgClass, i1.NgForOf, i1.NgIf, i1.KeyValuePipe, FormsModule, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, ReactiveFormsModule, i2.FormGroupDirective, i2.FormControlName, XFFormFieldsModule, i3.FormFieldComponent, i4.EditableFieldComponent, TranslocoModule, i5.TranslocoDirective, NgbTooltipModule, i6.NgbTooltip] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PendingDecisionComponent, [{
        type: Component,
        args: [{ selector: 'xf-pending-decision', standalone: true, providers: [
                    NgbActiveModal,
                ], imports: [CommonModule, FormsModule, ReactiveFormsModule, XFFormFieldsModule, TranslocoModule, NgbTooltipModule], template: "<div class=\"position-relative\">\n  <form [formGroup]=\"formGroup\" *ngIf=\"!playbookResumed\">\n    <div class=\"modal-header padding-bottom-8px padding-left-12px padding-right-16px padding-top-8px modal-close-left\">\n      <h4 class=\"page-title-font modal-title\" *ngIf=\"decisionInput.input.schema.title\">\n        {{decisionInput.input.schema.title}}</h4>\n      <button ype=\"button\" *ngIf=\"type === 'modal'\" aria-label=\"Close\" class=\"btn btn-sm ms-auto\"\n        (click)=\"closePopup($event);\">\n        <i class=\"fa fa-close\"></i>\n      </button>\n\n    </div>\n    <div class=\"h-auto modal-body\">\n      <div class=\"padding-left-12px\">\n        <xf-editable-field *ngIf=\"decisionDescriptionField\" [field]=\"decisionDescriptionField\" class=\"d-block\"\n          [ngClass]=\"{ 'margin-bottom-12px' : decisionInput.input.schema.inputVariables?.length === 0 }\"\n          [(value)]=\"decisionInput.input.schema.description\" use-placeholder=\"true\" [fieldClass]=\"'form-control-sm'\"\n          [readOnly]=\"true\" title=\"{{decisionDescriptionField.title}}\">\n        </xf-editable-field>\n      </div>\n      <div class=\"padding-left-12px padding-right-16px padding-top-8px padding-bottom-8px\">\n        <div *ngFor=\"let field of fields | keyvalue: originalOrder; let first = first;\">\n          <div [ngClass]=\"{'margin-top-10px' : !first }\">\n            <xf-form-field [field]=\"field.value\" [formControlName]=\"field.key\"></xf-form-field>\n          </div>\n        </div>\n      </div>\n    </div>\n    <!-- footer -->\n    <div\n      class=\"flex-row modal-footer padding-bottom-12px padding-left-12px padding-right-16px padding-top-16px position-relative\"\n      *ngIf=\"decisionInput.response_mapping.options?.length > 0\">\n      <button *ngFor=\"let option of decisionInput.response_mapping.options; let i = index;\" type=\"button\"\n        [ngClass]=\"option.primary ? 'btn-primary': 'btn-secondary'\" class=\"btn btn-sm margin-right-4px\"\n        (click)=\"submitDecision(option)\" id=\"submit-pending-decision-btn-{{i}}\">{{option.option}}</button>\n    </div>\n    <!-- Delete user Input -->\n    @if (type === 'modal' && playbookExecutePermission) {\n      <div class=\"border-1 border-dark border-top padding-bottom-6px padding-left-20px padding-right-20px padding-top-6px text-end\"  *transloco=\"let t\">\n        <span class=\"font-size-12px text-danger cursor-pointer\" (click)=\"deleteManualInput()\"><i class=\"fa fa-light fa-trash-alt\"></i>\n          <span class=\"margin-left-6px\">{{ t('NOTIFICATIONS.DISCARD_USER_INPUT') }}</span>\n        </span>\n        <span ngbTooltip=\"{{ t('NOTIFICATIONS.DISCARD_USER_INPUT_TOOLTIP') }}\" container=\"body\">\n        <i class=\"content-font fa-circle-info fa-duotone fa-light margin-left-4px\"></i></span>\n      </div>\n    }\n  </form>\n  <div class=\"padding-top-lg padding-bottom-lg\" *ngIf=\"playbookResumed\">\n    <div class=\"text-center content-font\">{{decisionInput.response_mapping.customSuccessMessage ?\n      decisionInput.response_mapping.customSuccessMessage : 'Playbook successfully resumed.'}}</div>\n  </div>\n</div>\n" }]
    }], () => [], { decisionInput: [{
            type: Input
        }], unauthenticated: [{
            type: Input
        }], type: [{
            type: Input
        }], mode: [{
            type: Input
        }], submitResponse: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PendingDecisionComponent, { className: "PendingDecisionComponent", filePath: "lib/components/pending-decision/pending-decision.component.ts", lineNumber: 37 }); })();
//# sourceMappingURL=data:application/json;base64,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