import { ChangeDetectionStrategy, Component, ElementRef, EventEmitter, forwardRef, Input, Output, ViewChild, ViewChildren } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR, Validators } from '@angular/forms';
import { NgbDropdown, NgbDropdownItem } from '@ng-bootstrap/ng-bootstrap';
import { fromEvent } from 'rxjs';
import { debounceTime, distinctUntilChanged, map, startWith, tap } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/common";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "@jsverse/transloco";
import * as i5 from "../../utility/pipes/highlight.pipe";
const _c0 = ["searchInput"];
const _c1 = ["inputField"];
const _c2 = a0 => ({ "d-inline-block": a0 });
const _c3 = (a0, a1, a2) => ({ "btn-select d-flex form-select": a0, "btn-link p-0": a1, "is-invalid": a2 });
const _c4 = a0 => ({ "active": a0 });
function SearchableDropdownComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function SearchableDropdownComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.selectItem(null)); })("keydown.arrowup", function SearchableDropdownComponent_div_0_div_7_button_1_Template_button_keydown_arrowup_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.dropdownItems.last.nativeElement.previousElementSibling.previousElementSibling.focus()); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(2, _c4, !ctx_r1.value));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.clearText);
} }
function SearchableDropdownComponent_div_0_div_7_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 14);
} }
function SearchableDropdownComponent_div_0_div_7_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 15);
    i0.ɵɵpipe(1, "highlight");
    i0.ɵɵlistener("click", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_click_0_listener() { const item_r5 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.selectItem(item_r5)); })("keydown.arrowup", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_keydown_arrowup_0_listener() { const i_r6 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r6 - 1)); })("keydown.arrowdown", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_keydown_arrowdown_0_listener() { const i_r6 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r6 + 1)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r5 = ctx.$implicit;
    const t_r7 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(5, _c4, ctx_r1.value && item_r5.value.uuid === ctx_r1.value.uuid))("innerHTML", i0.ɵɵpipeBind2(1, 2, t_r7(item_r5.display) + "", ctx_r1.searchText), i0.ɵɵsanitizeHtml);
} }
function SearchableDropdownComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵtemplate(1, SearchableDropdownComponent_div_0_div_7_button_1_Template, 2, 4, "button", 10)(2, SearchableDropdownComponent_div_0_div_7_div_2_Template, 1, 0, "div", 11)(3, SearchableDropdownComponent_div_0_div_7_button_3_Template, 2, 7, "button", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.items);
} }
function SearchableDropdownComponent_div_0_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵelement(1, "div", 17)(2, "div", 17)(3, "div", 17);
    i0.ɵɵelementEnd();
} }
function SearchableDropdownComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵlistener("openChange", function SearchableDropdownComponent_div_0_Template_div_openChange_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.firstLoad()); });
    i0.ɵɵelementStart(1, "button", 4, 0);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 5)(5, "input", 6, 1);
    i0.ɵɵlistener("keyup.arrowdown", function SearchableDropdownComponent_div_0_Template_input_keyup_arrowdown_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusOnItem(0)); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, SearchableDropdownComponent_div_0_div_7_Template, 4, 3, "div", 7)(8, SearchableDropdownComponent_div_0_div_8_Template, 4, 0, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r7 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c2, ctx_r1.buttonStyle !== "select"))("container", ctx_r1.container);
    i0.ɵɵadvance();
    i0.ɵɵproperty("disabled", ctx_r1.disabled)("ngClass", i0.ɵɵpureFunction3(9, _c3, ctx_r1.buttonStyle === "select", ctx_r1.buttonStyle !== "select", ctx_r1.touched && ctx_r1.invalid));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.value ? t_r7(ctx_r1.value.display) : t_r7(ctx_r1.placeholder) || "Select");
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
} }
export class SearchableDropdownComponent {
    constructor(_formBuilder, changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.onChange = null;
        this.onTouched = null;
        this.buttonStyle = 'button';
        this.searchQueryChange = new EventEmitter();
        this.required = false;
        this.invalid = false;
        this.touched = false;
        this.clearValueOnSelect = false;
        this.placeholder = 'Choose';
        this.clearText = 'None';
        this.container = null;
        this.disabled = false;
        this.searchText = '';
        this.loading = true;
    }
    ngOnChanges(changes) {
        if (changes.items) {
            this.loading = false;
        }
    }
    ngDoCheck() {
        if (this.touched) {
            return;
        }
        if (this.control?.touched) {
            this.touched = true;
            this.changeDetectorRef.detectChanges();
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    firstLoad() {
        if (!this.dropdown.isOpen()) {
            this.searchInput.nativeElement.value = '';
            return;
        }
        this.setTouched();
        if (this.keyupSubscription) {
            this.keyupSubscription.unsubscribe();
        }
        //this.searchQueryChange.next('');
        this.keyupSubscription = fromEvent(this.searchInput.nativeElement, 'keyup')
            .pipe(map(event => event.target.value), startWith(''), debounceTime(300), distinctUntilChanged(), tap((search) => this.searchText = search))
            .subscribe((search) => this.searchQueryChange.next(search));
        setTimeout(() => {
            this.focusOnSearchInput();
        });
    }
    selectItem(item) {
        if (!this.clearValueOnSelect) {
            this.value = item;
        }
        if (this.onChange) {
            this.onChange(item);
        }
        this.dropdown.close();
    }
    open() {
        this.dropdown.open();
    }
    focus() {
        this.inputField.nativeElement.focus();
    }
    setTouched() {
        this.touched = true;
        this.control?.markAsTouched();
        this.changeDetectorRef.detectChanges();
    }
    writeValue(value) {
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    validate(control) {
        this.control = control;
        this.required = control.hasValidator(Validators.required);
        if (this.required && !this.value) {
            this.invalid = true;
            return {
                required: true
            };
        }
        this.invalid = false;
        return null;
    }
    static { this.ɵfac = function SearchableDropdownComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SearchableDropdownComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SearchableDropdownComponent, selectors: [["xf-searchable-dropdown"]], viewQuery: function SearchableDropdownComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.inputField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { items: "items", buttonStyle: "buttonStyle", clearValueOnSelect: "clearValueOnSelect", placeholder: "placeholder", clearText: "clearText", container: "container", disabled: "disabled" }, outputs: { searchQueryChange: "searchQueryChange" }, features: [i0.ɵɵProvidersFeature([
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => SearchableDropdownComponent),
                    multi: true,
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => SearchableDropdownComponent),
                    multi: true
                }
            ]), i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["inputField", ""], ["searchInput", ""], ["ngbDropdown", "", 3, "ngClass", "container", "openChange", 4, "transloco"], ["ngbDropdown", "", 3, "openChange", "ngClass", "container"], ["type", "button", "id", "dropdownForm1", "ngbDropdownToggle", "", 1, "btn", "btn-sm", 3, "disabled", "ngClass"], ["ngbDropdownMenu", "", "aria-labelledby", "dropdownForm1", 1, "dropdown-menu-wide"], ["type", "text", "id", "searchDropdown", "placeholder", "Search", "autocomplete", "off", 1, "form-control", "form-control-sm", "lookup-search", 3, "keyup.arrowdown"], ["class", "dropdown-items", 4, "ngIf"], ["class", "p-3", 4, "ngIf"], [1, "dropdown-items"], ["type", "button", "ngbDropdownItem", "", 3, "ngClass", "click", "keydown.arrowup", 4, "ngIf"], ["class", "dropdown-divider", 4, "ngIf"], ["type", "button", "ngbDropdownItem", "", 3, "ngClass", "innerHTML", "click", "keydown.arrowup", "keydown.arrowdown", 4, "ngFor", "ngForOf"], ["type", "button", "ngbDropdownItem", "", 3, "click", "keydown.arrowup", "ngClass"], [1, "dropdown-divider"], ["type", "button", "ngbDropdownItem", "", 3, "click", "keydown.arrowup", "keydown.arrowdown", "ngClass", "innerHTML"], [1, "p-3"], [1, "bg-shimmer", "content-line"]], template: function SearchableDropdownComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, SearchableDropdownComponent_div_0_Template, 9, 13, "div", 2);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, i3.NgbDropdownButtonItem, i4.TranslocoDirective, i5.HighlightPipe], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.lookup-search[_ngcontent-%COMP%]{width:calc(100% - 30px);margin:5px 15px 10px}.dropdown-toggle[_ngcontent-%COMP%]:after{display:none}.dropdown-menu-wide[_ngcontent-%COMP%]{width:100%;font-size:12px}.dropdown-menu-wide[_ngcontent-%COMP%]   .dropdown-items[_ngcontent-%COMP%]{max-height:300px;overflow:auto}.dropdown-menu-wide[_ngcontent-%COMP%]   .dropdown-items[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%]{padding:8px 25px;font-size:12px;white-space:normal}.btn-select[_ngcontent-%COMP%]{width:100%;border:1px solid var(--form-default-border-color);background-color:var(--form-default-bg-color);border-radius:3px;text-align:left;color:var(--btn-select-color)}.btn-select.btn-sm[_ngcontent-%COMP%]{padding:8.25px 10px}.btn-select.btn-sm[_ngcontent-%COMP%]:disabled{cursor:not-allowed;pointer-events:auto}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SearchableDropdownComponent, [{
        type: Component,
        args: [{ selector: 'xf-searchable-dropdown', changeDetection: ChangeDetectionStrategy.OnPush, providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => SearchableDropdownComponent),
                        multi: true,
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => SearchableDropdownComponent),
                        multi: true
                    }
                ], template: "<div ngbDropdown [ngClass]=\"{'d-inline-block': buttonStyle !== 'select'}\" (openChange)=\"firstLoad()\" *transloco=\"let t\"\n  [container]=\"container\">\n  <button type=\"button\" class=\"btn btn-sm\" [disabled]=\"disabled\"\n    [ngClass]=\"{'btn-select d-flex form-select': buttonStyle === 'select', 'btn-link p-0': buttonStyle !== 'select', 'is-invalid': touched && invalid}\"\n    id=\"dropdownForm1\" ngbDropdownToggle #inputField>{{ value ? t(value.display) : t(placeholder) || 'Select' }}</button>\n  <div ngbDropdownMenu aria-labelledby=\"dropdownForm1\" class=\"dropdown-menu-wide\">\n    <input type=\"text\" class=\"form-control form-control-sm lookup-search\" id=\"searchDropdown\" #searchInput\n      placeholder=\"Search\" (keyup.arrowdown)=\"focusOnItem(0)\" autocomplete=\"off\">\n    <div *ngIf=\"!loading\" class=\"dropdown-items\">\n      <button type=\"button\" ngbDropdownItem *ngIf=\"!required\" (click)=\"selectItem(null)\"\n        (keydown.arrowup)=\"dropdownItems.last.nativeElement.previousElementSibling.previousElementSibling.focus()\"\n        [ngClass]=\"{'active': !value}\">{{ clearText }}</button>\n      <div class=\"dropdown-divider\" *ngIf=\"!required\"></div>\n      <button type=\"button\" ngbDropdownItem *ngFor=\"let item of items; let i = index\" (click)=\"selectItem(item)\"\n        (keydown.arrowup)=\"focusOnItem(i - 1)\" (keydown.arrowdown)=\"focusOnItem(i + 1)\"\n        [ngClass]=\"{'active': value && item.value.uuid === value.uuid}\" [innerHTML]=\"(t(item.display) + '') | highlight: searchText\"></button>\n    </div>\n    <div class=\"p-3\" *ngIf=\"loading\">\n      <div class=\"bg-shimmer content-line\"></div>\n      <div class=\"bg-shimmer content-line\"></div>\n      <div class=\"bg-shimmer content-line\"></div>\n    </div>\n  </div>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.lookup-search{width:calc(100% - 30px);margin:5px 15px 10px}.dropdown-toggle:after{display:none}.dropdown-menu-wide{width:100%;font-size:12px}.dropdown-menu-wide .dropdown-items{max-height:300px;overflow:auto}.dropdown-menu-wide .dropdown-items .dropdown-item{padding:8px 25px;font-size:12px;white-space:normal}.btn-select{width:100%;border:1px solid var(--form-default-border-color);background-color:var(--form-default-bg-color);border-radius:3px;text-align:left;color:var(--btn-select-color)}.btn-select.btn-sm{padding:8.25px 10px}.btn-select.btn-sm:disabled{cursor:not-allowed;pointer-events:auto}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i0.ChangeDetectorRef }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], inputField: [{
            type: ViewChild,
            args: ['inputField']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], items: [{
            type: Input
        }], buttonStyle: [{
            type: Input
        }], searchQueryChange: [{
            type: Output
        }], clearValueOnSelect: [{
            type: Input
        }], placeholder: [{
            type: Input
        }], clearText: [{
            type: Input
        }], container: [{
            type: Input
        }], disabled: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SearchableDropdownComponent, { className: "SearchableDropdownComponent", filePath: "lib/components/searchable-dropdown/searchable-dropdown.component.ts", lineNumber: 25 }); })();
//# sourceMappingURL=data:application/json;base64,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