import { CommonModule } from '@angular/common';
import { Component, Input, forwardRef } from '@angular/core';
import { FormsModule, NG_VALUE_ACCESSOR } from '@angular/forms';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
export class SlideToggleComponent {
    constructor() {
        this.isChecked = false;
        this.inputId = 'toggle';
        this.onChange = () => { };
        this.onTouched = () => { };
    }
    writeValue(value) {
        this.isChecked = value;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setChecked(value) {
        this.isChecked = value;
        this.onChange(value);
        this.onTouched();
    }
    static { this.ɵfac = function SlideToggleComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SlideToggleComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SlideToggleComponent, selectors: [["xf-slide-toggle"]], inputs: { inputId: "inputId" }, standalone: true, features: [i0.ɵɵProvidersFeature([
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => SlideToggleComponent),
                    multi: true,
                },
            ]), i0.ɵɵStandaloneFeature], decls: 3, vars: 3, consts: [[1, "slide-toggle"], ["type", "checkbox", 3, "ngModelChange", "id", "ngModel"], [1, "slider", 3, "for"]], template: function SlideToggleComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "input", 1);
            i0.ɵɵlistener("ngModelChange", function SlideToggleComponent_Template_input_ngModelChange_1_listener($event) { return ctx.setChecked($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelement(2, "label", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("id", ctx.inputId)("ngModel", ctx.isChecked);
            i0.ɵɵadvance();
            i0.ɵɵproperty("for", ctx.inputId);
        } }, dependencies: [CommonModule, FormsModule, i1.CheckboxControlValueAccessor, i1.NgControlStatus, i1.NgModel], styles: [".slide-toggle[_ngcontent-%COMP%]{display:inline-block;position:relative;width:40px;height:20px}.slide-toggle[_ngcontent-%COMP%]   input[type=checkbox][_ngcontent-%COMP%]{display:none}.slider[_ngcontent-%COMP%]{position:absolute;cursor:pointer;inset:0;background-color:var(--btn-toggle-bg-color);transition:.3s;border-radius:15px}.slider[_ngcontent-%COMP%]:before{position:absolute;content:\"\";height:20px;width:20px;background-color:#fff;transition:.3s;border-radius:50%}input[_ngcontent-%COMP%]:checked + .slider[_ngcontent-%COMP%]{background-color:var(--btn-primary-bg-color)}input[_ngcontent-%COMP%]:focus + .slider[_ngcontent-%COMP%]{box-shadow:0 0 1px var(--btn-primary-bg-color)}input[_ngcontent-%COMP%]:checked + .slider[_ngcontent-%COMP%]:before{transform:translate(20px)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SlideToggleComponent, [{
        type: Component,
        args: [{ selector: 'xf-slide-toggle', providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => SlideToggleComponent),
                        multi: true,
                    },
                ], standalone: true, imports: [CommonModule, FormsModule], template: "<div class=\"slide-toggle\">\n  <input\n    type=\"checkbox\"\n    [id]=\"inputId\"\n    [ngModel]=\"isChecked\"\n    (ngModelChange)=\"setChecked($event)\"\n  />\n  <label [for]=\"inputId\" class=\"slider\"></label>\n</div>\n", styles: [".slide-toggle{display:inline-block;position:relative;width:40px;height:20px}.slide-toggle input[type=checkbox]{display:none}.slider{position:absolute;cursor:pointer;inset:0;background-color:var(--btn-toggle-bg-color);transition:.3s;border-radius:15px}.slider:before{position:absolute;content:\"\";height:20px;width:20px;background-color:#fff;transition:.3s;border-radius:50%}input:checked+.slider{background-color:var(--btn-primary-bg-color)}input:focus+.slider{box-shadow:0 0 1px var(--btn-primary-bg-color)}input:checked+.slider:before{transform:translate(20px)}\n"] }]
    }], null, { inputId: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SlideToggleComponent, { className: "SlideToggleComponent", filePath: "lib/components/slide-toggle/slide-toggle.component.ts", lineNumber: 19 }); })();
//# sourceMappingURL=data:application/json;base64,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