import { CommonModule } from '@angular/common';
import { ChangeDetectorRef, Component, ElementRef, Input, ViewChild, ViewChildren, forwardRef, inject } from '@angular/core';
import { NG_VALUE_ACCESSOR, ReactiveFormsModule } from '@angular/forms';
import { RouterModule } from '@angular/router';
import { NgbDropdown, NgbDropdownItem, NgbDropdownModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslocoModule } from '@jsverse/transloco';
import { concatMap, debounceTime, map, of } from 'rxjs';
import { Tag } from '../../core/models/tag';
import { ApiService } from '../../core/services/api.service';
import { EntityService } from '../../core/services/entity.service';
import { FIXED_MODULE } from '../../core/constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/common";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "@jsverse/transloco";
const _c0 = ["searchInput"];
const _c1 = ["tagsBaseUrl", ""];
const _c2 = (a0, a1) => ({ "form-control-sm": a0, "form-control-xs": a1 });
const _c3 = a0 => ({ "invisible": a0 });
function TagsInputComponent_span_2_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "span", 5);
    i0.ɵɵtext(1);
    i0.ɵɵelementStart(2, "button", 6);
    i0.ɵɵlistener("click", function TagsInputComponent_span_2_Template_button_click_2_listener() { const tag_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.removeTag(tag_r2)); });
    i0.ɵɵtext(3, "\u00D7");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tag_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", tag_r2, " ");
} }
function TagsInputComponent_div_3_li_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li")(1, "a", 12);
    i0.ɵɵlistener("click", function TagsInputComponent_div_3_li_4_Template_a_click_1_listener() { const tag_r6 = i0.ɵɵrestoreView(_r5).$implicit; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.addTag(tag_r6)); })("keydown.enter", function TagsInputComponent_div_3_li_4_Template_a_keydown_enter_1_listener() { const tag_r6 = i0.ɵɵrestoreView(_r5).$implicit; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.addTag(tag_r6)); })("keydown.arrowup", function TagsInputComponent_div_3_li_4_Template_a_keydown_arrowup_1_listener() { const i_r7 = i0.ɵɵrestoreView(_r5).index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.focusOnItem(i_r7 - 1)); })("keydown.arrowdown", function TagsInputComponent_div_3_li_4_Template_a_keydown_arrowdown_1_listener() { const i_r7 = i0.ɵɵrestoreView(_r5).index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.focusOnItem(i_r7 + 1)); });
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tag_r6 = ctx.$implicit;
    const t_r8 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", t_r8(tag_r6), " ");
} }
function TagsInputComponent_div_3_li_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li");
    i0.ɵɵelement(1, "div", 13);
    i0.ɵɵelementEnd();
} }
function TagsInputComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 7)(1, "input", 8, 0);
    i0.ɵɵlistener("keyup.arrowdown", function TagsInputComponent_div_3_Template_input_keyup_arrowdown_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.focusOnItem(0)); })("keydown.tab", function TagsInputComponent_div_3_Template_input_keydown_tab_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onTab()); })("keydown.enter", function TagsInputComponent_div_3_Template_input_keydown_enter_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onEnter()); })("keydown.backspace", function TagsInputComponent_div_3_Template_input_keydown_backspace_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onBackspace()); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 9);
    i0.ɵɵtemplate(4, TagsInputComponent_div_3_li_4_Template, 3, 1, "li", 10)(5, TagsInputComponent_div_3_li_5_Template, 2, 0, "li", 11);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(5, _c2, ctx_r2.size === "sm", ctx_r2.size === "xs"))("placeholder", ctx_r2.placeholder || "Press Tab to add a tag");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(8, _c3, !ctx_r2.filteredTags.length));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.filteredTags);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.loading);
} }
export class TagsInputComponent {
    constructor(formBuilder) {
        this.loading = false;
        this.placeholder = '';
        this.size = 'sm';
        this.filteredTags = [];
        this.apiService = inject(ApiService);
        this.entityService = inject(EntityService);
        this.changeDetectorRef = inject(ChangeDetectorRef);
        this.tags = [];
        this.formGroup = formBuilder.group({
            searchText: ['']
        });
    }
    // Register change handler
    registerOnChange(fn) {
        this.onChange = fn;
    }
    // Register touched handler
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    // Write value
    writeValue(value) {
        if (Array.isArray(value)) {
            this.tags = value;
        }
    }
    ngOnInit() {
        this.formGroup.valueChanges.pipe(debounceTime(300), concatMap((values) => {
            if (values.searchText) {
                return this.applySearch(values.searchText);
            }
            return of();
        })).subscribe();
    }
    applySearch(searchText) {
        this.loading = true;
        return this.entityService.build(FIXED_MODULE.TAGS).pipe(concatMap((tagsEntity) => {
            tagsEntity.baseUrl = this.tagsBaseUrl;
            return this.apiService.getList(tagsEntity, Tag, {
                search: searchText
            }).pipe(map((tags) => {
                this.filteredTags = tags.map((tagObject) => tagObject.name).filter((tag) => this.tags.indexOf(tag) === -1);
                this.loading = false;
                this.dropdown.open(); // Ensure it is open
                this.changeDetectorRef.detectChanges();
            }));
        }));
    }
    onTab() {
        this.addTag(this.formGroup.get('searchText')?.value);
    }
    onEnter() {
        this.addTag(this.formGroup.get('searchText')?.value);
    }
    addTag(tag) {
        if (this.tags.indexOf(tag) === -1) {
            this.tags.push(tag);
        }
        this.formGroup.get('searchText')?.setValue('');
        if (this.onChange) {
            this.onChange(this.tags);
        }
        this.focusOnSearchInput();
        this.filteredTags = [];
        if (this.onTouched) {
            this.onTouched();
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    onBackspace() {
        if (!this.formGroup.get('searchText')?.value) {
            this.removeTag(this.tags[this.tags.length - 1]);
        }
    }
    removeTag(tag) {
        const index = this.tags.indexOf(tag);
        if (index !== -1) {
            this.tags.splice(index, 1);
        }
        if (this.onChange) {
            this.onChange(this.tags);
        }
        if (this.onTouched) {
            this.onTouched();
        }
    }
    static { this.ɵfac = function TagsInputComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TagsInputComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TagsInputComponent, selectors: [["xf-tags-input", "tagsBaseUrl", ""]], viewQuery: function TagsInputComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { placeholder: "placeholder", size: "size", tagsBaseUrl: "tagsBaseUrl" }, standalone: true, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => TagsInputComponent),
                    multi: true
                }]), i0.ɵɵStandaloneFeature], attrs: _c1, decls: 4, vars: 6, consts: [["searchInput", ""], [1, "form-control", "padding-0px", 3, "click", "ngClass", "formGroup"], [1, "d-inline-block"], ["class", "tag-chip", 4, "ngFor", "ngForOf"], ["ngbDropdown", "", "container", "body", "class", "d-inline-block", 4, "transloco"], [1, "tag-chip"], ["type", "button", 1, "close", 3, "click"], ["ngbDropdown", "", "container", "body", 1, "d-inline-block"], ["type", "text", "id", "searchDropdown", "formControlName", "searchText", "ngbDropdownToggle", "", "autocomplete", "off", 1, "lookup-search", "border-0", "shadow-none", "form-control", 3, "keyup.arrowdown", "keydown.tab", "keydown.enter", "keydown.backspace", "ngClass", "placeholder"], ["ngbDropdownMenu", "", "aria-labelledby", "tags", 1, "dropdown-menu", "mx-0", "border-0", "shadow", 3, "ngClass"], [4, "ngFor", "ngForOf"], [4, "ngIf"], ["ngbDropdownItem", "", "id", "clone-collection-btn", 1, "cursor-pointer", 3, "click", "keydown.enter", "keydown.arrowup", "keydown.arrowdown"], [1, "bg-shimmer", "content-line"]], template: function TagsInputComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 1);
            i0.ɵɵlistener("click", function TagsInputComponent_Template_div_click_0_listener() { return ctx.focusOnItem(-1); });
            i0.ɵɵelementStart(1, "div", 2);
            i0.ɵɵtemplate(2, TagsInputComponent_span_2_Template, 4, 1, "span", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(3, TagsInputComponent_div_3_Template, 6, 10, "div", 4);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c2, ctx.size === "sm", ctx.size === "xs"))("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.tags);
        } }, dependencies: [RouterModule, CommonModule, i2.NgClass, i2.NgForOf, i2.NgIf, ReactiveFormsModule, i1.DefaultValueAccessor, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, NgbDropdownModule, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, TranslocoModule, i4.TranslocoDirective], styles: [".close[_ngcontent-%COMP%]{cursor:pointer;background:none;border:none;color:rgb(var(--bs-danger-rgb))}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TagsInputComponent, [{
        type: Component,
        args: [{ selector: 'xf-tags-input[tagsBaseUrl]', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => TagsInputComponent),
                        multi: true
                    }], standalone: true, imports: [RouterModule, CommonModule, ReactiveFormsModule, NgbDropdownModule, TranslocoModule], template: "<div class=\"form-control padding-0px\" [ngClass]=\"{'form-control-sm': size === 'sm', 'form-control-xs': size === 'xs'}\" [formGroup]=\"formGroup\" (click)=\"focusOnItem(-1)\">\n  <div class=\"d-inline-block\">\n    <span *ngFor=\"let tag of tags\" class=\"tag-chip\">\n      {{ tag }}\n      <button type=\"button\" class=\"close\" (click)=\"removeTag(tag)\">&times;</button>\n    </span>\n  </div>\n  <div ngbDropdown *transloco=\"let t\" container=\"body\" class=\"d-inline-block\">\n    <input type=\"text\" class=\"lookup-search border-0 shadow-none form-control\" [ngClass]=\"{'form-control-sm': size === 'sm', 'form-control-xs': size === 'xs'}\" id=\"searchDropdown\" #searchInput\n      formControlName=\"searchText\" [placeholder]=\"placeholder || 'Press Tab to add a tag'\" ngbDropdownToggle (keyup.arrowdown)=\"focusOnItem(0)\"\n      autocomplete=\"off\" (keydown.tab)=\"onTab()\" (keydown.enter)=\"onEnter()\" (keydown.backspace)=\"onBackspace()\">\n    <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\" [ngClass]=\"{'invisible': !filteredTags.length}\"\n      aria-labelledby=\"tags\">\n      <li *ngFor=\"let tag of filteredTags; let i = index\">\n        <a ngbDropdownItem id=\"clone-collection-btn\" class=\"cursor-pointer\" (click)=\"addTag(tag)\"\n          (keydown.enter)=\"addTag(tag)\" (keydown.arrowup)=\"focusOnItem(i - 1)\" (keydown.arrowdown)=\"focusOnItem(i + 1)\">\n          {{ t(tag) }}\n        </a>\n      </li>\n      <li *ngIf=\"loading\">\n        <div class=\"bg-shimmer content-line\"></div>\n      </li>\n    </div>\n  </div>\n\n</div>\n", styles: [".close{cursor:pointer;background:none;border:none;color:rgb(var(--bs-danger-rgb))}\n"] }]
    }], () => [{ type: i1.FormBuilder }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], placeholder: [{
            type: Input
        }], size: [{
            type: Input
        }], tagsBaseUrl: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TagsInputComponent, { className: "TagsInputComponent", filePath: "lib/components/tags-input/tags-input.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,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