import { Component, forwardRef, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { SearchableDropdownComponent } from '../../searchable-dropdown/searchable-dropdown.component';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/timezone.service";
import * as i2 from "../../searchable-dropdown/searchable-dropdown.component";
import * as i3 from "@angular/forms";
export class TimezoneSelectComponent {
    constructor(timezoneService, changeDetectorRef) {
        this.timezoneService = timezoneService;
        this.changeDetectorRef = changeDetectorRef;
        this.timezoneList = [];
        this.items = [];
        this.filteredItems = [];
        this.selectedValue = null;
        this.selectedTimezone = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.touched = false;
        this.disabled = false;
    }
    valueChange(value) {
        this.selectedTimezone = this.timezoneList.find((timezone) => timezone.value === value) || null;
        this.onChange(this.selectedTimezone);
    }
    ngOnInit() {
        this.timezoneList = this.timezoneService.getUtcList();
        this.items = this.timezoneList.map((timezone) => {
            return {
                display: timezone.text,
                value: timezone.value,
                uuid: timezone.value
            };
        });
        this.selectSearchableItem();
    }
    selectSearchableItem() {
        this.selectedValue = this.items.find((item) => item.uuid === this.selectedTimezone?.value) || null;
    }
    loadItems(search) {
        search = search.toLowerCase();
        this.filteredItems = this.items.filter((item) => item.display.toLowerCase().indexOf(search) > -1 || item.value.toLowerCase().indexOf(search) > -1);
        this.changeDetectorRef.detectChanges();
    }
    writeValue(value) {
        this.selectedTimezone = value;
        this.selectSearchableItem();
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    markAsTouched() {
        if (!this.touched) {
            this.onTouched();
            this.touched = true;
        }
    }
    focus() {
        this.searchableDropdownComponent.focus();
    }
    get valid() {
        return !this.searchableDropdownComponent.invalid;
    }
    setDisabledState(disabled) {
        this.disabled = disabled;
    }
    validate(control) {
        const required = control.value;
        if (required <= 0) {
            return {
                required: {
                    required
                }
            };
        }
        return null;
    }
    static { this.ɵfac = function TimezoneSelectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneSelectComponent)(i0.ɵɵdirectiveInject(i1.TimezoneService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TimezoneSelectComponent, selectors: [["xf-timezone-select"]], viewQuery: function TimezoneSelectComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchableDropdownComponent = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => TimezoneSelectComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => TimezoneSelectComponent),
                    multi: true
                }])], decls: 2, vars: 3, consts: [[1, "form-group"], [3, "ngModelChange", "searchQueryChange", "ngModel", "items", "buttonStyle"]], template: function TimezoneSelectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "xf-searchable-dropdown", 1);
            i0.ɵɵtwoWayListener("ngModelChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_ngModelChange_1_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.selectedValue, $event) || (ctx.selectedValue = $event); return $event; });
            i0.ɵɵlistener("ngModelChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_ngModelChange_1_listener() { return ctx.valueChange(ctx.selectedValue == null ? null : ctx.selectedValue.value); })("searchQueryChange", function TimezoneSelectComponent_Template_xf_searchable_dropdown_searchQueryChange_1_listener($event) { return ctx.loadItems($event); });
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵtwoWayProperty("ngModel", ctx.selectedValue);
            i0.ɵɵproperty("items", ctx.filteredItems)("buttonStyle", "select");
        } }, dependencies: [i2.SearchableDropdownComponent, i3.NgControlStatus, i3.NgModel] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneSelectComponent, [{
        type: Component,
        args: [{ selector: 'xf-timezone-select', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => TimezoneSelectComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => TimezoneSelectComponent),
                        multi: true
                    }], template: "\n<div class=\"form-group\">\n  <xf-searchable-dropdown [(ngModel)]=\"selectedValue\" (ngModelChange)=\"valueChange(selectedValue?.value)\" [items]=\"filteredItems\" (searchQueryChange)=\"loadItems($event)\" [buttonStyle]=\"'select'\"></xf-searchable-dropdown>\n</div>\n" }]
    }], () => [{ type: i1.TimezoneService }, { type: i0.ChangeDetectorRef }], { searchableDropdownComponent: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TimezoneSelectComponent, { className: "TimezoneSelectComponent", filePath: "lib/components/timezone/timezone-select/timezone-select.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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