import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { map, of } from "rxjs";
import { ViewContainerDirective } from '../../utility/directives/view-container.directive';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "../../utility/directives/view-container.directive";
const _c0 = ["wizardForm"];
const _c1 = ["wizard", ""];
const _c2 = (a0, a1) => ({ "wizard-with-title": a0, "wizard-no-secondary-nav": a1 });
const _c3 = a0 => ({ "padding-left-16px padding-right-16px padding-top-8px padding-bottom-8px": a0 });
const _c4 = (a0, a1) => ({ "completed": a0, "active": a1 });
const _c5 = (a0, a1) => ({ "fa-check font-size-10px": a0, "fa-circle font-size-8px": a1 });
const _c6 = (a0, a1, a2, a3) => ({ "first": a0, "last": a1, "active": a2, "completed": a3 });
const _c7 = (a0, a1, a2, a3) => ({ "float-end": a0, "btn-primary": a1, "btn-secondary": a2, "btn-outline-secondary": a3 });
function WizardComponent_div_5_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 10)(2, "div", 11);
    i0.ɵɵelement(3, "span", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(4, "div", 13);
    i0.ɵɵelementStart(5, "div", 14);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const step_r1 = ctx.$implicit;
    const i_r2 = ctx.index;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c4, step_r1.isComplete || ctx_r2.wizard.currentStepIndex === ctx_r2.enabledSteps.length - 1, i_r2 === ctx_r2.wizard.currentStepIndex));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(7, _c5, step_r1.isComplete, !step_r1.isComplete));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction4(10, _c6, i_r2 === 0, i_r2 === ctx_r2.enabledSteps.length - 1, i_r2 === ctx_r2.wizard.currentStepIndex, step_r1.isComplete));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(step_r1.title);
} }
function WizardComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵtemplate(1, WizardComponent_div_5_ng_container_1_Template, 7, 15, "ng-container", 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.enabledSteps);
} }
function WizardComponent_ng_template_7_Template(rf, ctx) { }
function WizardComponent_ng_container_9_button_1_i_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 19);
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon ? button_r5.disabledIcon : button_r5.icon);
} }
function WizardComponent_ng_container_9_button_1_i_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 20);
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon ? button_r5.disabledIcon : button_r5.icon);
} }
function WizardComponent_ng_container_9_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 16);
    i0.ɵɵlistener("click", function WizardComponent_ng_container_9_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const button_r5 = i0.ɵɵnextContext().$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.buttonClicked(button_r5)); });
    i0.ɵɵtemplate(1, WizardComponent_ng_container_9_button_1_i_1_Template, 1, 1, "i", 17);
    i0.ɵɵtext(2);
    i0.ɵɵtemplate(3, WizardComponent_ng_container_9_button_1_i_3_Template, 1, 1, "i", 18);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const button_r5 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("disabled", button_r5.disabled)("ngClass", i0.ɵɵpureFunction4(6, _c7, button_r5.pullRight, button_r5.type === "primary", button_r5.type === "secondary", button_r5.type !== "primary" && button_r5.type !== "secondary"))("id", "wizard-" + button_r5.name + "-btn");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (button_r5.icon || (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon) && button_r5.iconPosition === "left");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", (ctx_r2.loading || button_r5.disabled) && button_r5.disabledText ? button_r5.disabledText : button_r5.text, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (button_r5.icon || (ctx_r2.loading || button_r5.disabled) && button_r5.disabledIcon) && button_r5.iconPosition === "right");
} }
function WizardComponent_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, WizardComponent_ng_container_9_button_1_Template, 4, 11, "button", 15);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const button_r5 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", button_r5 && !button_r5.hidden);
} }
export class WizardComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.subscriptions = [];
        this.loading = false;
        this.enabledSteps = [];
        this.onClose = new EventEmitter();
    }
    ngOnInit() {
        this.enabledSteps = this.wizard.steps.filter((step) => !step.disabled);
        let subscription = this.wizard.wizardChanged$.subscribe(() => {
            this.enabledSteps = this.wizard.steps.filter((step) => !step.disabled);
            this.changeDetectorRef.detectChanges();
        });
        this.wizard.next = () => this.next();
        this.wizard.back = () => this.back();
        this.wizard.close = (buttonName) => this.close(buttonName);
        this.subscriptions.push(subscription);
    }
    ngAfterViewInit() {
        this.loadStepView(this.wizard.currentStepIndex);
    }
    loadStepView(stepIndex) {
        const step = this.enabledSteps[stepIndex];
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(step.component);
        this.componentRef.instance.wizard = this.wizard;
        this.componentRef.instance.step = step;
        this.componentRef.instance.wizardForm = this.wizardForm;
        this.changeDetectorRef.detectChanges();
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    buttonClicked(button) {
        button.disabled = true;
        this.loading = true;
        this.changeDetectorRef.detectChanges();
        let observable$ = of(null);
        if (button.action === 'next') {
            observable$ = this.next(button.name);
        }
        else if (button.action === 'back') {
            this.back();
            this.loading = false;
        }
        else if (button.action === 'close') {
            this.close(button.name);
            return;
        }
        else if (button.action === 'submit') {
            observable$ = this.submit(button.name);
        }
        else if (button.action === 'skip') {
            this.skipToStep(this.wizard.currentStepIndex + 2);
        }
        if (this.buttonSubscription) {
            this.buttonSubscription.unsubscribe();
        }
        this.buttonSubscription = observable$.subscribe({
            complete: () => {
                button.disabled = false;
                this.loading = false;
                this.changeDetectorRef.detectChanges();
                this.buttonSubscription = undefined;
            }
        });
        this.subscriptions.push(this.buttonSubscription);
    }
    submit(buttonName) {
        const currentStep = this.enabledSteps[this.wizard.currentStepIndex];
        let observable$;
        if (currentStep && this.componentRef) {
            observable$ = this.componentRef.instance.submit(buttonName).pipe(map((valid) => {
                if (valid) {
                    currentStep.isComplete = true;
                }
                return valid;
            }));
        }
        else {
            observable$ = of(false);
        }
        return observable$;
    }
    next(buttonName) {
        return this.submit(buttonName).pipe(map((valid) => {
            if (valid) {
                this.wizard.currentStepIndex = this.wizard.currentStepIndex + 1;
                this.loadStepView(this.wizard.currentStepIndex);
            }
        }));
    }
    back() {
        this.wizard.currentStepIndex = this.wizard.currentStepIndex - 1;
        this.loadStepView(this.wizard.currentStepIndex);
    }
    close(buttonName) {
        this.onClose.emit();
    }
    navigateToStep(stepIndex) {
        this.wizard.currentStepIndex = stepIndex;
        // this.enabledSteps.forEach((step, index) => {
        //   if (stepIndex < index) {
        //     step.isComplete = false;
        //   }
        // });
        this.loadStepView(this.wizard.currentStepIndex);
    }
    skipToStep(stepIndex) {
        this.wizard.currentStepIndex = stepIndex;
        this.enabledSteps.forEach((step, index) => {
            if (stepIndex > index) {
                step.isComplete = true;
            }
        });
        this.loadStepView(this.wizard.currentStepIndex);
    }
    ngOnDestroy() {
        this.subscriptions.forEach((subscription) => subscription.unsubscribe());
    }
    static { this.ɵfac = function WizardComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WizardComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WizardComponent, selectors: [["xf-wizard", "wizard", ""]], viewQuery: function WizardComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.wizardForm = _t.first);
        } }, inputs: { wizard: "wizard" }, outputs: { onClose: "onClose" }, attrs: _c1, decls: 10, vars: 9, consts: [["wizardForm", "ngForm"], [1, "wizard", 3, "ngClass"], [1, "wizard-header-container"], [1, "wizard-header", "padding-left-16px", "padding-right-16px", "solid-border-bottom-1"], ["class", "wizard-steps w-100", 4, "ngIf"], [1, "wizard-body", "padding-left-16px", "padding-right-16px", "padding-bottom-40px"], ["xfViewContainer", "", 1, "h-100"], [1, "wizard-footer", 3, "ngClass"], [4, "ngFor", "ngForOf"], [1, "wizard-steps", "w-100"], [1, "wizard-step", 3, "ngClass"], [1, "step-counter"], [1, "fa", 3, "ngClass"], [1, "step-progress-bar", "w-100", 3, "ngClass"], [1, "step-name"], ["type", "button", "class", "btn btn-secondary btn-sm margin-left-8px", 3, "disabled", "ngClass", "id", "click", 4, "ngIf"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "margin-left-8px", 3, "click", "disabled", "ngClass", "id"], ["class", "me-1", 3, "ngClass", 4, "ngIf"], ["class", "ms-1", 3, "ngClass", 4, "ngIf"], [1, "me-1", 3, "ngClass"], [1, "ms-1", 3, "ngClass"]], template: function WizardComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", null, 0)(2, "div", 1)(3, "div", 2)(4, "div", 3);
            i0.ɵɵtemplate(5, WizardComponent_div_5_Template, 2, 1, "div", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 5);
            i0.ɵɵtemplate(7, WizardComponent_ng_template_7_Template, 0, 0, "ng-template", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 7);
            i0.ɵɵtemplate(9, WizardComponent_ng_container_9_Template, 2, 1, "ng-container", 8);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c2, ctx.wizard.title, ctx.wizard.data.noSecondaryNav));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.enabledSteps.length > 1);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c3, ctx.enabledSteps[ctx.wizard.currentStepIndex].buttons.length > 0));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.enabledSteps[ctx.wizard.currentStepIndex].buttons);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatusGroup, i2.NgForm, i3.ViewContainerDirective], styles: [".wizard.wizard-with-title[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]{padding-bottom:0}.wizard[_ngcontent-%COMP%]   .wizard-header-container[_ngcontent-%COMP%]{position:sticky;top:0;z-index:1}.wizard[_ngcontent-%COMP%]   .wizard-header-container[_ngcontent-%COMP%]   .wizard-title-content[_ngcontent-%COMP%]{background:var(--wizard-header-bg-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]{display:inline-flex;justify-content:space-between;margin:15px auto 10px}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]{position:relative;display:flex;flex-direction:column;align-items:center;flex:1}@media (max-width: 768px){.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]{font-size:12px}}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]{font-weight:700}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]   .step-name[_ngcontent-%COMP%]{font-weight:400}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.active[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{outline:4px solid var(--wizard-step-active-color);background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]   .step-name[_ngcontent-%COMP%]{font-size:12px;font-weight:400}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{position:relative;z-index:5;display:flex;justify-content:center;align-items:center;width:25px;height:25px;border-radius:50%;background:var(--wizard-body-bg-color);border:1px solid var(--wizard-step-default-color);margin-bottom:6px}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .wizard-step.completed[_ngcontent-%COMP%]   .step-counter[_ngcontent-%COMP%]{background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar[_ngcontent-%COMP%]{position:absolute;display:inline-block;top:13px;border:1px solid #ccc;background-color:#ccc}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.active[_ngcontent-%COMP%], .wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.completed[_ngcontent-%COMP%], .wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.first[_ngcontent-%COMP%]{border:1px solid var(--wizard-step-highlight-color);background-color:var(--wizard-step-highlight-color)}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.first[_ngcontent-%COMP%]{left:50%}.wizard[_ngcontent-%COMP%]   .wizard-header[_ngcontent-%COMP%]   .wizard-steps[_ngcontent-%COMP%]   .step-progress-bar.last[_ngcontent-%COMP%]{right:50%;z-index:0}.wizard[_ngcontent-%COMP%]   .wizard-body[_ngcontent-%COMP%]{height:calc(100vh - 265px);overflow:auto;background:var(--wizard-body-bg-color)}.wizard[_ngcontent-%COMP%]   .wizard-footer[_ngcontent-%COMP%]{background:var(--wizard-footer-bg-color);border-top:1px solid var(--footer-border-color);position:absolute;bottom:0;right:0;transition:left .4s linear;width:100%;z-index:11}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WizardComponent, [{
        type: Component,
        args: [{ selector: 'xf-wizard[wizard]', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2022 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form #wizardForm=\"ngForm\">\n  <div class=\"wizard\"\n    [ngClass]=\"{'wizard-with-title' : wizard.title, 'wizard-no-secondary-nav' : wizard.data.noSecondaryNav}\">\n    <div class=\"wizard-header-container\">\n      <div class=\"wizard-header padding-left-16px padding-right-16px solid-border-bottom-1\">\n        <div class=\"wizard-steps w-100\" *ngIf=\"enabledSteps.length > 1\">\n          <ng-container *ngFor=\"let step of enabledSteps; let i = index\">\n            <div class=\"wizard-step\"\n              [ngClass]=\"{'completed': step.isComplete || wizard.currentStepIndex === enabledSteps.length - 1, 'active': i === wizard.currentStepIndex}\">\n              <div class=\"step-counter\">\n                <span class=\"fa\" [ngClass]=\"{'fa-check font-size-10px': step.isComplete, 'fa-circle font-size-8px': !step.isComplete}\"></span>\n              </div>\n              <div class=\"step-progress-bar w-100\"\n                [ngClass]=\"{'first': i === 0, 'last': i === enabledSteps.length - 1, 'active': i === wizard.currentStepIndex, 'completed': step.isComplete}\">\n              </div>\n              <div class=\"step-name\">{{step.title}}</div>\n            </div>\n          </ng-container>\n        </div>\n      </div>\n    </div>\n    <div class=\"wizard-body padding-left-16px padding-right-16px padding-bottom-40px\">\n      <ng-template xfViewContainer class=\"h-100\"></ng-template>\n    </div>\n    <div class=\"wizard-footer\"\n      [ngClass]=\"{'padding-left-16px padding-right-16px padding-top-8px padding-bottom-8px' : enabledSteps[wizard.currentStepIndex].buttons.length > 0}\">\n      <ng-container *ngFor=\"let button of enabledSteps[wizard.currentStepIndex].buttons\">\n        <button type=\"button\" class=\"btn btn-secondary btn-sm margin-left-8px\" (click)=\"buttonClicked(button)\"\n          [disabled]=\"button.disabled\" *ngIf=\"button && !button.hidden\"\n          [ngClass]=\"{'float-end': button.pullRight, 'btn-primary': button.type === 'primary', 'btn-secondary': button.type === 'secondary', 'btn-outline-secondary': button.type !== 'primary' && button.type !== 'secondary'}\"\n          [id]=\"'wizard-' + button.name + '-btn'\">\n          <i *ngIf=\"(button.icon || ((loading || button.disabled) && button.disabledIcon)) && button.iconPosition === 'left'\"\n            [ngClass]=\"(loading || button.disabled) && button.disabledIcon ? button.disabledIcon : button.icon\"\n            class=\"me-1\"></i>\n          {{ (loading || button.disabled) && button.disabledText ? button.disabledText : button.text }}\n          <i *ngIf=\"(button.icon || ((loading || button.disabled) && button.disabledIcon)) && button.iconPosition === 'right'\"\n            [ngClass]=\"(loading || button.disabled) && button.disabledIcon ? button.disabledIcon : button.icon\"\n            class=\"ms-1\"></i>\n        </button>\n      </ng-container>\n    </div>\n  </div>\n</form>\n", styles: [".wizard.wizard-with-title .wizard-header{padding-bottom:0}.wizard .wizard-header-container{position:sticky;top:0;z-index:1}.wizard .wizard-header-container .wizard-title-content{background:var(--wizard-header-bg-color)}.wizard .wizard-header .wizard-steps{display:inline-flex;justify-content:space-between;margin:15px auto 10px}.wizard .wizard-header .wizard-steps .wizard-step{position:relative;display:flex;flex-direction:column;align-items:center;flex:1}@media (max-width: 768px){.wizard .wizard-header .wizard-steps .wizard-step{font-size:12px}}.wizard .wizard-header .wizard-steps .wizard-step.active{font-weight:700}.wizard .wizard-header .wizard-steps .wizard-step.active .step-name{font-weight:400}.wizard .wizard-header .wizard-steps .wizard-step.active .step-counter{outline:4px solid var(--wizard-step-active-color);background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .wizard-step .step-name{font-size:12px;font-weight:400}.wizard .wizard-header .wizard-steps .wizard-step .step-counter{position:relative;z-index:5;display:flex;justify-content:center;align-items:center;width:25px;height:25px;border-radius:50%;background:var(--wizard-body-bg-color);border:1px solid var(--wizard-step-default-color);margin-bottom:6px}.wizard .wizard-header .wizard-steps .wizard-step.completed .step-counter{background-color:var(--wizard-step-highlight-color);border:1px solid var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .step-progress-bar{position:absolute;display:inline-block;top:13px;border:1px solid #ccc;background-color:#ccc}.wizard .wizard-header .wizard-steps .step-progress-bar.active,.wizard .wizard-header .wizard-steps .step-progress-bar.completed,.wizard .wizard-header .wizard-steps .step-progress-bar.first{border:1px solid var(--wizard-step-highlight-color);background-color:var(--wizard-step-highlight-color)}.wizard .wizard-header .wizard-steps .step-progress-bar.first{left:50%}.wizard .wizard-header .wizard-steps .step-progress-bar.last{right:50%;z-index:0}.wizard .wizard-body{height:calc(100vh - 265px);overflow:auto;background:var(--wizard-body-bg-color)}.wizard .wizard-footer{background:var(--wizard-footer-bg-color);border-top:1px solid var(--footer-border-color);position:absolute;bottom:0;right:0;transition:left .4s linear;width:100%;z-index:11}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }], { xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective]
        }], wizardForm: [{
            type: ViewChild,
            args: ['wizardForm']
        }], wizard: [{
            type: Input
        }], onClose: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WizardComponent, { className: "WizardComponent", filePath: "lib/components/wizard/wizard.component.ts", lineNumber: 14 }); })();
//# sourceMappingURL=data:application/json;base64,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