import { HttpContextToken } from "@angular/common/http";
export var TOKEN;
(function (TOKEN) {
    TOKEN["ACCESS_KEY"] = "access.token";
    TOKEN["REFRESH_KEY"] = "refresh.token";
    TOKEN["RESTRICTED_KEY"] = "restricted.token";
})(TOKEN || (TOKEN = {}));
export var MMD;
(function (MMD) {
    MMD["MODEL_METADATAS_KEY"] = "model_metadatas";
    MMD["STAGING_METADATAS_KEY"] = "staging_model_metadatas";
    MMD["STAGING_ATTRIBUTE_METADATA_KEY"] = "attribute_metadatas";
    MMD["SYSTEM_MODEL_METADATAS_KEY"] = "system_model_metadatas";
    MMD["VIEW_TEMPLATES_KEY"] = "view_templates";
    MMD["WIDGET_CONFIG_KEY"] = "widget_configs";
})(MMD || (MMD = {}));
export const RESERVED_KEYWORDS = {
    PLAYBOOKS: ['items', 'result', 'input', 'request', 'values', 'keys', 'files', 'env', 'message', 'step_variables', 'do_until', 'ignore_errors', 'when', 'for_each', 'cyops_playbook_iri', 'cyops_playbook_name', 'collaborationNote', 'inputVariables', 'displayConditions'],
    MMD_FIELDS: ['id', 'recordtags', 'createUser', 'createdate', 'modifyUser', 'modifydate', 'owners', 'tenant']
};
export var VIEW_TEMPLATES;
(function (VIEW_TEMPLATES) {
    VIEW_TEMPLATES["GRID_COLUMNS"] = "grid_columns";
    VIEW_TEMPLATES["TYPE"] = "SystemViewTemplate";
    VIEW_TEMPLATES["CACHE_PREFIX"] = "views.";
    VIEW_TEMPLATES["VIEW_API_BASE"] = "/api/views/1/";
    VIEW_TEMPLATES["SYSTEM_VIEW_TEMPLATES_MODEL"] = "system_view_templates";
})(VIEW_TEMPLATES || (VIEW_TEMPLATES = {}));
export var API;
(function (API) {
    API["API"] = "api/";
    API["BASE"] = "api/3/";
    API["API_APPMANAGER"] = "api/appmanager/";
    API["DELETE_WITH_QUERY"] = "api/3/delete-with-query/";
    API["BULK_UPDATE"] = "api/3/update/";
    API["API_3_BASE"] = "api/3/";
    API["INSERT"] = "api/3/insert/";
    API["QUERY"] = "api/query/";
    API["SYSTEM_MODULES"] = "api/system/fixtures";
    API["CURRENT_ACTOR"] = "actors/current";
    API["AUTH"] = "api/auth/";
    API["DAS"] = "auth/";
    API["WEBSOCKET"] = "websocket/cyops-websocket";
    API["INTEGRATIONS"] = "api/integration/";
    API["INTEGRATION_CONFIGURATION"] = "api/integration/configuration/";
    API["WORKFLOW_ACTION"] = "xf/api/workflows/actions";
    API["PUBLIC"] = "api/public/";
    API["RULE"] = "api/rule/";
    API["WORKFLOW"] = "api/workflow/";
    API["WORKFLOW_GROUPS"] = "workflow_groups/";
    API["WORKFLOW_STEPS"] = "workflow_steps/";
    API["WORKFLOWS"] = "workflows/";
    API["USERS"] = "api/auth/users/";
    API["TEAMS"] = "api/auth/teams/";
    API["QUERY_PART"] = "query/";
    API["SEALAB"] = "api/workflow/";
    API["TEMP_WORKFLOWS"] = "wf/api/";
    API["EXPRESSIONS"] = "api/workflow/expressions/";
    API["LOGOUT"] = "token/logout/";
    API["SCHEDULE"] = "api/workflow/schedules/";
    API["AUDIT"] = "api/audit/";
    API["PORTER"] = "api/appmanager/";
    API["RULE_ENGINE"] = "api/rule-engine/";
})(API || (API = {}));
export const OPERATOR_MAPPINGS = {
    contains: 'icontains',
    notContains: 'nicontains',
    equals: 'eq',
    notEqual: 'neq',
    startsWith: 'istartswith',
    endsWith: 'iendswith',
    lessThan: 'lt',
    lessThanOrEqual: 'lte',
    greaterThan: 'gt',
    greaterThanOrEqual: 'gte',
    in: 'in'
};
export const ALL_RECORDS_SIZE = 2147483647;
export const DEFAULT_NEW_MODULE_PERMISSIONS = { create: false, read: false, update: false, delete: false, execute: false, fields: {} };
export const DEFAULT_REPO_URL = 'https://@product_yum_server@/';
export var STORAGE_KEYS;
(function (STORAGE_KEYS) {
    STORAGE_KEYS["LOCAL_STORAGE_PREFIX"] = "xf.";
    STORAGE_KEYS["LOCAL_STORAGE_PERSIST_PREFIX"] = "persist:";
    STORAGE_KEYS["CURRENT_USER"] = "current_user";
    STORAGE_KEYS["CURRENT_PERMISSIONS"] = "current_user.roles";
    STORAGE_KEYS["SETTINGS_HISTORY"] = "settings_history";
    STORAGE_KEYS["SETTINGS_ACCOUNT_CONFIG"] = "account_configuration";
    STORAGE_KEYS["SYSTEM_SETTINGS"] = "system_settings";
    STORAGE_KEYS["USER_PREFERENCES"] = "user_preferences";
    STORAGE_KEYS["AUDIT_PURGE_SETTINGS"] = "audit_purge_settings";
    STORAGE_KEYS["WF_PURGE_SETTINGS"] = "wf_purge_settings";
    STORAGE_KEYS["LICENSE_DETAILS"] = "license_details";
})(STORAGE_KEYS || (STORAGE_KEYS = {}));
export var AUTH;
(function (AUTH) {
    AUTH["TOKEN"] = "TOKEN";
})(AUTH || (AUTH = {}));
export var THEMES;
(function (THEMES) {
    THEMES["DEFAULT"] = "dark";
})(THEMES || (THEMES = {}));
export var FIXED_MODULE;
(function (FIXED_MODULE) {
    FIXED_MODULE["XF_QUEUES"] = "xf_queues";
    FIXED_MODULE["SHIFTS"] = "shifts";
    FIXED_MODULE["APPROVAL"] = "approvals";
    FIXED_MODULE["APPLICATION"] = "application";
    FIXED_MODULE["PLAYBOOK"] = "playbooks";
    FIXED_MODULE["PLAYBOOK_VERSIONS"] = "versions";
    FIXED_MODULE["PLAYBOOK_STEPS"] = "playbook-steps";
    FIXED_MODULE["EVENTS"] = "events";
    FIXED_MODULE["PLAYBOOK_COLLECTION"] = "playbook-collections";
    FIXED_MODULE["PEOPLE"] = "people";
    FIXED_MODULE["COMMENTS"] = "comments";
    FIXED_MODULE["TEAMS"] = "teams";
    FIXED_MODULE["ROLES"] = "roles";
    FIXED_MODULE["ROLE_SERVICES"] = "services";
    FIXED_MODULE["ROLE_ENTITIES"] = "entities";
    FIXED_MODULE["ROLE_PERMISSIONS"] = "permissions";
    FIXED_MODULE["USERS"] = "users";
    FIXED_MODULE["AUDIT_LOGS"] = "audit-logs";
    FIXED_MODULE["APPLIANCES"] = "appliances";
    FIXED_MODULE["SECURITY"] = "security";
    FIXED_MODULE["EXPORT_TEMPLATES"] = "export-templates";
    FIXED_MODULE["EXPORT_JOBS"] = "export-jobs";
    FIXED_MODULE["IMPORT_JOBS"] = "import-jobs";
    FIXED_MODULE["FILES"] = "files";
    FIXED_MODULE["PICKLIST_NAMES"] = "picklist_names";
    FIXED_MODULE["PICKLISTS"] = "picklists";
    FIXED_MODULE["LEGACY_SYSTEM_VIEW_TEMPLATE"] = "system_view_templates";
    FIXED_MODULE["WIDGET_METADATAS"] = "widget_metadatas";
    FIXED_MODULE["DYNAMIC_CONTENT"] = "dynamic_content";
    FIXED_MODULE["SETTINGS_CATEGORIES"] = "settings_categories";
    FIXED_MODULE["SETTINGS_LINKS"] = "settings_links";
    FIXED_MODULE["SETTINGS_PAGES"] = "settings_pages";
    FIXED_MODULE["SCHEDULES"] = "schedules";
    FIXED_MODULE["VIEW_TEMPLATES"] = "view-templates";
    FIXED_MODULE["WIDGET_CONFIGS"] = "widget-configs";
    FIXED_MODULE["AGENTS"] = "agents";
    FIXED_MODULE["WORKFLOW_LOGS"] = "workflow_logs";
    FIXED_MODULE["CONNECTORS"] = "connectors";
    FIXED_MODULE["GLOBAL_VARIABLES"] = "global-variables";
    FIXED_MODULE["RULE"] = "rules";
    FIXED_MODULE["CHANNEL"] = "channels";
    FIXED_MODULE["PENDING_NOTIFICATION"] = "pending-notification";
    FIXED_MODULE["SYSTEM_NOTIFICATION"] = "system-notification";
    FIXED_MODULE["SOLUTION_PACK"] = "solution-packs";
    FIXED_MODULE["WIDGETS"] = "widgets";
    FIXED_MODULE["PLAYBOOK_EXECUTION_LOGS"] = "playbook-execution-logs";
    FIXED_MODULE["CONNECTOR_CONFIGURATIONS"] = "connector-configurations";
    FIXED_MODULE["REFERENCE_BLOCKS"] = "reference-blocks";
    FIXED_MODULE["CONTENT_HUB"] = "contenthub";
    FIXED_MODULE["DASHBOARD"] = "dashboard";
    FIXED_MODULE["DELIVERY_RULES"] = "delivery-rules";
    FIXED_MODULE["NOTIFICATIONS"] = "notifications";
    FIXED_MODULE["EXPRESSIONS"] = "expressions";
    FIXED_MODULE["APPLICATION_CONFIGURATION"] = "application-configuration";
    FIXED_MODULE["TAGS"] = "tags";
    FIXED_MODULE["SYSTEM_SETTINGS"] = "system-settings";
})(FIXED_MODULE || (FIXED_MODULE = {}));
export const MAX_PLAYBOOK_RECORDS = 250;
export const DEFAULT_GRID_ROWS = 20;
export const DEFAULT_LOOKUP_RECORDS = 30;
export const DEFAULT_CACHE_BLOCK_SIZE = 30;
export const MAX_TEXT_LENGTH = 10485761;
export const MIN_NUMBER_LIMIT = -2147483648;
export const SORT_ORDER = [{
        value: 'ASC',
        label: 'Ascending'
    }, {
        value: 'DESC',
        label: 'Descending'
    }];
export var CS_USER_TYPE;
(function (CS_USER_TYPE) {
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_SECADMIN"] = 1] = "CS_USERTYPE_SECADMIN";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_USER"] = 2] = "CS_USERTYPE_USER";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_APPLIANCE"] = 3] = "CS_USERTYPE_APPLIANCE";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_MSSP"] = 4] = "CS_USERTYPE_MSSP";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_NO_IDLE"] = 5] = "CS_USERTYPE_NO_IDLE";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_SAML"] = 6] = "CS_USERTYPE_SAML";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_LDAP"] = 7] = "CS_USERTYPE_LDAP";
    CS_USER_TYPE[CS_USER_TYPE["CS_USERTYPE_RADIUS"] = 8] = "CS_USERTYPE_RADIUS";
})(CS_USER_TYPE || (CS_USER_TYPE = {}));
export var USER_ACCESS_TYPE;
(function (USER_ACCESS_TYPE) {
    USER_ACCESS_TYPE["NAMED"] = "Named";
    USER_ACCESS_TYPE["CONCURRENT"] = "Concurrent";
})(USER_ACCESS_TYPE || (USER_ACCESS_TYPE = {}));
export const BRANDING_FALLBACK = {
    light: {
        'largeLogo': 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGcAAAAWCAYAAADdP4KdAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAOKSURBVHgB7VmNedowED34GCCdoOoGdII6EzSZoM4ETSbATBAygdkgzQQmE0AnsDsBbKDei09BKMISxPwlvO+7OJJPd/q5k54MkUBr/Ztlrt+isHRK3YyQLupSOiMKXfzhCRvwY8RyQbuFYsnZ3y2dEUSXJ0rxM6P9YsB+dx0IJw9kzoD2DyxMSmc0AouT0GGQ0CcBdgmWhDZEj6USWYeZ839bunO3QgbwS4oPnU5nZr1TtMzyJ373Z51h2TLvaT2euf2YIsC2rvjxk2XBbe5oO0xZFNsaso2MThESYaXL/OTdo8X4VMCO0s3IKb5PmfFLWwJjERsbEaEeHRE4qhY8AETnI0uCwXDdSOj3laghoyqKx5jl2amraI/g/l4iYDbs9+t9pEmio8yxWwTsFoG2wNzJpqjodTInDegmkpWl+M3tzLQzR+xCd+rRS6Q93vfl/0Le5VJOLX2Ma2DNU/GmrzqMgraADl9Yy4a2Si8vxFOrjYr0HbU4ur54G9gX8FIL1deri1M6Y5ibPsGPR6905iKzfE+1H6/suUtHCEn/Byn25Tm2twWZjMIRHwm412+zVsm771RvcTiov/DzG8uC6sty6thB3ZPoGGKABbz16MHGNcsNeSABY8Z1w7476IOUM9O/ozpzHMyc8j+nrCiOjl/Qmi8fPCcpnrreYjBZfUvXbQO2ZhYC5+APqs9BMDl3ga4D54thpBPDGsHi2OaK0jEvjpsF2IJGIA1SxuemMYWBDFyh3WbidE2TsY30I+xUTvkv1YujXMWIg1/5bLo0u0dh5rKg7VBt+172XSXFSxace4hk1L9sKbJIMX2bse7E40NRzQqBMdWMbiK+lMeOm0lf5VlRS9DLi+rMCsLjgV49zHOpy6y6ZEMb6RqdxNK58LTL1vkWvVLqDCMzhEB7fJWOzZGUbUKRuH6OkRCYaK5oeUiOaBmhuW7no2ll/Z/LxDUxU0RyIYvxcuOX+gfaHCOxh3GAtcHe67hNpvd0mCrPzGcLiWTVki4O2Gu7wmExQ7N3y+UUzMdsOTiAM3oHYJttYvGxVV6JoIyDPvE0Wcj7e7vc9Bkp4BtMEQtiiAgwIZvhaf8PbDba/LHNq3tI6JqpqdhsNPrUEpr8Y1t7osPgUH5XgKxEJMcewEafWkKTfyzOmA6DjbeDz4auHD7bHGrvwbDN6PuoeGFrcvMd0u6B1L072d809oz/rrKuvUo0WsgAAAAASUVORK5CYII='
    },
    dark: {
        'largeLogo': 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGcAAAAWCAYAAADdP4KdAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAOKSURBVHgB7VmNedowED34GCCdoOoGdII6EzSZoM4ETSbATBAygdkgzQQmE0AnsDsBbKDei09BKMISxPwlvO+7OJJPd/q5k54MkUBr/Ztlrt+isHRK3YyQLupSOiMKXfzhCRvwY8RyQbuFYsnZ3y2dEUSXJ0rxM6P9YsB+dx0IJw9kzoD2DyxMSmc0AouT0GGQ0CcBdgmWhDZEj6USWYeZ839bunO3QgbwS4oPnU5nZr1TtMzyJ373Z51h2TLvaT2euf2YIsC2rvjxk2XBbe5oO0xZFNsaso2MThESYaXL/OTdo8X4VMCO0s3IKb5PmfFLWwJjERsbEaEeHRE4qhY8AETnI0uCwXDdSOj3laghoyqKx5jl2amraI/g/l4iYDbs9+t9pEmio8yxWwTsFoG2wNzJpqjodTInDegmkpWl+M3tzLQzR+xCd+rRS6Q93vfl/0Le5VJOLX2Ma2DNU/GmrzqMgraADl9Yy4a2Si8vxFOrjYr0HbU4ur54G9gX8FIL1deri1M6Y5ibPsGPR6905iKzfE+1H6/suUtHCEn/Byn25Tm2twWZjMIRHwm412+zVsm771RvcTiov/DzG8uC6sty6thB3ZPoGGKABbz16MHGNcsNeSABY8Z1w7476IOUM9O/ozpzHMyc8j+nrCiOjl/Qmi8fPCcpnrreYjBZfUvXbQO2ZhYC5+APqs9BMDl3ga4D54thpBPDGsHi2OaK0jEvjpsF2IJGIA1SxuemMYWBDFyh3WbidE2TsY30I+xUTvkv1YujXMWIg1/5bLo0u0dh5rKg7VBt+172XSXFSxace4hk1L9sKbJIMX2bse7E40NRzQqBMdWMbiK+lMeOm0lf5VlRS9DLi+rMCsLjgV49zHOpy6y6ZEMb6RqdxNK58LTL1vkWvVLqDCMzhEB7fJWOzZGUbUKRuH6OkRCYaK5oeUiOaBmhuW7no2ll/Z/LxDUxU0RyIYvxcuOX+gfaHCOxh3GAtcHe67hNpvd0mCrPzGcLiWTVki4O2Gu7wmExQ7N3y+UUzMdsOTiAM3oHYJttYvGxVV6JoIyDPvE0Wcj7e7vc9Bkp4BtMEQtiiAgwIZvhaf8PbDba/LHNq3tI6JqpqdhsNPrUEpr8Y1t7osPgUH5XgKxEJMcewEafWkKTfyzOmA6DjbeDz4auHD7bHGrvwbDN6PuoeGFrcvMd0u6B1L072d809oz/rrKuvUo0WsgAAAAASUVORK5CYII='
    },
    'favicon': 'data:image/vnd.microsoft.icon;base64,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',
};
export const CONTENTHUB = {
    CONTENT_TYPE: { CONNECTOR: 'connector', WIDGET: 'widget', SOLUTION_PACK: 'solutionpack' },
    CONTENT_PERMISSION: { CONNECTOR: 'connectors', WIDGET: 'widgets', SOLUTION_PACK: 'solution-packs' },
    CONTENT_LABEL: { CONNECTOR: 'Connectors', WIDGET: 'Widgets', SOLUTION_PACK: 'Solution Packs' },
    CONTENT_TYPE_LABEL: { connector: 'Connector', widget: 'Widget', solutionpack: 'Solution Pack' },
    CONTENT_TYPE_LABEL_PLURAL: { connectors: 'Connectors', widgets: 'Widgets', solutionpacks: 'Solution Packs' }
};
export const CONFIGURATION_LABELS = {
    dependency: 'Dependency(s)',
    prerequisite: 'Prerequisite(s)',
    modules: 'Module Schema(s)',
    recordSets: 'Record Set(s)',
    viewTemplates: 'Module View(s)',
    views: 'System View(s)',
    reports: 'Report(s)',
    dashboards: 'Dashboard(s)',
    picklistNames: 'Picklist(s)',
    roles: 'Role(s)',
    teams: 'Team(s)',
    actors: 'User(s)',
    playbooks: 'Playbook Collection(s)',
    playbookCollections: 'Playbook Collection(s)',
    playbookBlocks: 'Playbook Block(s)',
    globalVariables: 'Global Variable(s)',
    rules: 'Rule(s)',
    ruleChannels: 'Rule Channel(s)',
    connectors: 'Connector(s)',
    widgets: 'Widget(s)',
    appSettings: 'Administrative Setting(s)'
};
export const CONFIG_IMPORT_ORDER = [
    'starting',
    'picklistNames',
    'modules',
    'viewTemplates',
    'views',
    'roles',
    'actors',
    'teams',
    'playbooks',
    'rules',
    'ruleChannels',
    'reports',
    'dashboards',
    'connectors',
    'widgets',
    'recordSets',
    'appSettings',
    'completed'
];
export const APP_SETTINGS = [{
        name: 'systemSettings',
        title: 'Application Configuration (theme, branding, notifications, and more)'
    }, {
        name: 'LDAP',
        title: 'LDAP Configuration'
    }, {
        name: 'RADIUS',
        title: 'RADIUS Configuration'
    }, {
        name: 'TOKEN',
        title: 'Account Configuration (timeouts and token refresh)'
    }, {
        name: 'HA',
        title: 'System & Cluster Health Monitoring'
    }, {
        name: 'sso',
        title: 'SAML Configuration'
    }, {
        name: 'syslog',
        title: 'Logging Configuration'
    }, {
        name: 'proxy',
        title: 'Proxy & Environment Variables'
    }];
export const LANGUAGE_DATA = [
    {
        "id": "en",
        "label": "English"
    },
    {
        "id": "es",
        "label": "Spanish"
    },
    {
        "id": "hi",
        "label": "Hindi"
    }
];
export const REGEX = {
    ATTACHMENT_IRI: /^\/api\/3\/attachments\/[a-z0-9-]+$/,
    FILE_IRI: /^\/api\/3\/files\/[a-z0-9-]+$/,
    XSS_SVG_FILTER: /<img\s+[^>]*src="((ftp|http)s?:\/\/.*?\.(svg))"[^>]*>/g,
    HTML_ENTITIES_XSS_SVG_FILTER: /\&lt\;img\s+[^>]*src=[^>]*((ftp|http)s?:\/\/.*?\.(svg))[^>]*\&gt\;/g,
    ALPHA_NUMERIC_UNDERSCORE: /^[a-zA-Z_0-9]*$/g,
    ALPHA_NUMERIC_UNDERSCORE_SPACE: /^[a-zA-Z_0-9\s]*$/g,
    PB_STEP_NAME: /^[A-Za-z0-9`~!@#$%^&*()\-_=+|{}:;'<>,./?\s]*$/
};
export const COMMENT_TYPES = {
    ACTION_LOG: '/api/3/picklists/1165899b-7091-4291-aafc-487c4309e8ff',
    COMMENT: '/api/3/picklists/ff599189-3eeb-4c86-acb0-a7915e85ac3b'
};
export const UUID_REGEX = /^[0-9A-F]{8}-[0-9A-F]{4}-[4][0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i;
export const JINJA_REGEX = /\{\{(.*?)\}\}/g;
export const TOKEN_STORAGE_KEY = 'token';
export const TITLE_POSTFIX = 'X-Fabric';
export const AGENT_CONFIG_HEALTH = { 'in_progress': 'fb340c77-c2c6-471d-8081-77c9302b4bfb', 'complete_on_message_exchange': 'b5566a53-7af5-48f6-9dbd-5bf5fc9f432b', 'remote_node_connected': 'ab6a1713-9280-4619-9fbd-7694edad2159', 'missed_heartbeats': '0b916872-03d7-49aa-b809-e5471fa970df', 'failed_on_message_exchange': '4b7645c0-cafa-45dd-ad57-44882ce57f21', 'message_exchange_unreachable': '945621cd-f169-44b8-bc28-807a6f17d00a', 'remote_node_unreachable': '135030fa-1b0b-453d-9fed-df9be5d4397f' };
export var CONNECTOR_STATUS;
(function (CONNECTOR_STATUS) {
    CONNECTOR_STATUS["INSTALLED"] = "installed";
})(CONNECTOR_STATUS || (CONNECTOR_STATUS = {}));
export const CHANNEL_UUIDS = { 'IN_APP': '7a04788b-5128-4288-a0fc-6e82d18c3b7b', 'EMAIL': '2a817063-e12a-496d-934d-381d22a95b3b', 'QUEUE': '44fd54ca-f82d-431e-a6fa-dfde019a1ed6', 'RESUME_CONDITIONAL_PB_STEP': 'e2ce87c2-c55a-11ec-9d64-0242ac120002', 'ON_PLAYBOOK_FAILURE': '4c7f3cd4-b9a4-44c9-b372-de68070d0d67' };
export const POLL_INTERVAL = 5000;
export var PERMISSION;
(function (PERMISSION) {
    PERMISSION["READ"] = "read";
    PERMISSION["CREATE"] = "create";
    PERMISSION["UPDATE"] = "update";
    PERMISSION["DELETE"] = "delete";
    PERMISSION["EXECUTE"] = "execute";
    PERMISSION["DEBUG"] = "debug";
    PERMISSION["INSTALL"] = "install";
    PERMISSION["RETRY"] = "retry";
})(PERMISSION || (PERMISSION = {}));
export const ERROR_OBJECTS = {
    404: {
        code: 404,
        icon: 'assets/images/404_icon.png',
        error: 'Page Not Found',
        errorText: 'Sorry, we could not find the page you are looking for.',
        description: 'This error occurs when the server cannot find the requested resource. The user may have entered a incorrect URL, or the resource may have been deleted or moved.'
    },
    403: {
        code: 403,
        icon: 'assets/images/403_icon.png',
        error: 'Access Denied',
        errorText: 'You do not have permission to access this resource.',
        description: 'The request could not be fulfilled by the server due to insufficient access privileges. If you believe this is an error, please contact the website administrator for assistance.'
    },
    500: {
        code: 500,
        icon: 'assets/images/500_icon.png',
        error: 'Internal server error',
        errorText: 'Sorry for the inconvenience. Please report this message. Thank you very much!',
    },
    501: {
        code: 501,
        icon: 'assets/images/501_icon.png',
        error: 'Not Implemented',
        errorText: 'Sorry, the page you were looking for cannot be accessed as the server does not support the requested method. Please try again later or contact the website administrator if you need assistance. Thank you for your understanding.',
    },
    502: {
        code: 502,
        icon: 'assets/images/502_icon.png',
        error: 'Bad gateway',
        errorText: 'Error indicates a bad gateway, typically caused by server communication issues.',
        description: 'Try refreshing the page, clearing the browser cache, or contact the administrator if the issue persists.'
    },
    503: {
        code: 503,
        icon: 'assets/images/503_icon.png',
        error: 'Service unavailable',
        errorText: 'We apologize for the inconvenience. Our team is working to resolve the issue as quickly as possible. ',
    },
    504: {
        code: 504,
        icon: 'assets/images/504_icon.png',
        error: 'Gateway timeout',
        errorText: 'This error signifies a gateway timeout, indicating that a server didn\'t receive a timely response from another server it was accessing.',
        description: 'Try refreshing the page, checking their internet connection, or contacting the administrator if the issue persists'
    }
};
export const IGNORE_ERRORS = new HttpContextToken(() => false);
export const MODULE_MAPPING = {
    manualinput: "User Input"
};
export const DEFAULT_SCHEDULE_TASKS = {
    AUDIT: {
        SETTING: 'purge_audit_task',
        TASK: 'tasks.default_tasks.purge_audit_task'
    },
    PLAYBOOK: {
        SETTING: 'purge_workflow_task',
        TASK: 'tasks.default_tasks.purge_workflow_task'
    },
    SYSTEM_NOTOFICATIONS: {
        SETTING: 'purge_system_notifications',
        TASK: 'tasks.default_tasks.purge_system_notifications'
    },
    FAILURE_NOTOFICATIONS: {
        SETTING: 'purge_failed_notifications',
        TASK: 'tasks.default_tasks.purge_failed_notifications'
    }
};
//# sourceMappingURL=data:application/json;base64,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