import { __decorate } from "tslib";
import { Expose } from "class-transformer";
import { API, FIXED_MODULE } from "../constants";
export class Channel {
    constructor(name) {
        this.description = '';
        this.config = {};
        this.type = 'connector';
        this.defaultParams = {};
        this.isActive = true;
        this.name = name;
    }
    get iri() {
        return `${API.RULE_ENGINE}${FIXED_MODULE.CHANNEL}/${this.uuid}/`;
    }
    asSaved() {
        return {
            uuid: this.uuid,
            name: this.name,
            default_params: this.defaultParams,
            is_active: this.isActive,
            config: this.config,
            description: this.description,
            type: this.type
        };
    }
}
__decorate([
    Expose({ name: 'default_params' })
], Channel.prototype, "defaultParams", void 0);
__decorate([
    Expose({ name: 'is_active' })
], Channel.prototype, "isActive", void 0);
//# sourceMappingURL=data:application/json;base64,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