import { __decorate } from "tslib";
import { Expose, Transform } from "class-transformer";
import { forEach } from "lodash-es";
export class ConnectorFieldRendererParameter {
    constructor(name, type, renderer_type) {
        this.title = '';
        this.description = '';
        this.tooltip = '';
        this.visible = true;
        this.editable = false;
        this.required = false;
        this.placeholder = '';
        this.options = [];
        this.onchange = {};
        this.name = name;
        this.formType = renderer_type || type;
    }
}
__decorate([
    Expose({ name: 'type' })
], ConnectorFieldRendererParameter.prototype, "formType", void 0);
__decorate([
    Transform(({ value }) => {
        let values = [];
        if (typeof value[0] === 'string') {
            forEach(value, (option) => {
                values.push({ label: option, value: option });
            });
            return values;
        }
        return value;
    }, { toClassOnly: true })
], ConnectorFieldRendererParameter.prototype, "options", void 0);
export class ConnectorActionRendererField extends ConnectorFieldRendererParameter {
    constructor() {
        super(...arguments);
        this._jinjaEnabled = false;
        this.parameters = [];
    }
}
//# sourceMappingURL=data:application/json;base64,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