import { plainToInstance } from "class-transformer";
import { InputFieldComponent } from "../../form-fields/field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../../form-fields/field-renderers/built-ins/input/input-view.component";
import { Filter } from "../../query-filters/models/filter";
import { Operator } from "../../query-filters/models/operator";
import { Query } from "../../query-filters/models/query";
import { SearchableItem } from "../../components/searchable-dropdown/searchable-item";
import { DatetimeFieldComponent } from "../../form-fields/field-renderers/built-ins/datetime/datetime-field/datetime-field.component";
import { CheckboxFieldComponent } from "../../form-fields/field-renderers/built-ins/checkbox/checkbox-field.component";
export class Field {
    get visibility() {
        return this._visibility;
    }
    set visibility(value) {
        if (Array.isArray(value)) {
            value = value[0];
        }
        this._visibility = plainToInstance(Query, value);
    }
    getFlatValue(value, operator) {
        return value;
    }
    getViewValue(value) {
        return value;
    }
    static { this.listOperators = [
        new Operator('in', 'Is In List', null, this.evaluateIsInList),
        new Operator('nin', 'Is Not In List', null, this.evaluateIsNotInList),
    ]; }
    static { this.nullOperator = [
        new Operator('isnull', 'Is Null', CheckboxFieldComponent, this.evaluateIsNull),
    ]; }
    static { this.equalOperators = [
        new Operator('eq', 'Equals', InputFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', InputFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.greaterThanLessThanOperators = [
        new Operator('lt', 'Before', DatetimeFieldComponent, this.evaluateBefore),
        new Operator('lte', 'On or Before', DatetimeFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'After', DatetimeFieldComponent, this.evaluateAfter),
        new Operator('gte', 'On or After', DatetimeFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.numericGreaterThanLessThanOperators = [
        new Operator('lt', 'Less Than', InputFieldComponent, this.evaluateBefore),
        new Operator('lte', 'Less Than or Equal To', InputFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'Greater Than', InputFieldComponent, this.evaluateAfter),
        new Operator('gte', 'Greater Than or Equal To', InputFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.operators = this.equalOperators; }
    getOperator(operatorId) {
        return this.operators.find((op) => {
            return op.id === operatorId;
        });
    }
    get operators() {
        return Object.getPrototypeOf(this).constructor.operators;
    }
    constructor(name, formType) {
        this.defaultValue = '';
        this.blankDisplay = '';
        this.title = '';
        this.type = '';
        this.encrypted = false;
        this.gridColumn = false;
        this.orderIndex = 0;
        this.peerReplicable = false;
        this.htmlEscape = false;
        this.inversedField = null;
        this.ownsRelationship = false;
        this.recommend = false;
        this.searchable = false;
        this.system = false;
        this.tooltip = '';
        this.subtitle = '';
        this.validation = {
            required: false
        };
        this._visibility = true;
        this.writeable = true;
        this.visible = true;
        this.required = false;
        this.isFormField = false;
        this.isRelationship = false;
        this.displayTemplate = '';
        this.readOnly = false;
        this.trackable = false;
        this.placeholder = '';
        this.OPERATOR_KEY = '$';
        this.fieldContainerClass = ''; //for field container class like specific width (w-50, w-70) or col-md-6
        this.orphanRemoval = false;
        this.allowJinjaToggle = false;
        this.alwaysJinja = false;
        this.filter = Filter; //ArrayFilter|ObjectFilter
        this.params = {};
        this.mapping = {};
        //private _relationshipFields = ['manyToMany', 'oneToMany'];
        this.alwaysEditMode = false;
        this.name = name;
        this.formType = formType;
        this.descriptions = {
            singular: ''
        };
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    get descriptions() {
        return this._descriptions;
    }
    set descriptions(value) {
        this._descriptions = value;
        if (this._descriptions) {
            this.title = this._descriptions.singular || this.name;
        }
        else {
            this.title = this.title || this.name;
        }
    }
    get dataSource() {
        return this._dataSource;
    }
    set dataSource(value) {
        this._dataSource = value;
    }
    setMode(mode) {
        this.visibility = mode === 'archived' ? true : this.visibility;
        if (mode === 'archived') {
            this.visible = true;
            this.validation.required = false;
        }
        else {
            //this.evaluateRequired();
            //this.evaluateVisible();
        }
    }
    static evaluateIsInList(field, value) {
        return false;
    }
    static evaluateIsNotInList(field, value) {
        return false;
    }
    static evaluateIsNull(field, value) {
        return false;
    }
    ;
    static evaluateEqual(field, value) {
        return false;
    }
    static evaluateNotEqual(field, value) {
        return false;
    }
    static evaluateBefore(field, value) {
        return false;
    }
    static evaluateOnOrBefore(field, value) {
        return false;
    }
    static evaluateAfter(field, value) {
        return false;
    }
    static evaluateOnOrAfter(field, value) {
        return false;
    }
    asSearchableItem() {
        return new SearchableItem(this.title, this, this.name);
    }
    buildSort(order) {
        const sort = [];
        if (this.name === '@id') {
            sort.push({
                field: 'id',
                direction: order,
                _fieldName: this.name
            });
        }
        else if (!this.model) {
            sort.push({
                field: this.name,
                direction: order,
                _fieldName: this.name
            });
            return sort;
        }
        else if (this.defaultSort) {
            this.defaultSort.forEach((sortItem) => {
                sort.push({
                    field: this.name + '.' + sortItem.field,
                    direction: order,
                    _fieldName: this.name
                });
            });
        }
        return sort;
    }
    ;
    getURLQueryValue(value, operator) {
        let query = {};
        let _operator = operator.id === 'like_pattern' ? 'like' : operator.id;
        _operator = operator.id === 'notlike_pattern' ? 'notlike' : operator.id;
        query[`${this.name}${this.OPERATOR_KEY}${_operator}`] = this.getFlatValue(value, operator);
        return query;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: -1
        };
    }
}
(function (Field) {
    let BuiltInType;
    (function (BuiltInType) {
        BuiltInType["TEXT"] = "text";
        BuiltInType["PASSWORD"] = "password";
        BuiltInType["INTEGER"] = "integer";
        BuiltInType["DECIMAL"] = "decimal";
        BuiltInType["CHECKBOX"] = "checkbox";
        BuiltInType["EMAIL"] = "email";
        BuiltInType["DATETIME"] = "datetime";
        BuiltInType["LOOKUP"] = "lookup";
        BuiltInType["MULTISELECT_PICKLIST"] = "multiselectpicklist";
        BuiltInType["PICKLIST"] = "picklist";
        BuiltInType["MANY_TO_MANY"] = "manyToMany";
        BuiltInType["ONE_TO_MANY"] = "oneToMany";
        BuiltInType["FILE"] = "file";
        BuiltInType["JSON"] = "json";
        BuiltInType["JINJA"] = "jinja";
        BuiltInType["ARRAY"] = "array";
        BuiltInType["PHONE"] = "phone";
        BuiltInType["DOMAIN"] = "domain";
        BuiltInType["FILEHASH"] = "fileHash";
        BuiltInType["IPv4"] = "ipv4";
        BuiltInType["IPv6"] = "ipv6";
        BuiltInType["RICHTEXTHTML"] = "html";
        BuiltInType["RICHTEXTMARKDOWN"] = "richtext";
        BuiltInType["TEXTAREA"] = "textarea";
        BuiltInType["URL"] = "url";
        BuiltInType["TAGS"] = "tags";
        BuiltInType["SELECT"] = "select";
        BuiltInType["MULTISELECT"] = "multiselect";
        BuiltInType["RADIO"] = "radio";
        BuiltInType["TOGGLE"] = "toggle";
        BuiltInType["MULTISELECTCHECKBOXDROPDOWN"] = "multiSelectCheckboxDropdown";
        BuiltInType["TOGGLEDROPDOWN"] = "toggleDropdown";
        BuiltInType["CERTIFICATE"] = "certificate";
    })(BuiltInType = Field.BuiltInType || (Field.BuiltInType = {}));
})(Field || (Field = {}));
//# sourceMappingURL=data:application/json;base64,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