import { API } from "../constants";
import { PagedCollectionService } from "../services/paged-collection.service";
import { Entity } from "./entity";
import { Query } from "../../query-filters/models/query";
export class PagedCollection {
    constructor(module, entity, relatedField, relatedUuid) {
        this.module = '';
        this.entity = {};
        this.currentPageNumber = 1;
        this.data = [];
        this.totalItems = 0;
        this.itemsPerPage = 30;
        this.query = new Query();
        this.service = PagedCollectionService;
        this.urlRequestType = 'post';
        this.type = 'base';
        this.module = module;
        this.entity = entity || new Entity(this.module);
        this.relatedField = relatedField;
        this.relatedUuid = relatedUuid;
    }
    getURLData(query) {
        let payload = query.getQueryObject();
        // if (!sortApplied) {
        //   query.buildOrderForPostRequest(self.entity, preparedQuery);
        // }
        // check for default query
        // let url = this.currentPageUrl || (this.urlRequestType === 'post' ? `${API.QUERY}${this.module}` : `${API.API_3_BASE}${this.module}`);
        //Integration with new PBaaS API's
        let url = this.currentPageUrl || (this.urlRequestType === 'post' ? `${API.SEALAB}+${this.module}` : `${API.SEALAB}${this.module}`);
        if (this.relatedField && this.relatedUuid) {
            url = url + '/' + this.relatedUuid + '/' + this.relatedField;
        }
        let urlParams;
        if (!this.currentPageUrl) {
            urlParams = query.getURLParameters();
        }
        return {
            requestType: this.urlRequestType,
            url: url,
            payload: payload,
            queryParams: urlParams
        };
    }
    setPage(data, query) {
        this.data = data['hydra:member'];
        // self.id = data['@id'];
        let id = data['@id'];
        // self.title = data['hydra:title'];
        //let title = data['hydra:title'];
        // self.error = data['@type'] === 'Error' || false;
        //let error = data['@type'] === 'Error' || false;
        // self.description = data['hydra:description'];
        let description = data['hydra:description'];
        // self.totalItems = data['hydra:totalItems'];
        this.totalItems = data['hydra:totalItems'];
        // self.itemsPerPage = data['hydra:itemsPerPage'] || angular.copy(self.query.limit);
        this.itemsPerPage = data['hydra:itemsPerPage'] || (query.limit);
        // if (self.id) {
        if (id) {
            //   var pageIndex = self.id.indexOf('page=');
            let pageIndex = id.indexOf('page=');
            //   if (pageIndex > 0) {
            if (pageIndex > 0) {
                //     var currentPageNum = self.id.substring(pageIndex + 5);
                var currentPageNum = id.substring(pageIndex + 5);
                //     self.currPageNum = isNaN(currentPageNum) ? self.currPageNum : currentPageNum;
                this.currentPageNumber = isNaN(currentPageNum) ? this.currentPageNumber : currentPageNum;
            }
        }
        let firstItemNum = (this.itemsPerPage * this.currentPageNumber) - this.itemsPerPage + 1;
        let lastItemNum = firstItemNum + data['hydra:member'].length - 1;
        this.totalPages = Math.ceil(this.totalItems / this.itemsPerPage);
        if (data['hydra:view']) {
            this.firstPageUrl = data['hydra:view']['hydra:first'];
            this.lastPageUrl = data['hydra:view']['hydra:last'];
            this.nextPageUrl = data['hydra:view']['hydra:next'];
            this.previousPageUrl = data['hydra:view']['hydra:previous'];
            this.gotoPageUrl = this.lastPageUrl ? this.lastPageUrl.substring(0, this.lastPageUrl.length - String(this.totalPages).length) : undefined;
        }
        else {
            this.firstPageUrl = undefined;
            this.lastPageUrl = undefined;
            this.nextPageUrl = undefined;
            this.previousPageUrl = undefined;
            this.currentPageUrl = undefined;
            this.gotoPageUrl = undefined;
        }
    }
    pageFirst() {
        this.currentPageNumber = 1;
        this.currentPageUrl = this.firstPageUrl;
    }
    pageLast() {
        this.currentPageNumber = 1;
        this.currentPageUrl = this.lastPageUrl;
    }
    pageNext() {
        this.currentPageNumber++;
        this.currentPageUrl = this.nextPageUrl;
    }
    pagePrevious() {
        this.currentPageNumber--;
        this.currentPageUrl = this.previousPageUrl;
    }
    ;
    recordPerPageChange() {
        this.currentPageNumber = 1;
        this.currentPageUrl = undefined;
    }
    gotoPage(page) {
        this.currentPageNumber = page;
        this.currentPageUrl = this.gotoPageUrl ? `${this.gotoPageUrl}${page}` : undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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