import { __decorate } from "tslib";
import { Expose, Type } from "class-transformer";
import { API, FIXED_MODULE } from "../constants";
import { RecordTypeRule } from "./record-type-rule";
export class Rule {
    constructor(name) {
        this.recordTypeRules = [];
        this.recordTypes = [];
        this.isActive = false;
        this.eventSource = 'workflow';
        this.modules = '';
        this.actions = [];
        this.name = name;
    }
    get iri() {
        return `${API.RULE_ENGINE}${FIXED_MODULE.RULE}/${this.uuid}/`;
    }
    asSaved() {
        return {
            uuid: this.uuid,
            name: this.name,
            entity_type: this.entityType,
            event_type: this.eventType,
            trigger_condition: this.triggerCondition,
            actions: this.actions,
            is_active: this.isActive,
            event_source: this.eventSource
        };
    }
}
__decorate([
    Type(() => RecordTypeRule)
], Rule.prototype, "recordTypeRules", void 0);
__decorate([
    Expose({ name: 'entity_type' })
], Rule.prototype, "entityType", void 0);
__decorate([
    Expose({ name: 'event_type' })
], Rule.prototype, "eventType", void 0);
__decorate([
    Expose({ name: 'trigger_condition' })
], Rule.prototype, "triggerCondition", void 0);
__decorate([
    Expose({ name: 'is_active' })
], Rule.prototype, "isActive", void 0);
__decorate([
    Expose({ name: 'event_source' })
], Rule.prototype, "eventSource", void 0);
//# sourceMappingURL=data:application/json;base64,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