import { Injectable } from '@angular/core';
import { map } from 'rxjs';
import { API } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class AuditService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
    }
    purgeLogs(data) {
        return this.http.delete(`${API.AUDIT}audit-logs/delete/`, { 'body': data });
    }
    getSettingsByName(name) {
        return this.http.get(`${API.AUDIT}settings/?name=${name}`).pipe(map((result) => {
            if (!result['hydra:member'].length) {
                throw new Error('No audit purge schedule found');
            }
            return result['hydra:member'][0];
        }));
    }
    updateSettings(setting) {
        return this.http.put(`${API.AUDIT}settings/${setting.uuid}/`, setting).pipe(map((result) => {
            return result;
        }));
    }
    static { this.ɵfac = function AuditService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AuditService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: AuditService, factory: AuditService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AuditService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,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