import { Injectable } from '@angular/core';
import { map, of } from 'rxjs';
import { API, STORAGE_KEYS } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class LicenseService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
        this.license = null;
    }
    getLicenseDetails() {
        let licenseDetails = this.storageService.getItem(STORAGE_KEYS.LICENSE_DETAILS);
        if (licenseDetails) {
            return of(licenseDetails);
        }
        else {
            return this.setLicense();
        }
    }
    setLicense() {
        return this.http.get(API.AUTH + 'licenses/').pipe(map((response) => {
            this.storageService.setItem(STORAGE_KEYS.LICENSE_DETAILS, response['hydra:member'][0]);
            return response['hydra:member'][0];
        }));
    }
    getWorkflowMetrics() {
        return this.http.get(API.WORKFLOW + 'workflows/license/metrics/?format=json');
    }
    set licenseType(type) {
        this.license_type = type;
    }
    get licenseType() {
        return this.license_type;
    }
    static { this.ɵfac = function LicenseService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LicenseService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LicenseService, factory: LicenseService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LicenseService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,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