import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { AlertModalComponent } from '../../components/modals/alert-modal/alert-modal.component';
import { ConfirmationModalComponent } from '../../components/modals/confirmation-modal/confirmation-modal.component';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
export class ModalService {
    constructor(ngbModalService) {
        this.ngbModalService = ngbModalService;
    }
    confirm(message, modalTitle, modalClass = 'default') {
        let modalRef = this.ngbModalService.open(ConfirmationModalComponent, {
            backdrop: 'static'
        });
        modalRef.componentInstance.message = message;
        if (modalTitle) {
            modalRef.componentInstance.modalTitle = modalTitle;
        }
        let response$ = new Subject();
        modalRef.result.then((response) => {
            if (response) {
                response$.next(response);
                response$.complete();
            }
            else {
                response$.error(false);
            }
        }, () => {
            response$.error(false);
        });
        return response$.asObservable();
    }
    alert(message, modalTitle) {
        let modalRef = this.ngbModalService.open(AlertModalComponent, {
            backdrop: 'static'
        });
        modalRef.componentInstance.message = message;
        if (modalTitle) {
            modalRef.componentInstance.modalTitle = modalTitle;
        }
        return modalRef.closed;
    }
    static { this.ɵfac = function ModalService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModalService)(i0.ɵɵinject(i1.NgbModal)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModalService, factory: ModalService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.NgbModal }], null); })();
//# sourceMappingURL=data:application/json;base64,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