import { Injectable } from '@angular/core';
import { forkJoin, of } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API, MMD } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class ModelMetadataService {
    constructor(http, storage) {
        this.http = http;
        this.storage = storage;
    }
    loadAllModules(forceUpdate = false) {
        return forkJoin([
            this.getModuleList(false, forceUpdate),
            this.getSystemModules(),
        ]);
    }
    getModuleList(staging = false, forceUpdateModelMeta = false) {
        const KEY = staging ? MMD.STAGING_METADATAS_KEY : MMD.MODEL_METADATAS_KEY;
        const modelMetadatas = (staging || forceUpdateModelMeta) ? null : this.storage.getItem(KEY);
        if (modelMetadatas === null) {
            return this.http
                .get(API.BASE + KEY, {
                params: {
                    limit: ALL_RECORDS_SIZE,
                    $relationships: true,
                    $orderby: 'type',
                },
            })
                .pipe(map((response) => {
                const metadata = response['hydra:member'];
                if (staging === false) {
                    this.storage.setItem(KEY, modelMetadatas);
                    metadata.forEach((model) => {
                        this.storage.setItem('metadata.' + model.type, model);
                    });
                }
                return metadata;
            }));
        }
        else {
            return of(modelMetadatas);
        }
    }
    getSystemModules() {
        return this.http.get(API.SYSTEM_MODULES).pipe(map((systemModelMetadatas) => {
            if (systemModelMetadatas) {
                systemModelMetadatas.forEach((systemModel) => {
                    this.storage.setItem('metadata.' + systemModel.type, systemModel);
                });
            }
            return systemModelMetadatas;
        }));
    }
    getMetadataByModuleType(type) {
        let modelMetadata = this.storage.getItem('metadata.' + type);
        if (!modelMetadata) {
            console.warn(type + ' module metadata not found');
            return;
        }
        //modelMetadata.attributes = modelMetadata.attributes.filter((attribute: any) => attribute.name !== 'uuid');
        return modelMetadata;
    }
    static { this.ɵfac = function ModelMetadataService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModelMetadataService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModelMetadataService, factory: ModelMetadataService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModelMetadataService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,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