import { Injectable, inject } from '@angular/core';
import { RoleService } from '../models/role-service';
import { API, FIXED_MODULE, STORAGE_KEYS } from '../constants';
import { HttpClient } from '@angular/common/http';
import { concatMap, map } from 'rxjs';
import { plainToInstance } from 'class-transformer';
import { RoleEntity } from '../models/role-entity';
import { RolePermission } from '../models/role-permission';
import { StorageService } from './storage.service';
import { keys } from 'lodash-es';
import * as i0 from "@angular/core";
export class PermissionService {
    constructor() {
        this.http = inject(HttpClient);
        this.storageService = inject(StorageService);
    }
    getPermission(entity) {
        let permissions = this.storageService.getItem(STORAGE_KEYS.CURRENT_PERMISSIONS);
        return permissions[entity] ? permissions[entity].map((permission) => permission.name) : [];
    }
    getPermissions(entities) {
        let entityMap = {};
        entities.forEach((entity) => {
            entityMap[entity] = this.getPermission(entity);
        });
        return entityMap;
    }
    getAllFlatPermissions() {
        let flatPermissions = [];
        let permissions = this.storageService.getItem(STORAGE_KEYS.CURRENT_PERMISSIONS);
        keys(permissions).forEach((entity) => {
            let permission = this.getPermission(entity);
            permission.forEach((permissionAction) => {
                flatPermissions.push(`${entity}.${permissionAction}`);
            });
        });
        return flatPermissions;
    }
    isAdmin() {
        return true;
    }
    availablePermission(entity, permission) {
        // TODO: implement
        return true;
    }
    availableFieldPermission(entity, fieldName, permission) {
        return true;
    }
    loadServices() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_SERVICES + '/', {
            params: {
                limit: 1000
            }
        }).pipe(map((response) => {
            return plainToInstance(RoleService, response['hydra:member']);
        }));
    }
    loadEntities() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_ENTITIES + '/', {
            params: {
                limit: 1000
            }
        }).pipe(map((response) => {
            return plainToInstance(RoleEntity, response['hydra:member']);
        }));
    }
    loadServicesAndEntities() {
        return this.loadServices().pipe(concatMap((services) => {
            return this.loadEntities().pipe(map((entities) => {
                services.forEach((service) => {
                    service.entities = entities.filter((entity) => entity.service === service.uuid && entity.visible);
                });
                return services;
            }));
        }));
    }
    loadPermissions() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_PERMISSIONS + '/').pipe(map((response) => {
            return plainToInstance(RolePermission, response['hydra:member']);
        }));
    }
    static { this.ɵfac = function PermissionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PermissionService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PermissionService, factory: PermissionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PermissionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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