import { Injectable } from '@angular/core';
import { STORAGE_KEYS } from '../constants';
import * as i0 from "@angular/core";
export class StorageService {
    constructor() { }
    /**
     *
     * @param {string} key The key of Storage Entry
     * @param {any} value The value to store
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    setItem(key, value, persist) {
        let storageKey = this._getStorageKey(key, persist);
        localStorage.setItem(storageKey, JSON.stringify(value));
    }
    /**
     * Clean up all non-persisted storage entries post user session timeout.
     */
    clearAll() {
        for (let key in localStorage) {
            const length = STORAGE_KEYS.LOCAL_STORAGE_PREFIX.length;
            if (key.substring(0, length) == STORAGE_KEYS.LOCAL_STORAGE_PREFIX) {
                localStorage.removeItem(key);
            }
        }
    }
    /**
     * Retrive the storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {any} the value
     */
    getItem(key, persist) {
        let storageKey = this._getStorageKey(key, persist);
        let result = localStorage.getItem(storageKey);
        try {
            return result ? JSON.parse(result) : null;
        }
        catch (error) {
            return result;
        }
    }
    /**
     * Remove the specified storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    removeItem(key, persist) {
        let storageKey = this._getStorageKey(key, persist);
        localStorage.removeItem(storageKey);
    }
    /**
     * Build the key string of the storgae entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {string} key string
     */
    _getStorageKey(key, persist) {
        return persist ? STORAGE_KEYS.LOCAL_STORAGE_PERSIST_PREFIX + key : STORAGE_KEYS.LOCAL_STORAGE_PREFIX + key;
    }
    static { this.ɵfac = function StorageService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || StorageService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: StorageService, factory: StorageService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(StorageService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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