import { Injectable } from '@angular/core';
import { map, of } from 'rxjs';
import { API, FIXED_MODULE, STORAGE_KEYS } from '../constants';
import { extend } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class SystemSettingsService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
    }
    getSSOStatus() {
        return this.http.get(`${API.PUBLIC}saml/login`);
    }
    get() {
        return this.storageService.getItem(STORAGE_KEYS.SYSTEM_SETTINGS);
    }
    load() {
        return this.http.get(`${API.API_APPMANAGER}${FIXED_MODULE.SYSTEM_SETTINGS}/`).pipe(map((result) => {
            this.storageService.setItem(STORAGE_KEYS.SYSTEM_SETTINGS, result['hydra:member'][0]);
            return result['hydra:member'][0];
        }));
    }
    save(systemSettings) {
        return this.http.put(`${API.API_APPMANAGER}${FIXED_MODULE.SYSTEM_SETTINGS}/${systemSettings.uuid}/`, systemSettings).pipe(map((result) => {
            this.storageService.setItem(STORAGE_KEYS.SYSTEM_SETTINGS, result);
            return result;
        }));
    }
    saveUserPreferences(settings) {
        let userPreferences = this.storageService.getItem(STORAGE_KEYS.USER_PREFERENCES, true) || {};
        userPreferences = extend(userPreferences, settings);
        this.storageService.setItem(STORAGE_KEYS.USER_PREFERENCES, userPreferences, false);
        return of(userPreferences);
    }
    getUserPreferences() {
        return this.storageService.getItem(STORAGE_KEYS.USER_PREFERENCES, false) || {};
    }
    getDateFormats() {
        return this.http.get('assets/settings/dateFormat.json').pipe(map((response) => {
            return {
                dateFormat: this.getDateFormat(response),
                dateTimeFormat: this.getdateTimeFormat(response)
            };
        }));
    }
    getdateTimeFormat(data) {
        let dateTimeFormatOptions = data
            .filter((date) => date.type === 'datetime')
            .map((date) => {
            date.label = date.value;
            delete date.type;
            return date;
        });
        return dateTimeFormatOptions;
    }
    getDateFormat(data) {
        let dateFormatOptions = data
            .filter((date) => date.type === 'date')
            .map((date) => {
            date.label = date.value;
            delete date.type;
            return date;
        });
        return dateFormatOptions;
    }
    static { this.ɵfac = function SystemSettingsService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SystemSettingsService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SystemSettingsService, factory: SystemSettingsService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SystemSettingsService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3lzdGVtLXNldHRpbmdzLnNlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb3JlL3NlcnZpY2VzL3N5c3RlbS1zZXR0aW5ncy5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDM0MsT0FBTyxFQUFjLEdBQUcsRUFBRSxFQUFFLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDM0MsT0FBTyxFQUFFLEdBQUcsRUFBRSxZQUFZLEVBQUUsWUFBWSxFQUFFLE1BQU0sY0FBYyxDQUFDO0FBRy9ELE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxXQUFXLENBQUM7Ozs7QUFLbkMsTUFBTSxPQUFPLHFCQUFxQjtJQUdoQyxZQUNVLElBQWdCLEVBQ2hCLGNBQThCO1FBRDlCLFNBQUksR0FBSixJQUFJLENBQVk7UUFDaEIsbUJBQWMsR0FBZCxjQUFjLENBQWdCO0lBQ2xDLENBQUM7SUFFUCxZQUFZO1FBQ1YsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxNQUFNLFlBQVksQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFFRCxHQUFHO1FBQ0QsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbkUsQ0FBQztJQUVELElBQUk7UUFDRixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDLGNBQWMsR0FBRyxZQUFZLENBQUMsZUFBZSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQ2hGLEdBQUcsQ0FBQyxDQUFDLE1BQVcsRUFBRSxFQUFFO1lBQ2xCLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxlQUFlLEVBQUUsTUFBTSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDckYsT0FBTyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDbkMsQ0FBQyxDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCxJQUFJLENBQUMsY0FBOEI7UUFDakMsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxjQUFjLEdBQUcsWUFBWSxDQUFDLGVBQWUsSUFBSSxjQUFjLENBQUMsSUFBSSxHQUFHLEVBQUUsY0FBYyxDQUFDLENBQUMsSUFBSSxDQUN2SCxHQUFHLENBQUMsQ0FBQyxNQUFXLEVBQUUsRUFBRTtZQUNsQixJQUFJLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsZUFBZSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1lBQ2xFLE9BQU8sTUFBTSxDQUFDO1FBQ2hCLENBQUMsQ0FBQyxDQUNILENBQUE7SUFDSCxDQUFDO0lBRUQsbUJBQW1CLENBQUMsUUFBYTtRQUMvQixJQUFJLGVBQWUsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQzdGLGVBQWUsR0FBRyxNQUFNLENBQUMsZUFBZSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsRUFBRSxlQUFlLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDbkYsT0FBTyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVELGtCQUFrQjtRQUNoQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDakYsQ0FBQztJQUVELGNBQWM7UUFDWixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLGlDQUFpQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQWEsRUFBRSxFQUFFO1lBQ2pGLE9BQU87Z0JBQ0wsVUFBVSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsUUFBUSxDQUFDO2dCQUN4QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFFBQVEsQ0FBQzthQUNqRCxDQUFBO1FBQ0gsQ0FBQyxDQUFDLENBQUMsQ0FBQTtJQUNMLENBQUM7SUFFTyxpQkFBaUIsQ0FBQyxJQUFnQjtRQUN4QyxJQUFJLHFCQUFxQixHQUFHLElBQUk7YUFDL0IsTUFBTSxDQUFDLENBQUMsSUFBUyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLFVBQVUsQ0FBQzthQUMvQyxHQUFHLENBQUMsQ0FBQyxJQUFRLEVBQUUsRUFBRTtZQUNoQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDeEIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFBO1lBQ2hCLE9BQU8sSUFBSSxDQUFBO1FBRWIsQ0FBQyxDQUFDLENBQUE7UUFDRixPQUFPLHFCQUFxQixDQUFBO0lBQzlCLENBQUM7SUFFTyxhQUFhLENBQUMsSUFBZ0I7UUFDcEMsSUFBSSxpQkFBaUIsR0FBRyxJQUFJO2FBQzNCLE1BQU0sQ0FBQyxDQUFDLElBQVMsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLENBQUM7YUFDM0MsR0FBRyxDQUFDLENBQUMsSUFBUSxFQUFFLEVBQUU7WUFDaEIsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3hCLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQTtZQUNoQixPQUFPLElBQUksQ0FBQTtRQUViLENBQUMsQ0FBQyxDQUFBO1FBQ0YsT0FBTyxpQkFBaUIsQ0FBQTtJQUMxQixDQUFDO3NIQTVFVSxxQkFBcUI7dUVBQXJCLHFCQUFxQixXQUFyQixxQkFBcUIsbUJBRnBCLE1BQU07O2lGQUVQLHFCQUFxQjtjQUhqQyxVQUFVO2VBQUM7Z0JBQ1YsVUFBVSxFQUFFLE1BQU07YUFDbkIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBIdHRwQ2xpZW50IH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uL2h0dHAnO1xuaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgbWFwLCBvZiB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgQVBJLCBGSVhFRF9NT0RVTEUsIFNUT1JBR0VfS0VZUyB9IGZyb20gJy4uL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBTeXN0ZW1TZXR0aW5ncyB9IGZyb20gJy4uL21vZGVscy9zeXN0ZW0tc2V0dGluZ3MnO1xuaW1wb3J0IHsgU3RvcmFnZVNlcnZpY2UgfSBmcm9tICcuL3N0b3JhZ2Uuc2VydmljZSc7XG5pbXBvcnQgeyBleHRlbmQgfSBmcm9tICdsb2Rhc2gtZXMnO1xuXG5ASW5qZWN0YWJsZSh7XG4gIHByb3ZpZGVkSW46ICdyb290J1xufSlcbmV4cG9ydCBjbGFzcyBTeXN0ZW1TZXR0aW5nc1NlcnZpY2Uge1xuICBjdXJyZW50U2V0dGluZ3M6IGFueTtcbiAgcHVibGljRGF0YTogYW55O1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIGh0dHA6IEh0dHBDbGllbnQsXG4gICAgcHJpdmF0ZSBzdG9yYWdlU2VydmljZTogU3RvcmFnZVNlcnZpY2VcbiAgICApIHsgfVxuXG4gIGdldFNTT1N0YXR1cygpOiBPYnNlcnZhYmxlPGFueT4ge1xuICAgIHJldHVybiB0aGlzLmh0dHAuZ2V0KGAke0FQSS5QVUJMSUN9c2FtbC9sb2dpbmApO1xuICB9XG5cbiAgZ2V0KCk6IFN5c3RlbVNldHRpbmdzIHtcbiAgICByZXR1cm4gdGhpcy5zdG9yYWdlU2VydmljZS5nZXRJdGVtKFNUT1JBR0VfS0VZUy5TWVNURU1fU0VUVElOR1MpO1xuICB9XG5cbiAgbG9hZCgpIHtcbiAgICByZXR1cm4gdGhpcy5odHRwLmdldChgJHtBUEkuQVBJX0FQUE1BTkFHRVJ9JHtGSVhFRF9NT0RVTEUuU1lTVEVNX1NFVFRJTkdTfS9gKS5waXBlKFxuICAgICAgbWFwKChyZXN1bHQ6IGFueSkgPT4ge1xuICAgICAgICB0aGlzLnN0b3JhZ2VTZXJ2aWNlLnNldEl0ZW0oU1RPUkFHRV9LRVlTLlNZU1RFTV9TRVRUSU5HUywgcmVzdWx0WydoeWRyYTptZW1iZXInXVswXSk7XG4gICAgICAgIHJldHVybiByZXN1bHRbJ2h5ZHJhOm1lbWJlciddWzBdO1xuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgc2F2ZShzeXN0ZW1TZXR0aW5nczogU3lzdGVtU2V0dGluZ3MpIHtcbiAgICByZXR1cm4gdGhpcy5odHRwLnB1dChgJHtBUEkuQVBJX0FQUE1BTkFHRVJ9JHtGSVhFRF9NT0RVTEUuU1lTVEVNX1NFVFRJTkdTfS8ke3N5c3RlbVNldHRpbmdzLnV1aWR9L2AsIHN5c3RlbVNldHRpbmdzKS5waXBlKFxuICAgICAgbWFwKChyZXN1bHQ6IGFueSkgPT4ge1xuICAgICAgICB0aGlzLnN0b3JhZ2VTZXJ2aWNlLnNldEl0ZW0oU1RPUkFHRV9LRVlTLlNZU1RFTV9TRVRUSU5HUywgcmVzdWx0KTtcbiAgICAgICAgcmV0dXJuIHJlc3VsdDtcbiAgICAgIH0pXG4gICAgKVxuICB9XG5cbiAgc2F2ZVVzZXJQcmVmZXJlbmNlcyhzZXR0aW5nczogYW55KTogT2JzZXJ2YWJsZTxhbnk+IHtcbiAgICBsZXQgdXNlclByZWZlcmVuY2VzID0gdGhpcy5zdG9yYWdlU2VydmljZS5nZXRJdGVtKFNUT1JBR0VfS0VZUy5VU0VSX1BSRUZFUkVOQ0VTLCB0cnVlKSB8fCB7fTtcbiAgICB1c2VyUHJlZmVyZW5jZXMgPSBleHRlbmQodXNlclByZWZlcmVuY2VzLCBzZXR0aW5ncyk7XG4gICAgdGhpcy5zdG9yYWdlU2VydmljZS5zZXRJdGVtKFNUT1JBR0VfS0VZUy5VU0VSX1BSRUZFUkVOQ0VTLCB1c2VyUHJlZmVyZW5jZXMsIGZhbHNlKTtcbiAgICByZXR1cm4gb2YodXNlclByZWZlcmVuY2VzKTtcbiAgfVxuXG4gIGdldFVzZXJQcmVmZXJlbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy5zdG9yYWdlU2VydmljZS5nZXRJdGVtKFNUT1JBR0VfS0VZUy5VU0VSX1BSRUZFUkVOQ0VTLCBmYWxzZSkgfHwge307XG4gIH1cblxuICBnZXREYXRlRm9ybWF0cygpIHtcbiAgICByZXR1cm4gdGhpcy5odHRwLmdldCgnYXNzZXRzL3NldHRpbmdzL2RhdGVGb3JtYXQuanNvbicpLnBpcGUobWFwKChyZXNwb25zZTogYW55KSA9PiB7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBkYXRlRm9ybWF0OiB0aGlzLmdldERhdGVGb3JtYXQocmVzcG9uc2UpLFxuICAgICAgICBkYXRlVGltZUZvcm1hdDogdGhpcy5nZXRkYXRlVGltZUZvcm1hdChyZXNwb25zZSlcbiAgICAgIH1cbiAgICB9KSlcbiAgfVxuXG4gIHByaXZhdGUgZ2V0ZGF0ZVRpbWVGb3JtYXQoZGF0YTogQXJyYXk8YW55Pikge1xuICAgIGxldCBkYXRlVGltZUZvcm1hdE9wdGlvbnMgPSBkYXRhXG4gICAgLmZpbHRlcigoZGF0ZTogYW55KSA9PiBkYXRlLnR5cGUgPT09ICdkYXRldGltZScpXG4gICAgLm1hcCgoZGF0ZTphbnkpID0+IHtcbiAgICAgIGRhdGUubGFiZWwgPSBkYXRlLnZhbHVlO1xuICAgICAgZGVsZXRlIGRhdGUudHlwZVxuICAgICAgcmV0dXJuIGRhdGVcblxuICAgIH0pXG4gICAgcmV0dXJuIGRhdGVUaW1lRm9ybWF0T3B0aW9uc1xuICB9XG5cbiAgcHJpdmF0ZSBnZXREYXRlRm9ybWF0KGRhdGE6IEFycmF5PGFueT4pIHtcbiAgICBsZXQgZGF0ZUZvcm1hdE9wdGlvbnMgPSBkYXRhXG4gICAgLmZpbHRlcigoZGF0ZTogYW55KSA9PiBkYXRlLnR5cGUgPT09ICdkYXRlJylcbiAgICAubWFwKChkYXRlOmFueSkgPT4ge1xuICAgICAgZGF0ZS5sYWJlbCA9IGRhdGUudmFsdWU7XG4gICAgICBkZWxldGUgZGF0ZS50eXBlXG4gICAgICByZXR1cm4gZGF0ZVxuXG4gICAgfSlcbiAgICByZXR1cm4gZGF0ZUZvcm1hdE9wdGlvbnNcbiAgfVxuXG59XG5cblxuXG5cbiJdfQ==