import { Injectable } from '@angular/core';
import timezoneData from '../../data/timezones.json';
import * as i0 from "@angular/core";
export class TimezoneService {
    constructor() { }
    getList() {
        const timezones = timezoneData.timezones;
        return timezones;
    }
    getUtcList() {
        return this.getList().map((timezone) => {
            return timezone.utc.map((value) => {
                return {
                    value: value,
                    abbr: timezone.abbr,
                    text: `${value} (${timezone.abbr})`,
                    utcOffset: timezone.utcOffset
                };
            });
        }).flat();
    }
    getTimezoneByName(name) {
        const timezones = this.getUtcList();
        return timezones.find(timezone => timezone.value === name);
    }
    getTimezoneByAbbr(abbr) {
        const timezones = timezoneData.timezones;
        return timezones.find(timezone => timezone.abbr === abbr);
    }
    getLocalTimezone() {
        const list = this.getList();
        const localTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        return list.find((timezone) => timezone.utc.indexOf(localTimezone) > -1);
    }
    static { this.ɵfac = function TimezoneService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TimezoneService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: TimezoneService, factory: TimezoneService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TimezoneService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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