import { Component, inject } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
function DatetimeFloatingFilterComponent_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 2);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r1 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r1.value);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r1.name);
} }
export class DatetimeFloatingFilterComponent {
    constructor() {
        this.formBuilder = inject(FormBuilder);
        this.currentValue = null;
        this.pastOptions = [
            { value: { differenceType: 'years', differenceValue: -1 }, name: 'Last Year' },
            { value: { differenceType: 'months', differenceValue: -6 }, name: 'Last 6 Months' },
            { value: { differenceType: 'months', differenceValue: -3 }, name: 'Last 3 Months' },
            { value: { differenceType: 'months', differenceValue: -1 }, name: 'Last Month' },
            { value: { differenceType: 'months', differenceValue: -1, lastDate: true }, name: 'Last Calendar Month' },
            { value: { differenceType: 'days', differenceValue: -15 }, name: 'Last 15 Days' },
            { value: { differenceType: 'days', differenceValue: -30 }, name: 'Last 30 Days' },
            { value: { differenceType: 'days', differenceValue: -7 }, name: 'Last 7 Days' },
            { value: { differenceType: 'hours', differenceValue: -24 }, name: 'Last 24 Hours' },
            { value: { differenceType: 'hours', differenceValue: -1 }, name: 'Last Hour' },
            { value: { differenceType: 'mins', differenceValue: -30 }, name: 'Last 30 Min' },
            { value: { differenceType: 'years', differenceValue: 0 }, name: 'This Year' },
            { value: { differenceType: 'months', differenceValue: 0, lastDate: true }, name: 'This Month' },
            { value: { differenceType: 'days', differenceValue: 0 }, name: 'Today' }
        ];
        this.futureOptions = [
            { value: { differenceType: 'years', differenceValue: 1 }, name: 'Next Year' },
            { value: { differenceType: 'days', differenceValue: 15 }, name: 'Next 15 Days' },
            { value: { differenceType: 'days', differenceValue: 7 }, name: 'Next 7 Days' },
            { value: { differenceType: 'hours', differenceValue: 24 }, name: 'Next 24 Hours' },
            { value: { differenceType: 'hours', differenceValue: 6 }, name: 'Next 6 Hours' }
        ];
        this.relativeOptions = [];
        this.formGroup = this.formBuilder.group({
            value: [null]
        });
        this.formGroup.valueChanges.subscribe((values) => {
            this.currentValue = values.value;
            this.updateFilter();
        });
    }
    agInit(params) {
        this.params = params;
        let relativeDates = params.filterParams.colDef.headerComponentParams.field.options?.relativeDates || 'past';
        if (relativeDates === 'both') {
            this.relativeOptions = [...this.pastOptions, ...this.futureOptions];
        }
        else if (relativeDates === 'past') {
            this.relativeOptions = this.pastOptions;
        }
        else if (relativeDates === 'future') {
            this.relativeOptions = this.futureOptions;
        }
    }
    onParentModelChanged(parentModel) {
        // When the filter is empty we will receive a null value here
        if (!parentModel) {
            this.currentValue = null;
        }
        else {
            this.currentValue = parentModel.filter;
        }
    }
    updateFilter() {
        if (!this.currentValue) {
            this.params.parentFilterInstance((instance) => {
                instance.onFloatingFilterChanged(null, null);
            });
        }
        this.params.parentFilterInstance((instance) => {
            instance.onFloatingFilterChanged('date', this.currentValue);
        });
    }
    static { this.ɵfac = function DatetimeFloatingFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeFloatingFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeFloatingFilterComponent, selectors: [["xf-lookup-floating-filter"]], decls: 5, vars: 3, consts: [[1, "d-inline-block", 3, "formGroup"], ["formControlName", "value", 1, "form-select", "w-auto", "form-select-xs"], [3, "ngValue"], [3, "ngValue", 4, "ngFor", "ngForOf"]], template: function DatetimeFloatingFilterComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "select", 1)(2, "option", 2);
            i0.ɵɵtext(3, "Select");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(4, DatetimeFloatingFilterComponent_option_4_Template, 2, 2, "option", 3);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngValue", null);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.relativeOptions);
        } }, dependencies: [i1.NgForOf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeFloatingFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-lookup-floating-filter', template: "<div class=\"d-inline-block\" [formGroup]=\"formGroup\">\n  <select class=\"form-select w-auto form-select-xs\" formControlName=\"value\">\n    <option [ngValue]=\"null\">Select</option>\n    <option *ngFor=\"let option of relativeOptions\" [ngValue]=\"option.value\">{{ option.name }}</option>\n  </select>\n</div>\n" }]
    }], () => [], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeFloatingFilterComponent, { className: "DatetimeFloatingFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-floating-filter/datetime-floating-filter.component.ts", lineNumber: 12 }); })();
//# sourceMappingURL=data:application/json;base64,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