import { Component, EventEmitter, forwardRef, Input, Output, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { FieldOptions } from '../../../models/field-options';
import { ViewContainerDirective } from '../../../../utility/directives/view-container.directive';
import * as i0 from "@angular/core";
import * as i1 from "../../../../utility/directives/view-container.directive";
function FormFieldComponent_ng_template_0_Template(rf, ctx) { }
export class FormFieldComponent {
    constructor() {
        this.autoFocus = false;
        this.fieldOptions = new FieldOptions();
        this.jinjaToggled = new EventEmitter();
        this.onSubmit = new EventEmitter();
    }
    ngOnInit() {
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (this.field) {
            this.componentRef = viewContainerRef.createComponent(this.field.fieldComponent);
            this.componentRef.instance.field = this.field;
            this.componentRef.instance.autoFocus = this.autoFocus;
            this.componentRef.instance.fieldOptions = this.fieldOptions;
            this.componentRef.instance.fieldClass = this.fieldClass;
            this.componentRef.instance.jinjaToggled = this.jinjaToggled;
            this.componentRef.instance.onSubmit = this.onSubmit;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    ngOnChanges(changes) {
        if (this.componentRef) {
            if (!changes.field?.firstChange && changes.field?.currentValue.formType !== changes.field?.previousValue.formType) {
                this.ngOnInit();
                return;
            }
        }
    }
    writeValue(value) {
        if (this.componentRef) {
            this.componentRef.instance.writeValue(value);
        }
    }
    setDisabledState(isDisabled) {
        if (this.componentRef) {
            this.componentRef.instance.setDisabledState(isDisabled);
        }
    }
    registerOnChange(fn) {
        if (this.componentRef) {
            this.componentRef.instance.registerOnChange(fn);
        }
    }
    registerOnTouched(fn) {
        if (this.componentRef) {
            this.componentRef.instance.registerOnTouched(fn);
        }
    }
    validate(control) {
        if (this.componentRef) {
            return this.componentRef.instance.validate(control);
        }
        else {
            return null;
        }
    }
    get valid() {
        return this.componentRef.instance.valid;
    }
    focus() {
        if (this.componentRef) {
            this.componentRef.instance.focus();
        }
    }
    static { this.ɵfac = function FormFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FormFieldComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FormFieldComponent, selectors: [["xf-form-field"]], viewQuery: function FormFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { field: "field", autoFocus: "autoFocus", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, outputs: { jinjaToggled: "jinjaToggled", onSubmit: "onSubmit" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FormFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FormFieldComponent),
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function FormFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FormFieldComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [i1.ViewContainerDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FormFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-form-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FormFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FormFieldComponent),
                        multi: true
                    }], template: "<ng-template xfViewContainer></ng-template>\n" }]
    }], () => [], { field: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }], jinjaToggled: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FormFieldComponent, { className: "FormFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/form-field/form-field.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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