import { Component, Input } from '@angular/core';
import { map } from 'rxjs/operators';
import { AbstractFieldComponent } from '../abstract-field.component';
import { isString } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "./picklist.service";
import * as i2 from "@angular/forms";
import * as i3 from "../../../../core/services/theme.service";
import * as i4 from "@angular/common";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
import * as i6 from "../../../../utility/pipes/is-hex-color-light.pipe";
const _c0 = (a0, a1, a2) => ({ "form-select-lg": a0, "form-select-xs": a1, "colored": a2 });
const _c1 = (a0, a1) => ({ "background": a0, "color": a1 });
function PicklistFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 10);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function PicklistFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 11);
    i0.ɵɵelement(1, "i", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function PicklistFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 7);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, PicklistFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 8)(3, PicklistFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function PicklistFieldComponent_div_0_option_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 5);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", option_r2.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(option_r2.itemValue);
} }
function PicklistFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, PicklistFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "select", 4, 0);
    i0.ɵɵpipe(4, "isHexColorLight");
    i0.ɵɵelementStart(5, "option", 5);
    i0.ɵɵtext(6, "Select");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, PicklistFieldComponent_div_0_option_7_Template, 2, 2, "option", 6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("form-select picklist ", ctx_r0.fieldClass, "");
    i0.ɵɵproperty("name", "picklist-" + ctx_r0.field.picklistName)("ngClass", i0.ɵɵpureFunction3(12, _c0, ctx_r0.fieldOptions.size === "large", ctx_r0.fieldOptions.size === "small", !!(ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color)))("ngStyle", i0.ɵɵpureFunction2(16, _c1, (ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color) ? ctx_r0.fieldGroup.value.input == null ? null : ctx_r0.fieldGroup.value.input.color : "", (ctx_r0.value == null ? null : ctx_r0.value.color) && i0.ɵɵpipeBind1(4, 10, ctx_r0.value == null ? null : ctx_r0.value.color) ? "rgba(0, 0, 0, 0.8)" : (ctx_r0.value == null ? null : ctx_r0.value.color) ? "rgba(255, 255, 255, 0.8)" : !(ctx_r0.value == null ? null : ctx_r0.value.color) && ctx_r0.currentTheme === "light" ? "rgba(0, 0, 0, 0.8)" : "rgba(255, 255, 255, 0.8)"));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngValue", null);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r0.picklistItems);
} }
export class PicklistFieldComponent extends AbstractFieldComponent {
    constructor(picklistService, _changeDetectorRef, _formBuilder, themeService) {
        super(_changeDetectorRef, _formBuilder);
        this.picklistService = picklistService;
        this._changeDetectorRef = _changeDetectorRef;
        this._formBuilder = _formBuilder;
        this.themeService = themeService;
        this.picklistItems = [];
        this.currentTheme = this.themeService.getTheme();
    }
    ngAfterViewInit() {
        if (!this.field) {
            return;
        }
        if (this.field.picklistName == '') {
            console.warn('Picklist name not specified');
            return;
        }
        this.picklistService.loadPicklistName(this.field.picklistName).subscribe((picklistName) => {
            if (!picklistName) {
                console.warn(`Picklist ${this.field.picklistName} not found`);
                return;
            }
            this.picklistItems = picklistName.picklists;
            if (this.value || this.field.defaultValue) {
                this.value = this.picklistItems.find((item) => (this.field.defaultValue || this.value) && (this.value.uuid || this.field.defaultValue) === item.uuid);
            }
            this.changeDetectorRef.detectChanges();
        });
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((value) => {
            this.value = isString(value) ? value : value.uuid;
        });
    }
    writeValue(value) {
        if (value && this.picklistItems.length) {
            this.value = this.picklistItems.find((item) => value && value.uuid === value.uuid);
        }
        else {
            this.value = value;
        }
    }
    static { this.ɵfac = function PicklistFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistFieldComponent)(i0.ɵɵdirectiveInject(i1.PicklistService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i3.ThemeService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PicklistFieldComponent, selectors: [["xf-field-picklist"]], inputs: { field: "field", fieldClass: "fieldClass" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["inputField", ""], ["class", "form-group w-fit-content", 3, "formGroup", 4, "ngIf"], [1, "form-group", "w-fit-content", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], ["formControlName", "input", 3, "name", "ngClass", "ngStyle"], [3, "ngValue"], [3, "ngValue", 4, "ngFor", "ngForOf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"]], template: function PicklistFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PicklistFieldComponent_div_0_Template, 8, 19, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i4.NgClass, i4.NgForOf, i4.NgIf, i4.NgStyle, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i5.NgbTooltip, i6.IsHexColorLightPipe], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.picklist-search[_ngcontent-%COMP%]{width:90%;margin:10px 5% 0}.picklist[_ngcontent-%COMP%]{cursor:pointer;border-radius:4px}.picklist.colored[_ngcontent-%COMP%]{color:#ffffffb3;text-align:center}.picklist[_ngcontent-%COMP%]:focus{box-shadow:none}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-picklist', template: "<div class=\"form-group w-fit-content\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n        <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <select [name]=\"'picklist-' + field.picklistName\"\n    [ngClass]=\"{'form-select-lg': fieldOptions.size === 'large', 'form-select-xs': fieldOptions.size === 'small', 'colored': !!fieldGroup.value.input?.color}\"\n    class=\"form-select picklist {{fieldClass}}\" formControlName=\"input\" #inputField [ngStyle]=\"{\n      'background': fieldGroup.value.input?.color ? fieldGroup.value.input?.color : '',\n      'color': (value?.color) && (value?.color | isHexColorLight) ? 'rgba(0, 0, 0, 0.8)' : value?.color ? 'rgba(255, 255, 255, 0.8)' : (!value?.color && currentTheme === 'light') ? 'rgba(0, 0, 0, 0.8)' : 'rgba(255, 255, 255, 0.8)'\n    }\">\n    <option [ngValue]=\"null\">Select</option>\n    <option *ngFor=\"let option of picklistItems\" [ngValue]=\"option.uuid\">{{ option.itemValue }}</option>\n  </select>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.picklist-search{width:90%;margin:10px 5% 0}.picklist{cursor:pointer;border-radius:4px}.picklist.colored{color:#ffffffb3;text-align:center}.picklist:focus{box-shadow:none}\n"] }]
    }], () => [{ type: i1.PicklistService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }, { type: i3.ThemeService }], { field: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PicklistFieldComponent, { className: "PicklistFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/picklist/picklist-field.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,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