import { CheckboxFieldComponent } from "../field-renderers/built-ins/checkbox/checkbox-field.component";
import { CheckboxViewComponent } from "../field-renderers/built-ins/checkbox/checkbox-view.component";
import { Field } from "../../core/models/field";
import { Operator } from "../../query-filters/models/operator";
import { CheckboxFloatingFilterComponent } from "../field-renderers/built-ins/checkbox/checkbox-floating-filter/checkbox-floating-filter.component";
import { CheckboxGridFilterComponent } from "../field-renderers/built-ins/checkbox/checkbox-grid-filter/checkbox-grid-filter.component";
export class CheckboxField extends Field {
    static { this.checkboxOperators = [
        new Operator('eq', 'Equals', CheckboxFieldComponent, this.evaluateEqual)
    ]; }
    static { this.operators = [...CheckboxField.checkboxOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.CHECKBOX);
        this.viewMode = 'toggle';
        this.customLabel = { labelOn: '', labelOff: '' };
        this.isFormField = true;
        this.isRelationship = false;
        this.alwaysEditMode = true;
        this.fieldComponent = CheckboxFieldComponent;
        this.viewComponent = CheckboxViewComponent;
        this.defaultColDef = {
            filter: CheckboxGridFilterComponent,
            floatingFilterComponent: CheckboxFloatingFilterComponent,
            cellRenderer: (params) => {
                let valueMappings = 'values' in params.colDef?.filterParams ? (params.colDef?.filterParams).values : {};
                return `<i class="align-middle fa fa-circle fa-lg font-size-8px ${params.value ? 'text-success' : 'text-muted muted-40'}"></i><span class="font-size-12px margin-left-8px muted-10">${params.value ? valueMappings.true || 'Checked' : valueMappings.false || 'Unchecked'}</span>`;
            },
            suppressFloatingFilterButton: true
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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