import { DatetimeFieldComponent } from "../field-renderers/built-ins/datetime/datetime-field/datetime-field.component";
import { DatetimeViewComponent } from "../field-renderers/built-ins/datetime/datetime-view/datetime-view.component";
import { Field } from "../../core/models/field";
import { DatetimeFilter } from "../../query-filters/models/datetime-filter";
import { Operator } from "../../query-filters/models/operator";
import { DatetimeFloatingFilterComponent } from "../field-renderers/built-ins/datetime/datetime-floating-filter/datetime-floating-filter.component";
import { DatetimeGridFilterComponent } from "../field-renderers/built-ins/datetime/datetime-grid-filter/datetime-grid-filter.component";
export class DatetimeField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.DATETIME);
        this.isFormField = true;
        this.isRelationship = false;
        this.viewComponent = DatetimeViewComponent;
        this.fieldComponent = DatetimeFieldComponent;
        this.filter = DatetimeFilter;
        this.gridFloatingFilterComponent = DatetimeFloatingFilterComponent;
        this.gridFilterComponent = DatetimeGridFilterComponent;
    }
    static { this.dateOperators = [
        new Operator('date', 'Is In', null, this.evaluateIsIn)
    ]; }
    static { this.operators = [...Field.equalOperators, ...Field.greaterThanLessThanOperators, ...Field.nullOperator, ...DatetimeField.dateOperators]; }
    static evaluateIsIn(field, value) {
        console.log(field, value);
        return false;
    }
}
//# sourceMappingURL=data:application/json;base64,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