import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
import { Field } from "../../core/models/field";
export class IPv4Field extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.IPv4);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaXB2NC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL2Zvcm0tZmllbGRzL2ZpZWxkLXR5cGVzL2lwdjQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sMERBQTBELENBQUM7QUFDL0YsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0seURBQXlELENBQUM7QUFDN0YsT0FBTyxFQUFFLEtBQUssRUFBRSxNQUFNLHlCQUF5QixDQUFDO0FBRWhELE1BQU0sT0FBTyxTQUFVLFNBQVEsS0FBSztJQUNsQyxZQUFZLElBQVk7UUFDdEIsS0FBSyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO1FBQzVCLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxHQUFHLGtLQUFrSyxDQUFDO1FBQzdMLElBQUksQ0FBQyxjQUFjLEdBQUcsbUJBQW1CLENBQUM7UUFDMUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxrQkFBa0IsQ0FBQztJQUMxQyxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbnB1dEZpZWxkQ29tcG9uZW50IH0gZnJvbSBcIi4uL2ZpZWxkLXJlbmRlcmVycy9idWlsdC1pbnMvaW5wdXQvaW5wdXQtZmllbGQuY29tcG9uZW50XCI7XG5pbXBvcnQgeyBJbnB1dFZpZXdDb21wb25lbnQgfSBmcm9tIFwiLi4vZmllbGQtcmVuZGVyZXJzL2J1aWx0LWlucy9pbnB1dC9pbnB1dC12aWV3LmNvbXBvbmVudFwiO1xuaW1wb3J0IHsgRmllbGQgfSBmcm9tIFwiLi4vLi4vY29yZS9tb2RlbHMvZmllbGRcIjtcblxuZXhwb3J0IGNsYXNzIElQdjRGaWVsZCBleHRlbmRzIEZpZWxkIHtcbiAgY29uc3RydWN0b3IobmFtZTogc3RyaW5nKSB7XG4gICAgc3VwZXIobmFtZSwgRmllbGQuQnVpbHRJblR5cGUuSVB2NCk7XG4gICAgdGhpcy5pc0Zvcm1GaWVsZCA9IHRydWU7XG4gICAgdGhpcy5pc1JlbGF0aW9uc2hpcCA9IGZhbHNlO1xuICAgIHRoaXMudmFsaWRhdGlvbi5wYXR0ZXJuID0gL14oMjVbMC01XXwyWzAtNF1bMC05XXxbMDFdP1swLTldWzAtOV0/KVxcLigyNVswLTVdfDJbMC00XVswLTldfFswMV0/WzAtOV1bMC05XT8pXFwuKDI1WzAtNV18MlswLTRdWzAtOV18WzAxXT9bMC05XVswLTldPylcXC4oMjVbMC01XXwyWzAtNF1bMC05XXxbMDFdP1swLTldWzAtOV0/KSQvO1xuICAgIHRoaXMuZmllbGRDb21wb25lbnQgPSBJbnB1dEZpZWxkQ29tcG9uZW50O1xuICAgIHRoaXMudmlld0NvbXBvbmVudCA9IElucHV0Vmlld0NvbXBvbmVudDtcbiAgfVxufVxuIl19