import { Field } from "../../core/models/field";
import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
export class IPv6Field extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.IPv6);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(::|(([a-fA-F0-9]{1,4}):){7}(([a-fA-F0-9]{1,4}))|(:(:([a-fA-F0-9]{1,4})){1,6})|((([a-fA-F0-9]{1,4}):){1,6}:)|((([a-fA-F0-9]{1,4}):)(:([a-fA-F0-9]{1,4})){1,6})|((([a-fA-F0-9]{1,4}):){2}(:([a-fA-F0-9]{1,4})){1,5})|((([a-fA-F0-9]{1,4}):){3}(:([a-fA-F0-9]{1,4})){1,4})|((([a-fA-F0-9]{1,4}):){4}(:([a-fA-F0-9]{1,4})){1,3})|((([a-fA-F0-9]{1,4}):){5}(:([a-fA-F0-9]{1,4})){1,2}))$/i;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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