import { isObject } from "lodash-es";
import { PicklistFieldComponent } from "../field-renderers/built-ins/picklist/picklist-field.component";
import { PicklistViewComponent } from "../field-renderers/built-ins/picklist/picklist-view.component";
import { Field } from "../../core/models/field";
export class PicklistField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name, formType) {
        super(name, formType ? formType : Field.BuiltInType.PICKLIST);
        this._picklistName = '';
        this.displayConditions = {};
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = PicklistFieldComponent;
        this.viewComponent = PicklistViewComponent;
        this.alwaysEditMode = true;
    }
    set dataSource(value) {
        super.dataSource = value;
        this.model = value.model;
        this._picklistName = value.query.filters[0].value;
    }
    get picklistName() {
        return this._picklistName;
    }
    set picklistName(value) {
        this._picklistName = value;
        if (this._dataSource) {
            this._dataSource.query = {
                filters: [{
                        field: 'listName.name',
                        operator: 'eq',
                        value: value
                    }]
            };
        }
    }
    getFlatValue(value) {
        if (isObject(value)) {
            value = value['@id'];
        }
        else {
            value = value;
        }
        return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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