import { Field } from "../../core/models/field";
import { MAX_TEXT_LENGTH } from "../../core/constants";
import { RichtextMarkdownFieldComponent } from "../field-renderers/built-ins/richtext-markdown/richtext-markdown-field.component";
import { RichtextMarkdownViewComponent } from "../field-renderers/built-ins/richtext-markdown/richtext-markdown-view.component";
export class RichtextMarkdownField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.RICHTEXTMARKDOWN);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = RichtextMarkdownFieldComponent;
        this.viewComponent = RichtextMarkdownViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: MAX_TEXT_LENGTH
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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