import { Operator } from "../../query-filters/models/operator";
import { Field } from "../../core/models/field";
import { SelectFieldComponent } from "../field-renderers/built-ins/select-field/select-field.component";
import { SelectViewComponent } from "../field-renderers/built-ins/select-field/select-view.component";
export class SelectField extends Field {
    static { this.selectEqualsOperators = [
        new Operator('eq', 'Equals', SelectFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', SelectFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.operators = [...SelectField.selectEqualsOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.SELECT);
        this.options = [];
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = SelectFieldComponent;
        this.viewComponent = SelectViewComponent;
    }
}
//# sourceMappingURL=data:application/json;base64,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