import { Field } from "../../core/models/field";
export class URLField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.URL);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^(http|ftp|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?^=%&amp;:\/~\+#]*[\w\-\@?^=%&amp;\/~\+#])?/i;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXJsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3NyYy9saWIvZm9ybS1maWVsZHMvZmllbGQtdHlwZXMvdXJsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxLQUFLLEVBQUUsTUFBTSx5QkFBeUIsQ0FBQztBQUVoRCxNQUFNLE9BQU8sUUFBUyxTQUFRLEtBQUs7SUFDakMsWUFBWSxJQUFZO1FBQ3RCLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNuQyxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztRQUN4QixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztRQUM1QixJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sR0FBRyxtR0FBbUcsQ0FBQztJQUVoSSxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBGaWVsZCB9IGZyb20gXCIuLi8uLi9jb3JlL21vZGVscy9maWVsZFwiO1xuXG5leHBvcnQgY2xhc3MgVVJMRmllbGQgZXh0ZW5kcyBGaWVsZCB7XG4gIGNvbnN0cnVjdG9yKG5hbWU6IHN0cmluZykge1xuICAgIHN1cGVyKG5hbWUsIEZpZWxkLkJ1aWx0SW5UeXBlLlVSTCk7XG4gICAgdGhpcy5pc0Zvcm1GaWVsZCA9IHRydWU7XG4gICAgdGhpcy5pc1JlbGF0aW9uc2hpcCA9IGZhbHNlO1xuICAgIHRoaXMudmFsaWRhdGlvbi5wYXR0ZXJuID0gL14oaHR0cHxmdHB8aHR0cHMpOlxcL1xcL1tcXHdcXC1fXSsoXFwuW1xcd1xcLV9dKykrKFtcXHdcXC1cXC4sQD9ePSUmYW1wOzpcXC9+XFwrI10qW1xcd1xcLVxcQD9ePSUmYW1wO1xcL35cXCsjXSk/L2k7XG5cbiAgfVxufVxuIl19