import { ChangeDetectionStrategy, Component, forwardRef, Input, ViewChildren } from '@angular/core';
import { FormControl, NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { Filter } from '../models/filter';
import { FilterGroup } from '../models/filter-group';
import { map } from 'rxjs';
import { compact } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/common";
import * as i3 from "../filter/filter.component";
const _c0 = ["filterComponent"];
const _c1 = ["entity", ""];
const _c2 = (a0, a1) => ({ "margin-top-16px": a0, "border-start ms-0": a1 });
function FilterGroupComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 13);
    i0.ɵɵtext(1, "Filter Conditions");
    i0.ɵɵelementEnd();
} }
function FilterGroupComponent_div_0_label_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 14);
    i0.ɵɵtext(1, "Where");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "field-" + ctx_r1.depth);
} }
function FilterGroupComponent_div_0_select_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 15)(1, "option");
    i0.ɵɵtext(2, "AND");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "option");
    i0.ɵɵtext(4, "OR");
    i0.ɵɵelementEnd()();
} }
function FilterGroupComponent_div_0_div_7_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-filter-group", 18, 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const filterIndex_r3 = i0.ɵɵnextContext().index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.entity)("formControlName", filterIndex_r3)("depth", ctx_r1.depth + 1);
} }
function FilterGroupComponent_div_0_div_7_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-filter", 19, 0);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const filterIndex_r3 = i0.ɵɵnextContext().index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.entity)("formControlName", filterIndex_r3);
} }
function FilterGroupComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, FilterGroupComponent_div_0_div_7_ng_container_1_Template, 3, 3, "ng-container", 17)(2, FilterGroupComponent_div_0_div_7_ng_container_2_Template, 3, 2, "ng-container", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const formControl_r4 = ctx.$implicit;
    const filterIndex_r3 = ctx.index;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c2, filterIndex_r3 > 0, ctx_r1.depth > 0));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", formControl_r4.value == null ? null : formControl_r4.value.filters == null ? null : formControl_r4.value.filters.length);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !(formControl_r4.value == null ? null : formControl_r4.value.filters == null ? null : formControl_r4.value.filters.length));
} }
function FilterGroupComponent_div_0_button_11_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 20);
    i0.ɵɵlistener("click", function FilterGroupComponent_div_0_button_11_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.addFilter(true)); });
    i0.ɵɵtext(1, "+ Add Group");
    i0.ɵɵelementEnd();
} }
function FilterGroupComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, FilterGroupComponent_div_0_label_1_Template, 2, 0, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵtemplate(4, FilterGroupComponent_div_0_label_4_Template, 2, 1, "label", 6)(5, FilterGroupComponent_div_0_select_5_Template, 5, 0, "select", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 8);
    i0.ɵɵtemplate(7, FilterGroupComponent_div_0_div_7_Template, 3, 6, "div", 9);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(8, "div", 10)(9, "button", 11);
    i0.ɵɵlistener("click", function FilterGroupComponent_div_0_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.addFilter()); });
    i0.ɵɵtext(10, "+ Add Condition");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(11, FilterGroupComponent_div_0_button_11_Template, 2, 0, "button", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.depth === 0);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.filtersFormArray.controls.length === 1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.filtersFormArray.controls.length > 1);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.filtersFormArray.controls);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", ctx_r1.depth < 2);
} }
export class FilterGroupComponent {
    constructor(changeDetectorRef, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.depth = 0;
        this.FilterGroup = FilterGroup;
        this.Filter = Filter;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.filtersFormArray = this.formBuilder.array([]);
        this.formGroup = this.formBuilder.group({
            logic: new FormControl('AND'),
            filters: this.filtersFormArray
        });
        this.formGroup.valueChanges.pipe(map((values) => {
            if (this.value) {
                this.value.logic = values.logic;
                values.filters.forEach((filter, filterIndex) => {
                    if (!filter) {
                        this.filtersFormArray.removeAt(filterIndex);
                    }
                });
                this.value.filters = compact(values.filters);
            }
            if (this.depth === 0 || this.value?.filters.length) {
                this.onChange(this.value);
            }
            else {
                // Remove the group if all filters are deleted
                this.onChange(null);
            }
            this.changeDetectorRef.detectChanges();
        })).subscribe();
    }
    writeValue(value) {
        // Clear it first
        while (this.filtersFormArray.length !== 0) {
            this.filtersFormArray.removeAt(0);
        }
        value?.filters.forEach((filter) => {
            this.filtersFormArray.push(new FormControl(filter));
        });
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    addFilter(group = false) {
        const newFilter = new Filter();
        const filter = group ? new FilterGroup([newFilter], 'AND') : newFilter;
        this.filtersFormArray.push(new FormControl(filter), {
            emitEvent: false
        });
        setTimeout(() => this.onChange(this.value));
    }
    validate(control) {
        return this.formGroup.invalid ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        for (let filterComponent of this.filterComponents) {
            if (filterComponent.focusOnFirstInvalidInput()) {
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function FilterGroupComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterGroupComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterGroupComponent, selectors: [["xf-filter-group", "entity", ""]], viewQuery: function FilterGroupComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterComponents = _t);
        } }, inputs: { entity: "entity", depth: "depth" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterGroupComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterGroupComponent),
                    multi: true
                }])], attrs: _c1, decls: 1, vars: 1, consts: [["filterComponent", ""], [3, "formGroup", 4, "ngIf"], [3, "formGroup"], ["class", "form-label", 4, "ngIf"], [1, "d-flex"], [1, "w-60px", "d-flex", "align-items-start"], ["class", "col-form-label font-size-14px mx-2", 3, "for", 4, "ngIf"], ["formControlName", "logic", "class", "form-select w-auto form-select-sm", 4, "ngIf"], ["formArrayName", "filters", 1, "flex-grow-1"], [3, "ngClass", 4, "ngFor", "ngForOf"], [1, "btn-group", "margin-top-16px"], ["type", "button", 1, "btn", "btn-link", "btn-xs", "p-0", "margin-right-12px", 3, "click"], ["type", "button", "class", "btn btn-link btn-xs p-0", 3, "click", 4, "ngIf"], [1, "form-label"], [1, "col-form-label", "font-size-14px", "mx-2", 3, "for"], ["formControlName", "logic", 1, "form-select", "w-auto", "form-select-sm"], [3, "ngClass"], [4, "ngIf"], [3, "entity", "formControlName", "depth"], [3, "entity", "formControlName"], ["type", "button", 1, "btn", "btn-link", "btn-xs", "p-0", 3, "click"]], template: function FilterGroupComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FilterGroupComponent_div_0_Template, 12, 6, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.value);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i1.NgSelectOption, i1.ɵNgSelectMultipleOption, i1.SelectControlValueAccessor, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, i1.FormArrayName, FilterGroupComponent, i3.FilterComponent], styles: [".w-120px[_ngcontent-%COMP%]{width:120px}.select-block[_ngcontent-%COMP%]{border:1px solid var(--element-default-border-color);border-radius:3px;color:var(--btn-select-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterGroupComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter-group[entity]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterGroupComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterGroupComponent),
                        multi: true
                    }], template: "<div *ngIf=\"value\" [formGroup]=\"formGroup\">\n  <label class=\"form-label\" *ngIf=\"depth === 0\">Filter Conditions</label>\n  <div class=\"d-flex\">\n    <div class=\"w-60px d-flex align-items-start\">\n      <label [for]=\"'field-' + depth\" class=\"col-form-label font-size-14px mx-2\"\n        *ngIf=\"filtersFormArray.controls.length === 1\">Where</label>\n      <select formControlName=\"logic\" class=\"form-select w-auto form-select-sm\" *ngIf=\"filtersFormArray.controls.length > 1\">\n        <option>AND</option>\n        <option>OR</option>\n      </select>\n    </div>\n    <div formArrayName=\"filters\" class=\"flex-grow-1\">\n      <div [ngClass]=\"{'margin-top-16px': filterIndex > 0, 'border-start ms-0': depth > 0}\"\n        *ngFor=\"let formControl of filtersFormArray.controls; let filterIndex = index\">\n        <!-- <span class=\"content-font padding-bottom-6px padding-left-16px padding-right-16px padding-top-6px select-block\" *ngIf=\"filterIndex > 1\">{{\n          value.logic }}</span> -->\n        <ng-container *ngIf=\"$any(formControl.value)?.filters?.length\">\n          <xf-filter-group [entity]=\"entity\" [formControlName]=\"filterIndex\" [depth]=\"depth + 1\" #filterComponent></xf-filter-group>\n        </ng-container>\n        <ng-container *ngIf=\"!$any(formControl.value)?.filters?.length\">\n          <xf-filter [entity]=\"entity\" [formControlName]=\"filterIndex\" #filterComponent></xf-filter>\n        </ng-container>\n      </div>\n    </div>\n  </div>\n  <div class=\"btn-group margin-top-16px\">\n    <button type=\"button\" class=\"btn btn-link btn-xs p-0 margin-right-12px\" (click)=\"addFilter()\">+ Add\n      Condition</button>\n    <button type=\"button\" class=\"btn btn-link btn-xs p-0\" (click)=\"addFilter(true)\" *ngIf=\"depth < 2\">+ Add\n      Group</button>\n  </div>\n\n</div>\n", styles: [".w-120px{width:120px}.select-block{border:1px solid var(--element-default-border-color);border-radius:3px;color:var(--btn-select-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.FormBuilder }], { filterComponents: [{
            type: ViewChildren,
            args: ['filterComponent']
        }], entity: [{
            type: Input
        }], depth: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterGroupComponent, { className: "FilterGroupComponent", filePath: "lib/query-filters/filter-group/filter-group.component.ts", lineNumber: 25 }); })();
//# sourceMappingURL=data:application/json;base64,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