import { Filter } from "./filter";
export class DatetimeFilter extends Filter {
    constructor(field = null, value = null, secondValue = null) {
        super(field, null, value);
        this.secondValue = secondValue;
        this.secondValue = secondValue;
    }
    getFlatFilter() {
        let filters = [{
                field: this.field,
                operator: 'gte',
                value: this.value.toUTCString()
            }];
        if (this.secondValue) {
            filters.push({
                field: this.field,
                operator: 'lte',
                value: this.secondValue.toUTCString()
            });
        }
        return {
            logic: 'AND',
            filters: filters
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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