export class Filter {
    constructor(field = null, operator = null, value = null, oldValue) {
        this.type = '';
        this.evaluation = false;
        this.field = field;
        this.operator = operator;
        this.value = value;
        this.originalValue = value;
        this.oldValue = oldValue;
    }
    // public get value() {
    //   return this._value;
    // }
    // public set value(value: any) {
    //   this._value = value;
    // }
    populateFieldAndOperator(entity) {
        let fieldName = this.field;
        entity.attributes.forEach((field) => {
            if (field.name === fieldName) {
                let operator = this.operator ? field.getOperator(this.operator) : null;
                this.field = field.name;
                this.operator = operator?.savedId || null;
                this.value = field.getFlatValue(this.originalValue, operator);
            }
        });
    }
    evaluate(entity) {
        if (!this.field || !this.operator) {
            this.evaluation = false;
            return;
        }
        const field = entity.fields[this.field];
        const operator = field.getOperator(this.operator);
        this.evaluation = operator ? operator.evaluator(field, this.value) : false;
    }
    getFlatFilter() {
        // if(this.operator.getFlatValue) {
        //   return this.operator.getFlatValue();
        // } else {
        //   return this.value;
        // }
        // let value: any;
        // if (isArray(this.value)) {
        //   value = [];
        //   this.value.forEach((val: any) => {
        //     if (isObject(val)) {
        //       value.push(val['@id' as keyof typeof val])
        //     } else {
        //       value.push(val);
        //     }
        //   });
        // } else if (isObject(this.value)) {
        //   value = this.value['@id' as keyof typeof this.value];
        // } else {
        //   value = this.value;
        // }
        // let _value: any = (this.operator === 'like' || this.operator === 'notlike') ? value : value;
        return {
            operator: this.operator,
            field: this.field,
            value: this.value
        };
    }
    getURLQuery(entity) {
        const field = entity.fields[this.field];
        const operator = field.getOperator(this.operator);
        return field.getURLQueryValue(this.originalValue, operator);
    }
}
//# sourceMappingURL=data:application/json;base64,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