import { Directive, HostListener } from '@angular/core';
import * as i0 from "@angular/core";
export class TextareaAutoresizeDirective {
    constructor(elementRef) {
        this.elementRef = elementRef;
    }
    onInput() {
        this.resize();
    }
    ngOnInit() {
        if (this.elementRef.nativeElement.scrollHeight) {
            setTimeout(() => this.resize());
        }
    }
    resize() {
        this.elementRef.nativeElement.style.height = '0';
        this.elementRef.nativeElement.style.height = (this.elementRef.nativeElement.scrollHeight + 2) + 'px';
    }
    static { this.ɵfac = function TextareaAutoresizeDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TextareaAutoresizeDirective)(i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: TextareaAutoresizeDirective, selectors: [["", "xfTextareaAutoresize", ""]], hostBindings: function TextareaAutoresizeDirective_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("ngModelChange", function TextareaAutoresizeDirective_ngModelChange_HostBindingHandler() { return ctx.onInput(); });
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextareaAutoresizeDirective, [{
        type: Directive,
        args: [{
                selector: '[xfTextareaAutoresize]'
            }]
    }], () => [{ type: i0.ElementRef }], { onInput: [{
            type: HostListener,
            args: ['ngModelChange']
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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