import { Injectable, Pipe } from '@angular/core';
import * as i0 from "@angular/core";
export class InterpolatePipe {
    transform(stringTemplate, interpolateObject) {
        function getNestedValue(obj, keyPath) {
            return keyPath.split('.').reduce((acc, key) => (acc && acc[key] !== undefined) ? acc[key] : '', obj);
        }
        function interpolate(template, data) {
            return template.replace(/{{([\s\S]+?)}}/g, (match, p1) => getNestedValue(data, p1.trim()) || '');
        }
        const extendedContext = interpolateObject;
        return interpolate(stringTemplate, extendedContext);
    }
    static { this.ɵfac = function InterpolatePipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || InterpolatePipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "interpolate", type: InterpolatePipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: InterpolatePipe, factory: InterpolatePipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(InterpolatePipe, [{
        type: Pipe,
        args: [{
                name: 'interpolate'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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