import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./export-config.service";
export class AbstractExportFilterComponent {
    constructor(exportService, changeDetectorRef) {
        this.exportService = exportService;
        this.changeDetectorRef = changeDetectorRef;
        this.dataChange = new EventEmitter();
        this.checkAlls = {
            include: false
        };
        this.options = [];
        this.configKey = '';
        this.serviceKey = '';
    }
    ngOnInit() {
        if (this.wizard.data.selectedConfigs) {
            this.config = this.wizard.data.selectedConfigs.find((config) => config.name === this.configKey);
            this.subscription = this.includeAll$.subscribe((includeAll) => {
                this.checkAlls.include = includeAll;
                this.checkAllChanged();
            });
        }
    }
    ngOnDestroy() {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    }
    checkAllChanged(key = 'include') {
        this.options.forEach((option) => {
            option[key] = this.checkAlls[key];
        });
        this.onOptionsChange();
        this.changeDetectorRef.detectChanges();
    }
    onOptionsChange() {
        if (!this.wizard.data.exportTemplate) {
            return;
        }
        const includedOptions = this.options.filter((option) => option.include);
        this.checkAlls.include = includedOptions.length === this.options.length;
        this.wizard.data.exportTemplate.selections[this.serviceKey][this.configKey] = includedOptions.map((option) => option.asSaved());
        this.dataChange.emit();
    }
    buttonClicked(option, key = 'include') {
        option[key] = !option[key];
        this.onOptionsChange();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function AbstractExportFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractExportFilterComponent)(i0.ɵɵdirectiveInject(i1.ExportConfigService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractExportFilterComponent, selectors: [["xf-abstract-section-config"]], inputs: { wizard: "wizard", includeAll$: "includeAll$" }, outputs: { dataChange: "dataChange" }, decls: 0, vars: 0, template: function AbstractExportFilterComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractExportFilterComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-section-config',
                template: ''
            }]
    }], () => [{ type: i1.ExportConfigService }, { type: i0.ChangeDetectorRef }], { wizard: [{
            type: Input
        }], includeAll$: [{
            type: Input
        }], dataChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractExportFilterComponent, { className: "AbstractExportFilterComponent", filePath: "src/export/abstract-export-filter.component.ts", lineNumber: 12 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWJzdHJhY3QtZXhwb3J0LWZpbHRlci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvcG9ydGVyL3NyYy9leHBvcnQvYWJzdHJhY3QtZXhwb3J0LWZpbHRlci5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFxQixTQUFTLEVBQUUsWUFBWSxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxlQUFlLENBQUM7OztBQVcxRixNQUFNLE9BQWdCLDZCQUE2QjtJQWNqRCxZQUNZLGFBQWtDLEVBQ2xDLGlCQUFvQztRQURwQyxrQkFBYSxHQUFiLGFBQWEsQ0FBcUI7UUFDbEMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQVp0QyxlQUFVLEdBQUcsSUFBSSxZQUFZLEVBQVEsQ0FBQztRQUdoRCxjQUFTLEdBQTRCO1lBQ25DLE9BQU8sRUFBRSxLQUFLO1NBQ2YsQ0FBQztRQUNGLFlBQU8sR0FBbUIsRUFBRSxDQUFDO1FBUTNCLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDO1FBQ3BCLElBQUksQ0FBQyxVQUFVLEdBQUcsRUFBRSxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxRQUFRO1FBQ04sSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztZQUNyQyxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFxQixFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztZQUMvRyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLENBQUMsVUFBbUIsRUFBRSxFQUFFO2dCQUNyRSxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sR0FBRyxVQUFVLENBQUM7Z0JBQ3BDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztZQUN6QixDQUFDLENBQUMsQ0FBQztRQUNMLENBQUM7SUFDSCxDQUFDO0lBRUQsV0FBVztRQUNULElBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQ3RCLElBQUksQ0FBQyxZQUFZLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDbEMsQ0FBQztJQUNILENBQUM7SUFFRCxlQUFlLENBQUMsTUFBaUIsU0FBUztRQUN4QyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE1BQW9CLEVBQUUsRUFBRTtZQUM1QyxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNwQyxDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztRQUN2QixJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekMsQ0FBQztJQUVELGVBQWU7UUFDYixJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7WUFDckMsT0FBTztRQUNULENBQUM7UUFDRCxNQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQW9CLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN0RixJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sR0FBRyxlQUFlLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDO1FBQ3hFLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxlQUFlLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBb0IsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFDOUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUN6QixDQUFDO0lBRUQsYUFBYSxDQUFDLE1BQW9CLEVBQUUsTUFBaUIsU0FBUztRQUM1RCxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDM0IsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN6QyxDQUFDOzhIQTVEbUIsNkJBQTZCO29FQUE3Qiw2QkFBNkI7O2lGQUE3Qiw2QkFBNkI7Y0FKbEQsU0FBUztlQUFDO2dCQUNULFFBQVEsRUFBRSw0QkFBNEI7Z0JBQ3RDLFFBQVEsRUFBRSxFQUFFO2FBQ2I7b0ZBR1UsTUFBTTtrQkFBZCxLQUFLO1lBQ0csV0FBVztrQkFBbkIsS0FBSztZQUNJLFVBQVU7a0JBQW5CLE1BQU07O2tGQUphLDZCQUE2QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENoYW5nZURldGVjdG9yUmVmLCBDb21wb25lbnQsIEV2ZW50RW1pdHRlciwgSW5wdXQsIE91dHB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgU3Vic2NyaXB0aW9uIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBQb3J0aW5nQ29uZmlnIH0gZnJvbSAnLi4vcG9ydGluZy1jb25maWcnO1xuaW1wb3J0IHsgRXhwb3J0Q29uZmlnU2VydmljZSB9IGZyb20gJy4vZXhwb3J0LWNvbmZpZy5zZXJ2aWNlJztcbmltcG9ydCB7IEV4cG9ydE9wdGlvbiB9IGZyb20gJy4vbW9kZWxzL2V4cG9ydC1vcHRpb24nO1xuaW1wb3J0IHsgV2l6YXJkIH0gZnJvbSAnc2hhcmVkJztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAneGYtYWJzdHJhY3Qtc2VjdGlvbi1jb25maWcnLFxuICB0ZW1wbGF0ZTogJydcbn0pXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQWJzdHJhY3RFeHBvcnRGaWx0ZXJDb21wb25lbnQge1xuXG4gIEBJbnB1dCgpIHdpemFyZCE6IFdpemFyZDtcbiAgQElucHV0KCkgaW5jbHVkZUFsbCQhOiBPYnNlcnZhYmxlPGJvb2xlYW4+O1xuICBAT3V0cHV0KCkgZGF0YUNoYW5nZSA9IG5ldyBFdmVudEVtaXR0ZXI8dm9pZD4oKTtcbiAgc3Vic2NyaXB0aW9uPzogU3Vic2NyaXB0aW9uO1xuICBjb25maWc/OiBQb3J0aW5nQ29uZmlnO1xuICBjaGVja0FsbHM6IFJlY29yZDxzdHJpbmcsIGJvb2xlYW4+ID0ge1xuICAgIGluY2x1ZGU6IGZhbHNlXG4gIH07XG4gIG9wdGlvbnM6IEV4cG9ydE9wdGlvbltdID0gW107XG4gIGNvbmZpZ0tleTogc3RyaW5nO1xuICBzZXJ2aWNlS2V5OiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJvdGVjdGVkIGV4cG9ydFNlcnZpY2U6IEV4cG9ydENvbmZpZ1NlcnZpY2UsXG4gICAgcHJvdGVjdGVkIGNoYW5nZURldGVjdG9yUmVmOiBDaGFuZ2VEZXRlY3RvclJlZlxuICApIHtcbiAgICB0aGlzLmNvbmZpZ0tleSA9ICcnO1xuICAgIHRoaXMuc2VydmljZUtleSA9ICcnO1xuICB9XG5cbiAgbmdPbkluaXQoKSB7XG4gICAgaWYgKHRoaXMud2l6YXJkLmRhdGEuc2VsZWN0ZWRDb25maWdzKSB7XG4gICAgICB0aGlzLmNvbmZpZyA9IHRoaXMud2l6YXJkLmRhdGEuc2VsZWN0ZWRDb25maWdzLmZpbmQoKGNvbmZpZzogUG9ydGluZ0NvbmZpZykgPT4gY29uZmlnLm5hbWUgPT09IHRoaXMuY29uZmlnS2V5KTtcbiAgICAgIHRoaXMuc3Vic2NyaXB0aW9uID0gdGhpcy5pbmNsdWRlQWxsJC5zdWJzY3JpYmUoKGluY2x1ZGVBbGw6IGJvb2xlYW4pID0+IHtcbiAgICAgICAgdGhpcy5jaGVja0FsbHMuaW5jbHVkZSA9IGluY2x1ZGVBbGw7XG4gICAgICAgIHRoaXMuY2hlY2tBbGxDaGFuZ2VkKCk7XG4gICAgICB9KTtcbiAgICB9XG4gIH1cblxuICBuZ09uRGVzdHJveSgpIHtcbiAgICBpZiAodGhpcy5zdWJzY3JpcHRpb24pIHtcbiAgICAgIHRoaXMuc3Vic2NyaXB0aW9uLnVuc3Vic2NyaWJlKCk7XG4gICAgfVxuICB9XG5cbiAgY2hlY2tBbGxDaGFuZ2VkKGtleTogJ2luY2x1ZGUnID0gJ2luY2x1ZGUnKTogdm9pZCB7XG4gICAgdGhpcy5vcHRpb25zLmZvckVhY2goKG9wdGlvbjogRXhwb3J0T3B0aW9uKSA9PiB7XG4gICAgICBvcHRpb25ba2V5XSA9IHRoaXMuY2hlY2tBbGxzW2tleV07XG4gICAgfSk7XG4gICAgdGhpcy5vbk9wdGlvbnNDaGFuZ2UoKTtcbiAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG4gIG9uT3B0aW9uc0NoYW5nZSgpOiB2b2lkIHtcbiAgICBpZiAoIXRoaXMud2l6YXJkLmRhdGEuZXhwb3J0VGVtcGxhdGUpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgY29uc3QgaW5jbHVkZWRPcHRpb25zID0gdGhpcy5vcHRpb25zLmZpbHRlcigob3B0aW9uOiBFeHBvcnRPcHRpb24pID0+IG9wdGlvbi5pbmNsdWRlKTtcbiAgICB0aGlzLmNoZWNrQWxscy5pbmNsdWRlID0gaW5jbHVkZWRPcHRpb25zLmxlbmd0aCA9PT0gdGhpcy5vcHRpb25zLmxlbmd0aDtcbiAgICB0aGlzLndpemFyZC5kYXRhLmV4cG9ydFRlbXBsYXRlLnNlbGVjdGlvbnNbdGhpcy5zZXJ2aWNlS2V5XVt0aGlzLmNvbmZpZ0tleV0gPSBpbmNsdWRlZE9wdGlvbnMubWFwKChvcHRpb246IEV4cG9ydE9wdGlvbikgPT4gb3B0aW9uLmFzU2F2ZWQoKSk7XG4gICAgdGhpcy5kYXRhQ2hhbmdlLmVtaXQoKTtcbiAgfVxuXG4gIGJ1dHRvbkNsaWNrZWQob3B0aW9uOiBFeHBvcnRPcHRpb24sIGtleTogJ2luY2x1ZGUnID0gJ2luY2x1ZGUnKSB7XG4gICAgb3B0aW9uW2tleV0gPSAhb3B0aW9uW2tleV07XG4gICAgdGhpcy5vbk9wdGlvbnNDaGFuZ2UoKTtcbiAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG59XG4iXX0=