import { Component, EventEmitter, Input, Output, ViewChildren } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';
import cronstrue from 'cronstrue';
import { concatMap, of, tap } from 'rxjs';
import { CheckboxField, FieldOptions, FormFieldComponent, IntegerField } from 'shared';
import { ScheduleDetailComponent } from '../../schedule-detail/schedule-detail.component';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@jsverse/transloco";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "shared";
import * as i5 from "@angular/common";
const _c0 = (a0, a1) => ({ "text-bg-success": a0, "text-bg-danger": a1 });
const _c1 = (a0, a1) => ({ "fa-check": a0, "fa-minus": a1 });
function PurgeScheduleComponent_div_0_div_5_div_8_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 25)(1, "div", 26)(2, "label", 27);
    i0.ɵɵtext(3, "Schedule Status");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "span", 28);
    i0.ɵɵelement(5, "span", 29);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c0, ctx_r1.schedule.enabled, !ctx_r1.schedule.enabled));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(6, _c1, ctx_r1.schedule.enabled, !ctx_r1.schedule.enabled));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r1.schedule.enabled ? "Active" : "Inactive", " ");
} }
function PurgeScheduleComponent_div_0_div_5_div_8_Conditional_3_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 30);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_div_5_div_8_Conditional_3_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r1.openSchedule()); });
    i0.ɵɵelementStart(1, "span");
    i0.ɵɵtext(2, "View Schedule");
    i0.ɵɵelementEnd()();
} }
function PurgeScheduleComponent_div_0_div_5_div_8_Conditional_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 20);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.cronDescriber);
} }
function PurgeScheduleComponent_div_0_div_5_div_8_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 21)(1, "label", 22);
    i0.ɵɵtext(2, "Last run at:");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "span", 23);
    i0.ɵɵtext(4);
    i0.ɵɵpipe(5, "date");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(5, 1, ctx_r1.schedule.last_run_at, ctx_r1.systemSettings.preferences.dateTimeFormat));
} }
function PurgeScheduleComponent_div_0_div_5_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 17);
    i0.ɵɵtemplate(2, PurgeScheduleComponent_div_0_div_5_div_8_div_2_Template, 7, 9, "div", 18)(3, PurgeScheduleComponent_div_0_div_5_div_8_Conditional_3_Template, 3, 0, "button", 19)(4, PurgeScheduleComponent_div_0_div_5_div_8_Conditional_4_Template, 2, 1, "span", 20);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "div", 21)(6, "label", 22);
    i0.ɵɵtext(7, "Frequency:");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(8, "span", 23);
    i0.ɵɵtext(9);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(10, PurgeScheduleComponent_div_0_div_5_div_8_div_10_Template, 6, 4, "div", 24);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.schedule);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.entitlementType !== "trial" ? 3 : -1);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.entitlementType === "trial" ? 4 : -1);
    i0.ɵɵadvance(5);
    i0.ɵɵtextInterpolate(ctx_r1.cronDescriber);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.schedule.last_run_at);
} }
function PurgeScheduleComponent_div_0_div_5_Conditional_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14)(1, "p", 31);
    i0.ɵɵtext(2, "As per your entitlement, the schedule cannot be edited.");
    i0.ɵɵelementEnd()();
} }
function PurgeScheduleComponent_div_0_div_5_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 32);
    i0.ɵɵelement(1, "i", 33);
    i0.ɵɵelementStart(2, "small");
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext(2).$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("admin.auditLogs.schedulePurge.scheduleRequired"));
} }
function PurgeScheduleComponent_div_0_div_5_div_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 34)(1, "div", 35);
    i0.ɵɵelement(2, "xf-form-field", 36);
    i0.ɵɵelementStart(3, "span", 37);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
    i0.ɵɵelement(5, "xf-form-messages", 38)(6, "div", 39);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.fields.keepLogs)("fieldOptions", ctx_r1.keepLogsFieldOption);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(t_r4("admin.purgeLogs.schedule.primaryCriteriaLabels.days"));
    i0.ɵɵadvance();
    i0.ɵɵproperty("control", ctx_r1.formGroup.controls.keepLogs)("customErrorMessages", ctx_r1.keepLogsFieldOption.customErrorMessages);
} }
function PurgeScheduleComponent_div_0_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8)(1, "form", 9, 0)(3, "div")(4, "label", 10);
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 11);
    i0.ɵɵelement(7, "xf-form-field", 12);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(8, PurgeScheduleComponent_div_0_div_5_div_8_Template, 11, 5, "div", 13)(9, PurgeScheduleComponent_div_0_div_5_Conditional_9_Template, 3, 0, "div", 14)(10, PurgeScheduleComponent_div_0_div_5_div_10_Template, 4, 1, "div", 15)(11, PurgeScheduleComponent_div_0_div_5_div_11_Template, 7, 5, "div", 16);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    let tmp_10_0;
    let tmp_13_0;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.description);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.fields["enablePurge"])("formControlName", "enablePurge")("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (tmp_10_0 = ctx_r1.formGroup.get("enablePurge")) == null ? null : tmp_10_0.value);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.entitlementType === "trial" ? 9 : -1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.showScheduleError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (tmp_13_0 = ctx_r1.formGroup.get("enablePurge")) == null ? null : tmp_13_0.value);
} }
function PurgeScheduleComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 40);
    i0.ɵɵelement(1, "i", 41);
    i0.ɵɵelementEnd();
} }
function PurgeScheduleComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 42)(1, "button", 43);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelement(2, "i", 44);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 45);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_div_7_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(5, "i", 46);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.save"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.cancel"), " ");
} }
function PurgeScheduleComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, PurgeScheduleComponent_div_0_div_5_Template, 12, 10, "div", 5)(6, PurgeScheduleComponent_div_0_div_6_Template, 2, 0, "div", 6)(7, PurgeScheduleComponent_div_0_div_7_Template, 7, 2, "div", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.title);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
} }
export class PurgeScheduleComponent {
    constructor(formBuilder, translocoService, activeOffCanvas, offcanvasServicePurge, scheduleService, licenseService, systemSettingsService) {
        this.formBuilder = formBuilder;
        this.translocoService = translocoService;
        this.activeOffCanvas = activeOffCanvas;
        this.offcanvasServicePurge = offcanvasServicePurge;
        this.scheduleService = scheduleService;
        this.licenseService = licenseService;
        this.systemSettingsService = systemSettingsService;
        this.fields = {};
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.loading = true;
        this.scheduleClosed = new EventEmitter();
        this.showScheduleError = false;
        this.keepLogsFieldTooltip = '';
        this.systemSettings = this.systemSettingsService.get();
    }
    ngOnInit() {
        this.params.getSetting$().pipe(concatMap((result) => {
            this.settings = result;
            return this.getScheduleData();
        })).subscribe();
    }
    getScheduleData() {
        return this.scheduleService.getByTaskName(this.params.taskName).pipe(concatMap((result) => {
            if (result) {
                this.schedule = result;
                this.scheduleMode = 'edit';
            }
            return this.licenseService.getLicenseDetails().pipe(tap((licenseDetails) => {
                this.licenseDetails = licenseDetails;
                this.entitlementType = licenseDetails.type;
                this.cronDescriber = cronstrue.toString(`${this.schedule.crontab.minute} ${this.schedule.crontab.hour} ${this.schedule.crontab.day_of_month} ${this.schedule.crontab.month_of_year} ${this.schedule.crontab.day_of_week}`);
                this.loading = false;
                this.setForm();
            }));
        }));
    }
    setForm() {
        const warningMessage = this.translocoService.translate('admin.purgeLogs.DATA_RETENTION_POLICY_WARNING', { days: this.licenseDetails.info.data_retention_period });
        const defaultMessage = this.translocoService.translate('admin.purgeLogs.DEFAULT_ENTERPRISE_VALUE', { days: this.licenseDetails.info.data_retention_period });
        this.keepLogsFieldTooltip = this.entitlementType === 'trial' ? warningMessage : defaultMessage;
        this.formGroup = this.formBuilder.group({
            enablePurge: new FormControl(''),
            keepLogs: [this.licenseDetails.info.data_retention_period, Validators.required]
        });
        this.fields.keepLogs = new IntegerField('keepLogs');
        this.fields.keepLogs.title = 'Retain Logs For';
        this.fields.keepLogs.tooltip = this.keepLogsFieldTooltip;
        this.fields.keepLogs.validation.required = true;
        this.fields.keepLogs.validation.min = 1;
        this.fields.keepLogs.validation.max = 3650; // 10 years
        this.keepLogsFieldOption = new FieldOptions({
            showLabel: true,
            showError: false
        });
        if (this.entitlementType === 'trial') {
            this.formGroup.controls.keepLogs.disable();
        }
        this.fields.enablePurge = new CheckboxField('enablePurge');
        this.fields.enablePurge.title = 'Enable Purging';
        this.setFormValues();
    }
    setFormValues() {
        this.formGroup.patchValue({
            enablePurge: this.settings.data.enabled,
            keepLogs: this.entitlementType === 'trial' ? this.licenseDetails.info.data_retention_period : this.settings.data.ttl
        });
        this.loading = false;
        if (this.entitlementType === 'trial') {
            this.formGroup.get('enabledPurge')?.disable();
        }
    }
    openSchedule() {
        this.offcanvasInstancePurge = this.offcanvasServicePurge.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: `offcanvas-slide-left ${this.params.scheduleDetailModalClass}`,
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstancePurge.componentInstance.showReference = false;
        this.offcanvasInstancePurge.componentInstance.referenceData = null;
        this.offcanvasInstancePurge.componentInstance.mode = this.scheduleMode;
        this.offcanvasInstancePurge.componentInstance.schedule = this.schedule;
        this.offcanvasInstancePurge.closed.subscribe((result) => {
            if (result) {
                this.schedule = result;
                let cron = this.schedule.crontab;
                delete cron['timezone'];
                if (this.showScheduleError && result.id) {
                    this.showScheduleError = false;
                }
                this.cronDescriber = cronstrue.toString(`${this.schedule.crontab.minute} ${this.schedule.crontab.hour} ${this.schedule.crontab.day_of_month} ${this.schedule.crontab.month_of_year} ${this.schedule.crontab.day_of_week}`);
                this.setFormValues();
            }
            this.scheduleClosed.emit(this.schedule);
        });
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    save() {
        if (this.formGroup.invalid) {
            this.focusOnFirstInvalidInput();
            return;
        }
        let schedule_config;
        let observable$ = of(null);
        // Update Scheudle and set data for settings
        if ('enablePurge' in this.formGroup.value && !this.formGroup.value.enablePurge) {
            schedule_config = {
                enabled: false
            };
            this.schedule.enabled = false;
            observable$ = this.scheduleService.update(this.schedule);
        }
        else {
            schedule_config = {
                ttl: parseInt(this.formGroup.value.keepLogs || this.licenseDetails.info.data_retention_period),
                scheduleId: this.schedule.id,
                enabled: true
            };
        }
        this.settings.data = schedule_config;
        observable$.pipe(concatMap(() => this.params.save$(this.settings))
        //this.auditService.updateSettings(this.settings))
        ).subscribe((result) => {
            if (result.close) {
                this.activeOffCanvas.close(result.data);
            }
        });
    }
    // Update Settings
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        for (let formField of this.formFields) {
            if (!formField.valid) {
                formField.focus();
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function PurgeScheduleComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PurgeScheduleComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.TranslocoService), i0.ɵɵdirectiveInject(i3.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i3.NgbOffcanvas), i0.ɵɵdirectiveInject(i4.ScheduleService), i0.ɵɵdirectiveInject(i4.LicenseService), i0.ɵɵdirectiveInject(i4.SystemSettingsService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PurgeScheduleComponent, selectors: [["xf-purge-schedule"]], viewQuery: function PurgeScheduleComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { schedule: "schedule", params: "params" }, outputs: { scheduleClosed: "scheduleClosed" }, decls: 1, vars: 0, consts: [["auditLogPurgeScheduleForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10", "font-size-16px"], ["type", "button", "id", "close-btn-schedule", 1, "btn", "btn-close", 3, "click"], ["class", "margin-top-20px modal-body", 4, "ngIf"], ["class", "margin-top-28px text-center", 4, "ngIf"], ["class", "modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px", 4, "ngIf"], [1, "margin-top-20px", "modal-body"], [1, "ms-2", 3, "formGroup"], [1, "form-check-label", "align-bottom", "margin-left-10px", "margin-bottom-10px", "label-font"], [1, "margin-left-10px"], [3, "field", "formControlName", "fieldClass", "autoFocus"], [4, "ngIf"], [1, "ps-1", "pt-1"], ["class", "text-danger content-font fw-medium line-height-15px margin-top-8px ms-2", 4, "ngIf"], ["class", "ms-2 margin-top-12px", 4, "ngIf"], [1, "align-items-center", "d-flex"], ["class", "schedule-status me-2 ms-2 content-font", 4, "ngIf"], ["title", "View Schedule", 1, "btn", "btn-secondary", "btn-sm"], [1, "cron-describer", "mt-2"], [1, "margin-left-10px", "margin-top-10px"], [1, "content-font"], [1, "cron-describer", "margin-left-16px", "muted-50"], ["class", "margin-left-10px margin-top-10px", 4, "ngIf"], [1, "schedule-status", "me-2", "ms-2", "content-font"], [1, "padding-10px"], [1, "me-2"], [1, "padding-bottom-4px", "padding-left-10px", "padding-right-10px", "padding-top-4px", "rounded-4px", "text-bg-success", "text-light", 3, "ngClass"], [1, "padding-right-4px", "fa", 3, "ngClass"], ["title", "View Schedule", 1, "btn", "btn-secondary", "btn-sm", 3, "click"], [1, "content-font", "margin-left-4px", "mb-0", "mb-1", "p-0", "text-warning"], [1, "text-danger", "content-font", "fw-medium", "line-height-15px", "margin-top-8px", "ms-2"], [1, "fa", "fa-exclamation-circle", "fa-regular", "margin-right-4px"], [1, "ms-2", "margin-top-12px"], [1, "d-flex", "content-font", "align-items-center"], ["formControlName", "keepLogs", "fieldClass", "form-control-sm w-150px", 3, "field", "fieldOptions"], [1, "padding-left-12px", "font-size-12px", "muted-40", "margin-top-20px"], [3, "control", "customErrorMessages"], [1, "clearfix"], [1, "margin-top-28px", "text-center"], [1, "fa", "fa-refresh", "fa-spinner", "margin-top-lg"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"]], template: function PurgeScheduleComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PurgeScheduleComponent_div_0_Template, 8, 4, "div", 1);
        } }, dependencies: [i5.NgClass, i5.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i4.FormFieldComponent, i4.FormMessagesComponent, i1.FormGroupDirective, i1.FormControlName, i2.TranslocoDirective, i5.DatePipe], styles: [".close-btn[_ngcontent-%COMP%]{left:-50px;position:absolute}.schedule-status[_ngcontent-%COMP%]{background:var(--secondary-topbar-border-color)}.cron-describer[_ngcontent-%COMP%]{font-size:.8em;font-style:italic}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PurgeScheduleComponent, [{
        type: Component,
        args: [{ selector: 'xf-purge-schedule', template: "<div *transloco=\"let t\">\n    <!-- Header -->\n    <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n        <h4 class=\"page-title-font modal-title muted-10 font-size-16px\">{{ params.metadata.title }}</h4>\n        <button type=\"button\" id=\"close-btn-schedule\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n    </div>\n    <!-- Body -->\n    <div class=\"margin-top-20px modal-body\" *ngIf=\"!loading\">\n        <form #auditLogPurgeScheduleForm=\"ngForm\" [formGroup]=\"formGroup\" class=\"ms-2\">\n            <div>\n                <label class=\"form-check-label align-bottom margin-left-10px margin-bottom-10px label-font\">{{\n                    params.metadata.description }}</label>\n                <div class=\"margin-left-10px\">\n                    <xf-form-field [field]=\"fields['enablePurge']\" [formControlName]=\"'enablePurge'\"\n                        [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\"></xf-form-field>\n                </div>\n            </div>\n            <div *ngIf=\"formGroup.get('enablePurge')?.value\">\n                <div class=\"align-items-center d-flex\">\n                    <div *ngIf=\"schedule\" class=\"schedule-status me-2 ms-2 content-font\">\n                        <div class=\"padding-10px\">\n                            <label class=\"me-2\">Schedule Status</label>\n                            <span\n                                class=\"padding-bottom-4px padding-left-10px padding-right-10px padding-top-4px rounded-4px text-bg-success text-light\"\n                                [ngClass]=\"{'text-bg-success': schedule.enabled, 'text-bg-danger': !schedule.enabled}\">\n                                <span class=\"padding-right-4px fa\"\n                                    [ngClass]=\"{'fa-check': schedule.enabled, 'fa-minus': !schedule.enabled }\"></span>{{schedule.enabled\n                                ? 'Active' : 'Inactive' }}\n                            </span>\n                        </div>\n                    </div>\n                    @if (entitlementType !== 'trial') {\n                    <button class=\"btn btn-secondary btn-sm\" title=\"View Schedule\" (click)=\"openSchedule()\"><span>View\n                            Schedule</span></button>\n                    }\n                    @if (entitlementType === 'trial') {\n                    <span class=\"cron-describer mt-2\">{{cronDescriber}}</span>\n                    }\n                </div>\n                <div class=\"margin-left-10px margin-top-10px\">\n                    <label class=\"content-font\">Frequency:</label>\n                    <span class=\"cron-describer margin-left-16px muted-50\">{{cronDescriber}}</span>\n                </div>\n                <div class=\"margin-left-10px margin-top-10px\" *ngIf=\"schedule.last_run_at\">\n                    <label class=\"content-font\">Last run at:</label>\n                    <span class=\"cron-describer margin-left-16px muted-50\">{{schedule.last_run_at | date: systemSettings.preferences.dateTimeFormat }}</span>\n                </div>\n            </div>\n\n            @if (entitlementType === 'trial') {\n            <div class=\"ps-1 pt-1\">\n                <p class=\"content-font margin-left-4px mb-0 mb-1 p-0 text-warning\">As per your entitlement, the schedule\n                    cannot be edited.</p>\n            </div>\n            }\n            <div *ngIf=\"showScheduleError\"\n                class=\"text-danger content-font fw-medium line-height-15px margin-top-8px ms-2\">\n                <i class=\"fa fa-exclamation-circle fa-regular margin-right-4px\"></i>\n                <small>{{ t('admin.auditLogs.schedulePurge.scheduleRequired') }}</small>\n            </div>\n\n            <div class=\"ms-2 margin-top-12px\" *ngIf=\"formGroup.get('enablePurge')?.value\">\n                <div class=\"d-flex content-font align-items-center\">\n                    <!-- <label class=\"form-label padding-left-12px padding-right-12px\">{{\n                        t('admin.purgeLogs.schedule.primaryCriteriaLabels.keepLogs') }}</label> -->\n                    <xf-form-field [field]=\"fields.keepLogs\" formControlName=\"keepLogs\"\n                        [fieldOptions]=\"keepLogsFieldOption\"\n                        fieldClass=\"form-control-sm w-150px\"></xf-form-field>\n                      <span class=\"padding-left-12px font-size-12px muted-40 margin-top-20px\">{{\n                        t('admin.purgeLogs.schedule.primaryCriteriaLabels.days') }}</span>\n                </div>\n                <xf-form-messages [control]=\"formGroup.controls.keepLogs\" [customErrorMessages]=\"keepLogsFieldOption.customErrorMessages\"></xf-form-messages>\n                <div class=\"clearfix\"></div>\n            </div>\n        </form>\n    </div>\n    <div class=\"margin-top-28px text-center\" *ngIf=\"loading\">\n        <i class=\"fa fa-refresh fa-spinner margin-top-lg\"></i>\n    </div>\n    <!-- Footer -->\n    <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\" *ngIf=\"!loading\">\n        <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" (click)=\"save()\">\n            <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.save') }}\n        </button>\n        <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n            <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n        </button>\n    </div>\n</div>\n", styles: [".close-btn{left:-50px;position:absolute}.schedule-status{background:var(--secondary-topbar-border-color)}.cron-describer{font-size:.8em;font-style:italic}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i2.TranslocoService }, { type: i3.NgbActiveOffcanvas }, { type: i3.NgbOffcanvas }, { type: i4.ScheduleService }, { type: i4.LicenseService }, { type: i4.SystemSettingsService }], { schedule: [{
            type: Input
        }], params: [{
            type: Input,
            args: [{ required: true }]
        }], scheduleClosed: [{
            type: Output
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PurgeScheduleComponent, { className: "PurgeScheduleComponent", filePath: "src/manage-purge/purge-schedule/purge-schedule.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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