import { ChangeDetectionStrategy, Component, Input } from '@angular/core';
import { cloneDeep } from 'lodash-es';
import { FIXED_MODULE, PERMISSION, Schedule, Query, Filter } from 'shared';
import { concatMap, forkJoin, of } from 'rxjs';
import { ScheduleDetailComponent } from '../schedule-detail/schedule-detail.component';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "shared/grid";
import * as i3 from "@jsverse/transloco";
import * as i4 from "ngx-toastr";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
import * as i6 from "@angular/common";
function ScheduleListComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 6)(1, "button", 7);
    i0.ɵɵlistener("click", function ScheduleListComponent_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.createSchedule()); });
    i0.ɵɵelement(2, "i", 8);
    i0.ɵɵtext(3, "Create Schedule ");
    i0.ɵɵelementEnd()();
} }
export class ScheduleListComponent {
    constructor(entityService, gridDataSourceService, modalService, apiService, translocoService, toasterService, offcanvasService, permissionService, licenseService) {
        this.entityService = entityService;
        this.gridDataSourceService = gridDataSourceService;
        this.modalService = modalService;
        this.apiService = apiService;
        this.translocoService = translocoService;
        this.toasterService = toasterService;
        this.offcanvasService = offcanvasService;
        this.permissionService = permissionService;
        this.licenseService = licenseService;
        this.processing = false;
        this.selectedRows = [];
        this.permission = PERMISSION;
        this.defaultCron = {
            "minute": "*/5",
            "hour": "*",
            "day_of_week": "*",
            "day_of_month": "*",
            "month_of_year": "*",
            "timezone": "UTC"
        };
        this.schedulePermissions = this.permissionService.getPermission(FIXED_MODULE.SCHEDULES);
        this.licenseService.getLicenseDetails().subscribe((result) => {
            this.defaultCron.minute = `*/${result.info.polling_frequency}`;
        });
    }
    ngOnInit() {
        this.entityService.build(FIXED_MODULE.SCHEDULES).subscribe((entity) => {
            this.scheduleEntity = cloneDeep(entity);
            const query = new Query();
            query.filters.push(new Filter('task', 'eq', 'workflow.tasks.periodic_task'));
            this.dataSource = this.gridDataSourceService.getDataSource(entity, query);
        });
        this.gridConfig.options.onRegisterApi = (gridApi) => {
            this.gridApi = gridApi;
        };
        if (!this.gridConfig.options?.allowDelete) {
            this.setBulkDeleteConfig();
        }
    }
    createSchedule() {
        let schedule = new Schedule('');
        schedule.kwargs = {
            inputParameters: { query: { qparam: {} } }
        };
        schedule.crontab = this.defaultCron;
        this.offcanvasInstanceSchedule = this.offcanvasService.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: 'schedule-list-modal offcanvas-slide-left',
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstanceSchedule.componentInstance.showReference = true;
        this.offcanvasInstanceSchedule.componentInstance.mode = 'new'; //TODO: Do we really need mode?
        this.offcanvasInstanceSchedule.componentInstance.schedule = schedule;
        this.offcanvasInstanceSchedule.closed.subscribe((result) => {
            if (result) {
                this.gridApi?.refreshServerSide();
            }
        });
    }
    setBulkDeleteConfig() {
        this.gridConfig.options?.onRegisterApi;
        this.gridConfig.options.selectButtons = [{
                id: 'btn-delete-playbook',
                tooltip: 'Delete Playbook',
                onClick: () => {
                    this.deleteSelected();
                },
                class: 'btn-secondary margin-right-4px',
                iconClass: 'fa fa-trash fa-light',
                visible: this.schedulePermissions.includes(PERMISSION.DELETE)
            }];
    }
    rowSelectionChanged(event) {
        this.selectedRows = event;
    }
    deleteSelected() {
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            length: this.selectedRows.length,
            entityName: 'Schedule(s)'
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.id);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid));
            });
            return forkJoin(observables$);
        })).subscribe(() => {
            this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                length: this.selectedRows.length,
                entityName: 'Schedule(s)'
            }), 'Success');
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.gridApi.refreshServerSide();
        });
    }
    static { this.ɵfac = function ScheduleListComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleListComponent)(i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i2.GridDataSourceService), i0.ɵɵdirectiveInject(i1.ModalService), i0.ɵɵdirectiveInject(i1.ApiService), i0.ɵɵdirectiveInject(i3.TranslocoService), i0.ɵɵdirectiveInject(i4.ToastrService), i0.ɵɵdirectiveInject(i5.NgbOffcanvas), i0.ɵɵdirectiveInject(i1.PermissionService), i0.ɵɵdirectiveInject(i1.LicenseService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ScheduleListComponent, selectors: [["xf-schedule-list"]], inputs: { gridConfig: "gridConfig", customColumnDefs: "customColumnDefs" }, decls: 10, vars: 5, consts: [[1, "align-items-center", "schedule-list-header", "d-flex", "justify-content-between", "padding-bottom-12px", "padding-left-16px", "padding-right-16px", "padding-top-12px", "ms-3", "me-3"], [1, "page-header-font", "margin-bottom-4px"], [1, "page-subheader-font"], ["class", "d-flex", 4, "ngIf"], [1, "m-3"], [3, "rowSelectionChanged", "dataSource", "gridConfig", "customColumnDefs", "suppressContextMenu"], [1, "d-flex"], ["id", "create-schedule-btn", "type", "button", "ngbTooltip", "Create Schedule", 1, "btn", "btn-sm", "btn-primary", "margin-right-8px", 3, "click"], ["aria-hidden", "true", 1, "fa", "fa-add", "margin-right-4px"]], template: function ScheduleListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "div")(3, "h3", 1);
            i0.ɵɵtext(4, "Schedules");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "h5", 2);
            i0.ɵɵtext(6, "Utilize the Schedules module to set up and manage schedules for running playbooks at regular intervals");
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(7, ScheduleListComponent_div_7_Template, 4, 0, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 4)(9, "xf-grid", 5);
            i0.ɵɵlistener("rowSelectionChanged", function ScheduleListComponent_Template_xf_grid_rowSelectionChanged_9_listener($event) { return ctx.rowSelectionChanged($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.CREATE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("dataSource", ctx.dataSource)("gridConfig", ctx.gridConfig)("customColumnDefs", ctx.customColumnDefs)("suppressContextMenu", true);
        } }, dependencies: [i6.NgIf, i2.GridComponent], styles: [".schedule-list-header[_ngcontent-%COMP%]{background:var(--element-default-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleListComponent, [{
        type: Component,
        args: [{ selector: 'xf-schedule-list', changeDetection: ChangeDetectionStrategy.Default, template: "<div>\n    <div\n        class=\"align-items-center schedule-list-header d-flex justify-content-between padding-bottom-12px padding-left-16px padding-right-16px padding-top-12px ms-3 me-3\">\n        <div>\n            <h3 class=\"page-header-font margin-bottom-4px\">Schedules</h3>\n            <h5 class=\"page-subheader-font\">Utilize the Schedules module to set up and manage schedules for running playbooks at regular intervals</h5>\n        </div>\n        <!-- <input type=\"text\" class=\"ms-auto margin-right-8px w-350px form-control form-control-sm\" name=\"search-schedule\"\n            id=\"search-schedule\" placeholder=\"Search by Name, Tags, Commands etc\" /> -->\n        <div class=\"d-flex\" *ngIf=\"schedulePermissions.includes(permission.CREATE)\">\n            <button class=\"btn btn-sm btn-primary margin-right-8px\" id=\"create-schedule-btn\" type=\"button\"\n                (click)=\"createSchedule()\" ngbTooltip=\"Create Schedule\">\n                <i class=\"fa fa-add margin-right-4px\" aria-hidden=\"true\"></i>Create Schedule\n            </button>\n        </div>\n    </div>\n    <div class=\"m-3\">\n        <xf-grid [dataSource]=\"dataSource\" [gridConfig]=\"gridConfig\" [customColumnDefs]=\"customColumnDefs\"\n    [suppressContextMenu]=\"true\" (rowSelectionChanged)=\"rowSelectionChanged($event)\"></xf-grid>\n    </div>\n</div>\n", styles: [".schedule-list-header{background:var(--element-default-bg-color)}\n"] }]
    }], () => [{ type: i1.EntityService }, { type: i2.GridDataSourceService }, { type: i1.ModalService }, { type: i1.ApiService }, { type: i3.TranslocoService }, { type: i4.ToastrService }, { type: i5.NgbOffcanvas }, { type: i1.PermissionService }, { type: i1.LicenseService }], { gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ScheduleListComponent, { className: "ScheduleListComponent", filePath: "src/schedule-list/schedule-list.component.ts", lineNumber: 20 }); })();
//# sourceMappingURL=data:application/json;base64,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