import { v4 as uuidv4 } from 'uuid';
import { WidgetConfig } from "./widget-config";
export class ViewLayoutItem {
    constructor(type) {
        this.type = type;
        this.id = uuidv4();
    }
}
(function (ViewLayoutItem) {
    class Container extends ViewLayoutItem {
        constructor(contents) {
            super(Types.CONTAINER);
            this.contents = contents;
        }
    }
    ViewLayoutItem.Container = Container;
    class Tabs extends ViewLayoutItem {
        constructor(contents) {
            super(Types.TABS);
            this.contents = contents;
        }
    }
    ViewLayoutItem.Tabs = Tabs;
    class Tab extends ViewLayoutItem {
        constructor(name, contents) {
            super(Types.TAB);
            this.name = name;
            this.contents = contents;
        }
    }
    ViewLayoutItem.Tab = Tab;
    class Widget extends ViewLayoutItem {
        constructor(config) {
            super(Types.WIDGET);
            this.config = config;
            this.count = 0;
            if (this.config instanceof WidgetConfig) {
                this.rows = this.config.defaultHeight;
            }
        }
    }
    ViewLayoutItem.Widget = Widget;
    let Types;
    (function (Types) {
        Types["WIDGET"] = "widget";
        Types["TABS"] = "tabs";
        Types["TAB"] = "tab";
        Types["CONTAINER"] = "container";
    })(Types = ViewLayoutItem.Types || (ViewLayoutItem.Types = {}));
})(ViewLayoutItem || (ViewLayoutItem = {}));
//# sourceMappingURL=data:application/json;base64,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