import { ChangeDetectionStrategy, Component, Input } from '@angular/core';
import { cloneDeep, isString } from 'lodash-es';
import { map, of } from 'rxjs';
import { AddWidgetComponent } from '../add-widget/add-widget.component';
import { AbstractLayoutItemComponent } from '../../view-template/layout-item/abstract-layout-item.component';
import { ViewLayoutItem } from '../../models/view-layout-item';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "@ng-bootstrap/ng-bootstrap";
import * as i3 from "shared";
import * as i4 from "../../widgets/widget.service";
import * as i5 from "../view-template.service";
import * as i6 from "@angular/common/http";
const _c0 = a0 => ({ "headless": a0 });
function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "xf-widget", 6);
    i0.ɵɵlistener("edit", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_edit_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.editWidget($event, widgetIndex_r2)); })("delete", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_delete_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.deleteWidget($event, widgetIndex_r2)); })("clone", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_clone_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.cloneWidget($event, widgetIndex_r2)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const content_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("config", content_r4.config)("context", ctx_r2.context)("mode", ctx_r2.mode)("showLayoutControls", true)("updateHeight", ctx_r2.onUpdateGridsterHeight)("widgetId", content_r4.id);
} }
function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-layout-item", 7);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const content_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("context", ctx_r2.context)("layoutItem", content_r4)("viewTemplate", ctx_r2.viewTemplate)("mode", ctx_r2.mode)("widgetSelection$", ctx_r2.widgetSelection$);
} }
function ContainerLayoutComponent_ng_container_3_gridster_item_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "gridster-item", 5);
    i0.ɵɵtemplate(1, ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template, 2, 6, "ng-container", 3)(2, ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_2_Template, 2, 5, "ng-container", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const content_r4 = ctx.$implicit;
    i0.ɵɵproperty("item", content_r4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", content_r4.type === "widget");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", content_r4.type === "tabs");
} }
function ContainerLayoutComponent_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ContainerLayoutComponent_ng_container_3_gridster_item_1_Template, 3, 3, "gridster-item", 4);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.layoutItem.contents);
} }
export class ContainerLayoutComponent extends AbstractLayoutItemComponent {
    constructor(route, changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService, http) {
        super(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService);
        this.route = route;
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.http = http;
        this.displayHeader = true;
        this.inputs = this.route.snapshot.queryParamMap.get('inputs') || undefined;
        // this.context$ = new BehaviorSubject<ViewTemplateContext>(new ViewTemplateContext(undefined, undefined, this.inputs));
    }
    editWidget(widgetConfig, widgetIndex) {
        this.layoutItem.contents[widgetIndex].config = widgetConfig;
        this.layoutItemChange.emit(this.layoutItem);
    }
    cloneWidget(widgetConfig, widgetIndex) {
        let clonedWidgetConfig = cloneDeep(widgetConfig);
        if (isString(clonedWidgetConfig)) {
            this.http.get(clonedWidgetConfig).subscribe((widgetConfig) => {
                delete widgetConfig.uuid;
                let widget = new ViewLayoutItem.Widget(widgetConfig);
                this.layoutItem.contents.splice(widgetIndex, 0, widget);
                this.layoutItemChange.emit(this.layoutItem);
            });
        }
        else {
            delete clonedWidgetConfig.uuid;
            let widget = new ViewLayoutItem.Widget(clonedWidgetConfig);
            this.layoutItem.contents.splice(widgetIndex, 0, widget);
            this.layoutItemChange.emit(this.layoutItem);
        }
    }
    deleteWidget(widgetConfig, widgetIndex) {
        this.layoutItem.contents.splice(widgetIndex, 1);
        this.layoutItemChange.emit(this.layoutItem);
    }
    allowDrop(ev) {
        ev.preventDefault();
    }
    getWidgetConfig(widget) {
        let widgetType$;
        if (widget.remote && widget.className) {
            widgetType$ = this.widgetService.getRemoteConfig(widget);
        }
        else {
            widgetType$ = of(this.widgetService.builtInWidgetConfigs[widget?.name || '']);
        }
        return widgetType$.pipe(map((widgetType) => {
            let widgetConfig = new widgetType('', {});
            widgetConfig.type = widget?.name || '';
            widgetConfig.isNew = true;
            return widgetConfig;
        }));
    }
    onDropWidget(ev) {
        if (ev.srcElement.id === this.layoutItem.id) {
            if (this.selectedWidget.type === 'widget') {
                this.getWidgetConfig(this.selectedWidget).subscribe((widgetConfig) => {
                    let modalRef = this.ngbModalService.open(AddWidgetComponent, {
                        backdrop: 'static',
                        windowClass: 'modal-xlarge'
                    });
                    modalRef.componentInstance.widgetConfig = widgetConfig;
                    modalRef.componentInstance.context = this.context;
                    modalRef.closed.subscribe((widgetConfig) => {
                        widgetConfig.viewTemplate = this.viewTemplate?.uuid;
                        let widgetCopy = new ViewLayoutItem.Widget(widgetConfig);
                        widgetCopy.rows = widgetConfig.defaultHeight;
                        this.layoutItem?.contents.push(widgetCopy);
                        this.changeDetectorRef.detectChanges();
                    });
                });
            }
            else if (this.selectedWidget.type === 'tabs') {
                let widgetAdd = cloneDeep(this.selectedWidget);
                this.layoutItem?.contents.push(widgetAdd);
                this.changeDetectorRef.detectChanges();
            }
        }
    }
    static { this.ɵfac = function ContainerLayoutComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ContainerLayoutComponent)(i0.ɵɵdirectiveInject(i1.ActivatedRoute), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.NgbModal), i0.ɵɵdirectiveInject(i3.EntityService), i0.ɵɵdirectiveInject(i4.WidgetService), i0.ɵɵdirectiveInject(i3.UtilityService), i0.ɵɵdirectiveInject(i5.ViewTemplateService), i0.ɵɵdirectiveInject(i6.HttpClient)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ContainerLayoutComponent, selectors: [["xf-container"]], inputs: { displayHeader: "displayHeader" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 8, consts: [[1, "template-container", 3, "ngClass"], [1, "container-content"], [1, "gridster-layout", 3, "drop", "dragover", "options", "id"], [4, "ngIf"], ["class", "gridster-item", 3, "item", 4, "ngFor", "ngForOf"], [1, "gridster-item", 3, "item"], [3, "edit", "delete", "clone", "config", "context", "mode", "showLayoutControls", "updateHeight", "widgetId"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"]], template: function ContainerLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "gridster", 2);
            i0.ɵɵlistener("drop", function ContainerLayoutComponent_Template_gridster_drop_2_listener($event) { return ctx.onDropWidget($event); })("dragover", function ContainerLayoutComponent_Template_gridster_dragover_2_listener($event) { return ctx.allowDrop($event); });
            i0.ɵɵtemplate(3, ContainerLayoutComponent_ng_container_3_Template, 2, 1, "ng-container", 3);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c0, !ctx.displayHeader));
            i0.ɵɵadvance();
            i0.ɵɵstyleProp("height", ctx.gridsterHeight, "px");
            i0.ɵɵadvance();
            i0.ɵɵpropertyInterpolate("id", ctx.layoutItem.id);
            i0.ɵɵproperty("options", ctx.gridsterConfig);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.layoutItem && ctx.layoutItem.contents.length > 0);
        } }, styles: [".template-container[_ngcontent-%COMP%]{background:var(--template-container-bg-color);padding:0}.template-container.headless[_ngcontent-%COMP%]{margin:0}.template-container[_ngcontent-%COMP%]   .container-name[_ngcontent-%COMP%]{border-bottom:1px solid var(--element-secondary-border-color);height:40px}.template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   grdister[_ngcontent-%COMP%]   .moobile[_ngcontent-%COMP%]{overflow-y:unset;overflow-x:unset}.template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%], .template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%]   .gridster-item[_ngcontent-%COMP%]{background:inherit}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ContainerLayoutComponent, [{
        type: Component,
        args: [{ selector: 'xf-container', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"template-container\" [ngClass]=\"{'headless': !displayHeader}\">\n  <div class=\"container-content\" [style.height.px]=\"gridsterHeight\">\n    <!-- Make a directive or component -->\n\n    <gridster [options]=\"gridsterConfig\" (drop)=\"onDropWidget($event)\" (dragover)=\"allowDrop($event)\"\n      class=\"gridster-layout\" id=\"{{layoutItem.id}}\">\n      <ng-container *ngIf=\"layoutItem && layoutItem.contents.length > 0\">\n\n        <gridster-item class=\"gridster-item\" [item]=\"content\" *ngFor=\"let content of layoutItem.contents; let widgetIndex = index\">\n          <ng-container *ngIf=\"content.type === 'widget'\">\n            <xf-widget [config]=\"content.config\" [context]=\"context\" [mode]=\"mode\" [showLayoutControls]=\"true\"\n              (edit)=\"editWidget($event, widgetIndex)\" (delete)=\"deleteWidget($event, widgetIndex)\"\n              (clone)=\"cloneWidget($event, widgetIndex)\" [updateHeight]=\"onUpdateGridsterHeight\" [widgetId]=\"content.id\">\n            </xf-widget>\n          </ng-container>\n          <ng-container *ngIf=\"content.type === 'tabs'\">\n            <xf-layout-item [context]=\"context\" [layoutItem]=\"content\" [viewTemplate]=\"viewTemplate\" [mode]=\"mode\"\n              [widgetSelection$]=\"widgetSelection$\"></xf-layout-item>\n          </ng-container>\n\n\n        </gridster-item>\n      </ng-container>\n\n    </gridster>\n\n\n  </div>\n\n</div>\n", styles: [".template-container{background:var(--template-container-bg-color);padding:0}.template-container.headless{margin:0}.template-container .container-name{border-bottom:1px solid var(--element-secondary-border-color);height:40px}.template-container .container-content grdister .moobile{overflow-y:unset;overflow-x:unset}.template-container .container-content .gridster-layout,.template-container .container-content .gridster-layout .gridster-item{background:inherit}\n"] }]
    }], () => [{ type: i1.ActivatedRoute }, { type: i0.ChangeDetectorRef }, { type: i2.NgbModal }, { type: i3.EntityService }, { type: i4.WidgetService }, { type: i3.UtilityService }, { type: i5.ViewTemplateService }, { type: i6.HttpClient }], { displayHeader: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ContainerLayoutComponent, { className: "ContainerLayoutComponent", filePath: "src/view-template/container-layout/container-layout.component.ts", lineNumber: 24 }); })();
//# sourceMappingURL=data:application/json;base64,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