import { ChangeDetectionStrategy, Component, ViewChild } from '@angular/core';
import { CompactType, GridType } from 'angular-gridster2';
import { ViewLayoutItem } from '../../models/view-layout-item';
import { ContainerLayoutComponent } from '../container-layout/container-layout.component';
import { TabLayoutComponent } from '../tab-layout/tab-layout.component';
import { TabsLayoutComponent } from '../tabs-layout/tabs-layout.component';
import { WidgetsViewLayoutComponent } from '../widgets-view-layout/widgets-view-layout.component';
import { AbstractLayoutItemComponent } from './abstract-layout-item.component';
import { ViewContainerDirective } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "shared";
function LayoutItemComponent_ng_template_0_Template(rf, ctx) { }
export class LayoutItemComponent extends AbstractLayoutItemComponent {
    constructor() {
        super(...arguments);
        this.components = {
            [ViewLayoutItem.Types.WIDGET]: WidgetsViewLayoutComponent,
            [ViewLayoutItem.Types.CONTAINER]: ContainerLayoutComponent,
            [ViewLayoutItem.Types.TABS]: TabsLayoutComponent,
            [ViewLayoutItem.Types.TAB]: TabLayoutComponent
        };
    }
    ngOnInit() {
        this.createComponent();
    }
    findGridItem(itemId) {
        let itemFound;
        this.layoutItem.contents.forEach((item) => {
            if (item.id === itemId) {
                itemFound = item;
            }
        });
        return itemFound;
    }
    createComponent() {
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.components[this.layoutItem.type]);
        this.componentRef.instance.layoutItem = this.layoutItem;
        this.componentRef.instance.layoutItemChange = this.layoutItemChange;
        this.componentRef.instance.viewTemplate = this.viewTemplate;
        this.componentRef.instance.context = this.context;
        this.componentRef.instance.mode = this.mode;
        this.componentRef.instance.widgetSelection$ = this.widgetSelection$;
        this.componentRef.instance.onUpdateGridsterHeight = this.onUpdateGridsterHeight;
        this.componentRef.instance.gridsterConfig = this.getGridsterConfig(this.mode);
        this.componentRef.instance.onUpdateGridsterHeight.subscribe((data) => {
            let itemComponent = this.componentRef.instance.gridsterConfig.api?.getItemComponent(this.findGridItem(data.id));
            itemComponent.item.rows = data.height;
            itemComponent.resize.setItemHeight(data.height * this.fixedGridItemHeight);
            this.updateGridsterHeight();
        });
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    //TODO:- Re-Visit the logic
    ngOnChanges(changes) {
        let update = false;
        if (this.componentRef && changes.mode && changes.mode.currentValue && changes.mode.previousValue && changes.mode.currentValue !== changes.mode.previousValue) {
            update = true;
        }
        else if (this.componentRef && changes.layoutItem && changes.layoutItem.currentValue !== changes.layoutItem.previousValue) {
            update = true;
        }
        if (update) {
            this.componentRef.instance.mode = this.mode;
            this.componentRef.instance.gridsterConfig = this.getGridsterConfig(this.mode);
            this.componentRef.instance.layoutItem = this.layoutItem;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    getGridsterConfig(mode) {
        let gridsterConfig = {
            gridType: GridType.VerticalFixed,
            compactType: CompactType.None,
            pushItems: true,
            maxRows: undefined,
            fixedRowHeight: this.fixedGridItemHeight,
            enableEmptyCellDrop: mode !== 'view' ? true : false,
            enableEmptyCellDrag: mode !== 'view' ? true : false,
            draggable: {
                enabled: mode !== 'view' ? true : false
            },
            resizable: {
                enabled: mode !== 'view' ? true : false
            },
            itemChangeCallback: this.updateGridsterHeight.bind(this),
            itemResizeCallback: this.updateGridsterHeight.bind(this),
            itemInitCallback: this.updateGridsterHeight.bind(this)
        };
        return gridsterConfig;
    }
    updateGridsterHeight() {
        let height = 0;
        let margin = 100;
        this.layoutItem.contents.forEach((item) => {
            height += item.rows * this.fixedGridItemHeight;
        });
        this.gridsterHeight = height + margin;
        this.componentRef.instance.gridsterHeight = this.gridsterHeight;
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵLayoutItemComponent_BaseFactory; return function LayoutItemComponent_Factory(__ngFactoryType__) { return (ɵLayoutItemComponent_BaseFactory || (ɵLayoutItemComponent_BaseFactory = i0.ɵɵgetInheritedFactory(LayoutItemComponent)))(__ngFactoryType__ || LayoutItemComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LayoutItemComponent, selectors: [["xf-layout-item"]], viewQuery: function LayoutItemComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature, i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function LayoutItemComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LayoutItemComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [i1.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LayoutItemComponent, [{
        type: Component,
        args: [{ selector: 'xf-layout-item', changeDetection: ChangeDetectionStrategy.OnPush, template: "<ng-template xfViewContainer></ng-template>" }]
    }], null, { viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LayoutItemComponent, { className: "LayoutItemComponent", filePath: "src/view-template/layout-item/layout-item.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,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