import { Component, EventEmitter, Input, Output } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { FieldOptions, TextField } from 'shared';
import { ViewLayoutItem } from '../models/view-layout-item';
import { Widget } from '../models/widget';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "shared";
import * as i3 from "@angular/router";
import * as i4 from "./view-template.service";
import * as i5 from "@angular/common";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
import * as i7 from "./layout-item/layout-item.component";
import * as i8 from "./widget-library/widget-library.component";
function ViewTemplateComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 3);
    i0.ɵɵelementStart(1, "div", 4)(2, "div", 5)(3, "label", 6);
    i0.ɵɵtext(4, "Title");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(5, "xf-form-field", 7);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.viewTemplateForm);
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("field", ctx_r0.titleField)("fieldOptions", ctx_r0.titleFieldOptions);
} }
function ViewTemplateComponent_div_1_xf_layout_item_2_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-layout-item", 13);
    i0.ɵɵlistener("layoutItemChange", function ViewTemplateComponent_div_1_xf_layout_item_2_Template_xf_layout_item_layoutItemChange_0_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.onLayoutItemChange($event)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const container_r3 = ctx.$implicit;
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("context", ctx_r0.context)("layoutItem", container_r3)("viewTemplate", ctx_r0.viewTemplate)("mode", ctx_r0.mode)("widgetSelection$", ctx_r0.widgetSelection$);
} }
function ViewTemplateComponent_div_1_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14)(1, "button", 15);
    i0.ɵɵlistener("click", function ViewTemplateComponent_div_1_div_3_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.addContainer()); });
    i0.ɵɵtext(2, "+ Add Container");
    i0.ɵɵelementEnd()();
} }
function ViewTemplateComponent_div_1_xf_widget_library_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-widget-library", 16);
    i0.ɵɵlistener("widgetCollapsible", function ViewTemplateComponent_div_1_xf_widget_library_4_Template_xf_widget_library_widgetCollapsible_0_listener($event) { i0.ɵɵrestoreView(_r5); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.widgetLibraryCollapsible($event)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("widgetSelection$", ctx_r0.widgetSelection$);
} }
function ViewTemplateComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8)(1, "div", 9);
    i0.ɵɵtemplate(2, ViewTemplateComponent_div_1_xf_layout_item_2_Template, 1, 5, "xf-layout-item", 10)(3, ViewTemplateComponent_div_1_div_3_Template, 3, 0, "div", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(4, ViewTemplateComponent_div_1_xf_widget_library_4_Template, 1, 1, "xf-widget-library", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", ctx_r0.getWidth());
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r0.viewTemplate.layout);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.mode !== "view");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.mode !== "view");
} }
function ViewTemplateComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 17)(1, "ngb-alert", 18);
    i0.ɵɵtext(2, " View template not found. ");
    i0.ɵɵelementStart(3, "button", 19);
    i0.ɵɵlistener("click", function ViewTemplateComponent_div_2_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r6); const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.newViewTemplate()); });
    i0.ɵɵtext(4, "Create one");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    i0.ɵɵadvance();
    i0.ɵɵproperty("dismissible", false);
} }
export class ViewTemplateComponent {
    constructor(rootFormGroup, utilityService, changeDetectorRef, route, viewTemplateService, spinnerService, modalService, router) {
        this.rootFormGroup = rootFormGroup;
        this.utilityService = utilityService;
        this.changeDetectorRef = changeDetectorRef;
        this.route = route;
        this.viewTemplateService = viewTemplateService;
        this.spinnerService = spinnerService;
        this.modalService = modalService;
        this.router = router;
        this.openedInPreview = false;
        this.loading = true;
        this.onAddViewTemplate = new EventEmitter();
        this.navigationCollapsed = false;
        this.widgetLibraryCollapsed = false;
        this.titleFieldOptions = new FieldOptions({
            showLabel: false,
            customErrorMessages: {
                unique: 'A view template with this title already exists'
            }
        });
        this.params = {};
        this.titleField = new TextField('viewTemplateTitle');
        this.titleField.title = 'Title';
        this.titleField.validation.required = true;
        this.widgetSelection$ = new BehaviorSubject(new Widget('', ''));
    }
    ngOnInit() {
        this.viewTemplateForm = this.rootFormGroup.control;
        this.viewTemplateForm?.controls.viewTemplateTitle.setValue(this.viewTemplate?.title);
        this.viewTemplateForm?.controls.viewTemplateTitle.valueChanges.subscribe((title) => this.viewTemplate ? this.viewTemplate.title = title : null);
        if (this.recordId) {
            this.params.recordId = this.recordId;
        }
        this.utilityService.navigationChanged.subscribe((value) => {
            this.navigationCollapsed = value;
            this.changeDetectorRef.detectChanges();
        });
    }
    onLayoutItemChange(layoutItem) {
        if (!this.viewTemplate) {
            return;
        }
        this.viewTemplate.layout.map((l) => l.id != layoutItem.id ? l : layoutItem);
        this.changeDetectorRef.detectChanges();
    }
    setSelectedWidget(widget) {
        this.selectedWidget = widget;
        this.changeDetectorRef.detectChanges();
    }
    widgetLibraryCollapsible(value) {
        // make use of the replay subject in viewTemplateService
        this.widgetLibraryCollapsed = value;
        this.changeDetectorRef.detectChanges();
    }
    addContainer() {
        let containerLayout = new ViewLayoutItem.Container([]);
        this.viewTemplate?.layout.push(containerLayout);
    }
    getWidth() {
        switch (this.mode) {
            case 'edit':
            case 'new': {
                if (this.widgetLibraryCollapsed && this.navigationCollapsed) {
                    return 'all-collapsed';
                }
                else if (this.navigationCollapsed && !this.widgetLibraryCollapsed) {
                    return 'navigation-collapsed';
                }
                else if (this.widgetLibraryCollapsed && !this.navigationCollapsed) {
                    return 'widget-library-collapsed';
                }
                else if (!this.widgetLibraryCollapsed && !this.navigationCollapsed) {
                    return 'none-collapsed';
                }
                else {
                    return 'none-collapsed';
                }
                break;
            }
            case 'view': {
                if (this.navigationCollapsed) {
                    return 'all-collapsed-view-mode';
                }
                else {
                    return 'widget-library-collapsed-view-mode';
                }
            }
            default: {
                return 'widget-library-collapsed-view-mode';
            }
        }
    }
    onWidgetDrop(event) {
        console.log(this.selectedWidget);
    }
    newViewTemplate() {
        this.params.mode = 'new';
        this.onAddViewTemplate.emit();
    }
    static { this.ɵfac = function ViewTemplateComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateComponent)(i0.ɵɵdirectiveInject(i1.FormGroupDirective), i0.ɵɵdirectiveInject(i2.UtilityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.ActivatedRoute), i0.ɵɵdirectiveInject(i4.ViewTemplateService), i0.ɵɵdirectiveInject(i2.SpinnerService), i0.ɵɵdirectiveInject(i2.ModalService), i0.ɵɵdirectiveInject(i3.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ViewTemplateComponent, selectors: [["xf-view-template"]], inputs: { mode: "mode", uuid: "uuid", recordId: "recordId", viewTemplate: "viewTemplate", context: "context", openedInPreview: "openedInPreview", loading: "loading" }, outputs: { onAddViewTemplate: "onAddViewTemplate" }, decls: 3, vars: 3, consts: [[3, "formGroup", 4, "ngIf"], ["class", "d-flex", "cdkDropListGroup", "", 4, "ngIf"], ["class", "d-inline-flex p-2", 4, "ngIf"], [3, "formGroup"], [1, "row", "m-3", "pb-2", "border-bottom-primary"], [1, "col-xl-4", "col-lg-6", "col-md-12", "d-flex"], ["for", "viewTemplateTitle", 1, "form-label", "me-2", "mb-0", "align-self-center"], ["formControlName", "viewTemplateTitle", 3, "field", "fieldOptions"], ["cdkDropListGroup", "", 1, "d-flex"], [1, "view-template", 3, "ngClass"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$", "layoutItemChange", 4, "ngFor", "ngForOf"], ["class", "m-2", 4, "ngIf"], [3, "widgetSelection$", "widgetCollapsible", 4, "ngIf"], [3, "layoutItemChange", "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"], [1, "m-2"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "float-start", 3, "click"], [3, "widgetCollapsible", "widgetSelection$"], [1, "d-inline-flex", "p-2"], [3, "dismissible"], ["type", "button", 1, "btn", "btn-link", 3, "click"]], template: function ViewTemplateComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ViewTemplateComponent_ng_container_0_Template, 6, 3, "ng-container", 0)(1, ViewTemplateComponent_div_1_Template, 5, 4, "div", 1)(2, ViewTemplateComponent_div_2_Template, 5, 1, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.viewTemplateForm && (ctx.mode === "edit" || ctx.mode === "new"));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.viewTemplate && ctx.viewTemplate.layout);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.loading && !ctx.viewTemplate);
        } }, dependencies: [i5.NgClass, i5.NgForOf, i5.NgIf, i6.NgbAlert, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, i2.FormFieldComponent, i7.LayoutItemComponent, i8.WidgetLibraryComponent], styles: [".view-template[_ngcontent-%COMP%]{width:calc(60vw - 58px);display:flex;flex-direction:column}.view-template.all-collapsed[_ngcontent-%COMP%]{width:calc(100vw - 100px)}.view-template.all-collapsed-view-mode[_ngcontent-%COMP%]{width:100vw}.view-template.navigation-collapsed[_ngcontent-%COMP%]{width:calc(75vw - 60px)}.view-template.widget-library-collapsed[_ngcontent-%COMP%]{width:calc(100vw - 60px)}.view-template.widget-library-collapsed-view-mode[_ngcontent-%COMP%]{width:100vw}.view-template.none-collapsed[_ngcontent-%COMP%]{width:calc(80vw - 90px)}.view-template[_ngcontent-%COMP%]   .data-toggle[_ngcontent-%COMP%]{width:inherit}.view-template[_ngcontent-%COMP%]   .template-containers[_ngcontent-%COMP%]{height:calc(100vh - 150px);max-width:calc(100vw - 10px)}.border-bottom-primary[_ngcontent-%COMP%]{border-bottom:2px solid var(--primary-tabs-default-border-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateComponent, [{
        type: Component,
        args: [{ selector: 'xf-view-template', template: "<ng-container [formGroup]=\"viewTemplateForm\" *ngIf=\"viewTemplateForm && (mode === 'edit' || mode === 'new')\">\n  <div class=\"row m-3 pb-2 border-bottom-primary\">\n    <div class=\"col-xl-4 col-lg-6 col-md-12 d-flex\">\n      <label for=\"viewTemplateTitle\" class=\"form-label me-2 mb-0 align-self-center\">Title</label>\n      <xf-form-field [field]=\"titleField\" formControlName=\"viewTemplateTitle\" [fieldOptions]=\"titleFieldOptions\">\n      </xf-form-field>\n    </div>\n  </div>\n</ng-container>\n\n<div class=\"d-flex\" *ngIf=\"viewTemplate && viewTemplate.layout\" cdkDropListGroup>\n  <div class=\"view-template\" [ngClass]=\"getWidth()\">\n    <!-- Show Data Toggle -->\n    <!-- <div class=\"col-md-12 data-toggle\" *ngIf=\"mode !== 'view'\">\n      <div class=\"form-switch float-end w-150px\">\n        <input class=\"form-check-input float-none\" type=\"checkbox\">\n        <label class=\"align-top font-size-14px form-check-label margin-left-6px\">Show Data</label>\n      </div>\n    </div> -->\n    <xf-layout-item *ngFor=\"let container of viewTemplate.layout\" [context]=\"context\" [layoutItem]=\"container\"\n      [viewTemplate]=\"viewTemplate\" [mode]=\"mode\" [widgetSelection$]=\"widgetSelection$\"\n      (layoutItemChange)=\"onLayoutItemChange($event)\"></xf-layout-item>\n    <!-- Add Container -->\n    <div class=\"col-md-12\" class=\"m-2\" *ngIf=\"mode !== 'view'\">\n      <button type=\"button\" class=\"btn btn-primary btn-sm float-start\" (click)=\"addContainer()\">+ Add\n        Container</button>\n    </div>\n\n  </div>\n  <xf-widget-library (widgetCollapsible)=\"widgetLibraryCollapsible($event)\" [widgetSelection$]=\"widgetSelection$\"\n    *ngIf=\"mode !== 'view'\"></xf-widget-library>\n</div>\n<div *ngIf=\"!loading && !viewTemplate\" class=\"d-inline-flex p-2\">\n  <ngb-alert [dismissible]=\"false\">\n    View template not found. <button class=\"btn btn-link\" type=\"button\" (click)=\"newViewTemplate()\">Create\n      one</button>\n  </ngb-alert>\n</div>", styles: [".view-template{width:calc(60vw - 58px);display:flex;flex-direction:column}.view-template.all-collapsed{width:calc(100vw - 100px)}.view-template.all-collapsed-view-mode{width:100vw}.view-template.navigation-collapsed{width:calc(75vw - 60px)}.view-template.widget-library-collapsed{width:calc(100vw - 60px)}.view-template.widget-library-collapsed-view-mode{width:100vw}.view-template.none-collapsed{width:calc(80vw - 90px)}.view-template .data-toggle{width:inherit}.view-template .template-containers{height:calc(100vh - 150px);max-width:calc(100vw - 10px)}.border-bottom-primary{border-bottom:2px solid var(--primary-tabs-default-border-color)}\n"] }]
    }], () => [{ type: i1.FormGroupDirective }, { type: i2.UtilityService }, { type: i0.ChangeDetectorRef }, { type: i3.ActivatedRoute }, { type: i4.ViewTemplateService }, { type: i2.SpinnerService }, { type: i2.ModalService }, { type: i3.Router }], { mode: [{
            type: Input
        }], uuid: [{
            type: Input
        }], recordId: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], context: [{
            type: Input
        }], openedInPreview: [{
            type: Input
        }], loading: [{
            type: Input
        }], onAddViewTemplate: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ViewTemplateComponent, { className: "ViewTemplateComponent", filePath: "src/view-template/view-template.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,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