import { Injectable } from '@angular/core';
import { NavigationEnd } from '@angular/router';
import { plainToInstance } from 'class-transformer';
import { cloneDeep, concat, flatten, isString, last } from 'lodash-es';
import { ReplaySubject, forkJoin, of } from 'rxjs';
import { concatMap, filter, map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API, FIXED_MODULE } from "shared";
import { ViewLayoutItem } from '../models/view-layout-item';
import { ViewTemplate } from '../models/view-template';
import { WidgetConfig } from '../models/widget-config';
//TODO: Remove after backend API is ready
import { Entity } from "shared";
import { v4 as uuidv4 } from 'uuid';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "@angular/router";
import * as i3 from "shared";
export class ViewTemplateService {
    constructor(http, router, apiService, utilityService) {
        this.http = http;
        this.router = router;
        this.apiService = apiService;
        this.utilityService = utilityService;
        this.widgetLibraryChanged = new ReplaySubject(0);
        this.router.events
            .pipe(filter((e) => e instanceof NavigationEnd))
            .subscribe(() => {
            this.currentUrl = this.router.url;
        });
        // TODO: Add view template mmd
        this.viewTemplateEntity = new Entity(FIXED_MODULE.VIEW_TEMPLATES);
        this.viewTemplateEntity.baseUrl = API.API_APPMANAGER;
        this.widgetConfigEntity = new Entity(FIXED_MODULE.WIDGET_CONFIGS);
        this.widgetConfigEntity.baseUrl = API.API_APPMANAGER;
    }
    loadByUuid(uuid, includeWidgetConfigs = false) {
        let observable$;
        if (includeWidgetConfigs) {
            observable$ = this.apiService.query(this.widgetConfigEntity, {
                filters: [{
                        field: 'viewTemplate',
                        operator: 'eq',
                        value: uuid
                    }]
            }).pipe(map((response) => {
                return response['hydra:member'];
            }));
        }
        else {
            observable$ = of([]);
        }
        return observable$.pipe(concatMap((widgetConfigs) => {
            return this.apiService.getRecord(this.viewTemplateEntity, uuid, ViewTemplate).pipe(map((viewTemplate) => {
                viewTemplate.widgetConfigs = widgetConfigs;
                return plainToInstance(ViewTemplate, viewTemplate);
            }));
        }));
    }
    loadWithParams(filters) {
        return this.apiService.query(this.viewTemplateEntity, {
            filters: filters,
            limit: ALL_RECORDS_SIZE
        }).pipe(map((response) => {
            return response['hydra:member'];
        }));
    }
    //TODO:- Use when API is ready
    // public loadWithParams(params: any): Observable<ViewTemplate[]> {
    //   let filters = [];
    //   for (const k in params) {
    //     filters.push({
    //       field: k,
    //       operator: 'eq',
    //       value: params[k]
    //     });
    //   }
    //   // to do: use Query
    //   return this.http.post(API.QUERY + MMD.VIEW_TEMPLATES_KEY,
    //     {
    //       filters: filters,
    //       logic: 'AND',
    //       __selectFields: ['uuid', 'title']
    //     }
    //   )
    //     .pipe(
    //       map((response: any) => {
    //         return plainToInstance(ViewTemplate, response['hydra:member']);
    //       })
    //     );
    // }
    delete(uuid) {
        return this.apiService.deleteRecord(this.viewTemplateEntity, uuid);
    }
    save(viewTemplate) {
        let data = viewTemplate;
        let observable;
        let widgetConfigs = [];
        if (viewTemplate.layout) {
            widgetConfigs = flatten(viewTemplate.layout.map((item) => this.getNewWidgetConfigs(item)));
            data.widget_configs = widgetConfigs;
        }
        if (viewTemplate.uuid) {
            observable = this.apiService.updateRecord(this.viewTemplateEntity, viewTemplate.uuid, data);
        }
        else {
            observable = this.apiService.createRecord(this.viewTemplateEntity, data);
        }
        return observable.pipe(map((response) => {
            return plainToInstance(ViewTemplate, response);
        }), map((newViewTemplate) => {
            newViewTemplate.widgetConfigs = widgetConfigs;
            return newViewTemplate;
        }));
    }
    getNewWidgetConfigs(viewLayoutItem) {
        if (viewLayoutItem instanceof ViewLayoutItem.Widget || viewLayoutItem.type === ViewLayoutItem.Types.WIDGET) {
            let widget = viewLayoutItem;
            if (widget.config && typeof widget.config !== 'string') {
                widget.config.uuid = widget.config.uuid ?? uuidv4();
                const widgetConfig = cloneDeep(widget.config);
                widget.config = widget.config.uuid;
                return [widgetConfig];
            }
            else {
                return [widget.config];
            }
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Container || viewLayoutItem.type === ViewLayoutItem.Types.CONTAINER) {
            return flatten(concat(viewLayoutItem.contents.map((item) => this.getNewWidgetConfigs(item))));
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Tabs || viewLayoutItem.type === ViewLayoutItem.Types.TABS) {
            return flatten(concat(viewLayoutItem.contents.map((item) => this.getNewWidgetConfigs(item))));
        }
        return [];
    }
    navigateToView(params = {}, currentRoute) {
        this.router.navigate(['.'], {
            relativeTo: currentRoute,
            queryParams: params
        });
    }
    duplicate(uuid) {
        return this.loadByUuid(uuid, true).pipe(concatMap((viewTemplate) => {
            let newWidgetConfigs = viewTemplate.widgetConfigs;
            let uuidMap = {};
            newWidgetConfigs.forEach((widgetConfig) => {
                const newUuid = this.utilityService.generateUUID();
                widgetConfig.isNew = true;
                if (widgetConfig.uuid) {
                    uuidMap[widgetConfig.uuid] = newUuid;
                    widgetConfig.uuid = newUuid;
                }
            });
            viewTemplate.layout.forEach((layoutItem) => {
                this.updateLayoutWidgetUuids(layoutItem, uuidMap);
            });
            viewTemplate.title = 'Copy of ' + viewTemplate.title;
            delete viewTemplate.uuid;
            return this.apiService.createRecord(this.viewTemplateEntity, viewTemplate)
                .pipe(concatMap((newViewTemplate) => {
                let observables$ = [];
                newWidgetConfigs.forEach((widgetConfig) => {
                    widgetConfig.viewTemplate = newViewTemplate.uuid;
                    let newWidgetConfig$ = this.apiService.createRecord(this.widgetConfigEntity, widgetConfig);
                    observables$.push(newWidgetConfig$);
                });
                return forkJoin(observables$).pipe(map(() => newViewTemplate));
            }));
        }), map((response) => {
            return plainToInstance(ViewTemplate, response, {
                enableImplicitConversion: true
            });
        }));
    }
    updateLayoutWidgetUuids(viewLayoutItem, uuidMap) {
        if (viewLayoutItem instanceof ViewLayoutItem.Widget || viewLayoutItem.type === ViewLayoutItem.Types.WIDGET) {
            let widget = viewLayoutItem;
            if (widget.config instanceof WidgetConfig && widget.config.uuid) {
                widget.config.uuid = uuidMap[widget.config.uuid];
            }
            else if (isString(widget.config)) {
                const uuid = last(widget.config.split('/'));
                widget.config = uuid ? uuidMap[uuid] : widget.config;
            }
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Container || viewLayoutItem.type === ViewLayoutItem.Types.CONTAINER) {
            let container = viewLayoutItem;
            container.contents.forEach((item) => {
                this.updateLayoutWidgetUuids(item, uuidMap);
            });
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Tabs || viewLayoutItem.type === ViewLayoutItem.Types.TABS) {
            let tabs = viewLayoutItem;
            tabs.contents.forEach((tab) => {
                this.updateLayoutWidgetUuids(tab, uuidMap);
            });
        }
    }
    static { this.ɵfac = function ViewTemplateService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.Router), i0.ɵɵinject(i3.ApiService), i0.ɵɵinject(i3.UtilityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ViewTemplateService, factory: ViewTemplateService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.Router }, { type: i3.ApiService }, { type: i3.UtilityService }], null); })();
//# sourceMappingURL=data:application/json;base64,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