import { Component, Input } from '@angular/core';
import { isUndefined } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "shared";
export class AbstractWidgetEditComponent {
    constructor(changeDetectorRef, entityService, utilityService) {
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.utilityService = utilityService;
        this.items = [];
    }
    filterFields(search, fieldsAlreadyAdded, fieldsToFilter) {
        if (isUndefined(this.entity) && isUndefined(fieldsToFilter)) {
            return;
        }
        const fields = fieldsToFilter || this.entity.attributes;
        this.utilityService.filterFields(fields, search, fieldsAlreadyAdded).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function AbstractWidgetEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractWidgetEditComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractWidgetEditComponent, selectors: [["xf-abstract-widget-edit"]], inputs: { widgetConfig: "widgetConfig", context: "context" }, decls: 0, vars: 0, template: function AbstractWidgetEditComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractWidgetEditComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-widget-edit',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.EntityService }, { type: i1.UtilityService }], { widgetConfig: [{
            type: Input
        }], context: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractWidgetEditComponent, { className: "AbstractWidgetEditComponent", filePath: "src/widgets/abstract-widget-edit.component.ts", lineNumber: 15 }); })();
//# sourceMappingURL=data:application/json;base64,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