import { Injectable, inject } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import _, { extend } from 'lodash-es';
import { omit } from 'lodash-es';
import { from, of } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API, DynamicContent, FIXED_MODULE, HeaderService, StorageService } from "shared";
import builtInWidgetList from './built-in-widget-metadatas.json';
import { FieldGroupConfig } from './field-group/field-group-config';
import { PrimaryDetailConfig } from './primary-detail/primary-detail-config';
import { Widget } from '../models/widget';
import { loadRemoteModule } from '@angular-architects/native-federation';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class WidgetService {
    constructor(http) {
        this.http = http;
        this.builtInWidgetConfigs = {
            // 'grid': GridConfig,
            'field-group': FieldGroupConfig,
            'primary-detail': PrimaryDetailConfig
        };
        this.widgets = {};
        this.headerService = inject(HeaderService);
        this.localStorage = inject(StorageService);
        const widgets = plainToInstance(Widget, builtInWidgetList);
        this.builtInWidgets = _.keyBy(widgets, 'name');
    }
    loadWidget(name, force = false) {
        this.widgets = extend(this.widgets, this.builtInWidgets);
        if (!this.widgets[name] || force) {
            return this.loadWidgets(name).pipe(map(() => {
                return this.widgets[name];
            }));
        }
        return of(this.widgets[name]);
    }
    getWidgetById(widgets, id) {
        Object.keys(widgets).forEach((widget) => {
            if (widget.uuid === id) {
                return widget;
            }
        });
    }
    getWidget(name, version) {
        return this.http.get(`${API.API_APPMANAGER}contenthub/widget/${name}/${version}`);
    }
    loadDynamicContent(name, type) {
        return this.http.get(API.BASE + FIXED_MODULE.DYNAMIC_CONTENT, {
            params: {
                limit: ALL_RECORDS_SIZE,
                type: type,
                name: name
            }
        }).pipe(map((response) => {
            if (!response['hydra:member'].length) {
                return null;
            }
            return plainToInstance(DynamicContent, response['hydra:member'][0]);
        }));
    }
    loadWidgets(name) {
        return this.getWidget(name, null).pipe(map((response) => {
            const widgets = plainToInstance(Widget, response);
            this.widgets = _.keyBy(widgets, 'name');
            this.widgets = extend(this.widgets, this.builtInWidgets);
            return this.widgets;
        }));
    }
    getRemoteConfig(widget) {
        if (!widget.className) {
            return of();
        }
        const options = {
            remoteEntry: '/widgets/' + widget.name + '/remoteEntry.json',
            exposedModule: widget.exposedModule || './Config',
            className: widget.className
        };
        const component$ = from(loadRemoteModule(options));
        return component$.pipe(map((exposedModules) => {
            const widgetConfigType = exposedModules[options.className];
            return widgetConfigType;
        }));
    }
    castAsWidgetConfig(object, widget) {
        const foundType = this.builtInWidgetConfigs[object.type];
        const excludedKeys = ['@id', '@context'];
        object = omit(object, excludedKeys);
        if (foundType) {
            const instance = plainToInstance(foundType, object);
            return of(instance);
        }
        else {
            return this.getRemoteConfig(widget).pipe(map((widgetConfigType) => plainToInstance(widgetConfigType, object)));
        }
    }
    static { this.ɵfac = function WidgetService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: WidgetService, factory: WidgetService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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