import * as i0 from '@angular/core';
import { Injectable, inject, Component, ViewChildren, Input, ChangeDetectionStrategy, ViewChild, EventEmitter, Output, ViewContainerRef, Optional, NgModule } from '@angular/core';
import * as i3 from '@angular/forms';
import { Validators, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { ReplaySubject, of, forkJoin, concatMap as concatMap$1, map as map$1, tap, from, Subject, filter as filter$1, BehaviorSubject } from 'rxjs';
import * as i1$1 from 'shared';
import { Entity, FIXED_MODULE, API, ALL_RECORDS_SIZE, FormFieldComponent, Query, SearchableItem, FieldOptions, DynamicContent, HeaderService, StorageService, TextField, ViewContainerDirective, XFFormFieldsModule, SearchableDropdownModule, UtilityModule, BreadcrumbsComponent, ButtonGroupModule } from 'shared';
import { __decorate } from 'tslib';
import { Type, plainToInstance } from 'class-transformer';
import { v4 } from 'uuid';
import * as i1$2 from '@ng-bootstrap/ng-bootstrap';
import { NgbDropdownModule, NgbAlertModule, NgbNavModule } from '@ng-bootstrap/ng-bootstrap';
import * as i2 from '@angular/router';
import { NavigationEnd, RouterModule } from '@angular/router';
import _, { flatten, cloneDeep, concat, isString, last, isUndefined, findIndex, flattenDeep, isArray, extend, omit } from 'lodash-es';
import { filter, map, concatMap } from 'rxjs/operators';
import * as i1 from '@angular/common/http';
import * as i2$1 from '@angular/common';
import { CommonModule } from '@angular/common';
import * as i4 from 'ngx-drag-drop';
import { DndHandleDirective, DndDraggableDirective, DndModule } from 'ngx-drag-drop';
import * as i6 from '@jsverse/transloco';
import { TranslocoModule } from '@jsverse/transloco';
import { loadRemoteModule } from '@angular-architects/native-federation';
import { GridType, CompactType, GridsterComponent, GridsterItemComponent } from 'angular-gridster2';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';

class UniqueValidatorService {
    validate(strings) {
        return (control) => {
            if (strings.indexOf(control.value) > -1) {
                return { unique: true };
            }
            else {
                return null;
            }
            // return this.entityService.build(FIXED_MODULE.VIEW_TEMPLATES).pipe(
            //   concatMap((viewTemplateEntity: Entity) => {
            //     let findResult$ = this.apiService.query(viewTemplateEntity, {
            //       fields: ['uuid'],
            //       filters: [{
            //         field: 'title',
            //         operator: 'eq',
            //         value: control.value
            //       }]
            //     });
            //     return findResult$.pipe(
            //       map((result: HydraResponse) => {
            //         if (result['hydra:totalItems'] > 0) {
            //           return { unique: true };
            //         }
            //         return null;
            //       })
            //     );
            //   })
            // );
        };
    }
    static { this.ɵfac = function UniqueValidatorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UniqueValidatorService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: UniqueValidatorService, factory: UniqueValidatorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UniqueValidatorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], null, null); })();

class WidgetConfig {
    constructor(title = '', configuration = {}) {
        this.showBorder = true;
        this.viewTemplate = null;
        this.isNew = false;
        this.defaultHeight = 5;
        this.title = title;
        this.type = 'unknown';
        this.configuration = configuration;
    }
}

class ViewLayoutItem {
    constructor(type) {
        this.type = type;
        this.id = v4();
    }
}
(function (ViewLayoutItem) {
    class Container extends ViewLayoutItem {
        constructor(contents) {
            super(Types.CONTAINER);
            this.contents = contents;
        }
    }
    ViewLayoutItem.Container = Container;
    class Tabs extends ViewLayoutItem {
        constructor(contents) {
            super(Types.TABS);
            this.contents = contents;
        }
    }
    ViewLayoutItem.Tabs = Tabs;
    class Tab extends ViewLayoutItem {
        constructor(name, contents) {
            super(Types.TAB);
            this.name = name;
            this.contents = contents;
        }
    }
    ViewLayoutItem.Tab = Tab;
    class Widget extends ViewLayoutItem {
        constructor(config) {
            super(Types.WIDGET);
            this.config = config;
            this.count = 0;
            if (this.config instanceof WidgetConfig) {
                this.rows = this.config.defaultHeight;
            }
        }
    }
    ViewLayoutItem.Widget = Widget;
    let Types;
    (function (Types) {
        Types["WIDGET"] = "widget";
        Types["TABS"] = "tabs";
        Types["TAB"] = "tab";
        Types["CONTAINER"] = "container";
    })(Types = ViewLayoutItem.Types || (ViewLayoutItem.Types = {}));
})(ViewLayoutItem || (ViewLayoutItem = {}));

class ViewTemplate {
    constructor(title, type) {
        this.title = title;
        this.type = type;
        this.layout = [];
        this.query = null;
        this.configuration = {};
        this.uuid = null;
        this.system = false;
    }
}
__decorate([
    Type(() => ViewLayoutItem, {
        discriminator: {
            property: 'type',
            subTypes: [
                { value: ViewLayoutItem.Widget, name: ViewLayoutItem.Types.WIDGET },
                { value: ViewLayoutItem.Container, name: ViewLayoutItem.Types.CONTAINER },
                { value: ViewLayoutItem.Tabs, name: ViewLayoutItem.Types.TABS },
                { value: ViewLayoutItem.Tab, name: ViewLayoutItem.Types.TAB }
            ],
        },
    })
], ViewTemplate.prototype, "layout", void 0);
(function (ViewTemplate) {
    let Types;
    (function (Types) {
        Types["DASHBOARD"] = "dashboard";
        Types["MODULE_VIEW"] = "module-view";
        Types["DETAIL_VIEW"] = "detail-view";
        Types["PREVIEW"] = "preview";
        Types["EMBED"] = "embed";
    })(Types = ViewTemplate.Types || (ViewTemplate.Types = {}));
})(ViewTemplate || (ViewTemplate = {}));

class ViewTemplateService {
    constructor(http, router, apiService, utilityService) {
        this.http = http;
        this.router = router;
        this.apiService = apiService;
        this.utilityService = utilityService;
        this.widgetLibraryChanged = new ReplaySubject(0);
        this.router.events
            .pipe(filter((e) => e instanceof NavigationEnd))
            .subscribe(() => {
            this.currentUrl = this.router.url;
        });
        // TODO: Add view template mmd
        this.viewTemplateEntity = new Entity(FIXED_MODULE.VIEW_TEMPLATES);
        this.viewTemplateEntity.baseUrl = API.API_APPMANAGER;
        this.widgetConfigEntity = new Entity(FIXED_MODULE.WIDGET_CONFIGS);
        this.widgetConfigEntity.baseUrl = API.API_APPMANAGER;
    }
    loadByUuid(uuid, includeWidgetConfigs = false) {
        let observable$;
        if (includeWidgetConfigs) {
            observable$ = this.apiService.query(this.widgetConfigEntity, {
                filters: [{
                        field: 'viewTemplate',
                        operator: 'eq',
                        value: uuid
                    }]
            }).pipe(map((response) => {
                return response['hydra:member'];
            }));
        }
        else {
            observable$ = of([]);
        }
        return observable$.pipe(concatMap((widgetConfigs) => {
            return this.apiService.getRecord(this.viewTemplateEntity, uuid, ViewTemplate).pipe(map((viewTemplate) => {
                viewTemplate.widgetConfigs = widgetConfigs;
                return plainToInstance(ViewTemplate, viewTemplate);
            }));
        }));
    }
    loadWithParams(filters) {
        return this.apiService.query(this.viewTemplateEntity, {
            filters: filters,
            limit: ALL_RECORDS_SIZE
        }).pipe(map((response) => {
            return response['hydra:member'];
        }));
    }
    //TODO:- Use when API is ready
    // public loadWithParams(params: any): Observable<ViewTemplate[]> {
    //   let filters = [];
    //   for (const k in params) {
    //     filters.push({
    //       field: k,
    //       operator: 'eq',
    //       value: params[k]
    //     });
    //   }
    //   // to do: use Query
    //   return this.http.post(API.QUERY + MMD.VIEW_TEMPLATES_KEY,
    //     {
    //       filters: filters,
    //       logic: 'AND',
    //       __selectFields: ['uuid', 'title']
    //     }
    //   )
    //     .pipe(
    //       map((response: any) => {
    //         return plainToInstance(ViewTemplate, response['hydra:member']);
    //       })
    //     );
    // }
    delete(uuid) {
        return this.apiService.deleteRecord(this.viewTemplateEntity, uuid);
    }
    save(viewTemplate) {
        let data = viewTemplate;
        let observable;
        let widgetConfigs = [];
        if (viewTemplate.layout) {
            widgetConfigs = flatten(viewTemplate.layout.map((item) => this.getNewWidgetConfigs(item)));
            data.widget_configs = widgetConfigs;
        }
        if (viewTemplate.uuid) {
            observable = this.apiService.updateRecord(this.viewTemplateEntity, viewTemplate.uuid, data);
        }
        else {
            observable = this.apiService.createRecord(this.viewTemplateEntity, data);
        }
        return observable.pipe(map((response) => {
            return plainToInstance(ViewTemplate, response);
        }), map((newViewTemplate) => {
            newViewTemplate.widgetConfigs = widgetConfigs;
            return newViewTemplate;
        }));
    }
    getNewWidgetConfigs(viewLayoutItem) {
        if (viewLayoutItem instanceof ViewLayoutItem.Widget || viewLayoutItem.type === ViewLayoutItem.Types.WIDGET) {
            let widget = viewLayoutItem;
            if (widget.config && typeof widget.config !== 'string') {
                widget.config.uuid = widget.config.uuid ?? v4();
                const widgetConfig = cloneDeep(widget.config);
                widget.config = widget.config.uuid;
                return [widgetConfig];
            }
            else {
                return [widget.config];
            }
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Container || viewLayoutItem.type === ViewLayoutItem.Types.CONTAINER) {
            return flatten(concat(viewLayoutItem.contents.map((item) => this.getNewWidgetConfigs(item))));
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Tabs || viewLayoutItem.type === ViewLayoutItem.Types.TABS) {
            return flatten(concat(viewLayoutItem.contents.map((item) => this.getNewWidgetConfigs(item))));
        }
        return [];
    }
    navigateToView(params = {}, currentRoute) {
        this.router.navigate(['.'], {
            relativeTo: currentRoute,
            queryParams: params
        });
    }
    duplicate(uuid) {
        return this.loadByUuid(uuid, true).pipe(concatMap((viewTemplate) => {
            let newWidgetConfigs = viewTemplate.widgetConfigs;
            let uuidMap = {};
            newWidgetConfigs.forEach((widgetConfig) => {
                const newUuid = this.utilityService.generateUUID();
                widgetConfig.isNew = true;
                if (widgetConfig.uuid) {
                    uuidMap[widgetConfig.uuid] = newUuid;
                    widgetConfig.uuid = newUuid;
                }
            });
            viewTemplate.layout.forEach((layoutItem) => {
                this.updateLayoutWidgetUuids(layoutItem, uuidMap);
            });
            viewTemplate.title = 'Copy of ' + viewTemplate.title;
            delete viewTemplate.uuid;
            return this.apiService.createRecord(this.viewTemplateEntity, viewTemplate)
                .pipe(concatMap((newViewTemplate) => {
                let observables$ = [];
                newWidgetConfigs.forEach((widgetConfig) => {
                    widgetConfig.viewTemplate = newViewTemplate.uuid;
                    let newWidgetConfig$ = this.apiService.createRecord(this.widgetConfigEntity, widgetConfig);
                    observables$.push(newWidgetConfig$);
                });
                return forkJoin(observables$).pipe(map(() => newViewTemplate));
            }));
        }), map((response) => {
            return plainToInstance(ViewTemplate, response, {
                enableImplicitConversion: true
            });
        }));
    }
    updateLayoutWidgetUuids(viewLayoutItem, uuidMap) {
        if (viewLayoutItem instanceof ViewLayoutItem.Widget || viewLayoutItem.type === ViewLayoutItem.Types.WIDGET) {
            let widget = viewLayoutItem;
            if (widget.config instanceof WidgetConfig && widget.config.uuid) {
                widget.config.uuid = uuidMap[widget.config.uuid];
            }
            else if (isString(widget.config)) {
                const uuid = last(widget.config.split('/'));
                widget.config = uuid ? uuidMap[uuid] : widget.config;
            }
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Container || viewLayoutItem.type === ViewLayoutItem.Types.CONTAINER) {
            let container = viewLayoutItem;
            container.contents.forEach((item) => {
                this.updateLayoutWidgetUuids(item, uuidMap);
            });
        }
        else if (viewLayoutItem instanceof ViewLayoutItem.Tabs || viewLayoutItem.type === ViewLayoutItem.Types.TABS) {
            let tabs = viewLayoutItem;
            tabs.contents.forEach((tab) => {
                this.updateLayoutWidgetUuids(tab, uuidMap);
            });
        }
    }
    static { this.ɵfac = function ViewTemplateService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.Router), i0.ɵɵinject(i1$1.ApiService), i0.ɵɵinject(i1$1.UtilityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ViewTemplateService, factory: ViewTemplateService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.Router }, { type: i1$1.ApiService }, { type: i1$1.UtilityService }], null); })();

class AbstractViewTemplateComponent {
    constructor(offcanvasService, router, viewTemplateService, route, changeDetectorRef, spinnerService, modalService, formBuilder) {
        this.offcanvasService = offcanvasService;
        this.router = router;
        this.viewTemplateService = viewTemplateService;
        this.route = route;
        this.changeDetectorRef = changeDetectorRef;
        this.spinnerService = spinnerService;
        this.modalService = modalService;
        this.viewTemplates = [];
        this.types = ViewTemplate.Types;
        this.loading = true;
        this.loadMultipleViews = true;
        this.uniqueValidatorService = inject(UniqueValidatorService);
        this.headerButtons = [];
        this.formGroup = formBuilder.group({
            viewTemplateTitle: ['', Validators.required]
        });
    }
    ngOnInit() {
        this.route.queryParamMap.pipe(concatMap$1((params) => {
            this.mode = params.get('mode') || 'view';
            this.uuid = params.get('uuid');
            this.loading = true;
            this.changeDetectorRef.detectChanges();
            if (this.mode === 'new') {
                return this.loadViews().pipe(map$1(() => this.newViewTemplate()));
            }
            else if (this.loadMultipleViews) {
                return this.loadViews().pipe(tap(() => {
                    if (this.viewTemplates && this.viewTemplates?.length > 0) {
                        this.uuid = this.uuid ?? this.viewTemplates[0]?.uuid;
                        this.viewTemplate = this.viewTemplates.find((viewTemplate) => viewTemplate.uuid === this.uuid) || null;
                        this.updateHeaderButtons();
                    }
                    else {
                        this.mode == null;
                        this.uuid = null;
                        this.updateHeaderButtons();
                        this.navigate();
                    }
                    this.changeDetectorRef.detectChanges();
                }));
            }
            else if (this.mode === 'view' && this.uuid) {
                return this.loadView();
            }
            return of();
        })).subscribe();
    }
    ;
    onSaveTemplate() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            this.formFields.forEach((formField) => {
                if (!formField.valid) {
                    formField.focus();
                    return;
                }
            });
            this.changeDetectorRef.detectChanges();
            return;
        }
        let updateMode;
        this.viewTemplateService.save(this.viewTemplate).subscribe({
            next: (viewTemplate) => {
                updateMode = this.mode === 'new' ? 'new' : 'view';
                this.mode = 'view';
                this.uuid = viewTemplate.uuid;
                this.updateViews(updateMode, viewTemplate);
                this.updateHeaderButtons();
                this.navigate();
            },
            error: (error) => {
                console.log(error);
                this.formGroup.controls.viewTemplateTitle.setErrors({ unique: true });
                this.formGroup.controls.viewTemplateTitle.markAsTouched();
                return of();
            }
        });
    }
    onDuplicateTemplate() {
        if (!this.viewTemplate) {
            return;
        }
        if (!this.viewTemplate.uuid) {
            return;
        }
        this.spinnerService.start();
        return this.viewTemplateService.duplicate(this.viewTemplate.uuid).subscribe((viewTemplate) => {
            this.spinnerService.stop();
            this.uuid = viewTemplate.uuid;
            this.mode = 'edit';
            this.navigate();
        });
    }
    onDeleteTemplate() {
        if (!this.viewTemplate) {
            return;
        }
        else {
            const message = 'Are you sure you want to delete the current view?';
            this.modalService.confirm(message).pipe(concatMap$1(() => {
                if (!this.viewTemplate?.uuid) {
                    return of();
                }
                this.spinnerService.start();
                return this.viewTemplateService.delete(this.viewTemplate?.uuid);
            })).subscribe(() => {
                this.spinnerService.stop();
                this.updateViews(undefined, this.viewTemplate);
            });
        }
    }
    onCancel() {
        if (this.mode === 'edit') {
            if (!this.uuid) {
                this.viewTemplate = null;
            }
            this.mode = 'view';
            this.updateHeaderButtons();
            this.navigate();
        }
        else {
            this.viewTemplate = null;
            this.viewTemplateService.navigateToView(null, this.route);
        }
    }
    onEditTemplate() {
        if (this.uuid) {
            this.mode = 'edit';
            this.updateHeaderButtons();
            this.navigate();
        }
    }
    updateViews(mode, viewTemplate) {
        if (mode && viewTemplate) {
            if (mode === 'new') {
                this._updateOnNew(viewTemplate);
            }
            else if (mode === 'view') {
                this.viewTemplates.forEach((item) => {
                    if (item.uuid === viewTemplate.uuid) {
                        item.title = viewTemplate.title;
                    }
                });
            }
        }
        else if (!mode && viewTemplate) { // Delete Case
            this.viewTemplates = this.viewTemplates.filter(item => item.uuid !== viewTemplate.uuid);
            if (this.viewTemplates.length > 0) {
                this.uuid = this.viewTemplates[0].uuid;
                this.loading = true;
                this.loadView();
            }
            else {
                this.uuid = null;
            }
        }
        this.changeDetectorRef.detectChanges();
    }
    _updateOnNew(viewTemplate) {
        this.uuid = viewTemplate.uuid;
        this.viewTemplates.unshift(viewTemplate);
    }
    loadViews() {
        // Pick it from context
        this.viewTemplate = null;
        this.viewTemplates = [];
        const module = this.route.snapshot.paramMap.get('module');
        let filters = [{
                field: 'type',
                operator: 'eq',
                value: this.viewTemplateType
            }];
        if (module) {
            this.currentModule = module;
            filters.push({
                field: 'module',
                operator: 'eq',
                value: module
            });
        }
        return this.viewTemplateService.loadWithParams(filters).pipe(map$1((viewTemplates) => {
            if (viewTemplates && viewTemplates?.length > 0) {
                this.viewTemplates = viewTemplates;
                const viewTemplatesWithoutCurrent = this.viewTemplates.filter((viewTemplate) => viewTemplate.uuid !== this.uuid);
                this.formGroup.controls.viewTemplateTitle.addValidators(this.uniqueValidatorService.validate(viewTemplatesWithoutCurrent.map((viewTemplate) => viewTemplate.title)));
                this.formGroup.controls.viewTemplateTitle.updateValueAndValidity();
            }
            this.loading = false;
            this.changeDetectorRef.detectChanges();
        }));
    }
    loadView() {
        return this.viewTemplateService.loadByUuid(this.uuid).pipe(map$1((viewTemplate) => {
            this.viewTemplate = viewTemplate;
            this.loading = false;
            this.updateHeaderButtons();
            this.changeDetectorRef.detectChanges();
        }));
    }
    navigate() {
        let params = {
            mode: this.mode,
            uuid: this.uuid
        };
        // this.viewTemplateService.navigateToView(params, this.route);
        var url = this.router.createUrlTree([], { relativeTo: this.route, queryParams: params }).toString();
        this.router.navigateByUrl(url);
        // if (this.openedInPreview) {
        //   this.mode = this.params.mode;
        //   this.recordId = this.params.recordId;
        //   this.onAddViewTemplate.emit();
        // } else {
        //   this.viewTemplateService.navigateToView(this.params, this.route);
        // }
    }
    updateHeaderButtons() {
        const isSystem = this.viewTemplate?.system;
        this.headerButtons = [
            {
                id: 'actions',
                text: 'Actions',
                class: 'dropdown-toggle btn btn-primary btn-sm',
                visible: this.mode === 'view' && this.viewTemplate?.type !== 'dashboard',
                menuItems: [{
                        id: 'new',
                        text: 'New',
                        visible: true,
                        onClick: () => {
                            this.mode = 'new';
                            this.uuid = null;
                            this.navigate();
                        }
                    }, {
                        id: 'clone',
                        text: 'Clone & Edit',
                        visible: isSystem,
                        onClick: () => { this.onDuplicateTemplate(); }
                    }, {
                        id: 'edit',
                        text: 'Edit',
                        visible: !isSystem,
                        onClick: () => { this.onEditTemplate(); }
                    }, {
                        id: 'delete',
                        text: 'Delete',
                        visible: !isSystem,
                        onClick: () => { this.onDeleteTemplate(); }
                    }],
                onClick: () => null
            }, {
                id: 'cancel',
                text: 'Cancel',
                class: 'btn btn-secondary btn-sm me-2',
                visible: this.mode !== null && this.mode !== 'view',
                onClick: () => { this.onCancel(); }
            }, {
                id: 'save',
                text: 'Save and Publish',
                class: 'btn btn-primary btn-sm me-2',
                visible: this.mode !== null && this.mode !== 'view',
                onClick: () => { this.onSaveTemplate(); }
            }
        ];
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function AbstractViewTemplateComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractViewTemplateComponent)(i0.ɵɵdirectiveInject(i1$2.NgbOffcanvas), i0.ɵɵdirectiveInject(i2.Router), i0.ɵɵdirectiveInject(ViewTemplateService), i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.SpinnerService), i0.ɵɵdirectiveInject(i1$1.ModalService), i0.ɵɵdirectiveInject(i3.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractViewTemplateComponent, selectors: [["xf-abstract-view-template"]], viewQuery: function AbstractViewTemplateComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, decls: 0, vars: 0, template: function AbstractViewTemplateComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractViewTemplateComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-view-template',
                template: ''
            }]
    }], () => [{ type: i1$2.NgbOffcanvas }, { type: i2.Router }, { type: ViewTemplateService }, { type: i2.ActivatedRoute }, { type: i0.ChangeDetectorRef }, { type: i1$1.SpinnerService }, { type: i1$1.ModalService }, { type: i3.FormBuilder }], { formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractViewTemplateComponent, { className: "AbstractViewTemplateComponent", filePath: "src/abstract-view-template.component.ts", lineNumber: 16 }); })();

class AbstractEditViewLayout {
    static { this.ɵfac = function AbstractEditViewLayout_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractEditViewLayout)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractEditViewLayout, selectors: [["xf-abstract-edit-view-layout"]], inputs: { layoutItem: "layoutItem", entity: "entity" }, decls: 0, vars: 0, template: function AbstractEditViewLayout_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractEditViewLayout, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-edit-view-layout',
                template: ''
            }]
    }], null, { layoutItem: [{
            type: Input
        }], entity: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractEditViewLayout, { className: "AbstractEditViewLayout", filePath: "src/view-template/abstract-edit-view-layout.component.ts", lineNumber: 9 }); })();

var builtInWidgetList = [
	{
		name: "grid",
		title: "Grid",
		subTitle: null,
		description: "This is the grid widget",
		supportedViews: [
			"module-view",
			"preview",
			"dashboard",
			"detail-view"
		],
		version: "built-in"
	},
	{
		name: "field-group",
		title: "Field Group",
		subTitle: null,
		description: "This is the field group widget",
		supportedViews: [
			"preview",
			"detail-view"
		],
		version: "built-in"
	},
	{
		name: "primary-detail",
		title: "Primary Detail",
		subTitle: null,
		description: "This is the primary detail widget for detail views",
		supportedViews: [
			"detail-view"
		],
		version: "built-in"
	}
];

class AbstractWidgetEditComponent {
    constructor(changeDetectorRef, entityService, utilityService) {
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.utilityService = utilityService;
        this.items = [];
    }
    filterFields(search, fieldsAlreadyAdded, fieldsToFilter) {
        if (isUndefined(this.entity) && isUndefined(fieldsToFilter)) {
            return;
        }
        const fields = fieldsToFilter || this.entity.attributes;
        this.utilityService.filterFields(fields, search, fieldsAlreadyAdded).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function AbstractWidgetEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractWidgetEditComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i1$1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractWidgetEditComponent, selectors: [["xf-abstract-widget-edit"]], inputs: { widgetConfig: "widgetConfig", context: "context" }, decls: 0, vars: 0, template: function AbstractWidgetEditComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractWidgetEditComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-widget-edit',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$1.EntityService }, { type: i1$1.UtilityService }], { widgetConfig: [{
            type: Input
        }], context: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractWidgetEditComponent, { className: "AbstractWidgetEditComponent", filePath: "src/widgets/abstract-widget-edit.component.ts", lineNumber: 15 }); })();

class FieldRenderer {
    constructor(name) {
        this.readOnly = false;
        this.hideLabel = false;
        this.showInline = false;
        this.viewMode = 'default';
        this.name = name;
    }
}

function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 18)(1, "span", 19);
    i0.ɵɵelement(2, "i", 20);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 21)(5, "div", 22);
    i0.ɵɵelement(6, "i", 23);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "div", 24)(8, "div", 25)(9, "input", 26);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_input_ngModelChange_9_listener($event) { i0.ɵɵrestoreView(_r6); const field_r7 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(field_r7.readOnly, $event) || (field_r7.readOnly = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(10, "label", 27);
    i0.ɵɵtext(11, " Read-only ");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(12, "div", 25)(13, "input", 26);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_input_ngModelChange_13_listener($event) { i0.ɵɵrestoreView(_r6); const field_r7 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(field_r7.hideLabel, $event) || (field_r7.hideLabel = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(14, "label", 27);
    i0.ɵɵtext(15, " Hide Label ");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(16, "div", 25)(17, "input", 26);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_input_ngModelChange_17_listener($event) { i0.ɵɵrestoreView(_r6); const field_r7 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(field_r7.showInline, $event) || (field_r7.showInline = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(18, "label", 27);
    i0.ɵɵtext(19, " Show Inline ");
    i0.ɵɵelementEnd()()()();
    i0.ɵɵelementStart(20, "i", 28);
    i0.ɵɵlistener("click", function FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template_i_click_20_listener() { i0.ɵɵrestoreView(_r6); const fieldIndex_r8 = i0.ɵɵnextContext().index; const colIndex_r9 = i0.ɵɵnextContext().index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.removeField(colIndex_r9, fieldIndex_r8)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r9 = i0.ɵɵnextContext();
    const field_r7 = ctx_r9.$implicit;
    const fieldIndex_r8 = ctx_r9.index;
    const colIndex_r9 = i0.ɵɵnextContext().index;
    const t_r11 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r11(ctx_r1.entity.fields[field_r7.name].title), " ");
    i0.ɵɵadvance(2);
    i0.ɵɵpropertyInterpolate2("id", "field-dropdown-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵadvance(2);
    i0.ɵɵattribute("aria-labelledby", "field-dropdown-" + colIndex_r9 + "-" + fieldIndex_r8);
    i0.ɵɵadvance(2);
    i0.ɵɵpropertyInterpolate2("id", "field-read-only-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵtwoWayProperty("ngModel", field_r7.readOnly);
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate2("for", "field-read-only-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵadvance(3);
    i0.ɵɵpropertyInterpolate2("id", "field-hide-label-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵtwoWayProperty("ngModel", field_r7.hideLabel);
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate2("for", "field-hide-label-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵadvance(3);
    i0.ɵɵpropertyInterpolate2("id", "field-label-inline-", colIndex_r9, "-", fieldIndex_r8, "");
    i0.ɵɵtwoWayProperty("ngModel", field_r7.showInline);
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate2("for", "field-label-inline-", colIndex_r9, "-", fieldIndex_r8, "");
} }
function FieldGroupEditComponent_div_0_div_17_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵlistener("dndStart", function FieldGroupEditComponent_div_0_div_17_div_1_Template_div_dndStart_0_listener() { i0.ɵɵrestoreView(_r5); const col_r4 = i0.ɵɵnextContext().$implicit; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.originalColumn = col_r4); });
    i0.ɵɵtemplate(1, FieldGroupEditComponent_div_0_div_17_div_1_div_1_Template, 21, 26, "div", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r7 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("dndDraggable", field_r7);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.entity);
} }
function FieldGroupEditComponent_div_0_div_17_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 11);
    i0.ɵɵlistener("dndDrop", function FieldGroupEditComponent_div_0_div_17_Template_div_dndDrop_0_listener($event) { const col_r4 = i0.ɵɵrestoreView(_r3).$implicit; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.onDrop($event, col_r4)); });
    i0.ɵɵtemplate(1, FieldGroupEditComponent_div_0_div_17_div_1_Template, 2, 2, "div", 12);
    i0.ɵɵelement(2, "div", 13);
    i0.ɵɵelementStart(3, "div", 14)(4, "xf-searchable-dropdown", 15);
    i0.ɵɵlistener("ngModelChange", function FieldGroupEditComponent_div_0_div_17_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { const colIndex_r9 = i0.ɵɵrestoreView(_r3).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.addField(colIndex_r9, $event)); })("searchQueryChange", function FieldGroupEditComponent_div_0_div_17_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.filterFields($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const col_r4 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("dndHorizontal", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", col_r4);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngModel", ctx_r1.field)("clearValueOnSelect", true)("items", ctx_r1.items);
} }
function FieldGroupEditComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 1)(2, "label", 2);
    i0.ɵɵtext(3, "Columns");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "select", 3);
    i0.ɵɵlistener("ngModelChange", function FieldGroupEditComponent_div_0_Template_select_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); ctx_r1.columnCount = $event; return i0.ɵɵresetView(ctx_r1.columnCountChanges($event)); });
    i0.ɵɵelementStart(5, "option", 4);
    i0.ɵɵtext(6, "1-column");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "option", 4);
    i0.ɵɵtext(8, "2-column");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "option", 4);
    i0.ɵɵtext(10, "3-column");
    i0.ɵɵelementEnd()()();
    i0.ɵɵelementStart(11, "div", 5)(12, "label", 6)(13, "input", 7);
    i0.ɵɵtwoWayListener("ngModelChange", function FieldGroupEditComponent_div_0_Template_input_ngModelChange_13_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.columnInline, $event) || (ctx_r1.columnInline = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵlistener("ngModelChange", function FieldGroupEditComponent_div_0_Template_input_ngModelChange_13_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.columnInlineToggle()); });
    i0.ɵɵelementEnd();
    i0.ɵɵtext(14, "All Inline ");
    i0.ɵɵelementEnd()();
    i0.ɵɵelement(15, "div", 8);
    i0.ɵɵelementStart(16, "div", 9);
    i0.ɵɵtemplate(17, FieldGroupEditComponent_div_0_div_17_Template, 5, 5, "div", 10);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngModel", ctx_r1.columnCount);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngValue", 1);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", 2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", 3);
    i0.ɵɵadvance(4);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.columnInline);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngForOf", ctx_r1.widgetConfig.configuration.cols);
} }
class FieldGroupEditComponent extends AbstractWidgetEditComponent {
    constructor(entityService, changeDetectorRef, utilityService) {
        super(changeDetectorRef, entityService, utilityService);
        this.originalColumn = null;
        this.columnCount = 1;
        this.columnInline = false;
        this.field = null;
    }
    ngOnInit() {
        if (this.context.module) {
            this.entityService.build(this.context.module).subscribe((entity) => {
                this.entity = entity;
                this.widgetConfig.configuration.module = this.widgetConfig.configuration.module || this.entity.type;
                this.widgetConfig.configuration.cols = this.widgetConfig.configuration.cols || [[]];
                this.widgetConfig.configuration.showInline = this.widgetConfig.configuration.showInline || this.columnInline;
                this.columnCount = this.widgetConfig.configuration.cols.length;
                this.columnInline = this.widgetConfig.configuration.showInline;
                this.filterFields('');
                this.changeDetectorRef.detectChanges();
            });
        }
    }
    onChange(col, colIndex) {
        this.widgetConfig.configuration.cols[colIndex] = col;
    }
    onDrop(event, list) {
        if (list && this.originalColumn) {
            // Remove from existing columns
            const foundIndex = findIndex(this.originalColumn, {
                name: event.data.name
            });
            if (foundIndex > -1) {
                this.originalColumn.splice(foundIndex, 1);
                this.originalColumn = null;
            }
            // Add to new column
            let index = event.index;
            if (typeof index === "undefined") {
                index = list.length;
            }
            list.splice(index, 0, event.data);
        }
    }
    onDragStart(col) {
        this.originalColumn = col;
    }
    addField(colIndex, item) {
        if (!item) {
            return;
        }
        this.widgetConfig.configuration.cols[colIndex].push(new FieldRenderer(item.value.name));
    }
    removeField(colIndex, fieldIndex) {
        this.widgetConfig.configuration.cols[colIndex].splice(fieldIndex, 1);
    }
    filterFields(search) {
        const fieldsAlreadyAdded = flattenDeep(this.widgetConfig.configuration.cols.map((col) => col.map((field) => field.name)));
        super.filterFields(search, fieldsAlreadyAdded);
    }
    columnCountChanges(columns) {
        let cols = this.widgetConfig.configuration.cols;
        while (cols.length > columns) {
            const widgets = cols.pop() || [];
            if (widgets.length > 0) {
                cols[cols.length - 1] = cols[cols.length - 1].concat(widgets);
            }
        }
        while (cols.length < columns) {
            cols.push([]);
        }
        this.changeDetectorRef.detectChanges();
    }
    columnInlineToggle() {
        this.widgetConfig.configuration.showInline = this.columnInline;
    }
    static { this.ɵfac = function FieldGroupEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldGroupEditComponent)(i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldGroupEditComponent, selectors: [["xf-field-group-edit"]], inputs: { widgetConfig: "widgetConfig" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 0, consts: [[4, "transloco"], [1, "form-group", "d-inline-block"], ["for", "columns", 1, "form-label"], ["id", "columns", "name", "columns", 1, "form-select", "w-auto", 3, "ngModelChange", "ngModel"], [3, "ngValue"], [1, "form-group", "d-inline-block", "margin-left-4px"], ["title", "Enable to show label and field data in one line", 1, "align-self-center", "solid-border-1", "padding-6px", "rounded-3px"], ["type", "checkbox", "id", "section-inline", 1, "form-check-input", "margin-right-8px", 3, "ngModelChange", "ngModel"], [1, "hr", "pt-2", "pb-2"], [1, "row", "edit-cols", "m-0"], ["class", "col pb-2", "dndDropzone", "", "dndEffectAllowed", "copyMove", 3, "dndHorizontal", "dndDrop", 4, "ngFor", "ngForOf"], ["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card mt-2", 3, "dndDraggable", "dndStart", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Add Field", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"], ["dndEffectAllowed", "move", 1, "card", "mt-2", 3, "dndStart", "dndDraggable"], ["class", "card-title m-0 d-flex", 4, "ngIf"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], ["ngbDropdown", "", 1, "d-inline-block"], ["role", "button", "ngbDropdownToggle", "", 1, "dropdown-caret-off", "margin-right-16px", 3, "id"], [1, "fa", "fa-ellipsis-v-alt", "fa-light"], ["ngbDropdownMenu", ""], [1, "form-check", "mx-2"], ["type", "checkbox", 1, "form-check-input", 3, "ngModelChange", "ngModel", "id"], [1, "form-check-label", 3, "for"], ["role", "button", 1, "fa", "fa-light", "fa-trash", "margin-top-4px", "text-danger", 3, "click"]], template: function FieldGroupEditComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldGroupEditComponent_div_0_Template, 18, 6, "div", 0);
        } }, dependencies: [i2$1.NgForOf, i2$1.NgIf, i3.NgSelectOption, i3.ɵNgSelectMultipleOption, i3.CheckboxControlValueAccessor, i3.SelectControlValueAccessor, i3.NgControlStatus, i3.NgModel, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective, i1$2.NgbDropdown, i1$2.NgbDropdownToggle, i1$2.NgbDropdownMenu, i1$1.SearchableDropdownComponent, i6.TranslocoDirective], styles: [".dnd-placeholder[_ngcontent-%COMP%]{height:50px;background:var(--bs-gray-100);border:2px dashed var(--bs-gray-300)}.edit-cols[_ngcontent-%COMP%]{border:1px solid var(--bs-gray-300)}.edit-cols[_ngcontent-%COMP%]   .col[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]{background-color:#fff;padding:.5rem}.searchable-dropdown[_ngcontent-%COMP%]{max-height:200px;overflow:auto}.bi-three-dots-vertical[_ngcontent-%COMP%]:after{display:none}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldGroupEditComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-group-edit', template: "<div *transloco=\"let t\">\n <div class=\"form-group d-inline-block\">\n  <label for=\"columns\" class=\"form-label\">Columns</label>\n  <select [ngModel]=\"columnCount\" (ngModelChange)=\"columnCount = $event; columnCountChanges($event)\" id=\"columns\" name=\"columns\" class=\"form-select w-auto\">\n    <option [ngValue]=\"1\">1-column</option>\n    <option [ngValue]=\"2\">2-column</option>\n    <option [ngValue]=\"3\">3-column</option>\n  </select>\n</div>\n<div class=\"form-group d-inline-block margin-left-4px\">\n  <label class=\"align-self-center solid-border-1 padding-6px rounded-3px\" title=\"Enable to show label and field data in one line\">\n    <input type=\"checkbox\" class=\"form-check-input margin-right-8px\" id=\"section-inline\" [(ngModel)]=\"columnInline\" (ngModelChange)=\"columnInlineToggle()\" >All Inline </label>\n</div>\n<div class=\"hr pt-2 pb-2\"></div>\n<div class=\"row edit-cols m-0\">\n  <div class=\"col pb-2\" *ngFor=\"let col of widgetConfig.configuration.cols; let colIndex = index\" dndDropzone\n    [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\" (dndDrop)=\"onDrop($event, col)\">\n    <div *ngFor=\"let field of col; let fieldIndex = index\" [dndDraggable]=\"field\" dndEffectAllowed=\"move\"\n      (dndStart)=\"originalColumn = col\" class=\"card mt-2\">\n      <div class=\"card-title m-0 d-flex\" *ngIf=\"entity\">\n        <span class=\"flex-grow-1\">\n          <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ t(entity.fields[field.name].title) }}\n        </span>\n        <div ngbDropdown class=\"d-inline-block\">\n          <div role=\"button\" id=\"field-dropdown-{{ colIndex }}-{{ fieldIndex }}\"\n          ngbDropdownToggle class=\"dropdown-caret-off margin-right-16px\">\n            <i class=\"fa fa-ellipsis-v-alt fa-light\"></i>\n          </div>\n          <div ngbDropdownMenu [attr.aria-labelledby]=\"'field-dropdown-' + colIndex + '-' + fieldIndex\">\n            <div class=\"form-check mx-2\">\n              <input class=\"form-check-input\" type=\"checkbox\" [(ngModel)]=\"field.readOnly\"\n                id=\"field-read-only-{{ colIndex }}-{{ fieldIndex }}\">\n              <label class=\"form-check-label\" for=\"field-read-only-{{ colIndex }}-{{ fieldIndex }}\">\n                Read-only\n              </label>\n            </div>\n            <div class=\"form-check mx-2\">\n              <input class=\"form-check-input\" type=\"checkbox\" [(ngModel)]=\"field.hideLabel\"\n                id=\"field-hide-label-{{ colIndex }}-{{ fieldIndex }}\">\n              <label class=\"form-check-label\" for=\"field-hide-label-{{ colIndex }}-{{ fieldIndex }}\">\n                Hide Label\n              </label>\n            </div>\n            <div class=\"form-check mx-2\">\n              <input class=\"form-check-input\" type=\"checkbox\" [(ngModel)]=\"field.showInline\"\n                id=\"field-label-inline-{{ colIndex }}-{{ fieldIndex }}\">\n              <label class=\"form-check-label\" for=\"field-label-inline-{{ colIndex }}-{{ fieldIndex }}\">\n                Show Inline\n              </label>\n            </div>\n          </div>\n        </div>\n        <i class=\"fa fa-light fa-trash margin-top-4px text-danger\" role=\"button\" (click)=\"removeField(colIndex, fieldIndex)\"></i>\n      </div>\n\n    </div>\n    <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n    <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n      <xf-searchable-dropdown (ngModelChange)=\"addField(colIndex, $event)\" [ngModel]=\"field\" [clearValueOnSelect]=\"true\" [items]=\"items\"\n        placeholder=\"+ Add Field\" (searchQueryChange)=\"filterFields($event)\"></xf-searchable-dropdown>\n    </div>\n  </div>\n</div>\n</div>\n", styles: [".dnd-placeholder{height:50px;background:var(--bs-gray-100);border:2px dashed var(--bs-gray-300)}.edit-cols{border:1px solid var(--bs-gray-300)}.edit-cols .col .card{background-color:#fff;padding:.5rem}.searchable-dropdown{max-height:200px;overflow:auto}.bi-three-dots-vertical:after{display:none}\n"] }]
    }], () => [{ type: i1$1.EntityService }, { type: i0.ChangeDetectorRef }, { type: i1$1.UtilityService }], { widgetConfig: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldGroupEditComponent, { className: "FieldGroupEditComponent", filePath: "src/widgets/field-group/field-group-edit/field-group-edit.component.ts", lineNumber: 17 }); })();

class AbstractWidgetComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
    }
    ngOnInit() {
        if (this.widgetConfig) {
            this.widgetConfigChanged(this.widgetConfig);
        }
    }
    ngOnChanges(changes) {
        if (changes.widgetConfig) {
            this.widgetConfigChanged(changes.widgetConfig.currentValue);
        }
    }
    static { this.ɵfac = function AbstractWidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractWidgetComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractWidgetComponent, selectors: [["xf-abstract-widget"]], inputs: { widgetConfig: "widgetConfig", mode: "mode", context: "context", updateHeight: "updateHeight", widgetId: "widgetId" }, features: [i0.ɵɵNgOnChangesFeature], decls: 0, vars: 0, template: function AbstractWidgetComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractWidgetComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-widget',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }], { widgetConfig: [{
            type: Input
        }], mode: [{
            type: Input
        }], context: [{
            type: Input
        }], updateHeight: [{
            type: Input
        }], widgetId: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractWidgetComponent, { className: "AbstractWidgetComponent", filePath: "src/widgets/abstract-widget.component.ts", lineNumber: 10 }); })();

function FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "xf-editable-field", 9);
    i0.ɵɵlistener("valueChange", function FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_div_3_Template_xf_editable_field_valueChange_1_listener($event) { i0.ɵɵrestoreView(_r1); const field_r2 = i0.ɵɵnextContext(2).$implicit; const ctx_r2 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r2.valueChanged(field_r2.name, $event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", (ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.showInline) ? "d-inline-block w-70" : "d-block");
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r2.entity.fields[field_r2.name])("value", ctx_r2.entity.values[field_r2.name])("readOnly", field_r2.readOnly || ctx_r2.mode === "edit");
} }
function FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "h5", 6);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_div_3_Template, 2, 4, "div", 7);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const field_r2 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", (ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.showInline) ? "d-inline-block w-30 align-self-center margin-top-8px" : "d-block");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r2.entity.fields[field_r2.name].title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.entity.fields[field_r2.name]);
} }
function FieldGroupViewComponent_div_0_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 4);
    i0.ɵɵtemplate(1, FieldGroupViewComponent_div_0_div_1_div_1_ng_container_1_Template, 4, 3, "ng-container", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r2 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", (ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.showInline) ? "d-flex" : "d-block");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.entity.fields[field_r2.name]);
} }
function FieldGroupViewComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, FieldGroupViewComponent_div_0_div_1_div_1_Template, 2, 2, "div", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const col_r4 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMap("col-md-" + 12 / ((ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.cols == null ? null : ctx_r2.widgetConfig.configuration.cols.length) || 12));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", col_r4);
} }
function FieldGroupViewComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, FieldGroupViewComponent_div_0_div_1_Template, 2, 3, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.widgetConfig.configuration == null ? null : ctx_r2.widgetConfig.configuration.cols);
} }
class FieldGroupViewComponent extends AbstractWidgetComponent {
    constructor(_changeDetectorRef, dataProvider, entityService) {
        super(_changeDetectorRef);
        this.dataProvider = dataProvider;
        this.entityService = entityService;
        this.editModes = {};
        this.allFieldNames = [];
    }
    subscribeToData() {
        if (!this.context?.module) {
            return;
        }
        this.allFieldNames = flattenDeep(this.fieldGroupConfig.configuration.cols.map((col) => col.map((field) => field.name)));
        let topic = this.context?.uuid + this.allFieldNames.join('-');
        if (this.existingRequest === topic) {
            return;
        }
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
        this.existingRequest = topic;
        this.subscription = this.entityService.build(this.context.module).pipe(concatMap$1((entity) => {
            return this.dataProvider.observe(entity, this.context?.uuid, undefined, new Query({ selectedFields: this.allFieldNames }));
        })).subscribe((entityChange) => {
            this.entity = entityChange.entity;
            this.existingRequest = undefined;
            this.changeDetectorRef.detectChanges();
        });
    }
    widgetConfigChanged(widgetConfig) {
        this.fieldGroupConfig = widgetConfig;
        this.subscribeToData();
    }
    valueChanged(fieldName, value) {
        if (!this.entity) {
            return;
        }
        this.entity.values[fieldName] = value;
        this.dataProvider.save({
            entity: this.entity,
            changedFields: [fieldName],
            sourceId: this.fieldGroupConfig.uuid || null
        }).subscribe();
    }
    ngOnDestroy() {
        this.subscription.unsubscribe();
    }
    contextChanged(context) {
        this.context = context;
        this.subscribeToData();
    }
    static { this.ɵfac = function FieldGroupViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldGroupViewComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.DataProviderService), i0.ɵɵdirectiveInject(i1$1.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldGroupViewComponent, selectors: [["xf-field-group-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "row", 4, "ngIf"], [1, "row"], [3, "class", 4, "ngFor", "ngForOf"], ["class", "form-group mb-4 mt-3", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "form-group", "mb-4", "mt-3", 3, "ngClass"], [4, "ngIf"], [1, "detail-view-label", 3, "ngClass"], [3, "ngClass", 4, "ngIf"], [3, "ngClass"], [3, "valueChange", "field", "value", "readOnly"]], template: function FieldGroupViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldGroupViewComponent_div_0_Template, 2, 1, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.entity);
        } }, dependencies: [i2$1.NgClass, i2$1.NgForOf, i2$1.NgIf, i1$1.EditableFieldComponent], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldGroupViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-group-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"row\" *ngIf=\"entity\">\n  <div *ngFor=\"let col of widgetConfig.configuration?.cols; let colIndex = index\"\n    [class]=\"'col-md-' + 12 / (widgetConfig.configuration?.cols?.length || 12)\">\n    <div class=\"form-group mb-4 mt-3\" [ngClass]=\"widgetConfig.configuration?.showInline ? 'd-flex' : 'd-block'\"\n      *ngFor=\"let field of col\">\n      <ng-container *ngIf=\"entity.fields[field.name]\">\n        <h5 class=\"detail-view-label\"\n          [ngClass]=\"widgetConfig.configuration?.showInline ? 'd-inline-block w-30 align-self-center margin-top-8px' : 'd-block'\">\n          {{ entity.fields[field.name]!.title }}\n        </h5>\n        <div [ngClass]=\"widgetConfig.configuration?.showInline ? 'd-inline-block w-70' : 'd-block'\"\n          *ngIf=\"entity.fields[field.name]\">\n          <xf-editable-field [field]=\"entity.fields[field.name]!\" [value]=\"entity.values[field.name]\"\n            (valueChange)=\"valueChanged(field.name, $event)\" [readOnly]=\"field.readOnly || mode === 'edit'\">\n          </xf-editable-field>\n        </div>\n      </ng-container>\n    </div>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$1.DataProviderService }, { type: i1$1.EntityService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldGroupViewComponent, { className: "FieldGroupViewComponent", filePath: "src/widgets/field-group/field-group-view/field-group-view.component.ts", lineNumber: 16 }); })();

class FieldGroupConfig extends WidgetConfig {
    constructor(title, configuration) {
        super(title, configuration);
        this.title = title;
        this.configuration = configuration;
        this.type = 'field-group';
        if (this.configuration) {
            this.configuration.cols = this.configuration.cols || [[]];
        }
        this.viewComponent = FieldGroupViewComponent;
        this.editComponent = FieldGroupEditComponent;
    }
}

const _c0$7 = (a0, a1, a2) => ({ "pe-0": a0, "px-2": a1, "pe-3": a2 });
function PrimaryDetailEditComponent_div_10_div_1_div_2_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 13)(1, "span", 14);
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "i", 15);
    i0.ɵɵlistener("click", function PrimaryDetailEditComponent_div_10_div_1_div_2_div_1_Template_i_click_3_listener() { i0.ɵɵrestoreView(_r1); const fieldIndex_r2 = i0.ɵɵnextContext(2).index; const colIndex_r3 = i0.ɵɵnextContext().index; const ctx_r3 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r3.removeField(colIndex_r3, fieldIndex_r2)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const field_r5 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r3 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", ctx_r3.entity.fields[field_r5.name].title, " ");
} }
function PrimaryDetailEditComponent_div_10_div_1_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 13);
    i0.ɵɵtemplate(1, PrimaryDetailEditComponent_div_10_div_1_div_2_div_1_Template, 4, 1, "div", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r3.entity);
} }
function PrimaryDetailEditComponent_div_10_div_1_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 16)(1, "xf-searchable-dropdown", 17);
    i0.ɵɵlistener("ngModelChange", function PrimaryDetailEditComponent_div_10_div_1_div_3_Template_xf_searchable_dropdown_ngModelChange_1_listener($event) { i0.ɵɵrestoreView(_r6); const colIndex_r3 = i0.ɵɵnextContext(2).index; const ctx_r3 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r3.addField(colIndex_r3, $event)); })("searchQueryChange", function PrimaryDetailEditComponent_div_10_div_1_div_3_Template_xf_searchable_dropdown_searchQueryChange_1_listener($event) { i0.ɵɵrestoreView(_r6); const ctx_r3 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r3.filterFields($event, [])); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngModel", ctx_r3.newField)("clearValueOnSelect", true)("items", ctx_r3.items);
} }
function PrimaryDetailEditComponent_div_10_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9)(1, "div", 10);
    i0.ɵɵtemplate(2, PrimaryDetailEditComponent_div_10_div_1_div_2_Template, 2, 1, "div", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, PrimaryDetailEditComponent_div_10_div_1_div_3_Template, 2, 3, "div", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const colLast_r7 = ctx.last;
    const colFirst_r8 = ctx.first;
    const col_r9 = i0.ɵɵnextContext().$implicit;
    const ctx_r3 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction3(3, _c0$7, !colLast_r7, !colFirst_r8, colLast_r7));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r3.entity);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", col_r9.length < 4);
} }
function PrimaryDetailEditComponent_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7);
    i0.ɵɵtemplate(1, PrimaryDetailEditComponent_div_10_div_1_Template, 4, 7, "div", 8);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const col_r9 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", col_r9);
} }
class PrimaryDetailEditComponent extends AbstractWidgetEditComponent {
    constructor(changeDetectorRef, entityService, utilityService) {
        super(changeDetectorRef, entityService, utilityService);
        this.nameField = null;
        this.picklistField = null;
        this.newField = null;
    }
    ngOnInit() {
        if (this.context.module) {
            this.entityService.build(this.context.module).subscribe((entity) => {
                this.entity = entity;
                if (this.widgetConfig.configuration.nameField) {
                    let nameField = this.entity.fields[this.widgetConfig.configuration.nameField];
                    this.nameField = new SearchableItem(nameField.title, nameField, nameField.name);
                }
                if (this.widgetConfig.configuration.picklistField) {
                    let picklistField = this.entity.fields[this.widgetConfig.configuration.picklistField];
                    this.picklistField = new SearchableItem(picklistField.title, picklistField, picklistField.name);
                }
                this.widgetConfig.configuration.cols = this.widgetConfig.configuration.cols || [[]];
                this.changeDetectorRef.detectChanges();
            });
        }
    }
    setConfiguration() {
        this.widgetConfig.configuration.nameField = this.nameField?.value.name;
        this.widgetConfig.configuration.picklistField = this.picklistField?.value.name;
    }
    addField(colIndex, item) {
        if (!item || !this.widgetConfig.configuration.cols) {
            return;
        }
        this.widgetConfig.configuration.cols[colIndex].push(new FieldRenderer(item.value.name));
    }
    removeField(colIndex, fieldIndex) {
        if (!this.widgetConfig.configuration.cols) {
            return;
        }
        this.widgetConfig.configuration.cols[colIndex].splice(fieldIndex, 1);
    }
    static { this.ɵfac = function PrimaryDetailEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PrimaryDetailEditComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i1$1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PrimaryDetailEditComponent, selectors: [["xf-primary-detail-edit"]], inputs: { widgetConfig: "widgetConfig" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 11, vars: 5, consts: [[1, "form-group"], ["for", "name-field", 1, "control-label"], [1, "mt-1", "mb-1"], ["placeholder", "Choose field", 3, "ngModelChange", "searchQueryChange", "ngModel", "items"], [1, "form-group", "mt-3"], ["for", "picklist-field", 1, "control-label"], ["class", "row mt-2", 4, "ngFor", "ngForOf"], [1, "row", "mt-2"], ["class", "col-md-3", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "col-md-3", 3, "ngClass"], [1, "card", "mt-2", "p-2"], ["class", "card-title m-0 d-flex", 4, "ngIf"], ["class", "mt-2", 4, "ngIf"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["role", "button", 1, "fa-light", "fa", "fa-trash", "text-danger", 3, "click"], [1, "mt-2"], ["placeholder", "+ Add Field", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"]], template: function PrimaryDetailEditComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "label", 1);
            i0.ɵɵtext(2, "Name Field");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "div", 2)(4, "xf-searchable-dropdown", 3);
            i0.ɵɵtwoWayListener("ngModelChange", function PrimaryDetailEditComponent_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.nameField, $event) || (ctx.nameField = $event); return $event; });
            i0.ɵɵlistener("ngModelChange", function PrimaryDetailEditComponent_Template_xf_searchable_dropdown_ngModelChange_4_listener() { return ctx.setConfiguration(); })("searchQueryChange", function PrimaryDetailEditComponent_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { return ctx.filterFields($event, []); });
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(5, "div", 4)(6, "label", 5);
            i0.ɵɵtext(7, "Picklist Field");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 2)(9, "xf-searchable-dropdown", 3);
            i0.ɵɵtwoWayListener("ngModelChange", function PrimaryDetailEditComponent_Template_xf_searchable_dropdown_ngModelChange_9_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.picklistField, $event) || (ctx.picklistField = $event); return $event; });
            i0.ɵɵlistener("ngModelChange", function PrimaryDetailEditComponent_Template_xf_searchable_dropdown_ngModelChange_9_listener() { return ctx.setConfiguration(); })("searchQueryChange", function PrimaryDetailEditComponent_Template_xf_searchable_dropdown_searchQueryChange_9_listener($event) { return ctx.filterFields($event, []); });
            i0.ɵɵelementEnd()()();
            i0.ɵɵtemplate(10, PrimaryDetailEditComponent_div_10_Template, 2, 1, "div", 6);
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.nameField);
            i0.ɵɵproperty("items", ctx.items);
            i0.ɵɵadvance(5);
            i0.ɵɵtwoWayProperty("ngModel", ctx.picklistField);
            i0.ɵɵproperty("items", ctx.items);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.widgetConfig.configuration.cols);
        } }, dependencies: [i2$1.NgClass, i2$1.NgForOf, i2$1.NgIf, i3.NgControlStatus, i3.NgModel, i1$1.SearchableDropdownComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PrimaryDetailEditComponent, [{
        type: Component,
        args: [{ selector: 'xf-primary-detail-edit', template: "<div class=\"form-group\">\n  <label for=\"name-field\" class=\"control-label\">Name Field</label>\n  <div class=\"mt-1 mb-1\">\n    <xf-searchable-dropdown [(ngModel)]=\"nameField\" (ngModelChange)=\"setConfiguration()\" [items]=\"items\" placeholder=\"Choose field\" (searchQueryChange)=\"filterFields($event, [])\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n<div class=\"form-group mt-3\">\n  <label for=\"picklist-field\" class=\"control-label\">Picklist Field</label>\n  <div class=\"mt-1 mb-1\">\n    <xf-searchable-dropdown [(ngModel)]=\"picklistField\" (ngModelChange)=\"setConfiguration()\" [items]=\"items\" placeholder=\"Choose field\" (searchQueryChange)=\"filterFields($event, [])\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n<div class=\"row mt-2\"\n  *ngFor=\"let col of widgetConfig.configuration.cols; let colIndex = index;\">\n  <div *ngFor=\"let field of col; let fieldIndex = index; let colLast = last; let colFirst = first;\" class=\"col-md-3\" [ngClass]=\"{'pe-0': !colLast, 'px-2': !colFirst, 'pe-3': colLast}\">\n    <div class=\"card mt-2 p-2\">\n      <div class=\"card-title m-0 d-flex\" *ngIf=\"entity\">\n      <div class=\"card-title m-0 d-flex\" *ngIf=\"entity\">\n        <span class=\"flex-grow-1\">\n          {{ entity.fields[field.name].title }}\n        </span>\n        <i class=\"fa-light fa fa-trash text-danger\" role=\"button\" (click)=\"removeField(colIndex, fieldIndex)\"></i>\n      </div>\n    </div>\n  </div>\n  <div *ngIf=\"col.length < 4\" class=\"mt-2\">\n    <xf-searchable-dropdown (ngModelChange)=\"addField(colIndex, $event)\" [ngModel]=\"newField\" [clearValueOnSelect]=\"true\"\n      [items]=\"items\" placeholder=\"+ Add Field\" (searchQueryChange)=\"filterFields($event, [])\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$1.EntityService }, { type: i1$1.UtilityService }], { widgetConfig: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PrimaryDetailEditComponent, { className: "PrimaryDetailEditComponent", filePath: "src/widgets/primary-detail/primary-detail-edit/primary-detail-edit.component.ts", lineNumber: 15 }); })();

const _c0$6 = (a0, a1) => ({ "border-0": a0, "px-xl-4 px-lg-3 px-md-2 pb-1 pt-1 transitions-bottom-linear": a1 });
const _c1$1 = (a0, a1) => ({ "border-left": a0, "background": a1 });
const _c2$1 = a0 => ({ "margin-left-12px": a0 });
function PrimaryDetailViewComponent_div_0_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "xf-editable-field", 9);
    i0.ɵɵlistener("valueChange", function PrimaryDetailViewComponent_div_0_div_2_Template_xf_editable_field_valueChange_1_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.valueChanged(ctx_r1.widgetConfig.configuration.picklistField, $event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("fieldClass", "form-select-sm px-2 w-fit-content border-0")("field", ctx_r1.entity.fields[ctx_r1.widgetConfig.configuration.picklistField])("value", ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField])("readOnly", ctx_r1.mode === "edit");
} }
function PrimaryDetailViewComponent_div_0_div_4_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "xf-editable-field", 10);
    i0.ɵɵlistener("valueChange", function PrimaryDetailViewComponent_div_0_div_4_Template_xf_editable_field_valueChange_1_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.valueChanged(ctx_r1.widgetConfig.configuration.nameField, $event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("fieldClass", "text-wrap-ellipsis font-size-18px")("field", ctx_r1.entity.fields[ctx_r1.widgetConfig.configuration.nameField])("value", ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.nameField])("fieldOptions", ctx_r1.nameFieldOptions)("readOnly", ctx_r1.mode === "edit");
} }
function PrimaryDetailViewComponent_div_0_div_6_div_2_h5_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "h5", 18);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r5 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.entity.fields[field_r5.name].title, ": ");
} }
function PrimaryDetailViewComponent_div_0_div_6_div_2_span_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1, ",");
    i0.ɵɵelementEnd();
} }
function PrimaryDetailViewComponent_div_0_div_6_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, PrimaryDetailViewComponent_div_0_div_6_div_2_h5_1_Template, 2, 1, "h5", 15);
    i0.ɵɵelementStart(2, "div", 16)(3, "xf-editable-field", 17);
    i0.ɵɵlistener("valueChange", function PrimaryDetailViewComponent_div_0_div_6_div_2_Template_xf_editable_field_valueChange_3_listener($event) { const field_r5 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.valueChanged(field_r5.name, $event)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(4, PrimaryDetailViewComponent_div_0_div_6_div_2_span_4_Template, 2, 0, "span", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r5 = ctx.$implicit;
    const colFirst_r6 = ctx.first;
    const colLast_r7 = ctx.last;
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c2$1, !colFirst_r6));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.entity);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.entity.fields[field_r5.name])("value", ctx_r1.entity.values[field_r5.name])("readOnly", true)("fieldClass", "content-font minw-unset mw-unset px-0 ms-1 mb-0");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !colLast_r7);
} }
function PrimaryDetailViewComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 11)(1, "div", 12);
    i0.ɵɵtemplate(2, PrimaryDetailViewComponent_div_0_div_6_div_2_Template, 5, 9, "div", 13);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const col_r8 = ctx.$implicit;
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", col_r8);
} }
function PrimaryDetailViewComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2)(1, "div", 3);
    i0.ɵɵtemplate(2, PrimaryDetailViewComponent_div_0_div_2_Template, 2, 4, "div", 4);
    i0.ɵɵelementStart(3, "div", 5);
    i0.ɵɵtemplate(4, PrimaryDetailViewComponent_div_0_div_4_Template, 2, 5, "div", 6);
    i0.ɵɵelementStart(5, "div", 3);
    i0.ɵɵtemplate(6, PrimaryDetailViewComponent_div_0_div_6_Template, 3, 1, "div", 7);
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(5, _c0$6, ctx_r1.mode === "edit", ctx_r1.mode !== "edit"))("ngStyle", i0.ɵɵpureFunction2(8, _c1$1, "2px solid " + (ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField] === undefined || ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField] === null || (ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField] == null ? null : ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField].color) === null ? "#000" : ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField] == null ? null : ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField].color), "linear-gradient(to right, " + ctx_r1.convertHexToRgbA(ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField] == null ? null : ctx_r1.entity.values[ctx_r1.widgetConfig.configuration.picklistField].color) + "5%, transparent 15%)"));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.widgetConfig.configuration.picklistField && ctx_r1.entity.fields[ctx_r1.widgetConfig.configuration.picklistField]);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.widgetConfig.configuration.nameField && ctx_r1.entity.fields[ctx_r1.widgetConfig.configuration.nameField]);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.widgetConfig == null ? null : ctx_r1.widgetConfig.configuration == null ? null : ctx_r1.widgetConfig.configuration.cols);
} }
function PrimaryDetailViewComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 19)(1, "div", 3)(2, "div", 20);
    i0.ɵɵelement(3, "p", 21);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 5);
    i0.ɵɵelement(5, "p", 21);
    i0.ɵɵelementEnd()();
    i0.ɵɵelement(6, "p", 22);
    i0.ɵɵelementEnd();
} }
class PrimaryDetailViewComponent extends AbstractWidgetComponent {
    constructor(changeDetectorRef, dataProvider, entityService, utilityService) {
        super(changeDetectorRef);
        this.dataProvider = dataProvider;
        this.entityService = entityService;
        let nameFieldOptions = new FieldOptions();
        nameFieldOptions.size = 'large';
        this.nameFieldOptions = nameFieldOptions;
        this.convertHexToRgbA = utilityService.convertHexToRgbA;
    }
    widgetConfigChanged(widgetConfig) {
        this.widgetConfig = widgetConfig;
        this.loadEntity();
    }
    loadEntity() {
        if (!this.context?.module) {
            return;
        }
        let allFieldNames = flattenDeep(this.widgetConfig.configuration.cols?.map((col) => col.map((field) => field.name)));
        if (this.widgetConfig.configuration.nameField) {
            allFieldNames.push(this.widgetConfig.configuration.nameField);
        }
        if (this.widgetConfig.configuration.picklistField) {
            allFieldNames.push(this.widgetConfig.configuration.picklistField);
        }
        let topic = this.context?.uuid + allFieldNames.join('-');
        if (this.existingRequest === topic) {
            return;
        }
        this.existingRequest = topic;
        if (this.entitySubscription) {
            this.entitySubscription.unsubscribe();
        }
        this.entitySubscription = this.entityService.build(this.context.module).pipe(concatMap((entity) => {
            return this.dataProvider.observe(entity, this.context?.uuid, undefined, new Query({ selectedFields: allFieldNames }));
        })).pipe(filter((entityChange) => entityChange.sourceId !== this.widgetConfig.uuid)).subscribe((entityChange) => {
            this.entity = entityChange.entity;
            this.existingRequest = undefined;
            this.changeDetectorRef.detectChanges();
        });
    }
    valueChanged(fieldName, value) {
        if (!this.entity) {
            return;
        }
        this.entity.values[fieldName] = value;
        this.dataProvider.save({
            entity: this.entity,
            changedFields: [fieldName],
            sourceId: this.widgetConfig.uuid || null
        }).subscribe();
    }
    ngOnDestroy() {
        this.entitySubscription?.unsubscribe();
    }
    contextChanged(context) {
        this.context = context;
        this.loadEntity();
    }
    static { this.ɵfac = function PrimaryDetailViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PrimaryDetailViewComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.DataProviderService), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i1$1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PrimaryDetailViewComponent, selectors: [["xf-primary-detail-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 2, consts: [[3, "ngClass", "ngStyle", 4, "ngIf"], ["class", "px-xl-4 px-lg-3 px-md-2 pb-1 pt-1", 4, "ngIf"], [3, "ngClass", "ngStyle"], [1, "row"], ["class", "col-auto mw-50 margin-top-20px margin-bottom-20px pe-0", 4, "ngIf"], [1, "col-auto", "margin-top-16px"], [4, "ngIf"], ["class", "col-md-12", 4, "ngFor", "ngForOf"], [1, "col-auto", "mw-50", "margin-top-20px", "margin-bottom-20px", "pe-0"], [3, "valueChange", "fieldClass", "field", "value", "readOnly"], [3, "valueChange", "fieldClass", "field", "value", "fieldOptions", "readOnly"], [1, "col-md-12"], [1, "d-flex"], ["class", "form-group", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "form-group", 3, "ngClass"], ["class", "d-inline-block content-font mb-0 muted-40", 4, "ngIf"], [1, "d-inline-block"], [3, "valueChange", "field", "value", "readOnly", "fieldClass"], [1, "d-inline-block", "content-font", "mb-0", "muted-40"], [1, "px-xl-4", "px-lg-3", "px-md-2", "pb-1", "pt-1"], [1, "col-auto", "mw-50", "margin-top-16px", "pe-0"], [1, "bg-shimmer", "mb-0", "button-line"], [1, "bg-shimmer", "mt-3", "mb-0", "grid-row-line", "w-200px"]], template: function PrimaryDetailViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PrimaryDetailViewComponent_div_0_Template, 7, 11, "div", 0)(1, PrimaryDetailViewComponent_div_1_Template, 7, 0, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.entity && ctx.widgetConfig);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.entity && !ctx.widgetConfig);
        } }, dependencies: [i2$1.NgClass, i2$1.NgForOf, i2$1.NgIf, i2$1.NgStyle, i1$1.EditableFieldComponent], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PrimaryDetailViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-primary-detail-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div *ngIf=\"entity && widgetConfig\"\n  [ngClass]=\"{'border-0': mode === 'edit', 'px-xl-4 px-lg-3 px-md-2 pb-1 pt-1 transitions-bottom-linear' : mode !== 'edit'}\"\n  [ngStyle]=\"{'border-left': '2px solid ' +  (entity.values[widgetConfig.configuration.picklistField!] === undefined || entity.values[widgetConfig.configuration.picklistField!] === null || entity.values[widgetConfig.configuration.picklistField!]?.color === null ? '#000' : entity.values[widgetConfig.configuration.picklistField!]?.color), 'background': 'linear-gradient(to right, ' + convertHexToRgbA(entity.values[widgetConfig.configuration.picklistField!]?.color) + '5%, transparent 15%)'}\">\n  <div class=\"row\">\n    <div class=\"col-auto mw-50 margin-top-20px margin-bottom-20px pe-0\"\n      *ngIf=\"widgetConfig.configuration.picklistField && entity.fields[widgetConfig.configuration.picklistField]\">\n      <xf-editable-field [fieldClass]=\"'form-select-sm px-2 w-fit-content border-0'\"\n        [field]=\"entity.fields[widgetConfig.configuration.picklistField]\"\n        [value]=\"entity.values[widgetConfig.configuration.picklistField]\"\n        (valueChange)=\"valueChanged(widgetConfig.configuration.picklistField, $event)\" [readOnly]=\"mode === 'edit'\">\n      </xf-editable-field>\n    </div>\n    <div class=\"col-auto margin-top-16px\">\n      <div *ngIf=\"widgetConfig.configuration.nameField && entity.fields[widgetConfig.configuration.nameField]\">\n        <xf-editable-field [fieldClass]=\"'text-wrap-ellipsis font-size-18px'\"\n          [field]=\"entity.fields[widgetConfig.configuration.nameField]\"\n          [value]=\"entity.values[widgetConfig.configuration.nameField]\" [fieldOptions]=\"nameFieldOptions\"\n          (valueChange)=\"valueChanged(widgetConfig.configuration.nameField, $event)\" [readOnly]=\"mode === 'edit'\">\n        </xf-editable-field>\n      </div>\n      <div class=\"row\">\n        <div *ngFor=\"let col of widgetConfig?.configuration?.cols; let colIndex = index\" class=\"col-md-12\">\n          <div class=\"d-flex\">\n            <div class=\"form-group\" [ngClass]=\"{'margin-left-12px': !colFirst}\"\n              *ngFor=\"let field of col; let colFirst = first; let colLast = last;\">\n              <h5 class=\"d-inline-block content-font mb-0 muted-40\" *ngIf=\"entity\">\n                {{ entity.fields[field.name].title }}: </h5>\n              <div class=\"d-inline-block\">\n                <xf-editable-field [field]=\"entity.fields[field.name]\" [value]=\"entity.values[field.name]\"\n                  (valueChange)=\"valueChanged(field.name, $event)\" [readOnly]=\"true\"\n                  [fieldClass]=\"'content-font minw-unset mw-unset px-0 ms-1 mb-0'\"></xf-editable-field>\n              </div>\n              <span *ngIf=\"!colLast\">,</span>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n<div *ngIf=\"!entity && !widgetConfig\" class=\"px-xl-4 px-lg-3 px-md-2 pb-1 pt-1\">\n  <div class=\"row\">\n    <div class=\"col-auto mw-50 margin-top-16px pe-0\">\n      <p class=\"bg-shimmer mb-0 button-line\"></p>\n    </div>\n    <div class=\"col-auto margin-top-16px\">\n      <p class=\"bg-shimmer mb-0 button-line\">\n    </div>\n  </div>\n  <p class=\"bg-shimmer mt-3 mb-0 grid-row-line w-200px\">\n</div>" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$1.DataProviderService }, { type: i1$1.EntityService }, { type: i1$1.UtilityService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PrimaryDetailViewComponent, { className: "PrimaryDetailViewComponent", filePath: "src/widgets/primary-detail/primary-detail-view/primary-detail-view.component.ts", lineNumber: 24 }); })();

class PrimaryDetailConfig extends WidgetConfig {
    constructor(title, configuration) {
        super(title, configuration);
        this.title = title;
        this.configuration = configuration;
        this.type = 'primary-detail';
        this.configuration = configuration && !isArray(configuration) ? configuration : {};
        this.viewComponent = PrimaryDetailViewComponent;
        this.editComponent = PrimaryDetailEditComponent;
        this.showBorder = false;
    }
}

class Widget extends DynamicContent {
    constructor(name, title) {
        super(name, title, 'widget');
        this.name = name;
        this.title = title;
        this.metadata = {
            supportedViews: []
        };
    }
}

class WidgetService {
    constructor(http) {
        this.http = http;
        this.builtInWidgetConfigs = {
            // 'grid': GridConfig,
            'field-group': FieldGroupConfig,
            'primary-detail': PrimaryDetailConfig
        };
        this.widgets = {};
        this.headerService = inject(HeaderService);
        this.localStorage = inject(StorageService);
        const widgets = plainToInstance(Widget, builtInWidgetList);
        this.builtInWidgets = _.keyBy(widgets, 'name');
    }
    loadWidget(name, force = false) {
        this.widgets = extend(this.widgets, this.builtInWidgets);
        if (!this.widgets[name] || force) {
            return this.loadWidgets(name).pipe(map(() => {
                return this.widgets[name];
            }));
        }
        return of(this.widgets[name]);
    }
    getWidgetById(widgets, id) {
        Object.keys(widgets).forEach((widget) => {
            if (widget.uuid === id) {
                return widget;
            }
        });
    }
    getWidget(name, version) {
        return this.http.get(`${API.API_APPMANAGER}contenthub/widget/${name}/${version}`);
    }
    loadDynamicContent(name, type) {
        return this.http.get(API.BASE + FIXED_MODULE.DYNAMIC_CONTENT, {
            params: {
                limit: ALL_RECORDS_SIZE,
                type: type,
                name: name
            }
        }).pipe(map((response) => {
            if (!response['hydra:member'].length) {
                return null;
            }
            return plainToInstance(DynamicContent, response['hydra:member'][0]);
        }));
    }
    loadWidgets(name) {
        return this.getWidget(name, null).pipe(map((response) => {
            const widgets = plainToInstance(Widget, response);
            this.widgets = _.keyBy(widgets, 'name');
            this.widgets = extend(this.widgets, this.builtInWidgets);
            return this.widgets;
        }));
    }
    getRemoteConfig(widget) {
        if (!widget.className) {
            return of();
        }
        const options = {
            remoteEntry: '/widgets/' + widget.name + '/remoteEntry.json',
            exposedModule: widget.exposedModule || './Config',
            className: widget.className
        };
        const component$ = from(loadRemoteModule(options));
        return component$.pipe(map((exposedModules) => {
            const widgetConfigType = exposedModules[options.className];
            return widgetConfigType;
        }));
    }
    castAsWidgetConfig(object, widget) {
        const foundType = this.builtInWidgetConfigs[object.type];
        const excludedKeys = ['@id', '@context'];
        object = omit(object, excludedKeys);
        if (foundType) {
            const instance = plainToInstance(foundType, object);
            return of(instance);
        }
        else {
            return this.getRemoteConfig(widget).pipe(map((widgetConfigType) => plainToInstance(widgetConfigType, object)));
        }
    }
    static { this.ɵfac = function WidgetService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: WidgetService, factory: WidgetService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();

const _c0$5 = ["title"];
function AddWidgetComponent_ng_template_10_Template(rf, ctx) { }
class AddWidgetComponent {
    constructor(activeModal, changeDetectorRef, widgetService, formBuilder, entityService) {
        this.activeModal = activeModal;
        this.changeDetectorRef = changeDetectorRef;
        this.widgetService = widgetService;
        this.entityService = entityService;
        this.titleField = new TextField('widget-title');
        this.titleField.validation.required = true;
        this.titleField.descriptions = {
            singular: 'Title'
        };
        this.widgetFormGroup = formBuilder.group({
            title: ['']
        });
    }
    ngOnInit() {
        this.widgetFormGroup.valueChanges.subscribe((values) => {
            if (!this.widgetConfig) {
                return;
            }
            this.widgetConfig.title = values.title;
            this.ngOnChanges();
        });
    }
    ngAfterViewInit() {
        this.loadWidget();
    }
    loadWidget() {
        this.widgetConfig.isNew = true;
        this.changeDetectorRef.detectChanges();
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.widgetConfig.editComponent);
        this.componentRef.instance.widgetConfig = this.widgetConfig;
        this.componentRef.instance.context = this.context;
        // this.titleFieldComponent.focus();
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    ngOnChanges() {
        if (this.componentRef && this.widgetConfig) {
            this.componentRef.instance.widgetConfig = this.widgetConfig;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    saveAndClose() {
        this.activeModal.close(this.widgetConfig);
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function AddWidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AddWidgetComponent)(i0.ɵɵdirectiveInject(i1$2.NgbActiveModal), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i3.FormBuilder), i0.ɵɵdirectiveInject(i1$1.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AddWidgetComponent, selectors: [["ng-component"]], viewQuery: function AddWidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(_c0$5, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.titleFieldComponent = _t.first);
        } }, inputs: { context: "context", widgetConfig: "widgetConfig", widgetType: "widgetType" }, features: [i0.ɵɵNgOnChangesFeature], decls: 16, vars: 2, consts: [["title", ""], [3, "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body"], [1, "p-3"], ["formControlName", "title", 3, "field"], [1, "hr", "mt-2", "mb-2"], ["xfViewContainer", ""], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-primary", 3, "click"]], template: function AddWidgetComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "form", 1)(1, "div", 2)(2, "h4", 3);
            i0.ɵɵtext(3, "Add a widget");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 4);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.cancel()); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5)(6, "div", 6);
            i0.ɵɵelement(7, "xf-form-field", 7, 0)(9, "div", 8);
            i0.ɵɵtemplate(10, AddWidgetComponent_ng_template_10_Template, 0, 0, "ng-template", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(11, "div", 10)(12, "button", 11);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.cancel()); });
            i0.ɵɵtext(13, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(14, "button", 12);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_14_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.saveAndClose()); });
            i0.ɵɵtext(15, "Save Widget");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.widgetFormGroup);
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("field", ctx.titleField);
        } }, dependencies: [i3.ɵNgNoValidate, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i1$1.FormFieldComponent, i1$1.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AddWidgetComponent, [{
        type: Component,
        args: [{ changeDetection: ChangeDetectionStrategy.OnPush, template: "<form [formGroup]=\"widgetFormGroup\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Add a widget</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body\">\n    <div class=\"p-3\">\n      <xf-form-field [field]=\"titleField\" formControlName=\"title\" #title></xf-form-field>\n      <div class=\"hr mt-2 mb-2\"></div>\n      <ng-template xfViewContainer></ng-template>\n    </div>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-primary\" (click)=\"saveAndClose()\">Save Widget</button>\n  </div>\n\n</form>" }]
    }], () => [{ type: i1$2.NgbActiveModal }, { type: i0.ChangeDetectorRef }, { type: WidgetService }, { type: i3.FormBuilder }, { type: i1$1.EntityService }], { context: [{
            type: Input
        }], widgetConfig: [{
            type: Input
        }], widgetType: [{
            type: Input
        }], viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }], titleFieldComponent: [{
            type: ViewChild,
            args: ['title', { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AddWidgetComponent, { className: "AddWidgetComponent", filePath: "src/view-template/add-widget/add-widget.component.ts", lineNumber: 22 }); })();

const _c0$4 = ["titleElement"];
function EditWidgetComponent_xf_form_field_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-field", 16, 0);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("field", ctx_r0.titleField)("fieldOptions", ctx_r0.titleFieldOptions);
} }
function EditWidgetComponent_button_11_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 17);
    i0.ɵɵlistener("click", function EditWidgetComponent_button_11_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.addTitle()); });
    i0.ɵɵtext(1, "+ Add Title");
    i0.ɵɵelementEnd();
} }
function EditWidgetComponent_ng_template_13_Template(rf, ctx) { }
class EditWidgetComponent {
    constructor(activeModal, changeDetectorRef, formBuilder, element) {
        this.activeModal = activeModal;
        this.changeDetectorRef = changeDetectorRef;
        this.element = element;
        this.showTitleField = false;
        this.titleFieldOptions = new FieldOptions();
        this.formGroup = formBuilder.group({
            title: ['']
        });
        let titleField = new TextField('widget-title');
        titleField.validation.required = false;
        titleField.descriptions = {
            singular: 'Title'
        };
        this.titleField = titleField;
        this.titleFieldOptions.showLabel = false;
    }
    ngOnInit() {
        this.formGroup.controls.title.setValue(this.widgetConfig.title);
        if (this.widgetConfig.title) {
            this.showTitleField = true;
            this.changeDetectorRef.detectChanges();
        }
        this.formGroup.controls.title.valueChanges.subscribe((title) => {
            this.widgetConfig.title = title;
        });
    }
    ngAfterViewInit() {
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.widgetConfig.editComponent);
        this.componentRef.instance.widgetConfig = this.widgetConfig;
        this.componentRef.instance.context = this.context;
        this.changeDetectorRef.detectChanges();
    }
    saveAndClose() {
        if (this.formGroup.invalid) {
            this.formGroup.markAsTouched();
            this.formFields.forEach((formField) => {
                if (!formField.valid) {
                    formField.focus();
                    return;
                }
            });
            return;
        }
        this.activeModal.close(this.widgetConfig);
    }
    addTitle() {
        this.showTitleField = true;
        this.changeDetectorRef.detectChanges();
        setTimeout(() => this.titleElement.focus());
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function EditWidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditWidgetComponent)(i0.ɵɵdirectiveInject(i1$2.NgbActiveModal), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.FormBuilder), i0.ɵɵdirectiveInject(i0.ElementRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditWidgetComponent, selectors: [["xf-edit-widget"]], viewQuery: function EditWidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$4, 5);
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.titleElement = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { context: "context", widgetConfig: "widgetConfig" }, decls: 19, vars: 5, consts: [["titleElement", ""], ["focusInvalidInput", "", 3, "ngSubmit", "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body"], [1, "p-3"], [1, "form-group"], [1, "form-label", 3, "for"], ["formControlName", "title", 3, "field", "fieldOptions", 4, "ngIf"], ["type", "button", "class", "btn btn-link d-block", 3, "click", 4, "ngIf"], [1, "hr", "mt-2", "mb-2"], ["xfViewContainer", ""], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-primary"], ["formControlName", "title", 3, "field", "fieldOptions"], ["type", "button", 1, "btn", "btn-link", "d-block", 3, "click"]], template: function EditWidgetComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "form", 1);
            i0.ɵɵlistener("ngSubmit", function EditWidgetComponent_Template_form_ngSubmit_0_listener() { return ctx.saveAndClose(); });
            i0.ɵɵelementStart(1, "div", 2)(2, "h4", 3);
            i0.ɵɵtext(3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 4);
            i0.ɵɵlistener("click", function EditWidgetComponent_Template_button_click_4_listener() { return ctx.cancel(); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5)(6, "div", 6)(7, "div", 7)(8, "label", 8);
            i0.ɵɵtext(9, "Title");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(10, EditWidgetComponent_xf_form_field_10_Template, 2, 2, "xf-form-field", 9)(11, EditWidgetComponent_button_11_Template, 2, 0, "button", 10);
            i0.ɵɵelementEnd();
            i0.ɵɵelement(12, "div", 11);
            i0.ɵɵtemplate(13, EditWidgetComponent_ng_template_13_Template, 0, 0, "ng-template", 12);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(14, "div", 13)(15, "button", 14);
            i0.ɵɵlistener("click", function EditWidgetComponent_Template_button_click_15_listener() { return ctx.cancel(); });
            i0.ɵɵtext(16, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "button", 15);
            i0.ɵɵtext(18, "Save and Close");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵtextInterpolate1("Edit Widget: ", ctx.widgetConfig.title, "");
            i0.ɵɵadvance(5);
            i0.ɵɵproperty("for", "input-title");
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.showTitleField);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.showTitleField);
        } }, dependencies: [i2$1.NgIf, i3.ɵNgNoValidate, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i1$1.FormFieldComponent, i1$1.FocusInvalidInputDirective, i1$1.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditWidgetComponent, [{
        type: Component,
        args: [{ selector: 'xf-edit-widget', changeDetection: ChangeDetectionStrategy.OnPush, template: "<form [formGroup]=\"formGroup\" (ngSubmit)=\"saveAndClose()\" focusInvalidInput>\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Edit Widget: {{ widgetConfig.title }}</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body\">\n    <div class=\"p-3\">\n      <div class=\"form-group\">\n        <label class=\"form-label\" [for]=\"'input-title'\">Title</label>\n        <xf-form-field *ngIf=\"showTitleField\" [field]=\"titleField\" formControlName=\"title\" #titleElement [fieldOptions]=\"titleFieldOptions\"></xf-form-field>\n        <button type=\"button\" class=\"btn btn-link d-block\" *ngIf=\"!showTitleField\" (click)=\"addTitle()\">+ Add Title</button>\n      </div>\n      <div class=\"hr mt-2 mb-2\"></div>\n      <ng-template xfViewContainer></ng-template>\n    </div>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-primary\">Save and Close</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1$2.NgbActiveModal }, { type: i0.ChangeDetectorRef }, { type: i3.FormBuilder }, { type: i0.ElementRef }], { context: [{
            type: Input
        }], widgetConfig: [{
            type: Input
        }], titleElement: [{
            type: ViewChild,
            args: ['titleElement', { static: false }]
        }], viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditWidgetComponent, { className: "EditWidgetComponent", filePath: "src/view-template/edit-widget/edit-widget.component.ts", lineNumber: 16 }); })();

class AbstractLayoutItemComponent {
    constructor(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService) {
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.utilityService = utilityService;
        this.viewTemplateService = viewTemplateService;
        this.layoutItemChange = new EventEmitter();
        this.gridsterHeight = 150;
        this.fixedGridItemHeight = 50;
        // TODO: - Revisit after PM dicsussion. Do we need the abilit to add multiple containers?
        this.onUpdateGridsterHeight = new Subject();
    }
    ngOnInit() {
        if (this.context.module) {
            this.entityService.build(this.context.module).subscribe((entity) => this.entity = entity);
            this.changeDetectorRef.detectChanges();
        }
        this.widgetSelection$.subscribe((widget) => {
            this.selectedWidget = widget;
        });
        this.utilityService.navigationChanged.subscribe(() => {
            this.gridsterResize();
        });
        this.viewTemplateService.widgetLibraryChanged.subscribe(() => {
            this.gridsterResize();
        });
    }
    addWidget() {
        let modalRef = this.ngbModalService.open(AddWidgetComponent, {
            backdrop: 'static',
            windowClass: 'modal-xlarge'
        });
        modalRef.componentInstance.context = this.context;
        return modalRef.closed.pipe(map((widgetConfig) => {
            widgetConfig.viewTemplate = this.viewTemplate?.uuid || null;
            return widgetConfig;
        }));
    }
    gridsterResize() {
        if (this.gridsterConfig && this.gridsterConfig.api && this.gridsterConfig.api.resize) {
            this.gridsterConfig.api.resize();
        }
    }
    static { this.ɵfac = function AbstractLayoutItemComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractLayoutItemComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$2.NgbModal), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(ViewTemplateService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractLayoutItemComponent, selectors: [["xf-abstract-layout-item"]], inputs: { layoutItem: "layoutItem", mode: "mode", viewTemplate: "viewTemplate", context: "context", selectedWidget: "selectedWidget", widgetSelection$: "widgetSelection$", gridsterConfig: "gridsterConfig" }, outputs: { layoutItemChange: "layoutItemChange" }, decls: 0, vars: 0, template: function AbstractLayoutItemComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractLayoutItemComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-layout-item',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$2.NgbModal }, { type: i1$1.EntityService }, { type: WidgetService }, { type: i1$1.UtilityService }, { type: ViewTemplateService }], { layoutItem: [{
            type: Input
        }], mode: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], context: [{
            type: Input
        }], selectedWidget: [{
            type: Input
        }], widgetSelection$: [{
            type: Input
        }], gridsterConfig: [{
            type: Input
        }], layoutItemChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractLayoutItemComponent, { className: "AbstractLayoutItemComponent", filePath: "src/view-template/layout-item/abstract-layout-item.component.ts", lineNumber: 21 }); })();

const _c0$3 = a0 => ({ "headless": a0 });
function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "xf-widget", 6);
    i0.ɵɵlistener("edit", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_edit_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.editWidget($event, widgetIndex_r2)); })("delete", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_delete_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.deleteWidget($event, widgetIndex_r2)); })("clone", function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template_xf_widget_clone_1_listener($event) { i0.ɵɵrestoreView(_r1); const widgetIndex_r2 = i0.ɵɵnextContext().index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.cloneWidget($event, widgetIndex_r2)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const content_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("config", content_r4.config)("context", ctx_r2.context)("mode", ctx_r2.mode)("showLayoutControls", true)("updateHeight", ctx_r2.onUpdateGridsterHeight)("widgetId", content_r4.id);
} }
function ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "xf-layout-item", 7);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const content_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("context", ctx_r2.context)("layoutItem", content_r4)("viewTemplate", ctx_r2.viewTemplate)("mode", ctx_r2.mode)("widgetSelection$", ctx_r2.widgetSelection$);
} }
function ContainerLayoutComponent_ng_container_3_gridster_item_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "gridster-item", 5);
    i0.ɵɵtemplate(1, ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_1_Template, 2, 6, "ng-container", 3)(2, ContainerLayoutComponent_ng_container_3_gridster_item_1_ng_container_2_Template, 2, 5, "ng-container", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const content_r4 = ctx.$implicit;
    i0.ɵɵproperty("item", content_r4);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", content_r4.type === "widget");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", content_r4.type === "tabs");
} }
function ContainerLayoutComponent_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, ContainerLayoutComponent_ng_container_3_gridster_item_1_Template, 3, 3, "gridster-item", 4);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.layoutItem.contents);
} }
class ContainerLayoutComponent extends AbstractLayoutItemComponent {
    constructor(route, changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService, http) {
        super(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService);
        this.route = route;
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.http = http;
        this.displayHeader = true;
        this.inputs = this.route.snapshot.queryParamMap.get('inputs') || undefined;
        // this.context$ = new BehaviorSubject<ViewTemplateContext>(new ViewTemplateContext(undefined, undefined, this.inputs));
    }
    editWidget(widgetConfig, widgetIndex) {
        this.layoutItem.contents[widgetIndex].config = widgetConfig;
        this.layoutItemChange.emit(this.layoutItem);
    }
    cloneWidget(widgetConfig, widgetIndex) {
        let clonedWidgetConfig = cloneDeep(widgetConfig);
        if (isString(clonedWidgetConfig)) {
            this.http.get(clonedWidgetConfig).subscribe((widgetConfig) => {
                delete widgetConfig.uuid;
                let widget = new ViewLayoutItem.Widget(widgetConfig);
                this.layoutItem.contents.splice(widgetIndex, 0, widget);
                this.layoutItemChange.emit(this.layoutItem);
            });
        }
        else {
            delete clonedWidgetConfig.uuid;
            let widget = new ViewLayoutItem.Widget(clonedWidgetConfig);
            this.layoutItem.contents.splice(widgetIndex, 0, widget);
            this.layoutItemChange.emit(this.layoutItem);
        }
    }
    deleteWidget(widgetConfig, widgetIndex) {
        this.layoutItem.contents.splice(widgetIndex, 1);
        this.layoutItemChange.emit(this.layoutItem);
    }
    allowDrop(ev) {
        ev.preventDefault();
    }
    getWidgetConfig(widget) {
        let widgetType$;
        if (widget.remote && widget.className) {
            widgetType$ = this.widgetService.getRemoteConfig(widget);
        }
        else {
            widgetType$ = of(this.widgetService.builtInWidgetConfigs[widget?.name || '']);
        }
        return widgetType$.pipe(map$1((widgetType) => {
            let widgetConfig = new widgetType('', {});
            widgetConfig.type = widget?.name || '';
            widgetConfig.isNew = true;
            return widgetConfig;
        }));
    }
    onDropWidget(ev) {
        if (ev.srcElement.id === this.layoutItem.id) {
            if (this.selectedWidget.type === 'widget') {
                this.getWidgetConfig(this.selectedWidget).subscribe((widgetConfig) => {
                    let modalRef = this.ngbModalService.open(AddWidgetComponent, {
                        backdrop: 'static',
                        windowClass: 'modal-xlarge'
                    });
                    modalRef.componentInstance.widgetConfig = widgetConfig;
                    modalRef.componentInstance.context = this.context;
                    modalRef.closed.subscribe((widgetConfig) => {
                        widgetConfig.viewTemplate = this.viewTemplate?.uuid;
                        let widgetCopy = new ViewLayoutItem.Widget(widgetConfig);
                        widgetCopy.rows = widgetConfig.defaultHeight;
                        this.layoutItem?.contents.push(widgetCopy);
                        this.changeDetectorRef.detectChanges();
                    });
                });
            }
            else if (this.selectedWidget.type === 'tabs') {
                let widgetAdd = cloneDeep(this.selectedWidget);
                this.layoutItem?.contents.push(widgetAdd);
                this.changeDetectorRef.detectChanges();
            }
        }
    }
    static { this.ɵfac = function ContainerLayoutComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ContainerLayoutComponent)(i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$2.NgbModal), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(ViewTemplateService), i0.ɵɵdirectiveInject(i1.HttpClient)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ContainerLayoutComponent, selectors: [["xf-container"]], inputs: { displayHeader: "displayHeader" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 4, vars: 8, consts: [[1, "template-container", 3, "ngClass"], [1, "container-content"], [1, "gridster-layout", 3, "drop", "dragover", "options", "id"], [4, "ngIf"], ["class", "gridster-item", 3, "item", 4, "ngFor", "ngForOf"], [1, "gridster-item", 3, "item"], [3, "edit", "delete", "clone", "config", "context", "mode", "showLayoutControls", "updateHeight", "widgetId"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"]], template: function ContainerLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "gridster", 2);
            i0.ɵɵlistener("drop", function ContainerLayoutComponent_Template_gridster_drop_2_listener($event) { return ctx.onDropWidget($event); })("dragover", function ContainerLayoutComponent_Template_gridster_dragover_2_listener($event) { return ctx.allowDrop($event); });
            i0.ɵɵtemplate(3, ContainerLayoutComponent_ng_container_3_Template, 2, 1, "ng-container", 3);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c0$3, !ctx.displayHeader));
            i0.ɵɵadvance();
            i0.ɵɵstyleProp("height", ctx.gridsterHeight, "px");
            i0.ɵɵadvance();
            i0.ɵɵpropertyInterpolate("id", ctx.layoutItem.id);
            i0.ɵɵproperty("options", ctx.gridsterConfig);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.layoutItem && ctx.layoutItem.contents.length > 0);
        } }, styles: [".template-container[_ngcontent-%COMP%]{background:var(--template-container-bg-color);padding:0}.template-container.headless[_ngcontent-%COMP%]{margin:0}.template-container[_ngcontent-%COMP%]   .container-name[_ngcontent-%COMP%]{border-bottom:1px solid var(--element-secondary-border-color);height:40px}.template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   grdister[_ngcontent-%COMP%]   .moobile[_ngcontent-%COMP%]{overflow-y:unset;overflow-x:unset}.template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%], .template-container[_ngcontent-%COMP%]   .container-content[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%]   .gridster-item[_ngcontent-%COMP%]{background:inherit}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ContainerLayoutComponent, [{
        type: Component,
        args: [{ selector: 'xf-container', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"template-container\" [ngClass]=\"{'headless': !displayHeader}\">\n  <div class=\"container-content\" [style.height.px]=\"gridsterHeight\">\n    <!-- Make a directive or component -->\n\n    <gridster [options]=\"gridsterConfig\" (drop)=\"onDropWidget($event)\" (dragover)=\"allowDrop($event)\"\n      class=\"gridster-layout\" id=\"{{layoutItem.id}}\">\n      <ng-container *ngIf=\"layoutItem && layoutItem.contents.length > 0\">\n\n        <gridster-item class=\"gridster-item\" [item]=\"content\" *ngFor=\"let content of layoutItem.contents; let widgetIndex = index\">\n          <ng-container *ngIf=\"content.type === 'widget'\">\n            <xf-widget [config]=\"content.config\" [context]=\"context\" [mode]=\"mode\" [showLayoutControls]=\"true\"\n              (edit)=\"editWidget($event, widgetIndex)\" (delete)=\"deleteWidget($event, widgetIndex)\"\n              (clone)=\"cloneWidget($event, widgetIndex)\" [updateHeight]=\"onUpdateGridsterHeight\" [widgetId]=\"content.id\">\n            </xf-widget>\n          </ng-container>\n          <ng-container *ngIf=\"content.type === 'tabs'\">\n            <xf-layout-item [context]=\"context\" [layoutItem]=\"content\" [viewTemplate]=\"viewTemplate\" [mode]=\"mode\"\n              [widgetSelection$]=\"widgetSelection$\"></xf-layout-item>\n          </ng-container>\n\n\n        </gridster-item>\n      </ng-container>\n\n    </gridster>\n\n\n  </div>\n\n</div>\n", styles: [".template-container{background:var(--template-container-bg-color);padding:0}.template-container.headless{margin:0}.template-container .container-name{border-bottom:1px solid var(--element-secondary-border-color);height:40px}.template-container .container-content grdister .moobile{overflow-y:unset;overflow-x:unset}.template-container .container-content .gridster-layout,.template-container .container-content .gridster-layout .gridster-item{background:inherit}\n"] }]
    }], () => [{ type: i2.ActivatedRoute }, { type: i0.ChangeDetectorRef }, { type: i1$2.NgbModal }, { type: i1$1.EntityService }, { type: WidgetService }, { type: i1$1.UtilityService }, { type: ViewTemplateService }, { type: i1.HttpClient }], { displayHeader: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ContainerLayoutComponent, { className: "ContainerLayoutComponent", filePath: "src/view-template/container-layout/container-layout.component.ts", lineNumber: 24 }); })();

class TabLayoutComponent extends AbstractLayoutItemComponent {
    constructor(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService) {
        super(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService);
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.utilityService = utilityService;
        this.viewTemplateService = viewTemplateService;
    }
    static { this.ɵfac = function TabLayoutComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TabLayoutComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$2.NgbModal), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(ViewTemplateService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TabLayoutComponent, selectors: [["lib-tab-layout"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 3, vars: 7, consts: [[1, "tab"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$", "displayHeader", "gridsterConfig"]], template: function TabLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵelementContainerStart(1);
            i0.ɵɵelement(2, "xf-container", 1);
            i0.ɵɵelementContainerEnd();
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("context", ctx.context)("layoutItem", ctx.layoutItem)("viewTemplate", ctx.viewTemplate)("mode", ctx.mode)("widgetSelection$", ctx.widgetSelection$)("displayHeader", false)("gridsterConfig", ctx.gridsterConfig);
        } }, dependencies: [ContainerLayoutComponent], styles: [".tab[_ngcontent-%COMP%]{background:var(--secondary-topbar-bg-color);width:inherit;align-items:stretch;height:100%;min-height:100px}.tab[_ngcontent-%COMP%]   .gridster-layout[_ngcontent-%COMP%]{background:inherit;height:50vh}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TabLayoutComponent, [{
        type: Component,
        args: [{ selector: 'lib-tab-layout', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"tab\">\n  <ng-container>\n    <xf-container [context]=\"context\" [layoutItem]=\"layoutItem\" [viewTemplate]=\"viewTemplate\" [mode]=\"mode\"\n      [widgetSelection$]=\"widgetSelection$\" [displayHeader]=\"false\" [gridsterConfig]=\"gridsterConfig\"></xf-container>\n  </ng-container>\n</div>\n", styles: [".tab{background:var(--secondary-topbar-bg-color);width:inherit;align-items:stretch;height:100%;min-height:100px}.tab .gridster-layout{background:inherit;height:50vh}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$2.NgbModal }, { type: i1$1.EntityService }, { type: WidgetService }, { type: i1$1.UtilityService }, { type: ViewTemplateService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TabLayoutComponent, { className: "TabLayoutComponent", filePath: "src/view-template/tab-layout/tab-layout.component.ts", lineNumber: 15 }); })();

const _c0$2 = a0 => ({ "tab-selected": a0 });
function TabsLayoutComponent_li_3_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li", 6)(1, "a", 7);
    i0.ɵɵlistener("click", function TabsLayoutComponent_li_3_Template_a_click_1_listener() { const i_r2 = i0.ɵɵrestoreView(_r1).index; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.selectTab(i_r2)); });
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tab_r4 = ctx.$implicit;
    const i_r2 = ctx.index;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(2, _c0$2, i_r2 === ctx_r2.activeTab));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(tab_r4.name);
} }
class TabsLayoutComponent extends AbstractLayoutItemComponent {
    constructor(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService) {
        super(changeDetectorRef, ngbModalService, entityService, widgetService, utilityService, viewTemplateService);
        this.changeDetectorRef = changeDetectorRef;
        this.ngbModalService = ngbModalService;
        this.entityService = entityService;
        this.widgetService = widgetService;
        this.utilityService = utilityService;
        this.viewTemplateService = viewTemplateService;
        this.activeTab = 0;
    }
    selectTab(index) {
        this.activeTab = index;
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function TabsLayoutComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TabsLayoutComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$2.NgbModal), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(ViewTemplateService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TabsLayoutComponent, selectors: [["xf-tabs-layout"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 6, vars: 7, consts: [[1, "tabs"], [1, "d-flex", "header"], ["ngbNav", "", "orientation", "vertical", 1, "nav", "m-2", 3, "activeIdChange", "activeId"], ["ngbNavItem", "i", "class", "tab-item", 4, "ngFor", "ngForOf"], [1, "tab-content", "m-0", "p-0"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"], ["ngbNavItem", "i", 1, "tab-item"], [1, "tab-header", 3, "click", "ngClass"]], template: function TabsLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "ul", 2);
            i0.ɵɵtwoWayListener("activeIdChange", function TabsLayoutComponent_Template_ul_activeIdChange_2_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.activeTab, $event) || (ctx.activeTab = $event); return $event; });
            i0.ɵɵtemplate(3, TabsLayoutComponent_li_3_Template, 3, 4, "li", 3);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(4, "div", 4);
            i0.ɵɵelement(5, "xf-layout-item", 5);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("activeId", ctx.activeTab);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.layoutItem.contents);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("context", ctx.context)("layoutItem", ctx.layoutItem.contents[ctx.activeTab])("viewTemplate", ctx.viewTemplate)("mode", ctx.mode)("widgetSelection$", ctx.widgetSelection$);
        } }, styles: [".tabs[_ngcontent-%COMP%]{background:var(--secondary-topbar-bg-color);border:1px solid var(--element-secondary-border-color);align-items:stretch;height:100%;min-height:100px}.tabs[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]{height:40px;border-bottom:1px solid var(--element-secondary-border-color)}.tabs[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]{cursor:pointer}.tabs[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   .tab-item[_ngcontent-%COMP%]{border-right:1px solid var(--btn-secondary-border-color);justify-content:center;display:flex;padding:0 10px}.tabs[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   .tab-item[_ngcontent-%COMP%]   .tab-header[_ngcontent-%COMP%]{color:inherit;text-decoration:none}.tabs[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]   .tab-item[_ngcontent-%COMP%]   .tab-header.tab-selected[_ngcontent-%COMP%]{border-bottom:1px solid var(--btn-secondary-border-color)}.tabs[_ngcontent-%COMP%]   .tab-content[_ngcontent-%COMP%]{width:inherit;height:100%}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TabsLayoutComponent, [{
        type: Component,
        args: [{ selector: 'xf-tabs-layout', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"tabs\">\n  <div class=\"d-flex header\">\n    <ul ngbNav [(activeId)]=\"activeTab\" class=\"nav m-2\" orientation=\"vertical\">\n      <li ngbNavItem=\"i\" class=\"tab-item\" *ngFor=\"let tab of layoutItem.contents; let i = index\">\n        <a (click)=\"selectTab(i)\" class=\"tab-header\" [ngClass]=\"{'tab-selected': i === activeTab}\">{{tab.name}}</a>\n      </li>\n    </ul>\n  </div>\n  <div class=\"tab-content m-0 p-0\">\n    <xf-layout-item [context]=\"context\" [layoutItem]=\"layoutItem.contents[activeTab]\" [viewTemplate]=\"viewTemplate\"\n      [mode]=\"mode\" [widgetSelection$]=\"widgetSelection$\"></xf-layout-item>\n  </div>\n</div>\n", styles: [".tabs{background:var(--secondary-topbar-bg-color);border:1px solid var(--element-secondary-border-color);align-items:stretch;height:100%;min-height:100px}.tabs .header{height:40px;border-bottom:1px solid var(--element-secondary-border-color)}.tabs .header ul{cursor:pointer}.tabs .header ul .tab-item{border-right:1px solid var(--btn-secondary-border-color);justify-content:center;display:flex;padding:0 10px}.tabs .header ul .tab-item .tab-header{color:inherit;text-decoration:none}.tabs .header ul .tab-item .tab-header.tab-selected{border-bottom:1px solid var(--btn-secondary-border-color)}.tabs .tab-content{width:inherit;height:100%}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$2.NgbModal }, { type: i1$1.EntityService }, { type: WidgetService }, { type: i1$1.UtilityService }, { type: ViewTemplateService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TabsLayoutComponent, { className: "TabsLayoutComponent", filePath: "src/view-template/tabs-layout/tabs-layout.component.ts", lineNumber: 15 }); })();

const _c0$1 = ["widgetHolder"];
const _c1 = (a0, a1) => [a0, a1];
const _c2 = a0 => ({ "card-body p-0": a0 });
function WidgetComponent_div_0_div_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 13);
} }
function WidgetComponent_div_0_div_1_div_6_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 19);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r2.clone.emit(ctx_r2.widgetConfig)); });
    i0.ɵɵelement(1, "i", 20);
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_0_div_1_div_6_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 21);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_button_2_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r2.delete.emit(ctx_r2.widgetConfig)); });
    i0.ɵɵelement(1, "i", 22);
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_0_div_1_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, WidgetComponent_div_0_div_1_div_6_button_1_Template, 2, 0, "button", 15)(2, WidgetComponent_div_0_div_1_div_6_button_2_Template, 2, 0, "button", 16);
    i0.ɵɵelementStart(3, "button", 17);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r2 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r2.openEditModal()); });
    i0.ɵɵelement(4, "i", 18);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.showLayoutControls);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.showLayoutControls);
} }
function WidgetComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7)(1, "div", 8)(2, "div", 9);
    i0.ɵɵtemplate(3, WidgetComponent_div_0_div_1_span_3_Template, 1, 0, "span", 10);
    i0.ɵɵelementStart(4, "h5", 11);
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(6, WidgetComponent_div_0_div_1_div_6_Template, 5, 2, "div", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r2.mode === "edit" && ctx_r2.showLayoutControls);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.title);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.mode !== "view");
} }
function WidgetComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, WidgetComponent_div_0_div_1_Template, 7, 3, "div", 4);
    i0.ɵɵelementStart(2, "div", 5);
    i0.ɵɵelement(3, "div", 6)(4, "div", null, 0);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵclassMapInterpolate1("", ctx_r2.widgetClass, " transitions-bottom-linear widget");
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(6, _c1, (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder) || ctx_r2.mode !== "view" ? "card" : "no-border", ctx_r2.mode === "edit" ? "editing" : ""));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder) && (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.title) !== "" || ctx_r2.mode === "edit");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c2, ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder));
} }
function WidgetComponent_div_1_a_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 27);
    i0.ɵɵlistener("click", function WidgetComponent_div_1_a_4_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.logExpanded = !ctx_r2.logExpanded); });
    i0.ɵɵtext(1, "Show Build Log");
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_1_pre_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "pre", 28);
    i0.ɵɵtext(1, "        ");
    i0.ɵɵelement(2, "div", 29);
    i0.ɵɵtext(3, "\n      ");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("innerHTML", ctx_r2.buildLogHtml, i0.ɵɵsanitizeHtml);
} }
function WidgetComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 7)(2, "div", 23);
    i0.ɵɵtext(3);
    i0.ɵɵtemplate(4, WidgetComponent_div_1_a_4_Template, 2, 0, "a", 24)(5, WidgetComponent_div_1_pre_5_Template, 4, 1, "pre", 25);
    i0.ɵɵelement(6, "i", 26);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" The widget \"", ctx_r2.widget == null ? null : ctx_r2.widget.name, "\" is publishing. ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.widgetPermission.indexOf("update") > -1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.widgetPermission.indexOf("update") > -1 && ctx_r2.logExpanded);
} }
function WidgetComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 7)(2, "div", 23);
    i0.ɵɵtext(3);
    i0.ɵɵelementStart(4, "a", 30);
    i0.ɵɵlistener("click", function WidgetComponent_div_2_Template_a_click_4_listener() { i0.ɵɵrestoreView(_r6); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.reload()); });
    i0.ɵɵtext(5, "Refresh page");
    i0.ɵɵelementEnd();
    i0.ɵɵtext(6, " to see changes. ");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" There is an updated version of the \"", ctx_r2.widget == null ? null : ctx_r2.widget.name, "\" widget available. ");
} }
class WidgetComponent {
    constructor(widgetService, http, dataProvider, ngbModalService, permissionService, changeDetectorRef, entityService, apiService, parentDraggable, embedService) {
        this.widgetService = widgetService;
        this.http = http;
        this.dataProvider = dataProvider;
        this.ngbModalService = ngbModalService;
        this.permissionService = permissionService;
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.apiService = apiService;
        this.parentDraggable = parentDraggable;
        this.embedService = embedService;
        this.edit = new EventEmitter();
        this.clone = new EventEmitter();
        this.delete = new EventEmitter();
        this.showLayoutControls = false;
        this.showMenu = false;
        this.widgetPermission = [];
        this.logExpanded = false;
        this.buildLogHtml = '';
        this.reloadRequired = false;
    }
    ngOnInit() {
        this.widgetPermission = this.permissionService.getPermission(FIXED_MODULE.DYNAMIC_CONTENT);
    }
    ngAfterViewInit() {
        if (this.parentDraggable) {
            this.parentDraggable.registerDragHandle(this.dndHandle);
        }
    }
    ngOnChanges(changes) {
        if (changes.config && this.config) {
            this.subscription?.unsubscribe();
            this.setConfig().subscribe(() => {
                if (this.widgetConfig) {
                    this.componentRef.instance.widgetConfigChanged(this.widgetConfig);
                }
            });
        }
        else if (changes.mode && this.componentRef) {
            this.componentRef.instance.mode = this.mode;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
        else if (changes.context) {
            this.componentRef.instance.contextChanged(changes.context.currentValue);
        }
    }
    createWidgetComponent(widgetConfig) {
        this.viewContainer.clear();
        this.componentRef = this.viewContainer.createComponent(widgetConfig.viewComponent);
        this.componentRef.instance.widgetConfig = widgetConfig;
        this.componentRef.instance.mode = this.mode;
        this.componentRef.instance.widgetId = this.widgetId;
        this.componentRef.instance.updateHeight = this.updateHeight;
        this.componentRef.instance.context = this.context;
        this.changeDetectorRef.detectChanges();
    }
    watchMetadataChanges(widgetUuid) {
        let query = new Query({
            selectedFields: ['buildLog', 'publishing']
        });
        return this.entityService.build(FIXED_MODULE.DYNAMIC_CONTENT).pipe(concatMap$1((entity) => {
            return this.dataProvider.observe(entity, widgetUuid, undefined, query).pipe(tap((entityChange) => {
                if (!this.widget) {
                    return;
                }
                this.widget.publishing = entityChange.entity.values.publishing;
                this.widget.buildLog = entityChange.entity.values.buildLog;
                if (this.widget.publishing) {
                    this.reloadRequired = true;
                }
                this.setBuildLogHtml();
                this.changeDetectorRef.detectChanges();
            }), filter$1((entityChange) => {
                return !isUndefined(entityChange.entity.values.publishing) && !entityChange.entity.values.publishing;
            }));
        }));
    }
    getConfig(configUuid) {
        // TODO: Add widget-configs mmd
        let widgetConfigEntity = new Entity(FIXED_MODULE.WIDGET_CONFIGS);
        widgetConfigEntity.baseUrl = API.API_APPMANAGER;
        return this.apiService.getRecord(widgetConfigEntity, configUuid, WidgetConfig);
    }
    setConfig() {
        let getWidgetConfig$;
        getWidgetConfig$ = of('');
        return getWidgetConfig$.pipe(concatMap$1(() => this.widgetService.castAsWidgetConfig(this.config, this.widgetData).pipe(map$1((widgetConfig) => {
            this.widgetConfig = widgetConfig;
            this.changeDetectorRef.detectChanges();
            return this.createWidgetComponent(widgetConfig);
        }))));
    }
    setBuildLogHtml() {
        this.buildLogHtml = this.widget?.buildLog?.replace(/\\n/g, '<br>') || '';
    }
    ngOnDestroy() {
        this.subscription?.unsubscribe();
    }
    openEditModal() {
        if (!this.widgetConfig) {
            return;
        }
        let modalRef = this.ngbModalService.open(EditWidgetComponent, {
            backdrop: 'static',
            windowClass: 'modal-xlarge'
        });
        modalRef.componentInstance.widgetConfig = cloneDeep(this.widgetConfig);
        modalRef.componentInstance.context = this.context;
        modalRef.closed.subscribe((widgetConfig) => {
            this.edit.emit(widgetConfig);
            this.widgetConfig = widgetConfig;
            this.componentRef.instance.widgetConfig = widgetConfig;
            this.componentRef.instance.widgetConfigChanged(widgetConfig);
        });
    }
    reload() {
        location.reload();
    }
    static { this.ɵfac = function WidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetComponent)(i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i1$1.DataProviderService), i0.ɵɵdirectiveInject(i1$2.NgbModal), i0.ɵɵdirectiveInject(i1$1.PermissionService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i1$1.ApiService), i0.ɵɵdirectiveInject(i4.DndDraggableDirective, 8), i0.ɵɵdirectiveInject(i1$1.EmbedService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WidgetComponent, selectors: [["xf-widget"]], viewQuery: function WidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0$1, 5, ViewContainerRef);
            i0.ɵɵviewQuery(DndHandleDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dndHandle = _t.first);
        } }, inputs: { config: "config", widgetData: "widgetData", context: "context", mode: "mode", widgetClass: "widgetClass", showLayoutControls: "showLayoutControls", updateHeight: "updateHeight", widgetId: "widgetId" }, outputs: { edit: "edit", clone: "clone", delete: "delete" }, features: [i0.ɵɵProvidersFeature([DndDraggableDirective]), i0.ɵɵNgOnChangesFeature], decls: 3, vars: 3, consts: [["widgetHolder", ""], [3, "class", "ngClass", 4, "ngIf"], [4, "ngIf"], [3, "ngClass"], ["class", "card-header", 4, "ngIf"], [1, "", 3, "ngClass"], [1, "card-overlay"], [1, "card-header"], [1, "row"], [1, "col", "d-flex"], ["class", "fa fa-grip-horizontal fa-light align-self-center cursor-move margin-right-8px", "role", "grab", "dndHandle", "", 4, "ngIf"], [1, "pt-2", "pb-2", "mb-0", "container-title-font"], ["class", "col d-flex justify-content-end gap-2", 4, "ngIf"], ["role", "grab", "dndHandle", "", 1, "fa", "fa-grip-horizontal", "fa-light", "align-self-center", "cursor-move", "margin-right-8px"], [1, "col", "d-flex", "justify-content-end", "gap-2"], ["class", "btn btn-secondary btn-xs", 3, "click", 4, "ngIf"], ["type", "button", "class", "btn btn-danger btn-xs", 3, "click", 4, "ngIf"], ["type", "button", 1, "btn", "btn-primary", "btn-xs", 3, "click"], [1, "fa-light", "fa", "fa-pencil"], [1, "btn", "btn-secondary", "btn-xs", 3, "click"], [1, "fa", "fa-clone"], ["type", "button", 1, "btn", "btn-danger", "btn-xs", 3, "click"], [1, "fa-light", "fa", "fa-trash"], [1, "alert", "alert-warning"], ["class", "btn btn-link", 3, "click", 4, "ngIf"], ["class", "import-log", 4, "ngIf"], [1, "fa", "fa-spin", "fa-spinner"], [1, "btn", "btn-link", 3, "click"], [1, "import-log"], [3, "innerHTML"], ["href", ".", 1, "btn", "btn-link", "d-inline", 3, "click"]], template: function WidgetComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, WidgetComponent_div_0_Template, 6, 11, "div", 1)(1, WidgetComponent_div_1_Template, 7, 3, "div", 2)(2, WidgetComponent_div_2_Template, 7, 1, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !(ctx.widget == null ? null : ctx.widget.publishing) && !ctx.reloadRequired);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.widget == null ? null : ctx.widget.publishing);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !(ctx.widget == null ? null : ctx.widget.publishing) && ctx.reloadRequired);
        } }, dependencies: [i2$1.NgClass, i2$1.NgIf, i4.DndHandleDirective], styles: [".widget[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]{visibility:hidden}.widget[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]:hover   .menu[_ngcontent-%COMP%]{visibility:visible}.widget[_ngcontent-%COMP%]   .editing[_ngcontent-%COMP%]   .card-body[_ngcontent-%COMP%]{max-height:200px;position:relative;overflow:hidden}.widget[_ngcontent-%COMP%]   .editing[_ngcontent-%COMP%]   .card-body[_ngcontent-%COMP%]   .card-overlay[_ngcontent-%COMP%]{position:absolute;top:0;left:0;width:100%;height:200px;z-index:2;background-color:#fff0;background-image:linear-gradient(rgba(255,255,255,0),rgba(255,255,255,0) 100px,var(--card-header-bg-color));background-repeat:no-repeat}.widget[_ngcontent-%COMP%]   .dropdown-toggle[_ngcontent-%COMP%]:after{display:none}.widget[_ngcontent-%COMP%]   pre[_ngcontent-%COMP%]{white-space:pre-wrap;max-width:500px}.no-border[_ngcontent-%COMP%]{background-color:var(--card-bg-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetComponent, [{
        type: Component,
        args: [{ selector: 'xf-widget', providers: [DndDraggableDirective], changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"{{widgetClass}} transitions-bottom-linear widget\"\n  [ngClass]=\"[(widgetConfig?.showBorder || mode !== 'view') ? 'card': 'no-border', mode === 'edit' ? 'editing': '']\"\n  *ngIf=\"!widget?.publishing && !reloadRequired\">\n  <div class=\"card-header\" *ngIf=\"(widgetConfig?.showBorder && widgetConfig?.title !== '') || mode === 'edit'\">\n    <div class=\"row\">\n      <div class=\"col d-flex\">\n        <span *ngIf=\"mode === 'edit' && showLayoutControls\"\n          class=\"fa fa-grip-horizontal fa-light align-self-center cursor-move margin-right-8px\" role=\"grab\"\n          dndHandle></span>\n        <h5 class=\"pt-2 pb-2 mb-0 container-title-font\">{{ widgetConfig?.title }}</h5>\n      </div>\n      <div class=\"col d-flex justify-content-end gap-2\" *ngIf=\"mode !== 'view'\">\n        <button class=\"btn btn-secondary btn-xs\" (click)=\"clone.emit(widgetConfig)\" *ngIf=\"showLayoutControls\">\n          <i class=\"fa fa-clone\"></i>\n        </button>\n        <button type=\"button\" class=\"btn btn-danger btn-xs\" *ngIf=\"showLayoutControls\"\n          (click)=\"delete.emit(widgetConfig)\">\n          <i class=\"fa-light fa fa-trash\"></i>\n        </button>\n        <button type=\"button\" class=\"btn btn-primary btn-xs\" (click)=\"openEditModal()\">\n          <i class=\"fa-light fa fa-pencil\"></i>\n        </button>\n      </div>\n    </div>\n  </div>\n  <div class=\"\" [ngClass]=\"{'card-body p-0': widgetConfig?.showBorder}\">\n    <div class=\"card-overlay\"></div>\n    <div #widgetHolder></div>\n  </div>\n</div>\n<div *ngIf=\"widget?.publishing\">\n  <div class=\"card-header\">\n    <div class=\"alert alert-warning\">\n      The widget \"{{ widget?.name }}\" is publishing.\n      <a class=\"btn btn-link\" (click)=\"logExpanded = !logExpanded\" *ngIf=\"widgetPermission.indexOf('update') > -1\">Show Build Log</a>\n      <pre class=\"import-log\" *ngIf=\"widgetPermission.indexOf('update') > -1 && logExpanded\">\n        <div [innerHTML]=\"buildLogHtml\"></div>\n      </pre>\n      <i class=\"fa fa-spin fa-spinner\"></i>\n    </div>\n  </div>\n</div>\n<div *ngIf=\"!widget?.publishing && reloadRequired\">\n  <div class=\"card-header\">\n    <div class=\"alert alert-warning\">\n      There is an updated version of the \"{{ widget?.name }}\" widget available.\n      <a (click)=\"reload()\" href=\".\" class=\"btn btn-link d-inline\">Refresh page</a> to see changes.\n    </div>\n  </div>\n</div>\n", styles: [".widget .card .menu{visibility:hidden}.widget .card:hover .menu{visibility:visible}.widget .editing .card-body{max-height:200px;position:relative;overflow:hidden}.widget .editing .card-body .card-overlay{position:absolute;top:0;left:0;width:100%;height:200px;z-index:2;background-color:#fff0;background-image:linear-gradient(rgba(255,255,255,0),rgba(255,255,255,0) 100px,var(--card-header-bg-color));background-repeat:no-repeat}.widget .dropdown-toggle:after{display:none}.widget pre{white-space:pre-wrap;max-width:500px}.no-border{background-color:var(--card-bg-color)}\n"] }]
    }], () => [{ type: WidgetService }, { type: i1.HttpClient }, { type: i1$1.DataProviderService }, { type: i1$2.NgbModal }, { type: i1$1.PermissionService }, { type: i0.ChangeDetectorRef }, { type: i1$1.EntityService }, { type: i1$1.ApiService }, { type: i4.DndDraggableDirective, decorators: [{
                type: Optional
            }] }, { type: i1$1.EmbedService }], { config: [{
            type: Input
        }], widgetData: [{
            type: Input
        }], context: [{
            type: Input
        }], edit: [{
            type: Output
        }], clone: [{
            type: Output
        }], delete: [{
            type: Output
        }], mode: [{
            type: Input
        }], widgetClass: [{
            type: Input
        }], showLayoutControls: [{
            type: Input
        }], updateHeight: [{
            type: Input
        }], widgetId: [{
            type: Input
        }], viewContainer: [{
            type: ViewChild,
            args: ['widgetHolder', { read: ViewContainerRef }]
        }], dndHandle: [{
            type: ViewChild,
            args: [DndHandleDirective]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WidgetComponent, { className: "WidgetComponent", filePath: "src/widgets/widget/widget.component.ts", lineNumber: 24 }); })();

class WidgetsViewLayoutComponent extends AbstractLayoutItemComponent {
    editWidgetChanges(widgetConfig) {
        this.layoutItem.config = widgetConfig;
        this.layoutItemChange.emit(this.layoutItem);
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵWidgetsViewLayoutComponent_BaseFactory; return function WidgetsViewLayoutComponent_Factory(__ngFactoryType__) { return (ɵWidgetsViewLayoutComponent_BaseFactory || (ɵWidgetsViewLayoutComponent_BaseFactory = i0.ɵɵgetInheritedFactory(WidgetsViewLayoutComponent)))(__ngFactoryType__ || WidgetsViewLayoutComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WidgetsViewLayoutComponent, selectors: [["xf-widgets-view-layout"]], inputs: { layoutItem: "layoutItem" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 3, consts: [[3, "edit", "config", "context", "mode"]], template: function WidgetsViewLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "xf-widget", 0);
            i0.ɵɵlistener("edit", function WidgetsViewLayoutComponent_Template_xf_widget_edit_0_listener($event) { return ctx.editWidgetChanges($event); });
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("config", ctx.layoutItem.config)("context", ctx.context)("mode", ctx.mode);
        } }, dependencies: [WidgetComponent], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetsViewLayoutComponent, [{
        type: Component,
        args: [{ selector: 'xf-widgets-view-layout', changeDetection: ChangeDetectionStrategy.OnPush, template: "<xf-widget [config]=\"layoutItem.config\" [context]=\"context\" [mode]=\"mode\" (edit)=\"editWidgetChanges($event)\">\n</xf-widget>" }]
    }], null, { layoutItem: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WidgetsViewLayoutComponent, { className: "WidgetsViewLayoutComponent", filePath: "src/view-template/widgets-view-layout/widgets-view-layout.component.ts", lineNumber: 12 }); })();

function LayoutItemComponent_ng_template_0_Template(rf, ctx) { }
class LayoutItemComponent extends AbstractLayoutItemComponent {
    constructor() {
        super(...arguments);
        this.components = {
            [ViewLayoutItem.Types.WIDGET]: WidgetsViewLayoutComponent,
            [ViewLayoutItem.Types.CONTAINER]: ContainerLayoutComponent,
            [ViewLayoutItem.Types.TABS]: TabsLayoutComponent,
            [ViewLayoutItem.Types.TAB]: TabLayoutComponent
        };
    }
    ngOnInit() {
        this.createComponent();
    }
    findGridItem(itemId) {
        let itemFound;
        this.layoutItem.contents.forEach((item) => {
            if (item.id === itemId) {
                itemFound = item;
            }
        });
        return itemFound;
    }
    createComponent() {
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.components[this.layoutItem.type]);
        this.componentRef.instance.layoutItem = this.layoutItem;
        this.componentRef.instance.layoutItemChange = this.layoutItemChange;
        this.componentRef.instance.viewTemplate = this.viewTemplate;
        this.componentRef.instance.context = this.context;
        this.componentRef.instance.mode = this.mode;
        this.componentRef.instance.widgetSelection$ = this.widgetSelection$;
        this.componentRef.instance.onUpdateGridsterHeight = this.onUpdateGridsterHeight;
        this.componentRef.instance.gridsterConfig = this.getGridsterConfig(this.mode);
        this.componentRef.instance.onUpdateGridsterHeight.subscribe((data) => {
            let itemComponent = this.componentRef.instance.gridsterConfig.api?.getItemComponent(this.findGridItem(data.id));
            itemComponent.item.rows = data.height;
            itemComponent.resize.setItemHeight(data.height * this.fixedGridItemHeight);
            this.updateGridsterHeight();
        });
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    //TODO:- Re-Visit the logic
    ngOnChanges(changes) {
        let update = false;
        if (this.componentRef && changes.mode && changes.mode.currentValue && changes.mode.previousValue && changes.mode.currentValue !== changes.mode.previousValue) {
            update = true;
        }
        else if (this.componentRef && changes.layoutItem && changes.layoutItem.currentValue !== changes.layoutItem.previousValue) {
            update = true;
        }
        if (update) {
            this.componentRef.instance.mode = this.mode;
            this.componentRef.instance.gridsterConfig = this.getGridsterConfig(this.mode);
            this.componentRef.instance.layoutItem = this.layoutItem;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    getGridsterConfig(mode) {
        let gridsterConfig = {
            gridType: GridType.VerticalFixed,
            compactType: CompactType.None,
            pushItems: true,
            maxRows: undefined,
            fixedRowHeight: this.fixedGridItemHeight,
            enableEmptyCellDrop: mode !== 'view' ? true : false,
            enableEmptyCellDrag: mode !== 'view' ? true : false,
            draggable: {
                enabled: mode !== 'view' ? true : false
            },
            resizable: {
                enabled: mode !== 'view' ? true : false
            },
            itemChangeCallback: this.updateGridsterHeight.bind(this),
            itemResizeCallback: this.updateGridsterHeight.bind(this),
            itemInitCallback: this.updateGridsterHeight.bind(this)
        };
        return gridsterConfig;
    }
    updateGridsterHeight() {
        let height = 0;
        let margin = 100;
        this.layoutItem.contents.forEach((item) => {
            height += item.rows * this.fixedGridItemHeight;
        });
        this.gridsterHeight = height + margin;
        this.componentRef.instance.gridsterHeight = this.gridsterHeight;
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = /*@__PURE__*/ (() => { let ɵLayoutItemComponent_BaseFactory; return function LayoutItemComponent_Factory(__ngFactoryType__) { return (ɵLayoutItemComponent_BaseFactory || (ɵLayoutItemComponent_BaseFactory = i0.ɵɵgetInheritedFactory(LayoutItemComponent)))(__ngFactoryType__ || LayoutItemComponent); }; })(); }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LayoutItemComponent, selectors: [["xf-layout-item"]], viewQuery: function LayoutItemComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature, i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function LayoutItemComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LayoutItemComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [i1$1.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LayoutItemComponent, [{
        type: Component,
        args: [{ selector: 'xf-layout-item', changeDetection: ChangeDetectionStrategy.OnPush, template: "<ng-template xfViewContainer></ng-template>" }]
    }], null, { viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LayoutItemComponent, { className: "LayoutItemComponent", filePath: "src/view-template/layout-item/layout-item.component.ts", lineNumber: 17 }); })();

function ViewTemplateHeaderComponent_xf_breadcrumbs_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-breadcrumbs");
} }
function ViewTemplateHeaderComponent_select_3_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const viewTemplate_r3 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", viewTemplate_r3.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(viewTemplate_r3.title);
} }
function ViewTemplateHeaderComponent_select_3_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "select", 5);
    i0.ɵɵlistener("ngModelChange", function ViewTemplateHeaderComponent_select_3_Template_select_ngModelChange_0_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); ctx_r1.selectedViewUuid = $event; return i0.ɵɵresetView(ctx_r1.navigateToView(ctx_r1.selectedViewUuid || "", "view")); });
    i0.ɵɵtemplate(1, ViewTemplateHeaderComponent_select_3_option_1_Template, 2, 2, "option", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngModel", ctx_r1.selectedViewUuid);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.viewTemplates);
} }
function ViewTemplateHeaderComponent_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 9)(1, "button", 10);
    i0.ɵɵtext(2, "Actions");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 11)(4, "button", 12);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["new"]()); });
    i0.ɵɵtext(5, "New");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(6, "div", 13);
    i0.ɵɵelementStart(7, "button", 12);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_7_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["edit"](ctx_r1.selectedViewUuid)); });
    i0.ɵɵtext(8, "Edit ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "button", 12);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["duplicate"]()); });
    i0.ɵɵtext(10, "Duplicate");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(11, "div", 13);
    i0.ɵɵelementStart(12, "button", 14);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_1_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["delete"]()); });
    i0.ɵɵtext(13, "Delete");
    i0.ɵɵelementEnd()()();
} }
function ViewTemplateHeaderComponent_div_4_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "button", 15);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_2_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["cancel"](null, ctx_r1.mode)); });
    i0.ɵɵtext(2, "Cancel");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "button", 16);
    i0.ɵɵlistener("click", function ViewTemplateHeaderComponent_div_4_div_2_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.actions["save"]()); });
    i0.ɵɵtext(4, "Apply and Publish Changes");
    i0.ɵɵelementEnd()();
} }
function ViewTemplateHeaderComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, ViewTemplateHeaderComponent_div_4_div_1_Template, 14, 0, "div", 8)(2, ViewTemplateHeaderComponent_div_4_div_2_Template, 5, 0, "div", 1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.mode === "view" || !ctx_r1.mode);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.mode && ctx_r1.mode !== "view");
} }
class ViewTemplateHeaderComponent {
    constructor(rootFormGroup, changeDetectorRef, router, route, viewTemplateService, systemViewTemplateService, modalService, spinnerService) {
        this.rootFormGroup = rootFormGroup;
        this.changeDetectorRef = changeDetectorRef;
        this.router = router;
        this.route = route;
        this.viewTemplateService = viewTemplateService;
        this.systemViewTemplateService = systemViewTemplateService;
        this.modalService = modalService;
        this.spinnerService = spinnerService;
        this.showBreadcrumbs = true;
        this.viewTemplates = [];
        this.buttons = [];
        this.allowEdit = false;
        this.loadViews = new EventEmitter();
        this.params = {};
        this.backLink = this.route.snapshot.queryParamMap.get('returnPath') || '..';
    }
    ngOnInit() {
        this.selectedViewUuid = this.uuid;
        if (this.recordId) {
            this.params.recordId = this.recordId;
        }
    }
    //TODO : Re-Visit nessted if else
    ngOnChanges(changes) {
        if (changes.context && changes.context.currentValue !== changes.context.previousValue) {
            this.viewTemplates = [];
            this.loadViews.emit();
        }
        else if (changes.uuid && changes.uuid.currentValue !== changes.uuid.previousValue) {
            this.selectedViewUuid = this.uuid;
        }
        else {
            this.changeDetectorRef.detectChanges();
        }
        // else if (changes.mode && changes.mode.currentValue !== 'new') {
        //   if (!changes.uuid && changes.mode.currentValue === 'view') {
        //     this.loadViews.emit();
        //   } else {
        //     this.changeDetectorRef.detectChanges();
        //   }
        // }
    }
    navigateToView(uuid, mode) {
        this.params.uuid = uuid;
        this.params.mode = mode;
        this.viewTemplateService.navigateToView(this.params, this.route);
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function ViewTemplateHeaderComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateHeaderComponent)(i0.ɵɵdirectiveInject(i3.FormGroupDirective), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.Router), i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(ViewTemplateService), i0.ɵɵdirectiveInject(ViewTemplateService), i0.ɵɵdirectiveInject(i1$1.ModalService), i0.ɵɵdirectiveInject(i1$1.SpinnerService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ViewTemplateHeaderComponent, selectors: [["xf-view-template-header"]], inputs: { mode: "mode", uuid: "uuid", showBreadcrumbs: "showBreadcrumbs", context: "context", viewTemplate: "viewTemplate", viewTemplates: "viewTemplates", recordId: "recordId", actions: "actions", buttons: "buttons", allowEdit: "allowEdit" }, outputs: { loadViews: "loadViews" }, features: [i0.ɵɵNgOnChangesFeature], decls: 6, vars: 4, consts: [[1, "breadcrumb-bar", "d-flex", "padding-left-10px"], [4, "ngIf"], [1, "m-2", "ms-auto", "d-flex"], ["name", "selectedView", "class", "form-select form-select-sm me-3 w-auto", 3, "ngModel", "ngModelChange", 4, "ngIf"], [3, "buttons"], ["name", "selectedView", 1, "form-select", "form-select-sm", "me-3", "w-auto", 3, "ngModelChange", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"], ["ngbDropdown", "", "class", "show dropdown", 4, "ngIf"], ["ngbDropdown", "", 1, "show", "dropdown"], ["type", "button", "ngbDropdownToggle", "", "aria-expanded", "true", 1, "dropdown-toggle", "btn", "btn-primary", "btn-sm"], ["ngbDropdownMenu", ""], ["ngbDropdownItem", "", 3, "click"], [1, "dropdown-divider"], ["ngbDropdownItem", "", 1, "text-danger", 3, "click"], ["type", "button", "aria-expanded", "true", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], ["type", "button", "aria-expanded", "true", 1, "btn", "btn-primary", "btn-sm", 3, "click"]], template: function ViewTemplateHeaderComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "header", 0);
            i0.ɵɵtemplate(1, ViewTemplateHeaderComponent_xf_breadcrumbs_1_Template, 1, 0, "xf-breadcrumbs", 1);
            i0.ɵɵelementStart(2, "div", 2);
            i0.ɵɵtemplate(3, ViewTemplateHeaderComponent_select_3_Template, 2, 2, "select", 3)(4, ViewTemplateHeaderComponent_div_4_Template, 3, 2, "div", 1);
            i0.ɵɵelement(5, "xf-button-group", 4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.showBreadcrumbs);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.viewTemplates.length > 0 && ctx.mode === "view");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.allowEdit);
            i0.ɵɵadvance();
            i0.ɵɵproperty("buttons", ctx.buttons);
        } }, dependencies: [i2$1.NgForOf, i2$1.NgIf, i3.NgSelectOption, i3.ɵNgSelectMultipleOption, i3.SelectControlValueAccessor, i3.NgControlStatus, i3.NgModel, i1$2.NgbDropdown, i1$2.NgbDropdownToggle, i1$2.NgbDropdownMenu, i1$2.NgbDropdownItem, i1$2.NgbDropdownButtonItem, i1$1.BreadcrumbsComponent, i1$1.ButtonGroupComponent], styles: [".border-bottom-primary[_ngcontent-%COMP%]{border-bottom:2px solid var(--primary-tabs-default-border-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateHeaderComponent, [{
        type: Component,
        args: [{ selector: 'xf-view-template-header', changeDetection: ChangeDetectionStrategy.OnPush, template: "<header class=\"breadcrumb-bar d-flex padding-left-10px\">\n  <xf-breadcrumbs *ngIf=\"showBreadcrumbs\"></xf-breadcrumbs>\n  <div class=\"m-2 ms-auto d-flex\">\n    <select *ngIf=\"viewTemplates.length > 0 && mode === 'view'\" name=\"selectedView\"\n      class=\"form-select form-select-sm me-3 w-auto\" [ngModel]=\"selectedViewUuid\"\n      (ngModelChange)=\"selectedViewUuid = $event; navigateToView(selectedViewUuid || '', 'view');\">\n      <option *ngFor=\"let viewTemplate of viewTemplates\" [ngValue]=\"viewTemplate.uuid\">{{ viewTemplate.title }}</option>\n    </select>\n    <div *ngIf=\"allowEdit\">\n      <div ngbDropdown class=\"show dropdown\" *ngIf=\"mode === 'view' || !mode\">\n        <button type=\"button\" ngbDropdownToggle class=\"dropdown-toggle btn btn-primary btn-sm\"\n          aria-expanded=\"true\">Actions</button>\n        <div ngbDropdownMenu>\n          <button ngbDropdownItem (click)=\"actions['new']()\">New</button>\n          <div class=\"dropdown-divider\"></div>\n          <button ngbDropdownItem (click)=\"actions['edit'](selectedViewUuid)\">Edit\n          </button>\n          <button ngbDropdownItem (click)=\"actions['duplicate']()\">Duplicate</button>\n          <div class=\"dropdown-divider\"></div>\n          <button ngbDropdownItem class=\"text-danger\" (click)=\"actions['delete']()\">Delete</button>\n        </div>\n      </div>\n\n      <div *ngIf=\"mode && mode !== 'view'\">\n        <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" aria-expanded=\"true\"\n          (click)=\"actions['cancel'](null, mode)\">Cancel</button>\n        <button type=\"button\" class=\"btn btn-primary btn-sm\" aria-expanded=\"true\" (click)=\"actions['save']()\">Apply and\n          Publish\n          Changes</button>\n      </div>\n    </div>\n    <xf-button-group [buttons]=\"buttons\"></xf-button-group>\n\n  </div>\n</header>", styles: [".border-bottom-primary{border-bottom:2px solid var(--primary-tabs-default-border-color)}\n"] }]
    }], () => [{ type: i3.FormGroupDirective }, { type: i0.ChangeDetectorRef }, { type: i2.Router }, { type: i2.ActivatedRoute }, { type: ViewTemplateService }, { type: ViewTemplateService }, { type: i1$1.ModalService }, { type: i1$1.SpinnerService }], { mode: [{
            type: Input
        }], uuid: [{
            type: Input
        }], showBreadcrumbs: [{
            type: Input
        }], context: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], viewTemplates: [{
            type: Input
        }], recordId: [{
            type: Input
        }], actions: [{
            type: Input
        }], buttons: [{
            type: Input
        }], allowEdit: [{
            type: Input
        }], loadViews: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ViewTemplateHeaderComponent, { className: "ViewTemplateHeaderComponent", filePath: "src/view-template/view-template-header/view-template-header.component.ts", lineNumber: 16 }); })();
var ViewTemplateHeaderActions;
(function (ViewTemplateHeaderActions) {
    ViewTemplateHeaderActions["NEW"] = "new";
    ViewTemplateHeaderActions["SAVE"] = "save";
    ViewTemplateHeaderActions["EDIT"] = "edit";
    ViewTemplateHeaderActions["DUPLICATE"] = "duplicate";
    ViewTemplateHeaderActions["DELETE"] = "delete";
    ViewTemplateHeaderActions["CANCEL"] = "cancel";
})(ViewTemplateHeaderActions || (ViewTemplateHeaderActions = {}));

const _c0 = a0 => ({ "widget-library-collapsed": a0 });
function WidgetLibraryComponent_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span");
    i0.ɵɵtext(1, "Widget Library");
    i0.ɵɵelementEnd();
} }
function WidgetLibraryComponent_ng_container_6_div_7_div_12_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵlistener("dragstart", function WidgetLibraryComponent_ng_container_6_div_7_div_12_Template_div_dragstart_0_listener($event) { const widget_r5 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.widgetDrag($event, widget_r5)); });
    i0.ɵɵelementStart(1, "div", 15);
    i0.ɵɵelement(2, "i", 16);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 17)(4, "span");
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "span", 18);
    i0.ɵɵtext(7);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(8, "div", 19);
    i0.ɵɵelement(9, "i", 20)(10, "i", 21);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const widget_r5 = ctx.$implicit;
    i0.ɵɵadvance(5);
    i0.ɵɵtextInterpolate(widget_r5.name);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(widget_r5.description);
} }
function WidgetLibraryComponent_ng_container_6_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 13)(1, "div", 14);
    i0.ɵɵlistener("dragstart", function WidgetLibraryComponent_ng_container_6_div_7_Template_div_dragstart_1_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.widgetDrag($event, ctx_r1.tabs)); });
    i0.ɵɵelementStart(2, "div", 15);
    i0.ɵɵelement(3, "i", 16);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 17)(5, "span");
    i0.ɵɵtext(6, "Tabs");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "span", 18);
    i0.ɵɵtext(8, "Tabs Container");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(9, "div", 19);
    i0.ɵɵelement(10, "i", 20)(11, "i", 21);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(12, WidgetLibraryComponent_ng_container_6_div_7_div_12_Template, 11, 2, "div", 22);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(12);
    i0.ɵɵproperty("ngForOf", ctx_r1.widgets);
} }
function WidgetLibraryComponent_ng_container_6_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 6)(2, "div", 7)(3, "div", 8)(4, "input", 9);
    i0.ɵɵtwoWayListener("ngModelChange", function WidgetLibraryComponent_ng_container_6_Template_input_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.searchText, $event) || (ctx_r1.searchText = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "button", 10);
    i0.ɵɵlistener("click", function WidgetLibraryComponent_ng_container_6_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.searchWidget()); });
    i0.ɵɵelement(6, "span", 11);
    i0.ɵɵelementEnd()()()();
    i0.ɵɵtemplate(7, WidgetLibraryComponent_ng_container_6_div_7_Template, 13, 1, "div", 12);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.searchText);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", !ctx_r1.widgetsLoading);
} }
class WidgetLibraryComponent {
    constructor(widgetService, changeDetectorRef, viewTemplateService) {
        this.widgetService = widgetService;
        this.changeDetectorRef = changeDetectorRef;
        this.viewTemplateService = viewTemplateService;
        this.widgetCollapsible = new EventEmitter();
        this.widgetLibraryCollapsed = false;
        this.widgetsLoading = false;
        this.tabs = new ViewLayoutItem.Tabs([
            new ViewLayoutItem.Tab('Tab 1', []),
            new ViewLayoutItem.Tab('Tab 2', [])
        ]);
    }
    widgetLibraryCollapse() {
        this.widgetLibraryCollapsed = !this.widgetLibraryCollapsed;
        this.viewTemplateService.widgetLibraryChanged.next(true);
        this.widgetCollapsible.emit(this.widgetLibraryCollapsed); // make use of the replay subject in viewTemplateService
    }
    ngOnInit() {
        this._loadWidgets();
    }
    _loadWidgets() {
        this.widgetsLoading = true;
        // this.widgetService.loadWidgets().subscribe((widgets: any) => {
        //   this.widgets = values(widgets);
        //   this.widgetsLoading = false;
        //   this.changeDetectorRef.detectChanges();
        // });
    }
    searchWidget() { }
    widgetDrag(ev, widget) {
        this.widgetSelection$.next(widget);
    }
    static { this.ɵfac = function WidgetLibraryComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetLibraryComponent)(i0.ɵɵdirectiveInject(WidgetService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(ViewTemplateService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WidgetLibraryComponent, selectors: [["xf-widget-library"]], inputs: { widgetSelection$: "widgetSelection$" }, outputs: { widgetCollapsible: "widgetCollapsible" }, decls: 7, vars: 7, consts: [[1, "widget-library", 3, "ngClass"], [1, "col"], [4, "ngIf"], ["role", "button", 1, "nav-item", "float-end", 3, "click"], ["title", "Close Widget Library", 1, "nav-link", 3, "title"], [1, "fa", "nav-link-icon", "fa-light", 3, "ngClass"], [1, "search-box", "mt-3"], [1, "w-350px", "search-text", "pe-2"], [1, "d-flex", "search-input"], ["id", "widget-search", "type", "text", "placeholder", "Search", "aria-labelledby", "search-widget", "aria-invalid", "false", 1, "form-control", "form-select-sm", "input-md", "content-hub-search-bar", 3, "ngModelChange", "ngModel"], [1, "btn", "btn-sm", "btn-secondary", "search-button", 3, "click"], [1, "fa", "fa-magnifying-glass"], ["class", "widget-list", 4, "ngIf"], [1, "widget-list"], ["draggable", "true", 1, "widget-box", 3, "dragstart"], [1, "float-left"], [1, "fa", "fa-grip-dots-vertical"], [1, "widget-data"], [1, "description"], [1, "float-end"], [1, "fa-sm", "fa-light", "fa-star", "me-2"], [1, "fa-sm", "fa-light", "fa-eye"], ["class", "widget-box", "draggable", "true", 3, "dragstart", 4, "ngFor", "ngForOf"]], template: function WidgetLibraryComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1);
            i0.ɵɵtemplate(2, WidgetLibraryComponent_span_2_Template, 2, 0, "span", 2);
            i0.ɵɵelementStart(3, "div", 3);
            i0.ɵɵlistener("click", function WidgetLibraryComponent_Template_div_click_3_listener() { return ctx.widgetLibraryCollapse(); });
            i0.ɵɵelementStart(4, "a", 4);
            i0.ɵɵelement(5, "i", 5);
            i0.ɵɵelementEnd()()();
            i0.ɵɵtemplate(6, WidgetLibraryComponent_ng_container_6_Template, 8, 2, "ng-container", 2);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(5, _c0, ctx.widgetLibraryCollapsed));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", !ctx.widgetLibraryCollapsed);
            i0.ɵɵadvance(2);
            i0.ɵɵpropertyInterpolate("title", ctx.widgetLibraryCollapsed ? "Expand Widget Library" : "Collapse Widget Library");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.widgetLibraryCollapsed ? "fa-arrows-left-right" : "fa-arrows-left-right-to-line");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.widgetLibraryCollapsed);
        } }, dependencies: [i2$1.NgClass, i2$1.NgForOf, i2$1.NgIf, i3.DefaultValueAccessor, i3.NgControlStatus, i3.NgModel], styles: [".widget-library[_ngcontent-%COMP%]{width:25vw;height:90vh;overflow:auto;padding:10px;background-color:var(--template-container-bg-color);margin-left:5px}.widget-library.widget-library-collapsed[_ngcontent-%COMP%]{width:40px;transition:width .2s linear}.widget-library[_ngcontent-%COMP%]   .widget-list[_ngcontent-%COMP%]{overflow:scroll}.widget-library[_ngcontent-%COMP%]   .widget-list[_ngcontent-%COMP%]   .widget-box[_ngcontent-%COMP%]{display:flex;margin:10px 0;padding:10px;background-color:var(--element-default-bg-color)}.widget-library[_ngcontent-%COMP%]   .widget-list[_ngcontent-%COMP%]   .widget-box[_ngcontent-%COMP%]   .widget-data[_ngcontent-%COMP%]{display:flex;flex-direction:column;width:18vw;padding:0 5px}.widget-library[_ngcontent-%COMP%]   .widget-list[_ngcontent-%COMP%]   .widget-box[_ngcontent-%COMP%]   .widget-data[_ngcontent-%COMP%]   .description[_ngcontent-%COMP%]{font-size:10px}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetLibraryComponent, [{
        type: Component,
        args: [{ selector: 'xf-widget-library', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"widget-library\" [ngClass]=\"{'widget-library-collapsed': widgetLibraryCollapsed }\">\n  <div class=\"col\">\n    <span *ngIf=\"!widgetLibraryCollapsed\">Widget Library</span>\n    <div class=\" nav-item float-end\" role=\"button\" (click)=\"widgetLibraryCollapse()\">\n      <a class=\"nav-link\" title=\"{{widgetLibraryCollapsed ? 'Expand Widget Library' : 'Collapse Widget Library'}}\"\n        title=\"Close Widget Library\">\n        <i class=\"fa nav-link-icon fa-light\"\n          [ngClass]=\"widgetLibraryCollapsed ? 'fa-arrows-left-right' : 'fa-arrows-left-right-to-line'\"></i>\n      </a>\n    </div>\n  </div>\n  <ng-container *ngIf=\"!widgetLibraryCollapsed\">\n    <!-- Search -->\n    <div class=\"search-box mt-3\">\n      <div class=\"w-350px search-text pe-2\">\n        <div class=\"d-flex search-input\">\n          <input id=\"widget-search\" type=\"text\" class=\"form-control form-select-sm input-md content-hub-search-bar\"\n            placeholder=\"Search\" aria-labelledby=\"search-widget\" [(ngModel)]=\"searchText\" aria-invalid=\"false\">\n          <button class=\"btn btn-sm btn-secondary search-button\" (click)=\"searchWidget()\"><span\n              class=\"fa fa-magnifying-glass\"></span></button>\n        </div>\n      </div>\n    </div>\n\n    <!-- Widget List -->\n    <div class=\"widget-list\" *ngIf=\"!widgetsLoading\">\n      <!-- Tabs Container -->\n      <div class=\"widget-box\" draggable=\"true\" (dragstart)=\"widgetDrag($event, tabs)\">\n        <div class=\"float-left\">\n          <i class=\"fa fa-grip-dots-vertical\"></i>\n        </div>\n\n        <div class=\"widget-data\">\n          <span>Tabs</span>\n          <span class=\"description\">Tabs Container</span>\n        </div>\n        <div class=\"float-end\">\n          <i class=\"fa-sm fa-light fa-star me-2\"></i>\n          <i class=\"fa-sm fa-light fa-eye\"></i>\n        </div>\n      </div>\n      <div class=\"widget-box\" *ngFor=\"let widget of widgets\" draggable=\"true\" (dragstart)=\"widgetDrag($event, widget)\">\n        <div class=\"float-left\">\n          <i class=\"fa fa-grip-dots-vertical\"></i>\n        </div>\n\n        <div class=\"widget-data\">\n          <span>{{widget.name}}</span>\n          <span class=\"description\">{{widget.description}}</span>\n        </div>\n        <div class=\"float-end\">\n          <i class=\"fa-sm fa-light fa-star me-2\"></i>\n          <i class=\"fa-sm fa-light fa-eye\"></i>\n        </div>\n      </div>\n\n    </div>\n  </ng-container>", styles: [".widget-library{width:25vw;height:90vh;overflow:auto;padding:10px;background-color:var(--template-container-bg-color);margin-left:5px}.widget-library.widget-library-collapsed{width:40px;transition:width .2s linear}.widget-library .widget-list{overflow:scroll}.widget-library .widget-list .widget-box{display:flex;margin:10px 0;padding:10px;background-color:var(--element-default-bg-color)}.widget-library .widget-list .widget-box .widget-data{display:flex;flex-direction:column;width:18vw;padding:0 5px}.widget-library .widget-list .widget-box .widget-data .description{font-size:10px}\n"] }]
    }], () => [{ type: WidgetService }, { type: i0.ChangeDetectorRef }, { type: ViewTemplateService }], { widgetCollapsible: [{
            type: Output
        }], widgetSelection$: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WidgetLibraryComponent, { className: "WidgetLibraryComponent", filePath: "src/view-template/widget-library/widget-library.component.ts", lineNumber: 15 }); })();

function ViewTemplateComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0, 3);
    i0.ɵɵelementStart(1, "div", 4)(2, "div", 5)(3, "label", 6);
    i0.ɵɵtext(4, "Title");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(5, "xf-form-field", 7);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.viewTemplateForm);
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("field", ctx_r0.titleField)("fieldOptions", ctx_r0.titleFieldOptions);
} }
function ViewTemplateComponent_div_1_xf_layout_item_2_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-layout-item", 13);
    i0.ɵɵlistener("layoutItemChange", function ViewTemplateComponent_div_1_xf_layout_item_2_Template_xf_layout_item_layoutItemChange_0_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.onLayoutItemChange($event)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const container_r3 = ctx.$implicit;
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("context", ctx_r0.context)("layoutItem", container_r3)("viewTemplate", ctx_r0.viewTemplate)("mode", ctx_r0.mode)("widgetSelection$", ctx_r0.widgetSelection$);
} }
function ViewTemplateComponent_div_1_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14)(1, "button", 15);
    i0.ɵɵlistener("click", function ViewTemplateComponent_div_1_div_3_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.addContainer()); });
    i0.ɵɵtext(2, "+ Add Container");
    i0.ɵɵelementEnd()();
} }
function ViewTemplateComponent_div_1_xf_widget_library_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "xf-widget-library", 16);
    i0.ɵɵlistener("widgetCollapsible", function ViewTemplateComponent_div_1_xf_widget_library_4_Template_xf_widget_library_widgetCollapsible_0_listener($event) { i0.ɵɵrestoreView(_r5); const ctx_r0 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r0.widgetLibraryCollapsible($event)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("widgetSelection$", ctx_r0.widgetSelection$);
} }
function ViewTemplateComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8)(1, "div", 9);
    i0.ɵɵtemplate(2, ViewTemplateComponent_div_1_xf_layout_item_2_Template, 1, 5, "xf-layout-item", 10)(3, ViewTemplateComponent_div_1_div_3_Template, 3, 0, "div", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(4, ViewTemplateComponent_div_1_xf_widget_library_4_Template, 1, 1, "xf-widget-library", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", ctx_r0.getWidth());
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r0.viewTemplate.layout);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.mode !== "view");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.mode !== "view");
} }
function ViewTemplateComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 17)(1, "ngb-alert", 18);
    i0.ɵɵtext(2, " View template not found. ");
    i0.ɵɵelementStart(3, "button", 19);
    i0.ɵɵlistener("click", function ViewTemplateComponent_div_2_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r6); const ctx_r0 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r0.newViewTemplate()); });
    i0.ɵɵtext(4, "Create one");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    i0.ɵɵadvance();
    i0.ɵɵproperty("dismissible", false);
} }
class ViewTemplateComponent {
    constructor(rootFormGroup, utilityService, changeDetectorRef, route, viewTemplateService, spinnerService, modalService, router) {
        this.rootFormGroup = rootFormGroup;
        this.utilityService = utilityService;
        this.changeDetectorRef = changeDetectorRef;
        this.route = route;
        this.viewTemplateService = viewTemplateService;
        this.spinnerService = spinnerService;
        this.modalService = modalService;
        this.router = router;
        this.openedInPreview = false;
        this.loading = true;
        this.onAddViewTemplate = new EventEmitter();
        this.navigationCollapsed = false;
        this.widgetLibraryCollapsed = false;
        this.titleFieldOptions = new FieldOptions({
            showLabel: false,
            customErrorMessages: {
                unique: 'A view template with this title already exists'
            }
        });
        this.params = {};
        this.titleField = new TextField('viewTemplateTitle');
        this.titleField.title = 'Title';
        this.titleField.validation.required = true;
        this.widgetSelection$ = new BehaviorSubject(new Widget('', ''));
    }
    ngOnInit() {
        this.viewTemplateForm = this.rootFormGroup.control;
        this.viewTemplateForm?.controls.viewTemplateTitle.setValue(this.viewTemplate?.title);
        this.viewTemplateForm?.controls.viewTemplateTitle.valueChanges.subscribe((title) => this.viewTemplate ? this.viewTemplate.title = title : null);
        if (this.recordId) {
            this.params.recordId = this.recordId;
        }
        this.utilityService.navigationChanged.subscribe((value) => {
            this.navigationCollapsed = value;
            this.changeDetectorRef.detectChanges();
        });
    }
    onLayoutItemChange(layoutItem) {
        if (!this.viewTemplate) {
            return;
        }
        this.viewTemplate.layout.map((l) => l.id != layoutItem.id ? l : layoutItem);
        this.changeDetectorRef.detectChanges();
    }
    setSelectedWidget(widget) {
        this.selectedWidget = widget;
        this.changeDetectorRef.detectChanges();
    }
    widgetLibraryCollapsible(value) {
        // make use of the replay subject in viewTemplateService
        this.widgetLibraryCollapsed = value;
        this.changeDetectorRef.detectChanges();
    }
    addContainer() {
        let containerLayout = new ViewLayoutItem.Container([]);
        this.viewTemplate?.layout.push(containerLayout);
    }
    getWidth() {
        switch (this.mode) {
            case 'edit':
            case 'new': {
                if (this.widgetLibraryCollapsed && this.navigationCollapsed) {
                    return 'all-collapsed';
                }
                else if (this.navigationCollapsed && !this.widgetLibraryCollapsed) {
                    return 'navigation-collapsed';
                }
                else if (this.widgetLibraryCollapsed && !this.navigationCollapsed) {
                    return 'widget-library-collapsed';
                }
                else if (!this.widgetLibraryCollapsed && !this.navigationCollapsed) {
                    return 'none-collapsed';
                }
                else {
                    return 'none-collapsed';
                }
                break;
            }
            case 'view': {
                if (this.navigationCollapsed) {
                    return 'all-collapsed-view-mode';
                }
                else {
                    return 'widget-library-collapsed-view-mode';
                }
            }
            default: {
                return 'widget-library-collapsed-view-mode';
            }
        }
    }
    onWidgetDrop(event) {
        console.log(this.selectedWidget);
    }
    newViewTemplate() {
        this.params.mode = 'new';
        this.onAddViewTemplate.emit();
    }
    static { this.ɵfac = function ViewTemplateComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateComponent)(i0.ɵɵdirectiveInject(i3.FormGroupDirective), i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(ViewTemplateService), i0.ɵɵdirectiveInject(i1$1.SpinnerService), i0.ɵɵdirectiveInject(i1$1.ModalService), i0.ɵɵdirectiveInject(i2.Router)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ViewTemplateComponent, selectors: [["xf-view-template"]], inputs: { mode: "mode", uuid: "uuid", recordId: "recordId", viewTemplate: "viewTemplate", context: "context", openedInPreview: "openedInPreview", loading: "loading" }, outputs: { onAddViewTemplate: "onAddViewTemplate" }, decls: 3, vars: 3, consts: [[3, "formGroup", 4, "ngIf"], ["class", "d-flex", "cdkDropListGroup", "", 4, "ngIf"], ["class", "d-inline-flex p-2", 4, "ngIf"], [3, "formGroup"], [1, "row", "m-3", "pb-2", "border-bottom-primary"], [1, "col-xl-4", "col-lg-6", "col-md-12", "d-flex"], ["for", "viewTemplateTitle", 1, "form-label", "me-2", "mb-0", "align-self-center"], ["formControlName", "viewTemplateTitle", 3, "field", "fieldOptions"], ["cdkDropListGroup", "", 1, "d-flex"], [1, "view-template", 3, "ngClass"], [3, "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$", "layoutItemChange", 4, "ngFor", "ngForOf"], ["class", "m-2", 4, "ngIf"], [3, "widgetSelection$", "widgetCollapsible", 4, "ngIf"], [3, "layoutItemChange", "context", "layoutItem", "viewTemplate", "mode", "widgetSelection$"], [1, "m-2"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "float-start", 3, "click"], [3, "widgetCollapsible", "widgetSelection$"], [1, "d-inline-flex", "p-2"], [3, "dismissible"], ["type", "button", 1, "btn", "btn-link", 3, "click"]], template: function ViewTemplateComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ViewTemplateComponent_ng_container_0_Template, 6, 3, "ng-container", 0)(1, ViewTemplateComponent_div_1_Template, 5, 4, "div", 1)(2, ViewTemplateComponent_div_2_Template, 5, 1, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.viewTemplateForm && (ctx.mode === "edit" || ctx.mode === "new"));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.viewTemplate && ctx.viewTemplate.layout);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.loading && !ctx.viewTemplate);
        } }, dependencies: [i2$1.NgClass, i2$1.NgForOf, i2$1.NgIf, i1$2.NgbAlert, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i1$1.FormFieldComponent, LayoutItemComponent, WidgetLibraryComponent], styles: [".view-template[_ngcontent-%COMP%]{width:calc(60vw - 58px);display:flex;flex-direction:column}.view-template.all-collapsed[_ngcontent-%COMP%]{width:calc(100vw - 100px)}.view-template.all-collapsed-view-mode[_ngcontent-%COMP%]{width:100vw}.view-template.navigation-collapsed[_ngcontent-%COMP%]{width:calc(75vw - 60px)}.view-template.widget-library-collapsed[_ngcontent-%COMP%]{width:calc(100vw - 60px)}.view-template.widget-library-collapsed-view-mode[_ngcontent-%COMP%]{width:100vw}.view-template.none-collapsed[_ngcontent-%COMP%]{width:calc(80vw - 90px)}.view-template[_ngcontent-%COMP%]   .data-toggle[_ngcontent-%COMP%]{width:inherit}.view-template[_ngcontent-%COMP%]   .template-containers[_ngcontent-%COMP%]{height:calc(100vh - 150px);max-width:calc(100vw - 10px)}.border-bottom-primary[_ngcontent-%COMP%]{border-bottom:2px solid var(--primary-tabs-default-border-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateComponent, [{
        type: Component,
        args: [{ selector: 'xf-view-template', template: "<ng-container [formGroup]=\"viewTemplateForm\" *ngIf=\"viewTemplateForm && (mode === 'edit' || mode === 'new')\">\n  <div class=\"row m-3 pb-2 border-bottom-primary\">\n    <div class=\"col-xl-4 col-lg-6 col-md-12 d-flex\">\n      <label for=\"viewTemplateTitle\" class=\"form-label me-2 mb-0 align-self-center\">Title</label>\n      <xf-form-field [field]=\"titleField\" formControlName=\"viewTemplateTitle\" [fieldOptions]=\"titleFieldOptions\">\n      </xf-form-field>\n    </div>\n  </div>\n</ng-container>\n\n<div class=\"d-flex\" *ngIf=\"viewTemplate && viewTemplate.layout\" cdkDropListGroup>\n  <div class=\"view-template\" [ngClass]=\"getWidth()\">\n    <!-- Show Data Toggle -->\n    <!-- <div class=\"col-md-12 data-toggle\" *ngIf=\"mode !== 'view'\">\n      <div class=\"form-switch float-end w-150px\">\n        <input class=\"form-check-input float-none\" type=\"checkbox\">\n        <label class=\"align-top font-size-14px form-check-label margin-left-6px\">Show Data</label>\n      </div>\n    </div> -->\n    <xf-layout-item *ngFor=\"let container of viewTemplate.layout\" [context]=\"context\" [layoutItem]=\"container\"\n      [viewTemplate]=\"viewTemplate\" [mode]=\"mode\" [widgetSelection$]=\"widgetSelection$\"\n      (layoutItemChange)=\"onLayoutItemChange($event)\"></xf-layout-item>\n    <!-- Add Container -->\n    <div class=\"col-md-12\" class=\"m-2\" *ngIf=\"mode !== 'view'\">\n      <button type=\"button\" class=\"btn btn-primary btn-sm float-start\" (click)=\"addContainer()\">+ Add\n        Container</button>\n    </div>\n\n  </div>\n  <xf-widget-library (widgetCollapsible)=\"widgetLibraryCollapsible($event)\" [widgetSelection$]=\"widgetSelection$\"\n    *ngIf=\"mode !== 'view'\"></xf-widget-library>\n</div>\n<div *ngIf=\"!loading && !viewTemplate\" class=\"d-inline-flex p-2\">\n  <ngb-alert [dismissible]=\"false\">\n    View template not found. <button class=\"btn btn-link\" type=\"button\" (click)=\"newViewTemplate()\">Create\n      one</button>\n  </ngb-alert>\n</div>", styles: [".view-template{width:calc(60vw - 58px);display:flex;flex-direction:column}.view-template.all-collapsed{width:calc(100vw - 100px)}.view-template.all-collapsed-view-mode{width:100vw}.view-template.navigation-collapsed{width:calc(75vw - 60px)}.view-template.widget-library-collapsed{width:calc(100vw - 60px)}.view-template.widget-library-collapsed-view-mode{width:100vw}.view-template.none-collapsed{width:calc(80vw - 90px)}.view-template .data-toggle{width:inherit}.view-template .template-containers{height:calc(100vh - 150px);max-width:calc(100vw - 10px)}.border-bottom-primary{border-bottom:2px solid var(--primary-tabs-default-border-color)}\n"] }]
    }], () => [{ type: i3.FormGroupDirective }, { type: i1$1.UtilityService }, { type: i0.ChangeDetectorRef }, { type: i2.ActivatedRoute }, { type: ViewTemplateService }, { type: i1$1.SpinnerService }, { type: i1$1.ModalService }, { type: i2.Router }], { mode: [{
            type: Input
        }], uuid: [{
            type: Input
        }], recordId: [{
            type: Input
        }], viewTemplate: [{
            type: Input
        }], context: [{
            type: Input
        }], openedInPreview: [{
            type: Input
        }], loading: [{
            type: Input
        }], onAddViewTemplate: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ViewTemplateComponent, { className: "ViewTemplateComponent", filePath: "src/view-template/view-template.component.ts", lineNumber: 17 }); })();

class FieldGroupModule {
    static { this.ɵfac = function FieldGroupModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldGroupModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: FieldGroupModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            ReactiveFormsModule,
            XFFormFieldsModule,
            DndModule,
            NgbDropdownModule,
            SearchableDropdownModule,
            TranslocoModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldGroupModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    FieldGroupViewComponent,
                    FieldGroupEditComponent
                ],
                imports: [
                    CommonModule,
                    FormsModule,
                    ReactiveFormsModule,
                    XFFormFieldsModule,
                    DndModule,
                    NgbDropdownModule,
                    SearchableDropdownModule,
                    TranslocoModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(FieldGroupModule, { declarations: [FieldGroupViewComponent,
        FieldGroupEditComponent], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule,
        XFFormFieldsModule,
        DndModule,
        NgbDropdownModule,
        SearchableDropdownModule,
        TranslocoModule] }); })();

class XFWidgetsModule {
    static { this.ɵfac = function XFWidgetsModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || XFWidgetsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: XFWidgetsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FieldGroupModule,
            NgbDropdownModule,
            DndModule,
            UtilityModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(XFWidgetsModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    WidgetComponent
                ],
                imports: [
                    CommonModule,
                    FieldGroupModule,
                    NgbDropdownModule,
                    DndModule,
                    UtilityModule
                ],
                exports: [
                    WidgetComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(XFWidgetsModule, { declarations: [WidgetComponent], imports: [CommonModule,
        FieldGroupModule,
        NgbDropdownModule,
        DndModule,
        UtilityModule], exports: [WidgetComponent] }); })();

class ViewTemplateModule {
    static { this.ɵfac = function ViewTemplateModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ViewTemplateModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ViewTemplateModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            XFWidgetsModule,
            NgbAlertModule,
            RouterModule,
            FormsModule,
            ReactiveFormsModule,
            XFFormFieldsModule,
            DndModule,
            UtilityModule,
            NgbNavModule,
            NgbDropdownModule,
            TranslocoModule,
            NgMultiSelectDropDownModule,
            BreadcrumbsComponent,
            GridsterComponent,
            GridsterItemComponent,
            ButtonGroupModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ViewTemplateModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    ViewTemplateComponent,
                    AddWidgetComponent,
                    ContainerLayoutComponent,
                    LayoutItemComponent,
                    TabLayoutComponent,
                    TabsLayoutComponent,
                    WidgetLibraryComponent,
                    ViewTemplateHeaderComponent,
                    WidgetsViewLayoutComponent,
                    EditWidgetComponent
                ],
                imports: [
                    CommonModule,
                    XFWidgetsModule,
                    NgbAlertModule,
                    RouterModule,
                    FormsModule,
                    ReactiveFormsModule,
                    XFFormFieldsModule,
                    DndModule,
                    UtilityModule,
                    NgbNavModule,
                    NgbDropdownModule,
                    TranslocoModule,
                    NgMultiSelectDropDownModule,
                    BreadcrumbsComponent,
                    GridsterComponent,
                    GridsterItemComponent,
                    ButtonGroupModule
                ],
                exports: [
                    ViewTemplateComponent,
                    ViewTemplateHeaderComponent,
                    WidgetLibraryComponent,
                    ContainerLayoutComponent,
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ViewTemplateModule, { declarations: [ViewTemplateComponent,
        AddWidgetComponent,
        ContainerLayoutComponent,
        LayoutItemComponent,
        TabLayoutComponent,
        TabsLayoutComponent,
        WidgetLibraryComponent,
        ViewTemplateHeaderComponent,
        WidgetsViewLayoutComponent,
        EditWidgetComponent], imports: [CommonModule,
        XFWidgetsModule,
        NgbAlertModule,
        RouterModule,
        FormsModule,
        ReactiveFormsModule,
        XFFormFieldsModule,
        DndModule,
        UtilityModule,
        NgbNavModule,
        NgbDropdownModule,
        TranslocoModule,
        NgMultiSelectDropDownModule,
        BreadcrumbsComponent,
        GridsterComponent,
        GridsterItemComponent,
        ButtonGroupModule], exports: [ViewTemplateComponent,
        ViewTemplateHeaderComponent,
        WidgetLibraryComponent,
        ContainerLayoutComponent] }); })();
i0.ɵɵsetComponentScope(ContainerLayoutComponent, [i2$1.NgClass, i2$1.NgForOf, i2$1.NgIf, WidgetComponent, GridsterComponent,
    GridsterItemComponent, LayoutItemComponent], []);
i0.ɵɵsetComponentScope(TabsLayoutComponent, [i2$1.NgClass, i2$1.NgForOf, i1$2.NgbNav, i1$2.NgbNavItem, i1$2.NgbNavItemRole, LayoutItemComponent], []);

class PrimaryDetailModule {
    static { this.ɵfac = function PrimaryDetailModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PrimaryDetailModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: PrimaryDetailModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            XFFormFieldsModule,
            FormsModule,
            SearchableDropdownModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PrimaryDetailModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    PrimaryDetailViewComponent,
                    PrimaryDetailEditComponent
                ],
                imports: [
                    CommonModule,
                    XFFormFieldsModule,
                    FormsModule,
                    SearchableDropdownModule
                ],
                exports: [
                    PrimaryDetailViewComponent,
                    PrimaryDetailEditComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(PrimaryDetailModule, { declarations: [PrimaryDetailViewComponent,
        PrimaryDetailEditComponent], imports: [CommonModule,
        XFFormFieldsModule,
        FormsModule,
        SearchableDropdownModule], exports: [PrimaryDetailViewComponent,
        PrimaryDetailEditComponent] }); })();

class DashboardTemplate extends ViewTemplate {
    constructor(title) {
        super(title, ViewTemplate.Types.DASHBOARD);
        this.configuration = {};
    }
}

class DetailViewTemplate extends ViewTemplate {
    constructor(title) {
        super(title, ViewTemplate.Types.DETAIL_VIEW);
        this.configuration = {
            primaryDetail: new PrimaryDetailConfig('Primary Detail', {
                cols: [[new FieldRenderer('modifyDate'), new FieldRenderer('createDate')]]
            }),
            showSectionLinks: false
        };
    }
}

class LoadingTemplate extends ViewTemplate {
    constructor() {
        super('', ViewTemplate.Types.DASHBOARD);
    }
}

class ModuleViewTemplate extends ViewTemplate {
    constructor(title) {
        super(title, ViewTemplate.Types.MODULE_VIEW);
        this.configuration = {};
    }
}

class PreviewTemplate extends ViewTemplate {
    constructor(title) {
        super(title, ViewTemplate.Types.PREVIEW);
    }
}

class EmbedTemplate extends ViewTemplate {
    constructor(title) {
        super(title, EmbedTemplate.Types.EMBED);
        this.configuration = {};
    }
}

class ViewTemplateContext {
    constructor(module, uuid, inputs, query) {
        this.module = module;
        this.uuid = uuid;
        this.inputs = inputs;
        this.query = query;
    }
}

// export * from './src/configs';
// export * from './src/porting-config';

/**
 * Generated bundle index. Do not edit.
 */

export { AbstractEditViewLayout, AbstractLayoutItemComponent, AbstractViewTemplateComponent, AbstractWidgetComponent, AbstractWidgetEditComponent, AddWidgetComponent, ContainerLayoutComponent, DashboardTemplate, DetailViewTemplate, EditWidgetComponent, EmbedTemplate, FieldGroupConfig, FieldGroupEditComponent, FieldGroupModule, FieldGroupViewComponent, FieldRenderer, LayoutItemComponent, LoadingTemplate, ModuleViewTemplate, PreviewTemplate, PrimaryDetailConfig, PrimaryDetailEditComponent, PrimaryDetailModule, PrimaryDetailViewComponent, TabLayoutComponent, TabsLayoutComponent, ViewLayoutItem, ViewTemplate, ViewTemplateComponent, ViewTemplateContext, ViewTemplateHeaderActions, ViewTemplateHeaderComponent, ViewTemplateModule, ViewTemplateService, Widget, WidgetComponent, WidgetConfig, WidgetLibraryComponent, WidgetService, WidgetsViewLayoutComponent, XFWidgetsModule };
//# sourceMappingURL=shared-view-templates.mjs.map
