import { DatePipe } from '@angular/common';
import { ChangeDetectorRef, EventEmitter } from '@angular/core';
import { TranslocoService } from '@jsverse/transloco';
import { AgGridAngular } from 'ag-grid-angular';
import { ColDef, FirstDataRenderedEvent, GridApi, GridOptions, GridReadyEvent, GridSizeChangedEvent, ICellRendererParams, ProcessCellForExportParams, RowDataUpdatedEvent, SelectionColumnDef } from 'ag-grid-community';
import { ToastrService } from 'ngx-toastr';
import { Observable } from 'rxjs';
import { ApiService, Button, ModalService, Query, ThemeService } from "shared";
import { GridColumnService } from './services/grid-column.service';
import { GridDataSource } from './services/grid-data-source';
import { GridReferenceService } from './services/grid-reference.service';
import { GridConfig } from './widgets/grid-widget/grid-config';
import * as i0 from "@angular/core";
export declare class GridComponent {
    private themeService;
    private changeDetectorRef;
    params: ICellRendererParams;
    gridApi: GridApi;
    rowId: string;
    agGrid: AgGridAngular;
    dataSource: GridDataSource;
    gridConfig: GridConfig;
    customColumnDefs: ColDef[];
    suppressContextMenu: boolean;
    rowSelectionChanged: EventEmitter<any>;
    gridOptions?: GridOptions;
    gridQuery: Query;
    gridColumnService: GridColumnService;
    gridReferenceService: GridReferenceService;
    modalService: ModalService;
    apiService: ApiService;
    toasterService: ToastrService;
    translocoService: TranslocoService;
    datePipe: DatePipe;
    contextId: string;
    gridClass: string;
    selectedRows: any[];
    selectButtons: Button[];
    selectionColumnDef: SelectionColumnDef;
    columnDefs: ColDef[];
    defaultColDef?: ColDef;
    currentRowHeight: number;
    minRowHeight: number;
    noRowsTemplate: string;
    constructor(themeService: ThemeService, changeDetectorRef: ChangeDetectorRef);
    onGridReady(params: GridReadyEvent): void;
    onFirstDataRendered(params: FirstDataRenderedEvent): void;
    onGridSizeChanged(params: GridSizeChangedEvent): void;
    onRowDataUpdated(params: RowDataUpdatedEvent): void;
    updateGridRowsHeight(params: {
        api: GridApi;
    }): void;
    ngOnInit(): void;
    createDeleteButton(): Button;
    deleteSelected(): void;
    setTheme(theme: string): void;
    mapGridOptions(): GridOptions;
    refresh(): void;
    processCellCallback(params: ProcessCellForExportParams): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<GridComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<GridComponent, "xf-grid", never, { "dataSource": { "alias": "dataSource"; "required": false; }; "gridConfig": { "alias": "gridConfig"; "required": false; }; "customColumnDefs": { "alias": "customColumnDefs"; "required": false; }; "suppressContextMenu": { "alias": "suppressContextMenu"; "required": false; }; }, { "rowSelectionChanged": "rowSelectionChanged"; }, never, never, false, never>;
}
export declare function storeResolvedObservableValue(observable: Observable<unknown>, value: unknown): void;
export declare function getStoredResolvedObservableValue(observable: Observable<unknown>): unknown;
