import { DatePipe } from '@angular/common';
import { ColDef, DataTypeDefinition } from 'ag-grid-community';
import { ApiService, EntityService, Field, Query, QuerySort, SystemSettingsService } from "shared";
import * as i0 from "@angular/core";
export declare class GridColumnService {
    systemSettingsService: SystemSettingsService;
    entityService: EntityService;
    apiService: ApiService;
    datePipe: DatePipe;
    create(fields: Record<string, Field>, query?: Query, columns?: GridColumn[], useUserPrefColumns?: boolean, customColDefs?: ColDef[], defaultSort?: QuerySort[]): ColDef[];
    private orderColumns;
    private getColumnDefinition;
    private setSort;
    private getColumnVisibility;
    getMainMenuItems(): string[];
    getColumns(columns: string[], visibleColumns?: string[]): GridColumn[];
    getDefaultColumnTypes(): Record<string, ColDef>;
    getDefaultDataTypeDefinitions(): Record<string, DataTypeDefinition>;
    getDefaultColumnDef(): ColDef;
    static ɵfac: i0.ɵɵFactoryDeclaration<GridColumnService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<GridColumnService>;
}
export declare class GridColumn {
    name: string;
    visible?: boolean;
    width?: number;
    renderer?: any;
    sticky?: 'START' | 'END' | 'NONE';
    enableFiltering?: boolean;
    resizable?: boolean;
    draggable?: boolean;
    sortable?: boolean;
    editable?: boolean;
    cellRenderer?: any;
    cellRendererParams?: any;
    filterParams?: any;
    tooltipValueGetter?: (params: any) => string;
    sort?: 'asc' | 'desc' | null;
    constructor(params: GridColumn);
}
