import { AfterViewInit, ElementRef, EventEmitter, OnDestroy } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { CompletionContext, CompletionResult } from '@codemirror/autocomplete';
import { KeyBinding } from '@codemirror/view';
import { EditorView } from 'codemirror';
import { ThemeService } from '../../core/services/theme.service';
import { Diagnostic } from '@codemirror/lint';
import * as i0 from "@angular/core";
export declare class CodemirrorComponent implements AfterViewInit, OnDestroy, ControlValueAccessor {
    private elementRef;
    private editorView;
    private onChange;
    private onTouched;
    code: string;
    themeService: ThemeService;
    currentTheme: any;
    focus: EventEmitter<void>;
    blur: EventEmitter<void>;
    autocompleteGetter?: (context: CompletionContext) => CompletionResult | null;
    linter?: (view: EditorView) => Diagnostic[];
    extraKeyBindings: KeyBinding[];
    placeholder: string;
    constructor(elementRef: ElementRef);
    ngAfterViewInit(): void;
    private handleUpdates;
    private handleFocusChanges;
    replaceSelection(text: string, skipBrackets?: boolean): void;
    private isInCurlyBraces;
    ngOnDestroy(): void;
    writeValue(value: string): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    setFocus(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<CodemirrorComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<CodemirrorComponent, "xf-code-mirror", never, { "autocompleteGetter": { "alias": "autocompleteGetter"; "required": false; }; "linter": { "alias": "linter"; "required": false; }; "extraKeyBindings": { "alias": "extraKeyBindings"; "required": false; }; "placeholder": { "alias": "placeholder"; "required": false; }; }, { "focus": "focus"; "blur": "blur"; }, never, never, true, never>;
}
